/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationHolder;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class MethodBinding
extends Binding {
    public int modifiers;
    public char[] selector;
    public TypeBinding returnType;
    public TypeBinding[] parameters;
    public TypeBinding receiver;
    public ReferenceBinding[] thrownExceptions;
    public ReferenceBinding declaringClass;
    public TypeVariableBinding[] typeVariables = Binding.NO_TYPE_VARIABLES;
    char[] signature;
    public long tagBits;
    public Boolean[] parameterNonNullness;
    public int defaultNullness;
    public char[][] parameterNames = Binding.NO_PARAMETER_NAMES;

    protected MethodBinding() {
    }

    public MethodBinding(int n, char[] cArray, TypeBinding typeBinding, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this.modifiers = n;
        this.selector = cArray;
        this.returnType = typeBinding;
        this.parameters = typeBindingArray == null || typeBindingArray.length == 0 ? Binding.NO_PARAMETERS : typeBindingArray;
        this.thrownExceptions = referenceBindingArray == null || referenceBindingArray.length == 0 ? Binding.NO_EXCEPTIONS : referenceBindingArray;
        this.declaringClass = referenceBinding;
        if (this.declaringClass != null && this.declaringClass.isStrictfp() && !this.isNative() && !this.isAbstract()) {
            this.modifiers |= 0x800;
        }
    }

    public MethodBinding(int n, TypeBinding[] typeBindingArray, ReferenceBinding[] referenceBindingArray, ReferenceBinding referenceBinding) {
        this(n, TypeConstants.INIT, TypeBinding.VOID, typeBindingArray, referenceBindingArray, referenceBinding);
    }

    public MethodBinding(MethodBinding methodBinding, ReferenceBinding referenceBinding) {
        this.modifiers = methodBinding.modifiers;
        this.selector = methodBinding.selector;
        this.returnType = methodBinding.returnType;
        this.parameters = methodBinding.parameters;
        this.thrownExceptions = methodBinding.thrownExceptions;
        this.declaringClass = referenceBinding;
        referenceBinding.storeAnnotationHolder(this, methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true));
    }

    public final boolean areParameterErasuresEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (TypeBinding.notEquals(this.parameters[n2], typeBindingArray[n2]) && TypeBinding.notEquals(this.parameters[n2].erasure(), typeBindingArray[n2].erasure())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final boolean areParametersCompatibleWith(TypeBinding[] typeBindingArray) {
        int n;
        int n2 = this.parameters.length;
        int n3 = n = typeBindingArray.length;
        if (this.isVarargs()) {
            TypeBinding typeBinding;
            n3 = n2 - 1;
            if (n2 == n) {
                typeBinding = this.parameters[n3];
                TypeBinding typeBinding2 = typeBindingArray[n3];
                if (TypeBinding.notEquals(typeBinding, typeBinding2) && !typeBinding2.isCompatibleWith(typeBinding)) {
                    return false;
                }
            } else if (n2 < n) {
                typeBinding = ((ArrayBinding)this.parameters[n3]).elementsType();
                int n4 = n3;
                while (n4 < n) {
                    if (TypeBinding.notEquals(typeBinding, typeBindingArray[n4]) && !typeBindingArray[n4].isCompatibleWith(typeBinding)) {
                        return false;
                    }
                    ++n4;
                }
            } else if (n3 != n) {
                return false;
            }
        }
        int n5 = 0;
        while (n5 < n3) {
            if (TypeBinding.notEquals(this.parameters[n5], typeBindingArray[n5]) && !typeBindingArray[n5].isCompatibleWith(this.parameters[n5])) {
                return false;
            }
            ++n5;
        }
        return true;
    }

    public final boolean areParametersEqual(MethodBinding methodBinding) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (this.parameters == typeBindingArray) {
            return true;
        }
        int n = this.parameters.length;
        if (n != typeBindingArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (TypeBinding.notEquals(this.parameters[n2], typeBindingArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public final boolean areTypeVariableErasuresEqual(MethodBinding methodBinding) {
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (this.typeVariables == typeVariableBindingArray) {
            return true;
        }
        int n = this.typeVariables.length;
        if (n != typeVariableBindingArray.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (TypeBinding.notEquals(this.typeVariables[n2], typeVariableBindingArray[n2]) && TypeBinding.notEquals(this.typeVariables[n2].erasure(), typeVariableBindingArray[n2].erasure())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public MethodBinding asRawMethod(LookupEnvironment lookupEnvironment) {
        if (this.typeVariables == Binding.NO_TYPE_VARIABLES) {
            return this;
        }
        int n = this.typeVariables.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        int n2 = 0;
        while (n2 < n) {
            TypeVariableBinding typeVariableBinding = this.typeVariables[n2];
            if (typeVariableBinding.boundsCount() <= 1) {
                typeBindingArray[n2] = lookupEnvironment.convertToRawType(typeVariableBinding.upperBound(), false);
            } else {
                int n3;
                ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
                int n4 = referenceBindingArray.length;
                TypeBinding typeBinding = null;
                TypeBinding[] typeBindingArray2 = null;
                if (typeVariableBinding.boundsCount() == n4) {
                    typeBinding = lookupEnvironment.convertToRawType(referenceBindingArray[0], false);
                    typeBindingArray2 = new TypeBinding[n4 - 1];
                    n3 = 1;
                    while (n3 < n4) {
                        typeBindingArray2[n3 - 1] = lookupEnvironment.convertToRawType(referenceBindingArray[n3], false);
                        ++n3;
                    }
                } else {
                    typeBinding = lookupEnvironment.convertToRawType(typeVariableBinding.superclass(), false);
                    typeBindingArray2 = new TypeBinding[n4];
                    n3 = 0;
                    while (n3 < n4) {
                        typeBindingArray2[n3] = lookupEnvironment.convertToRawType(referenceBindingArray[n3], false);
                        ++n3;
                    }
                }
                typeBindingArray[n2] = lookupEnvironment.createWildcard(null, 0, typeBinding, typeBindingArray2, 1);
            }
            ++n2;
        }
        return lookupEnvironment.createParameterizedGenericMethod(this, typeBindingArray);
    }

    public final boolean canBeSeenBy(InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (TypeBinding.equalsEquals(sourceTypeBinding, this.declaringClass)) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            return invocationSite.isSuperAccess();
        }
        if (this.isPrivate()) {
            ReferenceBinding referenceBinding = sourceTypeBinding;
            ReferenceBinding referenceBinding2 = referenceBinding.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.declaringClass.erasure();
            referenceBinding2 = referenceBinding3.enclosingType();
            while (referenceBinding2 != null) {
                referenceBinding3 = referenceBinding2;
                referenceBinding2 = referenceBinding2.enclosingType();
            }
            return TypeBinding.equalsEquals(referenceBinding, referenceBinding3);
        }
        return sourceTypeBinding.fPackage == this.declaringClass.fPackage;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (this.declaringClass.isInterface() && this.isStatic()) {
            if (scope.compilerOptions().sourceLevel < 0x340000L) {
                return false;
            }
            return (invocationSite.isTypeAccess() || invocationSite.receiverIsImplicitThis()) && TypeBinding.equalsEquals(typeBinding, this.declaringClass);
        }
        if (this.isPublic()) {
            return true;
        }
        if (TypeBinding.equalsEquals(sourceTypeBinding, this.declaringClass) && TypeBinding.equalsEquals(sourceTypeBinding, typeBinding)) {
            return true;
        }
        if (sourceTypeBinding == null) {
            return !this.isPrivate() && scope.getCurrentPackage() == this.declaringClass.fPackage;
        }
        if (this.isProtected()) {
            if (TypeBinding.equalsEquals(sourceTypeBinding, this.declaringClass)) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            TypeBinding typeBinding2 = typeBinding.erasure();
            ReferenceBinding referenceBinding2 = (ReferenceBinding)this.declaringClass.erasure();
            int n = 0;
            do {
                if (referenceBinding.findSuperTypeOriginatingFrom(referenceBinding2) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                    if (TypeBinding.equalsEquals(referenceBinding, typeBinding2) || typeBinding2.findSuperTypeOriginatingFrom(referenceBinding) != null) {
                        if (n > 0) {
                            invocationSite.setDepth(n);
                        }
                        return true;
                    }
                }
                ++n;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(!TypeBinding.notEquals(typeBinding, this.declaringClass) || scope.compilerOptions().complianceLevel <= 0x320000L && typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (TypeBinding.notEquals(sourceTypeBinding, this.declaringClass)) {
                ReferenceBinding referenceBinding = sourceTypeBinding;
                ReferenceBinding referenceBinding3 = referenceBinding.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                ReferenceBinding referenceBinding4 = (ReferenceBinding)this.declaringClass.erasure();
                referenceBinding3 = referenceBinding4.enclosingType();
                while (referenceBinding3 != null) {
                    referenceBinding4 = referenceBinding3;
                    referenceBinding3 = referenceBinding3.enclosingType();
                }
                if (TypeBinding.notEquals(referenceBinding, referenceBinding4)) {
                    return false;
                }
            }
            return true;
        }
        PackageBinding packageBinding = this.declaringClass.fPackage;
        if (sourceTypeBinding.fPackage != packageBinding) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        TypeBinding typeBinding3 = this.declaringClass.original();
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            if (referenceBinding.isCapture() ? TypeBinding.equalsEquals(typeBinding3, referenceBinding.erasure().original()) : TypeBinding.equalsEquals(typeBinding3, referenceBinding.original())) {
                return true;
            }
            PackageBinding packageBinding2 = referenceBinding.fPackage;
            if (packageBinding2 == null || packageBinding2 == packageBinding) continue;
            return false;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public List collectMissingTypes(List list) {
        if ((this.tagBits & 0x80L) != 0L) {
            list = this.returnType.collectMissingTypes(list);
            int n = 0;
            int n2 = this.parameters.length;
            while (n < n2) {
                list = this.parameters[n].collectMissingTypes(list);
                ++n;
            }
            n = 0;
            n2 = this.thrownExceptions.length;
            while (n < n2) {
                list = this.thrownExceptions[n].collectMissingTypes(list);
                ++n;
            }
            n = 0;
            n2 = this.typeVariables.length;
            while (n < n2) {
                TypeVariableBinding typeVariableBinding = this.typeVariables[n];
                list = typeVariableBinding.superclass().collectMissingTypes(list);
                ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces();
                int n3 = 0;
                int n4 = referenceBindingArray.length;
                while (n3 < n4) {
                    list = referenceBindingArray[n3].collectMissingTypes(list);
                    ++n3;
                }
                ++n;
            }
        }
        return list;
    }

    MethodBinding computeSubstitutedMethod(MethodBinding methodBinding, LookupEnvironment lookupEnvironment) {
        int n = this.typeVariables.length;
        TypeVariableBinding[] typeVariableBindingArray = methodBinding.typeVariables;
        if (n != typeVariableBindingArray.length) {
            return null;
        }
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = lookupEnvironment.createParameterizedGenericMethod(methodBinding, this.typeVariables);
        int n2 = 0;
        while (n2 < n) {
            if (!this.typeVariables[n2].isInterchangeableWith(typeVariableBindingArray[n2], parameterizedGenericMethodBinding)) {
                return null;
            }
            ++n2;
        }
        return parameterizedGenericMethodBinding;
    }

    public char[] computeUniqueKey(boolean bl) {
        boolean bl2;
        boolean bl3;
        char[] cArray = this.declaringClass.computeUniqueKey(false);
        int n = cArray.length;
        int n2 = this.selector == TypeConstants.INIT ? 0 : this.selector.length;
        char[] cArray2 = this.genericSignature();
        boolean bl4 = bl3 = cArray2 != null;
        if (!bl3) {
            cArray2 = this.signature();
        }
        int n3 = cArray2.length;
        int n4 = this.thrownExceptions.length;
        int n5 = 0;
        char[][] cArrayArray = null;
        boolean bl5 = bl2 = n4 > 0 && (!bl3 || CharOperation.lastIndexOf('^', cArray2) < 0);
        if (bl2) {
            cArrayArray = new char[n4][];
            int n6 = 0;
            while (n6 < n4) {
                if (this.thrownExceptions[n6] != null) {
                    cArrayArray[n6] = this.thrownExceptions[n6].signature();
                    n5 += cArrayArray[n6].length + 1;
                }
                ++n6;
            }
        }
        char[] cArray3 = new char[n + 1 + n2 + n3 + n5];
        int n7 = 0;
        System.arraycopy(cArray, 0, cArray3, n7, n);
        n7 = n;
        cArray3[n7++] = 46;
        System.arraycopy(this.selector, 0, cArray3, n7, n2);
        System.arraycopy(cArray2, 0, cArray3, n7 += n2, n3);
        if (n5 > 0) {
            n7 += n3;
            int n8 = 0;
            while (n8 < n4) {
                char[] cArray4 = cArrayArray[n8];
                if (cArray4 != null) {
                    cArray3[n7++] = 124;
                    int n9 = cArray4.length;
                    System.arraycopy(cArray4, 0, cArray3, n7, n9);
                    n7 += n9;
                }
                ++n8;
            }
        }
        return cArray3;
    }

    public final char[] constantPoolName() {
        return this.selector;
    }

    protected void fillInDefaultNonNullness(AbstractMethodDeclaration abstractMethodDeclaration) {
        if (this.parameterNonNullness == null) {
            this.parameterNonNullness = new Boolean[this.parameters.length];
        }
        boolean bl = false;
        int n = this.parameterNonNullness.length;
        int n2 = 0;
        while (n2 < n) {
            if (!this.parameters[n2].isBaseType()) {
                if (this.parameterNonNullness[n2] == null) {
                    bl = true;
                    this.parameterNonNullness[n2] = Boolean.TRUE;
                    if (abstractMethodDeclaration != null) {
                        abstractMethodDeclaration.arguments[n2].binding.tagBits |= 0x100000000000000L;
                    }
                } else if (abstractMethodDeclaration != null && this.parameterNonNullness[n2].booleanValue()) {
                    abstractMethodDeclaration.scope.problemReporter().nullAnnotationIsRedundant(abstractMethodDeclaration, n2);
                }
            }
            ++n2;
        }
        if (bl) {
            this.tagBits |= 0x400L;
        }
        if (this.returnType != null && !this.returnType.isBaseType() && (this.tagBits & 0x180000000000000L) == 0L) {
            this.tagBits |= 0x100000000000000L;
        } else if (abstractMethodDeclaration != null && (this.tagBits & 0x100000000000000L) != 0L) {
            abstractMethodDeclaration.scope.problemReporter().nullAnnotationIsRedundant(abstractMethodDeclaration, -1);
        }
    }

    protected void fillInDefaultNonNullness18(AbstractMethodDeclaration abstractMethodDeclaration, LookupEnvironment lookupEnvironment) {
        if (this.hasNonNullDefaultFor(8, true)) {
            boolean bl = false;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                TypeBinding typeBinding = this.parameters[n2];
                if (typeBinding.acceptsNonNullDefault()) {
                    long l = typeBinding.tagBits & 0x180000000000000L;
                    if (l == 0L) {
                        bl = true;
                        if (!typeBinding.isBaseType()) {
                            this.parameters[n2] = lookupEnvironment.createAnnotatedType(typeBinding, new AnnotationBinding[]{lookupEnvironment.getNonNullAnnotation()});
                            if (abstractMethodDeclaration != null) {
                                abstractMethodDeclaration.arguments[n2].binding.type = this.parameters[n2];
                            }
                        }
                    } else if (abstractMethodDeclaration != null && (typeBinding.tagBits & 0x100000000000000L) != 0L && abstractMethodDeclaration.arguments[n2].hasNullTypeAnnotation(TypeReference.AnnotationPosition.MAIN_TYPE)) {
                        abstractMethodDeclaration.scope.problemReporter().nullAnnotationIsRedundant(abstractMethodDeclaration, n2);
                    }
                }
                ++n2;
            }
            if (bl) {
                this.tagBits |= 0x400L;
            }
        }
        if (this.returnType != null && this.hasNonNullDefaultFor(16, true)) {
            if (this.returnType.acceptsNonNullDefault() && (this.returnType.tagBits & 0x180000000000000L) == 0L) {
                this.returnType = lookupEnvironment.createAnnotatedType(this.returnType, new AnnotationBinding[]{lookupEnvironment.getNonNullAnnotation()});
            } else if (abstractMethodDeclaration instanceof MethodDeclaration && (this.returnType.tagBits & 0x100000000000000L) != 0L && ((MethodDeclaration)abstractMethodDeclaration).hasNullTypeAnnotation(TypeReference.AnnotationPosition.MAIN_TYPE)) {
                abstractMethodDeclaration.scope.problemReporter().nullAnnotationIsRedundant(abstractMethodDeclaration, -1);
            }
        }
    }

    public MethodBinding findOriginalInheritedMethod(MethodBinding methodBinding) {
        MethodBinding methodBinding2 = methodBinding.original();
        TypeBinding typeBinding = this.declaringClass.findSuperTypeOriginatingFrom(methodBinding2.declaringClass);
        if (typeBinding == null || !(typeBinding instanceof ReferenceBinding)) {
            return null;
        }
        if (TypeBinding.notEquals(methodBinding2.declaringClass, typeBinding)) {
            MethodBinding[] methodBindingArray = ((ReferenceBinding)typeBinding).getMethods(methodBinding2.selector, methodBinding2.parameters.length);
            int n = 0;
            int n2 = methodBindingArray.length;
            while (n < n2) {
                if (methodBindingArray[n].original() == methodBinding2) {
                    return methodBindingArray[n];
                }
                ++n;
            }
        }
        return methodBinding2;
    }

    public char[] genericSignature() {
        int n;
        int n2;
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        if (this.typeVariables != Binding.NO_TYPE_VARIABLES) {
            stringBuffer.append('<');
            n2 = 0;
            n = this.typeVariables.length;
            while (n2 < n) {
                stringBuffer.append(this.typeVariables[n2].genericSignature());
                ++n2;
            }
            stringBuffer.append('>');
        }
        stringBuffer.append('(');
        n2 = 0;
        n = this.parameters.length;
        while (n2 < n) {
            stringBuffer.append(this.parameters[n2].genericTypeSignature());
            ++n2;
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.genericTypeSignature());
        }
        n2 = 0;
        n = this.thrownExceptions.length;
        int n3 = 0;
        while (n3 < n) {
            if ((this.thrownExceptions[n3].modifiers & 0x40000000) != 0) {
                n2 = 1;
                break;
            }
            ++n3;
        }
        if (n2 != 0) {
            n3 = 0;
            while (n3 < n) {
                stringBuffer.append('^');
                stringBuffer.append(this.thrownExceptions[n3].genericTypeSignature());
                ++n3;
            }
        }
        n3 = stringBuffer.length();
        char[] cArray = new char[n3];
        stringBuffer.getChars(0, n3, cArray, 0);
        return cArray;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0x1FFFF;
    }

    public AnnotationBinding[] getAnnotations() {
        MethodBinding methodBinding = this.original();
        return methodBinding.declaringClass.retrieveAnnotations(methodBinding);
    }

    public long getAnnotationTagBits() {
        ClassScope classScope;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x200000000L) == 0L && methodBinding.declaringClass instanceof SourceTypeBinding && (classScope = ((SourceTypeBinding)methodBinding.declaringClass).scope) != null) {
            TypeDeclaration typeDeclaration = classScope.referenceContext;
            AbstractMethodDeclaration abstractMethodDeclaration = typeDeclaration.declarationOf(methodBinding);
            if (abstractMethodDeclaration != null) {
                ASTNode.resolveAnnotations((BlockScope)abstractMethodDeclaration.scope, abstractMethodDeclaration.annotations, methodBinding);
            }
            CompilerOptions compilerOptions = classScope.compilerOptions();
            if (compilerOptions.isAnnotationBasedNullAnalysisEnabled) {
                SourceTypeBinding sourceTypeBinding;
                long l;
                boolean bl = classScope.environment().usesNullTypeAnnotations();
                long l2 = l = bl ? (long)this.defaultNullness : this.tagBits & 0x600000000000000L;
                if (l != 0L && this.declaringClass instanceof SourceTypeBinding && (sourceTypeBinding = (SourceTypeBinding)this.declaringClass).checkRedundantNullnessDefaultOne(abstractMethodDeclaration, abstractMethodDeclaration.annotations, l, bl)) {
                    sourceTypeBinding.checkRedundantNullnessDefaultRecurse(abstractMethodDeclaration, abstractMethodDeclaration.annotations, l, bl);
                }
            }
        }
        return methodBinding.tagBits;
    }

    public Object getDefaultValue() {
        Object object;
        MethodBinding methodBinding = this.original();
        if ((methodBinding.tagBits & 0x800000000000000L) == 0L) {
            if (methodBinding.declaringClass instanceof SourceTypeBinding) {
                AbstractMethodDeclaration abstractMethodDeclaration;
                object = (SourceTypeBinding)methodBinding.declaringClass;
                if (((SourceTypeBinding)object).scope != null && (abstractMethodDeclaration = methodBinding.sourceMethod()) != null && abstractMethodDeclaration.isAnnotationMethod()) {
                    abstractMethodDeclaration.resolve(((SourceTypeBinding)object).scope);
                }
            }
            methodBinding.tagBits |= 0x800000000000000L;
        }
        return (object = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true)) == null ? null : ((AnnotationHolder)object).getDefaultValue();
    }

    public AnnotationBinding[][] getParameterAnnotations() {
        AnnotationBinding[][] annotationBindingArray;
        int n = this.parameters.length;
        if (n == 0) {
            return null;
        }
        MethodBinding methodBinding = this.original();
        AnnotationHolder annotationHolder = methodBinding.declaringClass.retrieveAnnotationHolder(methodBinding, true);
        AnnotationBinding[][] annotationBindingArray2 = annotationBindingArray = annotationHolder == null ? null : annotationHolder.getParameterAnnotations();
        if (annotationBindingArray == null && (this.tagBits & 0x400L) != 0L) {
            annotationBindingArray = new AnnotationBinding[n][];
            if (this.declaringClass instanceof SourceTypeBinding) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
                if (sourceTypeBinding.scope != null) {
                    AbstractMethodDeclaration abstractMethodDeclaration = sourceTypeBinding.scope.referenceType().declarationOf(this);
                    int n2 = 0;
                    while (n2 < n) {
                        Argument argument = abstractMethodDeclaration.arguments[n2];
                        if (argument.annotations != null) {
                            ASTNode.resolveAnnotations((BlockScope)abstractMethodDeclaration.scope, argument.annotations, argument.binding);
                            annotationBindingArray[n2] = argument.binding.getAnnotations();
                        } else {
                            annotationBindingArray[n2] = Binding.NO_ANNOTATIONS;
                        }
                        ++n2;
                    }
                } else {
                    int n3 = 0;
                    while (n3 < n) {
                        annotationBindingArray[n3] = Binding.NO_ANNOTATIONS;
                        ++n3;
                    }
                }
            } else {
                int n4 = 0;
                while (n4 < n) {
                    annotationBindingArray[n4] = Binding.NO_ANNOTATIONS;
                    ++n4;
                }
            }
            this.setParameterAnnotations(annotationBindingArray);
        }
        return annotationBindingArray;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        int n = this.typeVariables.length;
        while (--n >= 0) {
            if (!CharOperation.equals(this.typeVariables[n].sourceName, cArray)) continue;
            return this.typeVariables[n];
        }
        return null;
    }

    public boolean hasSubstitutedParameters() {
        return false;
    }

    public boolean hasSubstitutedReturnType() {
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public final boolean isBridge() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isConstructor() {
        return this.selector == TypeConstants.INIT;
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDefaultAbstract() {
        return (this.modifiers & 0x80000) != 0;
    }

    public boolean isDefaultMethod() {
        return (this.modifiers & 0x10000) != 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isImplementing() {
        return (this.modifiers & 0x20000000) != 0;
    }

    public final boolean isMain() {
        TypeBinding typeBinding;
        return this.selector.length == 4 && CharOperation.equals(this.selector, TypeConstants.MAIN) && (this.modifiers & 9) != 0 && TypeBinding.VOID == this.returnType && this.parameters.length == 1 && (typeBinding = this.parameters[0]).dimensions() == 1 && typeBinding.leafComponentType().id == 11;
    }

    public final boolean isNative() {
        return (this.modifiers & 0x100) != 0;
    }

    public final boolean isOverriding() {
        return (this.modifiers & 0x10000000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isOrEnclosedByPrivateType() {
        if ((this.modifiers & 2) != 0) {
            return true;
        }
        return this.declaringClass != null && this.declaringClass.isOrEnclosedByPrivateType();
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public final boolean isSynchronized() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public boolean isVarargs() {
        return (this.modifiers & 0x80) != 0;
    }

    public boolean isPolymorphic() {
        return false;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public final int kind() {
        return 8;
    }

    public MethodBinding original() {
        return this;
    }

    public MethodBinding shallowOriginal() {
        return this.original();
    }

    public MethodBinding genericMethod() {
        return this;
    }

    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.sourceName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            int n = 0;
            int n2 = this.parameters.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n].sourceName());
                ++n;
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString().toCharArray();
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray) {
        this.declaringClass.storeAnnotations(this, annotationBindingArray);
    }

    public void setAnnotations(AnnotationBinding[] annotationBindingArray, AnnotationBinding[][] annotationBindingArray2, Object object, LookupEnvironment lookupEnvironment) {
        this.declaringClass.storeAnnotationHolder(this, AnnotationHolder.storeAnnotations(annotationBindingArray, annotationBindingArray2, object, lookupEnvironment));
    }

    public void setDefaultValue(Object object) {
        MethodBinding methodBinding = this.original();
        methodBinding.tagBits |= 0x800000000000000L;
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, null, object, null);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationHolder.getParameterAnnotations(), object, null);
        }
    }

    public void setParameterAnnotations(AnnotationBinding[][] annotationBindingArray) {
        AnnotationHolder annotationHolder = this.declaringClass.retrieveAnnotationHolder(this, false);
        if (annotationHolder == null) {
            this.setAnnotations(null, annotationBindingArray, null, null);
        } else {
            this.setAnnotations(annotationHolder.getAnnotations(), annotationBindingArray, annotationHolder.getDefaultValue(), null);
        }
    }

    protected final void setSelector(char[] cArray) {
        this.selector = cArray;
        this.signature = null;
    }

    public char[] shortReadableName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        if (this.isConstructor()) {
            stringBuffer.append(this.declaringClass.shortReadableName());
        } else {
            stringBuffer.append(this.selector);
        }
        stringBuffer.append('(');
        if (this.parameters != Binding.NO_PARAMETERS) {
            n = 0;
            int n2 = this.parameters.length;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.parameters[n].shortReadableName());
                ++n;
            }
        }
        stringBuffer.append(')');
        n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        return cArray;
    }

    public final char[] signature() {
        int n;
        int n2;
        Binding[] bindingArray;
        boolean bl;
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer stringBuffer = new StringBuffer(this.parameters.length + 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl2 = this.isConstructor();
        if (bl2 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(TypeBinding.INT.signature());
        }
        boolean bl3 = bl = bl2 && this.declaringClass.isNestedType();
        if (bl) {
            bindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (bindingArray != null) {
                n2 = 0;
                n = bindingArray.length;
                while (n2 < n) {
                    stringBuffer.append(((ReferenceBinding)bindingArray[n2]).signature());
                    ++n2;
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            int n3 = 0;
            while (n3 < typeBindingArray.length) {
                stringBuffer.append(typeBindingArray[n3].signature());
                ++n3;
            }
        }
        if (bl) {
            bindingArray = this.declaringClass.syntheticOuterLocalVariables();
            n2 = bindingArray == null ? 0 : bindingArray.length;
            n = 0;
            while (n < n2) {
                stringBuffer.append(((SyntheticArgumentBinding)bindingArray[n]).type.signature());
                ++n;
            }
            n = typeBindingArray.length;
            int n4 = this.parameters.length;
            while (n < n4) {
                stringBuffer.append(this.parameters[n].signature());
                ++n;
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            stringBuffer.append(this.returnType.signature());
        }
        int n5 = stringBuffer.length();
        this.signature = new char[n5];
        stringBuffer.getChars(0, n5, this.signature, 0);
        return this.signature;
    }

    public final char[] signature(ClassFile classFile) {
        TypeBinding typeBinding;
        int n;
        boolean bl;
        if (this.signature != null) {
            if ((this.tagBits & 0x800L) != 0L) {
                TypeBinding typeBinding2;
                int n2;
                Object object;
                boolean bl2;
                boolean bl3 = this.isConstructor();
                TypeBinding[] typeBindingArray = this.parameters;
                boolean bl4 = bl2 = bl3 && this.declaringClass.isNestedType();
                if (bl2) {
                    object = this.declaringClass.syntheticEnclosingInstanceTypes();
                    if (object != null) {
                        n2 = 0;
                        int n3 = ((ReferenceBinding[])object).length;
                        while (n2 < n3) {
                            typeBinding2 = object[n2];
                            if ((typeBinding2.tagBits & 0x800L) != 0L) {
                                Util.recordNestedType(classFile, typeBinding2);
                            }
                            ++n2;
                        }
                    }
                    if (this instanceof SyntheticMethodBinding) {
                        typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
                    }
                }
                if (typeBindingArray != Binding.NO_PARAMETERS) {
                    int n4 = 0;
                    n2 = typeBindingArray.length;
                    while (n4 < n2) {
                        TypeBinding typeBinding3 = typeBindingArray[n4];
                        typeBinding2 = typeBinding3.leafComponentType();
                        if ((typeBinding2.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, typeBinding2);
                        }
                        ++n4;
                    }
                }
                if (bl2) {
                    int n5 = typeBindingArray.length;
                    n2 = this.parameters.length;
                    while (n5 < n2) {
                        TypeBinding typeBinding4 = this.parameters[n5];
                        typeBinding2 = typeBinding4.leafComponentType();
                        if ((typeBinding2.tagBits & 0x800L) != 0L) {
                            Util.recordNestedType(classFile, typeBinding2);
                        }
                        ++n5;
                    }
                }
                if (this.returnType != null) {
                    object = this.returnType.leafComponentType();
                    if ((object.tagBits & 0x800L) != 0L) {
                        Util.recordNestedType(classFile, (TypeBinding)object);
                    }
                }
            }
            return this.signature;
        }
        StringBuffer stringBuffer = new StringBuffer((this.parameters.length + 1) * 20);
        stringBuffer.append('(');
        TypeBinding[] typeBindingArray = this.parameters;
        boolean bl5 = this.isConstructor();
        if (bl5 && this.declaringClass.isEnum()) {
            stringBuffer.append(ConstantPool.JavaLangStringSignature);
            stringBuffer.append(TypeBinding.INT.signature());
        }
        boolean bl6 = bl = bl5 && this.declaringClass.isNestedType();
        if (bl) {
            ReferenceBinding[] referenceBindingArray = this.declaringClass.syntheticEnclosingInstanceTypes();
            if (referenceBindingArray != null) {
                n = 0;
                int n6 = referenceBindingArray.length;
                while (n < n6) {
                    typeBinding = referenceBindingArray[n];
                    if ((((ReferenceBinding)typeBinding).tagBits & 0x800L) != 0L) {
                        this.tagBits |= 0x800L;
                        Util.recordNestedType(classFile, typeBinding);
                    }
                    stringBuffer.append(((ReferenceBinding)typeBinding).signature());
                    ++n;
                }
            }
            if (this instanceof SyntheticMethodBinding) {
                typeBindingArray = ((SyntheticMethodBinding)this).targetMethod.parameters;
            }
        }
        if (typeBindingArray != Binding.NO_PARAMETERS) {
            int n7 = 0;
            n = typeBindingArray.length;
            while (n7 < n) {
                TypeBinding typeBinding5 = typeBindingArray[n7];
                typeBinding = typeBinding5.leafComponentType();
                if ((typeBinding.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    Util.recordNestedType(classFile, typeBinding);
                }
                stringBuffer.append(typeBinding5.signature());
                ++n7;
            }
        }
        if (bl) {
            SyntheticArgumentBinding[] syntheticArgumentBindingArray = this.declaringClass.syntheticOuterLocalVariables();
            n = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
            int n8 = 0;
            while (n8 < n) {
                stringBuffer.append(syntheticArgumentBindingArray[n8].type.signature());
                ++n8;
            }
            n8 = typeBindingArray.length;
            int n9 = this.parameters.length;
            while (n8 < n9) {
                TypeBinding typeBinding6 = this.parameters[n8];
                TypeBinding typeBinding7 = typeBinding6.leafComponentType();
                if ((typeBinding7.tagBits & 0x800L) != 0L) {
                    this.tagBits |= 0x800L;
                    Util.recordNestedType(classFile, typeBinding7);
                }
                stringBuffer.append(typeBinding6.signature());
                ++n8;
            }
        }
        stringBuffer.append(')');
        if (this.returnType != null) {
            TypeBinding typeBinding8 = this.returnType.leafComponentType();
            if ((typeBinding8.tagBits & 0x800L) != 0L) {
                this.tagBits |= 0x800L;
                Util.recordNestedType(classFile, typeBinding8);
            }
            stringBuffer.append(this.returnType.signature());
        }
        int n10 = stringBuffer.length();
        this.signature = new char[n10];
        stringBuffer.getChars(0, n10, this.signature, 0);
        return this.signature;
    }

    public final int sourceEnd() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceEnd();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceEnd;
    }

    public AbstractMethodDeclaration sourceMethod() {
        AbstractMethodDeclaration[] abstractMethodDeclarationArray;
        SourceTypeBinding sourceTypeBinding;
        if (this.isSynthetic()) {
            return null;
        }
        try {
            sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        AbstractMethodDeclaration[] abstractMethodDeclarationArray2 = abstractMethodDeclarationArray = sourceTypeBinding.scope != null ? sourceTypeBinding.scope.referenceContext.methods : null;
        if (abstractMethodDeclarationArray != null) {
            int n = abstractMethodDeclarationArray.length;
            while (--n >= 0) {
                if (this != abstractMethodDeclarationArray[n].binding) continue;
                return abstractMethodDeclarationArray[n];
            }
        }
        return null;
    }

    public LambdaExpression sourceLambda() {
        return null;
    }

    public final int sourceStart() {
        AbstractMethodDeclaration abstractMethodDeclaration = this.sourceMethod();
        if (abstractMethodDeclaration == null) {
            if (this.declaringClass instanceof SourceTypeBinding) {
                return ((SourceTypeBinding)this.declaringClass).sourceStart();
            }
            return 0;
        }
        return abstractMethodDeclaration.sourceStart;
    }

    public MethodBinding tiebreakMethod() {
        return this;
    }

    public String toString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(10);
        if ((this.modifiers & 0x2000000) != 0) {
            stringBuffer.append("[unresolved] ");
        }
        ASTNode.printModifiers(this.modifiers, stringBuffer);
        stringBuffer.append(this.returnType != null ? this.returnType.debugName() : "<no type>");
        stringBuffer.append(" ");
        stringBuffer.append(this.selector != null ? new String(this.selector) : "<no selector>");
        stringBuffer.append("(");
        if (this.parameters != null) {
            if (this.parameters != Binding.NO_PARAMETERS) {
                n2 = 0;
                n = this.parameters.length;
                while (n2 < n) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.parameters[n2] != null ? this.parameters[n2].debugName() : "<no argument type>");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("<no argument types>");
        }
        stringBuffer.append(") ");
        if (this.thrownExceptions != null) {
            if (this.thrownExceptions != Binding.NO_EXCEPTIONS) {
                stringBuffer.append("throws ");
                n2 = 0;
                n = this.thrownExceptions.length;
                while (n2 < n) {
                    if (n2 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.thrownExceptions[n2] != null ? this.thrownExceptions[n2].debugName() : "<no exception type>");
                    ++n2;
                }
            }
        } else {
            stringBuffer.append("<no exception types>");
        }
        return stringBuffer.toString();
    }

    public TypeVariableBinding[] typeVariables() {
        return this.typeVariables;
    }

    public boolean hasNonNullDefaultFor(int n, boolean bl) {
        if ((this.modifiers & 0x4000000) != 0) {
            return false;
        }
        if (bl) {
            if (this.defaultNullness != 0) {
                return (this.defaultNullness & n) != 0;
            }
        } else {
            if ((this.tagBits & 0x200000000000000L) != 0L) {
                return true;
            }
            if ((this.tagBits & 0x400000000000000L) != 0L) {
                return false;
            }
        }
        return this.declaringClass.hasNonNullDefaultFor(n, bl);
    }

    public boolean redeclaresPublicObjectMethod(Scope scope) {
        ReferenceBinding referenceBinding = scope.getJavaLangObject();
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(this.selector);
        int n = 0;
        int n2 = methodBindingArray == null ? 0 : methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding = methodBindingArray[n];
            if (methodBinding.isPublic() && !methodBinding.isStatic() && methodBinding.parameters.length == this.parameters.length && MethodVerifier.doesMethodOverride(this, methodBinding, scope.environment())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isVoidMethod() {
        return this.returnType == TypeBinding.VOID;
    }
}

