/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.ReferenceExpression;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.BoundSet;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintFormula;
import org.eclipse.jdt.internal.compiler.lookup.ConstraintTypeFormula;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.InferenceFailureException;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBound;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstraintExpressionFormula
extends ConstraintFormula {
    Expression left;
    boolean isSoft;

    ConstraintExpressionFormula(Expression expression, TypeBinding typeBinding, int n) {
        this.left = expression;
        this.right = typeBinding;
        this.relation = n;
    }

    ConstraintExpressionFormula(Expression expression, TypeBinding typeBinding, int n, boolean bl) {
        this(expression, typeBinding, n);
        this.isSoft = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object reduce(InferenceContext18 inferenceContext18) throws InferenceFailureException {
        Object object;
        block39: {
            if (this.relation == 8) {
                ConstraintTypeFormula constraintTypeFormula;
                if (this.left.isPotentiallyCompatibleWith(this.right, inferenceContext18.scope)) {
                    constraintTypeFormula = TRUE;
                    return constraintTypeFormula;
                }
                constraintTypeFormula = FALSE;
                return constraintTypeFormula;
            }
            if (this.right.isProperType(true)) {
                ConstraintTypeFormula constraintTypeFormula;
                if (!this.left.isCompatibleWith(this.right, inferenceContext18.scope) && !this.left.isBoxingCompatibleWith(this.right, inferenceContext18.scope)) {
                    constraintTypeFormula = FALSE;
                    return constraintTypeFormula;
                }
                constraintTypeFormula = TRUE;
                return constraintTypeFormula;
            }
            if (!this.canBePolyExpression(this.left)) {
                TypeBinding typeBinding = this.left.resolvedType;
                if (typeBinding != null) {
                    if (typeBinding.isValidBinding()) return ConstraintTypeFormula.create(typeBinding, this.right, 1, this.isSoft);
                }
                if (!(this.left instanceof MessageSend)) return FALSE;
                if (!(((MessageSend)this.left).actualReceiverType instanceof InferenceVariable)) return FALSE;
                return null;
            }
            if (!(this.left instanceof Invocation)) break block39;
            Invocation invocation = (Invocation)((Object)this.left);
            MethodBinding methodBinding = invocation.binding();
            if (methodBinding == null) {
                return null;
            }
            MethodBinding methodBinding2 = methodBinding;
            methodBinding2 = methodBinding.shallowOriginal();
            InferenceContext18.SuspendedInferenceRecord suspendedInferenceRecord = inferenceContext18.enterPolyInvocation(invocation, invocation.arguments());
            try {
                block40: {
                    boolean bl;
                    TypeBinding[] typeBindingArray;
                    block38: {
                        InferenceContext18 inferenceContext182;
                        Expression[] expressionArray = invocation.arguments();
                        typeBindingArray = expressionArray == null ? Binding.NO_PARAMETERS : new TypeBinding[expressionArray.length];
                        bl = false;
                        while (true) {
                            if (bl >= typeBindingArray.length) {
                                if (methodBinding instanceof ParameterizedGenericMethodBinding) {
                                    inferenceContext182 = invocation.getInferenceContext((ParameterizedGenericMethodBinding)methodBinding);
                                    if (inferenceContext182 != null) break;
                                    TypeBinding typeBinding = this.left.resolvedType;
                                    if (typeBinding != null && typeBinding.isValidBinding()) {
                                        ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(typeBinding, this.right, 1, this.isSoft);
                                        return constraintTypeFormula;
                                    }
                                    ConstraintTypeFormula constraintTypeFormula = FALSE;
                                    return constraintTypeFormula;
                                }
                                break block38;
                            }
                            typeBindingArray[bl] = expressionArray[bl].resolvedType;
                            bl += 1;
                        }
                        if (inferenceContext182.stepCompleted < 1) {
                            ConstraintTypeFormula constraintTypeFormula = FALSE;
                            return constraintTypeFormula;
                        }
                        inferenceContext18.currentBounds.addBounds(inferenceContext182.b2, inferenceContext18.environment);
                        inferenceContext18.inferenceVariables = inferenceContext182.inferenceVariables;
                        inferenceContext18.inferenceKind = inferenceContext182.inferenceKind;
                        inferenceContext182.outerContext = inferenceContext18;
                        inferenceContext18.usesUncheckedConversion = inferenceContext182.usesUncheckedConversion;
                        break block40;
                    }
                    inferenceContext18.inferenceKind = inferenceContext18.getInferenceKind(methodBinding, typeBindingArray);
                    bl = methodBinding2.isConstructor() && this.left.isPolyExpression(methodBinding2);
                    ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext18, methodBinding2, typeBindingArray, bl, inferenceContext18.inferenceKind);
                }
                if (ConstraintExpressionFormula.inferPolyInvocationType(inferenceContext18, invocation, this.right, methodBinding2)) return null;
                ConstraintTypeFormula constraintTypeFormula = FALSE;
                return constraintTypeFormula;
            }
            finally {
                inferenceContext18.resumeSuspendedInference(suspendedInferenceRecord);
            }
        }
        if (this.left instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)this.left;
            return new ConstraintFormula[]{new ConstraintExpressionFormula(conditionalExpression.valueIfTrue, this.right, this.relation, this.isSoft), new ConstraintExpressionFormula(conditionalExpression.valueIfFalse, this.right, this.relation, this.isSoft)};
        }
        if (!(this.left instanceof LambdaExpression)) {
            if (!(this.left instanceof ReferenceExpression)) return FALSE;
            return this.reduceReferenceExpressionCompatibility((ReferenceExpression)this.left, inferenceContext18);
        }
        LambdaExpression lambdaExpression = (LambdaExpression)this.left;
        BlockScope blockScope = lambdaExpression.enclosingScope;
        if (!this.right.isFunctionalInterface(blockScope)) {
            return FALSE;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.right;
        ParameterizedTypeBinding parameterizedTypeBinding = InferenceContext18.parameterizedWithWildcard(referenceBinding);
        if (parameterizedTypeBinding != null) {
            referenceBinding = ConstraintExpressionFormula.findGroundTargetType(inferenceContext18, blockScope, lambdaExpression, parameterizedTypeBinding);
        }
        if (referenceBinding == null) {
            return FALSE;
        }
        MethodBinding methodBinding = referenceBinding.getSingleAbstractMethod(blockScope, true);
        if (methodBinding == null) {
            return FALSE;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        if (typeBindingArray.length != lambdaExpression.arguments().length) {
            return FALSE;
        }
        if (lambdaExpression.argumentsTypeElided()) {
            int n = 0;
            while (n < typeBindingArray.length) {
                if (!typeBindingArray[n].isProperType(true)) {
                    return FALSE;
                }
                ++n;
            }
        }
        if ((lambdaExpression = lambdaExpression.resolveExpressionExpecting(referenceBinding, inferenceContext18.scope, inferenceContext18)) == null) {
            return FALSE;
        }
        if (methodBinding.returnType == TypeBinding.VOID ? !lambdaExpression.isVoidCompatible() : !lambdaExpression.isValueCompatible()) {
            return FALSE;
        }
        ArrayList<ConstraintFormula> arrayList = new ArrayList<ConstraintFormula>();
        if (!lambdaExpression.argumentsTypeElided()) {
            object = lambdaExpression.arguments();
            int n = 0;
            while (n < typeBindingArray.length) {
                arrayList.add(ConstraintTypeFormula.create(typeBindingArray[n], object[n].type.resolvedType, 4));
                ++n;
            }
            if (lambdaExpression.resolvedType != null) {
                arrayList.add(ConstraintTypeFormula.create(lambdaExpression.resolvedType, this.right, 2));
            }
        }
        if (methodBinding.returnType != TypeBinding.VOID) {
            object = methodBinding.returnType;
            Expression[] expressionArray = lambdaExpression.resultExpressions();
            int n = 0;
            int n2 = expressionArray == null ? 0 : expressionArray.length;
            while (n < n2) {
                Expression expression = expressionArray[n];
                if (((TypeBinding)object).isProperType(true) && expression.resolvedType != null) {
                    TypeBinding typeBinding = expression.resolvedType;
                    if (!(expression.isConstantValueOfTypeAssignableToType(typeBinding, (TypeBinding)object) || typeBinding.isCompatibleWith((TypeBinding)object) || expression.isBoxingCompatible(typeBinding, (TypeBinding)object, expression, blockScope))) {
                        return FALSE;
                    }
                } else {
                    arrayList.add(new ConstraintExpressionFormula(expression, (TypeBinding)object, 1, this.isSoft));
                }
                ++n;
            }
        }
        if (arrayList.size() != 0) return arrayList.toArray(new ConstraintFormula[arrayList.size()]);
        return TRUE;
    }

    public static ReferenceBinding findGroundTargetType(InferenceContext18 inferenceContext18, BlockScope blockScope, LambdaExpression lambdaExpression, ParameterizedTypeBinding parameterizedTypeBinding) {
        if (lambdaExpression.argumentsTypeElided()) {
            return lambdaExpression.findGroundTargetTypeForElidedLambda(blockScope, parameterizedTypeBinding);
        }
        InferenceContext18.SuspendedInferenceRecord suspendedInferenceRecord = inferenceContext18.enterLambda(lambdaExpression);
        try {
            ReferenceBinding referenceBinding = inferenceContext18.inferFunctionalInterfaceParameterization(lambdaExpression, blockScope, parameterizedTypeBinding);
            return referenceBinding;
        }
        finally {
            inferenceContext18.resumeSuspendedInference(suspendedInferenceRecord);
        }
    }

    private boolean canBePolyExpression(Expression expression) {
        ExpressionContext expressionContext = expression.getExpressionContext();
        if (expressionContext == ExpressionContext.VANILLA_CONTEXT) {
            this.left.setExpressionContext(ExpressionContext.ASSIGNMENT_CONTEXT);
        }
        try {
            boolean bl = expression.isPolyExpression();
            return bl;
        }
        finally {
            expression.setExpressionContext(expressionContext);
        }
    }

    private Object reduceReferenceExpressionCompatibility(ReferenceExpression referenceExpression, InferenceContext18 inferenceContext18) {
        Object object;
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        MethodBinding methodBinding;
        TypeBinding typeBinding3 = this.right;
        if (typeBinding3.isProperType(true)) {
            throw new IllegalStateException("Should not reach here with T being a proper type");
        }
        if (!typeBinding3.isFunctionalInterface(inferenceContext18.scope)) {
            return FALSE;
        }
        MethodBinding methodBinding2 = typeBinding3.getSingleAbstractMethod(inferenceContext18.scope, true);
        if (methodBinding2 == null) {
            return FALSE;
        }
        MethodBinding methodBinding3 = methodBinding = (referenceExpression = referenceExpression.resolveExpressionExpecting(typeBinding3, inferenceContext18.scope, inferenceContext18)) != null ? referenceExpression.binding : null;
        if (methodBinding == null) {
            return FALSE;
        }
        if (referenceExpression.isExactMethodReference()) {
            ArrayList<ConstraintTypeFormula> arrayList = new ArrayList<ConstraintTypeFormula>();
            TypeBinding[] typeBindingArray = methodBinding2.parameters;
            int n = typeBindingArray.length;
            TypeBinding[] typeBindingArray2 = methodBinding.parameters;
            int n2 = typeBindingArray2.length;
            int n3 = 0;
            if (n == n2 + 1) {
                arrayList.add(ConstraintTypeFormula.create(typeBindingArray[0], referenceExpression.lhs.resolvedType, 1));
                n3 = 1;
            }
            int n4 = n3;
            while (n4 < n) {
                arrayList.add(ConstraintTypeFormula.create(typeBindingArray[n4], typeBindingArray2[n4 - n3], 1));
                ++n4;
            }
            TypeBinding typeBinding4 = methodBinding2.returnType;
            if (typeBinding4 != TypeBinding.VOID) {
                TypeBinding typeBinding5;
                TypeBinding typeBinding6 = typeBinding5 = methodBinding.isConstructor() && !referenceExpression.isArrayConstructorReference() ? methodBinding.declaringClass : methodBinding.returnType;
                if (typeBinding5 == TypeBinding.VOID) {
                    return FALSE;
                }
                TypeBinding typeBinding7 = typeBinding5.capture(inferenceContext18.scope, referenceExpression.sourceStart, referenceExpression.sourceEnd);
                arrayList.add(ConstraintTypeFormula.create(typeBinding7, typeBinding4, 1));
            }
            return arrayList.toArray(new ConstraintFormula[arrayList.size()]);
        }
        int n = methodBinding2.parameters.length;
        int n5 = 0;
        while (n5 < n) {
            if (!methodBinding2.parameters[n5].isProperType(true)) {
                return FALSE;
            }
            ++n5;
        }
        MethodBinding methodBinding4 = methodBinding;
        if (!methodBinding4.isValidBinding()) {
            return FALSE;
        }
        TypeBinding typeBinding8 = typeBinding2 = methodBinding2.isConstructor() ? methodBinding2.declaringClass : methodBinding2.returnType;
        if (typeBinding2.id == 6) {
            return TRUE;
        }
        MethodBinding methodBinding5 = methodBinding4.shallowOriginal();
        TypeBinding typeBinding9 = typeBinding = methodBinding5.isConstructor() ? methodBinding5.declaringClass : methodBinding5.returnType;
        if (referenceExpression.typeArguments == null && (methodBinding5.typeVariables() != Binding.NO_TYPE_VARIABLES && typeBinding.mentionsAny(methodBinding5.typeVariables(), -1) || methodBinding5.isConstructor() && methodBinding4.declaringClass.isRawType())) {
            object = inferenceContext18.enterPolyInvocation(referenceExpression, referenceExpression.createPseudoExpressions(methodBinding2.parameters));
            try {
                InferenceContext18 inferenceContext182 = referenceExpression.getInferenceContext((ParameterizedMethodBinding)methodBinding4);
                int n6 = inferenceContext182 != null ? inferenceContext182.inferenceKind : 1;
                ConstraintExpressionFormula.inferInvocationApplicability(inferenceContext18, methodBinding5, methodBinding2.parameters, methodBinding5.isConstructor(), n6);
                if (!ConstraintExpressionFormula.inferPolyInvocationType(inferenceContext18, referenceExpression, typeBinding2, methodBinding5)) {
                    ConstraintTypeFormula constraintTypeFormula = FALSE;
                    return constraintTypeFormula;
                }
                if (!methodBinding5.isConstructor() || referenceExpression.receiverType.isRawType() || referenceExpression.receiverType.typeArguments() == null) {
                    return null;
                }
            }
            catch (InferenceFailureException inferenceFailureException) {
                ConstraintTypeFormula constraintTypeFormula = FALSE;
                return constraintTypeFormula;
            }
            finally {
                inferenceContext18.resumeSuspendedInference((InferenceContext18.SuspendedInferenceRecord)object);
            }
        }
        Object object2 = object = methodBinding4.isConstructor() ? methodBinding4.declaringClass : methodBinding4.returnType.capture(inferenceContext18.scope, referenceExpression.sourceStart(), referenceExpression.sourceEnd());
        if (((TypeBinding)object).id == 6) {
            return FALSE;
        }
        return ConstraintTypeFormula.create((TypeBinding)object, typeBinding2, 1, this.isSoft);
    }

    static void inferInvocationApplicability(InferenceContext18 inferenceContext18, MethodBinding methodBinding, TypeBinding[] typeBindingArray, boolean bl, int n) {
        int n2;
        TypeBinding[] typeBindingArray2;
        TypeBinding[] typeBindingArray3 = methodBinding.typeVariables;
        if (bl) {
            typeBindingArray2 = methodBinding.declaringClass.typeVariables();
            int n3 = typeBindingArray3.length;
            n2 = typeBindingArray2.length;
            if (n3 == 0) {
                typeBindingArray3 = typeBindingArray2;
            } else if (n2 != 0) {
                TypeBinding[] typeBindingArray4 = typeBindingArray3;
                typeBindingArray3 = new TypeVariableBinding[n3 + n2];
                System.arraycopy(typeBindingArray4, 0, typeBindingArray3, 0, n3);
                System.arraycopy(typeBindingArray2, 0, typeBindingArray3, n3, n2);
            }
        }
        typeBindingArray2 = methodBinding.parameters;
        InferenceVariable[] inferenceVariableArray = inferenceContext18.createInitialBoundSet((TypeVariableBinding[])typeBindingArray3);
        n2 = methodBinding.parameters.length;
        TypeBinding typeBinding = null;
        if (methodBinding.isVarargs()) {
            int n4 = n2 - 1;
            typeBinding = methodBinding.parameters[n4];
        }
        inferenceContext18.createInitialConstraintsForParameters(typeBindingArray2, n == 3, typeBinding, methodBinding);
        inferenceContext18.addThrowsContraints(typeBindingArray3, inferenceVariableArray, methodBinding.thrownExceptions);
    }

    static boolean inferPolyInvocationType(InferenceContext18 inferenceContext18, InvocationSite invocationSite, TypeBinding typeBinding, MethodBinding methodBinding) throws InferenceFailureException {
        TypeBinding[] typeBindingArray = invocationSite.genericTypeArguments();
        if (typeBindingArray == null) {
            Object object;
            TypeBinding typeBinding2;
            Object object2;
            TypeBinding typeBinding3;
            TypeBinding typeBinding4 = typeBinding3 = methodBinding.isConstructor() ? methodBinding.declaringClass : methodBinding.returnType;
            if (typeBinding3 == TypeBinding.VOID) {
                throw new InferenceFailureException("expression has no value");
            }
            if (inferenceContext18.usesUncheckedConversion && !inferenceContext18.reduceAndIncorporate((ConstraintFormula)(object2 = ConstraintTypeFormula.create(typeBinding2 = inferenceContext18.environment.convertToRawType(typeBinding3, false), typeBinding, 1)))) {
                return false;
            }
            typeBinding2 = inferenceContext18.substitute(typeBinding3);
            object2 = InferenceContext18.parameterizedWithWildcard(typeBinding2);
            if (object2 != null && ((ParameterizedTypeBinding)object2).arguments != null) {
                TypeBinding[] typeBindingArray2 = ((ParameterizedTypeBinding)object2).arguments;
                TypeBinding[] typeBindingArray3 = inferenceContext18.addTypeVariableSubstitutions(typeBindingArray2);
                ParameterizedTypeBinding parameterizedTypeBinding = inferenceContext18.environment.createParameterizedType(((ParameterizedTypeBinding)object2).genericType(), typeBindingArray3, ((ParameterizedTypeBinding)object2).enclosingType(), ((TypeBinding)object2).getTypeAnnotations());
                inferenceContext18.currentBounds.captures.put(parameterizedTypeBinding, (ParameterizedTypeBinding)object2);
                object2 = ((ParameterizedTypeBinding)object2).capture(inferenceContext18.scope, invocationSite.sourceStart(), invocationSite.sourceEnd());
                typeBindingArray2 = ((ParameterizedTypeBinding)object2).arguments;
                int n = 0;
                int n2 = typeBindingArray2.length;
                while (n < n2) {
                    if (typeBindingArray2[n].isCapture() && typeBindingArray2[n].isProperType(true)) {
                        CaptureBinding captureBinding = (CaptureBinding)typeBindingArray2[n];
                        inferenceContext18.currentBounds.addBound(new TypeBound((InferenceVariable)typeBindingArray3[n], captureBinding, 4), inferenceContext18.environment);
                    }
                    ++n;
                }
                ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(parameterizedTypeBinding, typeBinding, 1);
                return inferenceContext18.reduceAndIncorporate(constraintTypeFormula);
            }
            if (typeBinding2.leafComponentType() instanceof InferenceVariable) {
                Object object3;
                object = (InferenceVariable)typeBinding2.leafComponentType();
                TypeBinding typeBinding5 = typeBinding.leafComponentType();
                boolean bl = false;
                if (inferenceContext18.currentBounds.condition18_5_2_bullet_3_3_1((InferenceVariable)object, typeBinding5)) {
                    bl = true;
                } else if (inferenceContext18.currentBounds.condition18_5_2_bullet_3_3_2((InferenceVariable)object, typeBinding5, inferenceContext18)) {
                    bl = true;
                } else if (typeBinding5.isPrimitiveType() && (object3 = inferenceContext18.currentBounds.findWrapperTypeBound((InferenceVariable)object)) != null) {
                    bl = true;
                }
                if (bl) {
                    object3 = inferenceContext18.solve(new InferenceVariable[]{object});
                    if (object3 == null) {
                        return false;
                    }
                    TypeBinding typeBinding6 = ((BoundSet)object3).getInstantiation((InferenceVariable)object, null).capture(inferenceContext18.scope, invocationSite.sourceStart(), invocationSite.sourceEnd());
                    if (typeBinding2.dimensions() != 0) {
                        typeBinding6 = inferenceContext18.environment.createArrayType(typeBinding6, typeBinding2.dimensions());
                    }
                    ConstraintTypeFormula constraintTypeFormula = ConstraintTypeFormula.create(typeBinding6, typeBinding, 1);
                    return inferenceContext18.reduceAndIncorporate(constraintTypeFormula);
                }
            }
            if (!inferenceContext18.reduceAndIncorporate((ConstraintFormula)(object = ConstraintTypeFormula.create(typeBinding2, typeBinding, 1)))) {
                return false;
            }
        }
        return true;
    }

    @Override
    Collection<InferenceVariable> inputVariables(InferenceContext18 inferenceContext18) {
        if (this.left instanceof LambdaExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope)) {
                LambdaExpression lambdaExpression = (LambdaExpression)this.left;
                MethodBinding methodBinding = this.right.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                if (lambdaExpression.argumentsTypeElided()) {
                    int n = methodBinding.parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        methodBinding.parameters[n2].collectInferenceVariables(hashSet);
                        ++n2;
                    }
                }
                if (methodBinding.returnType != TypeBinding.VOID) {
                    TypeBinding typeBinding = methodBinding.returnType;
                    LambdaExpression lambdaExpression2 = lambdaExpression.resolveExpressionExpecting(this.right, inferenceContext18.scope, inferenceContext18);
                    Expression[] expressionArray = lambdaExpression2 != null ? lambdaExpression2.resultExpressions() : null;
                    int n = 0;
                    int n3 = expressionArray == null ? 0 : expressionArray.length;
                    while (n < n3) {
                        hashSet.addAll(new ConstraintExpressionFormula(expressionArray[n], typeBinding, 1).inputVariables(inferenceContext18));
                        ++n;
                    }
                }
                return hashSet;
            }
        } else if (this.left instanceof ReferenceExpression) {
            if (this.right instanceof InferenceVariable) {
                return Collections.singletonList((InferenceVariable)this.right);
            }
            if (this.right.isFunctionalInterface(inferenceContext18.scope) && !this.left.isExactMethodReference()) {
                MethodBinding methodBinding = this.right.getSingleAbstractMethod(inferenceContext18.scope, true);
                HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
                int n = methodBinding.parameters.length;
                int n4 = 0;
                while (n4 < n) {
                    methodBinding.parameters[n4].collectInferenceVariables(hashSet);
                    ++n4;
                }
                return hashSet;
            }
        } else if (this.left instanceof ConditionalExpression && this.left.isPolyExpression()) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)this.left;
            HashSet<InferenceVariable> hashSet = new HashSet<InferenceVariable>();
            hashSet.addAll(new ConstraintExpressionFormula(conditionalExpression.valueIfTrue, this.right, 1).inputVariables(inferenceContext18));
            hashSet.addAll(new ConstraintExpressionFormula(conditionalExpression.valueIfFalse, this.right, 1).inputVariables(inferenceContext18));
            return hashSet;
        }
        return EMPTY_VARIABLE_LIST;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append('\u27e8');
        this.left.printExpression(4, stringBuffer);
        stringBuffer.append(ConstraintExpressionFormula.relationToString(this.relation));
        this.appendTypeName(stringBuffer, this.right);
        stringBuffer.append('\u27e9');
        return stringBuffer.toString();
    }
}

