/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.TryFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FinallyFlowContext
extends TryFlowContext {
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount;
    LocalVariableBinding[] nullLocals;
    ASTNode[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;
    public FlowContext tryContext;

    public FinallyFlowContext(FlowContext flowContext, ASTNode aSTNode, ExceptionHandlingFlowContext exceptionHandlingFlowContext) {
        super(flowContext, aSTNode);
        this.tryContext = exceptionHandlingFlowContext;
    }

    public void complainOnDeferredChecks(FlowInfo flowInfo, BlockScope blockScope) {
        TypeConstants typeConstants;
        int n;
        Object object;
        int n2 = 0;
        while (n2 < this.assignCount) {
            object = this.finalVariables[n2];
            if (object != null) {
                n = 0;
                if (object instanceof FieldBinding) {
                    if (flowInfo.isPotentiallyAssigned((FieldBinding)object)) {
                        n = 1;
                        blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)object, this.finalAssignments[n2]);
                    }
                } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)object)) {
                    ((VariableBinding)object).tagBits &= 0xFFFFFFFFFFFFF7FFL;
                    if (((VariableBinding)object).isFinal()) {
                        n = 1;
                        blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)object, this.finalAssignments[n2]);
                    }
                }
                if (n != 0) {
                    typeConstants = this.getLocalParent();
                    while (typeConstants != null) {
                        ((FlowContext)typeConstants).removeFinalAssignmentIfAny(this.finalAssignments[n2]);
                        typeConstants = ((FlowContext)typeConstants).getLocalParent();
                    }
                }
            }
            ++n2;
        }
        if ((this.tagBits & 1) != 0) {
            n2 = 0;
            while (n2 < this.nullCount) {
                object = this.nullReferences[n2];
                switch (this.nullCheckTypes[n2] & 0xFFFF0FFF) {
                    case 128: {
                        n = flowInfo.nullStatus(this.nullLocals[n2]);
                        if (n == 4) break;
                        this.parent.recordNullityMismatch(blockScope, (Expression)object, this.providedExpectedTypes[n2][0], this.providedExpectedTypes[n2][1], flowInfo, n, null);
                        break;
                    }
                    case 16: {
                        this.checkUnboxing(blockScope, (Expression)object, flowInfo);
                        break;
                    }
                    default: {
                        this.parent.recordUsingNullReference(blockScope, this.nullLocals[n2], this.nullReferences[n2], this.nullCheckTypes[n2], flowInfo);
                    }
                }
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < this.nullCount) {
                object = this.nullReferences[n2];
                LocalVariableBinding localVariableBinding = this.nullLocals[n2];
                block4 : switch (this.nullCheckTypes[n2] & 0xFFFF0FFF) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if ((this.nullCheckTypes[n2] & 0xFFFF0FFF) == 512) {
                                if ((this.nullCheckTypes[n2] & 0x1000) != 0) break;
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, (ASTNode)object);
                                break;
                            }
                            blockScope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, (ASTNode)object);
                            break;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        typeConstants = (Expression)object;
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                                case 256: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (((Expression)typeConstants).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)typeConstants);
                                        break block4;
                                    }
                                    if ((this.nullCheckTypes[n2] & 0x1000) != 0) break block4;
                                    blockScope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, (ASTNode)typeConstants);
                                    break block4;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) == 1 && (((Expression)typeConstants).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)typeConstants);
                                        break block4;
                                    }
                                    blockScope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, (ASTNode)typeConstants);
                                    break block4;
                                }
                                case 768: {
                                    blockScope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, (ASTNode)typeConstants);
                                    break block4;
                                }
                                case 1024: {
                                    blockScope.problemReporter().localVariableNullInstanceof(localVariableBinding, (ASTNode)typeConstants);
                                    break block4;
                                }
                            }
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                        switch (this.nullCheckTypes[n2] & 0xFFFF0F00) {
                            case 256: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) != 1 || (((Expression)typeConstants).implicitConversion & 0x400) == 0) break block4;
                                blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)typeConstants);
                                break block4;
                            }
                            case 512: {
                                this.nullReferences[n2] = null;
                                if ((this.nullCheckTypes[n2] & 0xFF & 0xFFFF0FFF) != 1 || (((Expression)typeConstants).implicitConversion & 0x400) == 0) break block4;
                                blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)typeConstants);
                                break block4;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            blockScope.problemReporter().localVariableNullReference(localVariableBinding, (ASTNode)object);
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                        blockScope.problemReporter().localVariablePotentialNullReference(localVariableBinding, (ASTNode)object);
                        break;
                    }
                    case 128: {
                        int n3 = flowInfo.nullStatus(localVariableBinding);
                        if (n3 == 4) break;
                        char[][] cArray = blockScope.environment().getNonNullAnnotationName();
                        blockScope.problemReporter().nullityMismatch((Expression)object, this.providedExpectedTypes[n2][0], this.providedExpectedTypes[n2][1], n3, cArray);
                        break;
                    }
                    case 16: {
                        this.checkUnboxing(blockScope, (Expression)object, flowInfo);
                    }
                }
                ++n2;
            }
        }
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Finally flow context");
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    public boolean isSubRoutine() {
        return true;
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        block52: {
            block54: {
                int n2;
                block53: {
                    if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) break block52;
                    n2 = (n |= this.tagBits & 0x1000) & 0xFFFF0FFF;
                    if ((this.tagBits & 1) == 0) break block53;
                    switch (n2) {
                        case 256: 
                        case 257: 
                        case 512: 
                        case 513: 
                        case 769: 
                        case 1025: {
                            Expression expression = (Expression)aSTNode;
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                if (n2 == 512) {
                                    if ((n & 0x1000) == 0) {
                                        scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                                    }
                                    flowInfo.initsWhenFalse().setReachMode(2);
                                } else if (n2 == 256) {
                                    scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                                    flowInfo.initsWhenTrue().setReachMode(2);
                                }
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                switch (n2 & 0xFFFF0F00) {
                                    case 256: {
                                        if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                            return;
                                        }
                                        if ((n & 0x1000) == 0) {
                                            scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                        }
                                        flowInfo.initsWhenFalse().setReachMode(2);
                                        return;
                                    }
                                    case 512: {
                                        if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                            scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                            return;
                                        }
                                        scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                        flowInfo.initsWhenTrue().setReachMode(2);
                                        return;
                                    }
                                    case 768: {
                                        scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                        return;
                                    }
                                    case 1024: {
                                        scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                        return;
                                    }
                                }
                                break;
                            }
                            if (!flowInfo.isPotentiallyNull(localVariableBinding)) break block54;
                            switch (n2 & 0xFFFF0F00) {
                                case 256: {
                                    if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    break block54;
                                }
                                case 512: {
                                    if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    break block54;
                                }
                            }
                            break block54;
                        }
                        case 3: {
                            if (flowInfo.cannotBeNull(localVariableBinding)) {
                                return;
                            }
                            if (flowInfo.canOnlyBeNull(localVariableBinding)) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, aSTNode);
                                return;
                            }
                            break block54;
                        }
                    }
                    break block54;
                }
                block14 : switch (n2) {
                    case 256: 
                    case 512: {
                        if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                            if (n2 == 512) {
                                if ((n & 0x1000) == 0) {
                                    scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, aSTNode);
                                }
                                flowInfo.initsWhenFalse().setReachMode(2);
                            } else {
                                scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, aSTNode);
                                flowInfo.initsWhenTrue().setReachMode(2);
                            }
                            return;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        Expression expression = (Expression)aSTNode;
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            switch (n2 & 0xFFFF0F00) {
                                case 256: {
                                    if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    if ((n & 0x1000) == 0) {
                                        scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                                    }
                                    flowInfo.initsWhenFalse().setReachMode(2);
                                    return;
                                }
                                case 512: {
                                    if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                        scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                        return;
                                    }
                                    scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                                    flowInfo.initsWhenTrue().setReachMode(2);
                                    return;
                                }
                                case 768: {
                                    scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                                    return;
                                }
                                case 1024: {
                                    scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                                    return;
                                }
                            }
                            break;
                        }
                        if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                        switch (n2 & 0xFFFF0F00) {
                            case 256: {
                                if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break block14;
                                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                return;
                            }
                            case 512: {
                                if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break block14;
                                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                                return;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                            scope.problemReporter().localVariableNullReference(localVariableBinding, aSTNode);
                            return;
                        }
                        if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, aSTNode);
                            return;
                        }
                        if (!flowInfo.isDefinitelyNonNull(localVariableBinding)) break;
                        return;
                    }
                }
            }
            this.recordNullReference(localVariableBinding, aSTNode, n, flowInfo);
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        int n = 0;
        while (n < this.assignCount) {
            if (this.finalAssignments[n] == reference) {
                this.finalAssignments[n] = null;
                this.finalVariables[n] = null;
                return;
            }
            ++n;
        }
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new ASTNode[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            int n2 = this.nullCount * 2;
            this.nullLocals = new LocalVariableBinding[n2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new ASTNode[n2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[n2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = aSTNode;
        this.nullCheckTypes[this.nullCount++] = n;
    }

    public void recordUnboxing(Scope scope, Expression expression, int n, FlowInfo flowInfo) {
        if (n == 2) {
            super.recordUnboxing(scope, expression, n, flowInfo);
        } else {
            this.recordNullReference(null, expression, 16, flowInfo);
        }
    }

    protected boolean internalRecordNullityMismatch(Expression expression, TypeBinding typeBinding, FlowInfo flowInfo, int n, TypeBinding typeBinding2, int n2) {
        if (n == 1 || (this.tagBits & 1) != 0 && n != 2) {
            this.recordProvidedExpectedTypes(typeBinding, typeBinding2, this.nullCount);
            this.recordNullReference(expression.localVariableBinding(), expression, n2, flowInfo);
            return true;
        }
        return false;
    }
}

