/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.HashMap;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ExpressionContext;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.IPolyExpression;
import org.eclipse.jdt.internal.compiler.ast.Invocation;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InferenceContext18;
import org.eclipse.jdt.internal.compiler.lookup.IntersectionTypeBinding18;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PolyTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class ReferenceExpression
extends FunctionalExpression
implements IPolyExpression,
InvocationSite {
    private static final String SecretReceiverVariableName = " rec_";
    private static final char[] ImplicitArgName = " arg".toCharArray();
    public LocalVariableBinding receiverVariable;
    public Expression lhs;
    public TypeReference[] typeArguments;
    public char[] selector;
    public int nameSourceStart;
    public TypeBinding receiverType;
    private boolean haveReceiver;
    public TypeBinding[] resolvedTypeArguments;
    private boolean typeArgumentsHaveErrors;
    MethodBinding syntheticAccessor;
    private int depth;
    private MethodBinding exactMethodBinding;
    private boolean receiverPrecedesParameters = false;
    private TypeBinding[] freeParameters;
    private boolean checkingPotentialCompatibility;
    private MethodBinding[] potentialMethods = Binding.NO_METHODS;
    protected ReferenceExpression original = this;
    private HashMap<TypeBinding, ReferenceExpression> copiesPerTargetType;
    public char[] text;
    private HashMap<ParameterizedGenericMethodBinding, InferenceContext18> inferenceContexts;

    public void initialize(CompilationResult compilationResult, Expression expression, TypeReference[] typeReferenceArray, char[] cArray, int n) {
        super.setCompilationResult(compilationResult);
        this.lhs = expression;
        this.typeArguments = typeReferenceArray;
        this.selector = cArray;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = n;
    }

    private ReferenceExpression copy() {
        Parser parser = new Parser(this.enclosingScope.problemReporter(), false);
        ICompilationUnit iCompilationUnit = this.compilationResult.getCompilationUnit();
        char[] cArray = iCompilationUnit != null ? iCompilationUnit.getContents() : this.text;
        ReferenceExpression referenceExpression = (ReferenceExpression)parser.parseExpression(cArray, iCompilationUnit != null ? this.sourceStart : 0, this.sourceEnd - this.sourceStart + 1, this.enclosingScope.referenceCompilationUnit(), false);
        referenceExpression.original = this;
        referenceExpression.sourceStart = this.sourceStart;
        referenceExpression.sourceEnd = this.sourceEnd;
        return referenceExpression;
    }

    private boolean shouldGenerateSecretReceiverVariable() {
        if (this.isMethodReference() && this.haveReceiver) {
            if (this.lhs instanceof Invocation) {
                return true;
            }
            return new ASTVisitor(){
                boolean accessesnonFinalOuterLocals;

                public boolean visit(SingleNameReference singleNameReference, BlockScope blockScope) {
                    LocalVariableBinding localVariableBinding;
                    Binding binding = blockScope.getBinding(singleNameReference.getName(), ReferenceExpression.this);
                    if (binding instanceof LocalVariableBinding && !(localVariableBinding = (LocalVariableBinding)binding).isFinal() && !localVariableBinding.isEffectivelyFinal()) {
                        this.accessesnonFinalOuterLocals = true;
                    }
                    return false;
                }

                public boolean accessesnonFinalOuterLocals() {
                    ReferenceExpression.this.lhs.traverse((ASTVisitor)this, ReferenceExpression.this.enclosingScope);
                    return this.accessesnonFinalOuterLocals;
                }
            }.accessesnonFinalOuterLocals();
        }
        return false;
    }

    public void generateImplicitLambda(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        Object object;
        Object object2;
        ReferenceExpression referenceExpression = this.copy();
        int n = this.descriptor.parameters.length;
        LambdaExpression lambdaExpression = new LambdaExpression(this.compilationResult, false, (this.binding.modifiers & 0x40000000) != 0);
        Argument[] argumentArray = new Argument[n];
        int n2 = 0;
        while (n2 < n) {
            argumentArray[n2] = new Argument(CharOperation.append(ImplicitArgName, Integer.toString(n2).toCharArray()), 0L, null, 0, true);
            ++n2;
        }
        lambdaExpression.setArguments(argumentArray);
        lambdaExpression.setExpressionContext(this.expressionContext);
        lambdaExpression.setExpectedType(this.expectedType);
        n2 = this.receiverPrecedesParameters ? 1 : 0;
        SingleNameReference[] singleNameReferenceArray = new SingleNameReference[n - n2];
        int n3 = 0;
        int n4 = singleNameReferenceArray.length;
        while (n3 < n4) {
            object2 = CharOperation.append(ImplicitArgName, Integer.toString(n3 + n2).toCharArray());
            singleNameReferenceArray[n3] = new SingleNameReference((char[])object2, 0L);
            ++n3;
        }
        n3 = this.shouldGenerateSecretReceiverVariable() ? 1 : 0;
        if (this.isMethodReference()) {
            Object object3;
            if (n3 != 0) {
                this.lhs.generateCode(blockScope, codeStream, true);
                codeStream.store(this.receiverVariable, false);
                codeStream.addVariable(this.receiverVariable);
            }
            object = new MessageSend();
            ((MessageSend)object).selector = this.selector;
            object2 = n3 != 0 ? new SingleNameReference(this.receiverVariable.name, 0L) : referenceExpression.lhs;
            if (this.receiverPrecedesParameters) {
                SingleNameReference singleNameReference;
                object3 = singleNameReference;
                singleNameReference = new SingleNameReference(CharOperation.append(ImplicitArgName, Integer.toString(0).toCharArray()), 0L);
            } else {
                object3 = object2;
            }
            ((MessageSend)object).receiver = object3;
            ((MessageSend)object).typeArguments = referenceExpression.typeArguments;
            ((MessageSend)object).arguments = singleNameReferenceArray;
            lambdaExpression.setBody((Statement)object);
        } else if (this.isArrayConstructorReference()) {
            object = new ArrayAllocationExpression();
            ((ArrayAllocationExpression)object).dimensions = new Expression[]{singleNameReferenceArray[0]};
            if (this.lhs instanceof ArrayTypeReference) {
                object2 = (ArrayTypeReference)this.lhs;
                ((ArrayAllocationExpression)object).type = object2.dimensions == 1 ? new SingleTypeReference(object2.token, 0L) : new ArrayTypeReference(object2.token, object2.dimensions - 1, 0L);
            } else {
                object2 = (ArrayQualifiedTypeReference)this.lhs;
                ((ArrayAllocationExpression)object).type = object2.dimensions == 1 ? new QualifiedTypeReference(object2.tokens, object2.sourcePositions) : new ArrayQualifiedTypeReference(object2.tokens, object2.dimensions - 1, object2.sourcePositions);
            }
            lambdaExpression.setBody((Statement)object);
        } else {
            object = new AllocationExpression();
            if (this.lhs instanceof TypeReference) {
                ((AllocationExpression)object).type = (TypeReference)this.lhs;
            } else if (this.lhs instanceof SingleNameReference) {
                ((AllocationExpression)object).type = new SingleTypeReference(((SingleNameReference)this.lhs).token, 0L);
            } else if (this.lhs instanceof QualifiedNameReference) {
                ((AllocationExpression)object).type = new QualifiedTypeReference(((QualifiedNameReference)this.lhs).tokens, new long[((QualifiedNameReference)this.lhs).tokens.length]);
            } else {
                throw new IllegalStateException("Unexpected node type");
            }
            ((AllocationExpression)object).typeArguments = referenceExpression.typeArguments;
            ((AllocationExpression)object).arguments = singleNameReferenceArray;
            lambdaExpression.setBody((Statement)object);
        }
        lambdaExpression.resolve(blockScope);
        object = blockScope.problemReporter().switchErrorHandlingPolicy(silentErrorHandlingPolicy);
        try {
            lambdaExpression.analyseCode(blockScope, new ExceptionHandlingFlowContext(null, this, Binding.NO_EXCEPTIONS, null, blockScope, FlowInfo.DEAD_END), UnconditionalFlowInfo.fakeInitializedFlowInfo(blockScope.outerMostMethodScope().analysisIndex, blockScope.referenceType().maxFieldCount));
        }
        finally {
            blockScope.problemReporter().switchErrorHandlingPolicy((IErrorHandlingPolicy)object);
        }
        object2 = this.receiverType.syntheticOuterLocalVariables();
        int n5 = 0;
        int n6 = object2 == null ? 0 : ((char[])object2).length;
        while (n5 < n6) {
            lambdaExpression.addSyntheticArgument(object2[n5].actualOuterLocalVariable);
            ++n5;
        }
        lambdaExpression.generateCode(blockScope, codeStream, bl);
        if (n3 != 0) {
            codeStream.removeVariable(this.receiverVariable);
            this.receiverVariable = null;
        }
    }

    private boolean shouldGenerateImplicitLambda(BlockScope blockScope) {
        return this.binding.isVarargs() || this.isConstructorReference() && this.receiverType.syntheticOuterLocalVariables() != null && blockScope.methodScope().isStatic || this.expectedType instanceof IntersectionTypeBinding18 || this.expectedType.findSuperTypeOriginatingFrom(blockScope.getJavaIoSerializable()) != null || this.requiresBridges();
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        Object object;
        this.actualMethodBinding = this.binding;
        if (this.shouldGenerateImplicitLambda(blockScope)) {
            this.generateImplicitLambda(blockScope, codeStream, bl);
            return;
        }
        SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
        if (this.receiverType.isArrayType()) {
            if (this.isConstructorReference()) {
                this.actualMethodBinding = this.binding = sourceTypeBinding.addSyntheticArrayMethod((ArrayBinding)this.receiverType, 14);
            } else if (CharOperation.equals(this.selector, TypeConstants.CLONE)) {
                this.actualMethodBinding = this.binding = sourceTypeBinding.addSyntheticArrayMethod((ArrayBinding)this.receiverType, 15);
            }
        } else if (this.syntheticAccessor != null) {
            if (this.lhs.isSuper() || this.isMethodReference()) {
                this.binding = this.syntheticAccessor;
            }
        } else if (this.binding != null && this.isMethodReference() && TypeBinding.notEquals(this.binding.declaringClass, this.lhs.resolvedType.erasure()) && !this.binding.declaringClass.canBeSeenBy(blockScope)) {
            this.binding = new MethodBinding(this.binding, (ReferenceBinding)this.lhs.resolvedType.erasure());
        }
        int n = codeStream.position;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        stringBuffer.append('(');
        if (this.haveReceiver) {
            this.lhs.generateCode(blockScope, codeStream, true);
            if (this.lhs.isSuper() && !this.actualMethodBinding.isPrivate()) {
                if (this.lhs instanceof QualifiedSuperReference) {
                    object = (QualifiedSuperReference)this.lhs;
                    TypeReference typeReference = object.qualification;
                    if (typeReference.resolvedType.isInterface()) {
                        stringBuffer.append(sourceTypeBinding.signature());
                    } else {
                        stringBuffer.append(((QualifiedSuperReference)this.lhs).currentCompatibleType.signature());
                    }
                } else {
                    stringBuffer.append(sourceTypeBinding.signature());
                }
            } else {
                stringBuffer.append(this.receiverType.signature());
            }
            n2 = 1;
        } else if (this.isConstructorReference()) {
            object = Binding.UNINITIALIZED_REFERENCE_TYPES;
            if (this.receiverType.isNestedType()) {
                ReferenceBinding referenceBinding = (ReferenceBinding)this.receiverType;
                object = referenceBinding.syntheticEnclosingInstanceTypes();
                if (object != null) {
                    int n3;
                    n2 = n3 = ((ReferenceBinding[])object).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TypeBinding typeBinding = object[n4];
                        stringBuffer.append(((ReferenceBinding)typeBinding).signature());
                        Object[] objectArray = blockScope.getEmulationPath((ReferenceBinding)typeBinding, false, true);
                        codeStream.generateOuterAccess(objectArray, this, typeBinding, blockScope);
                        ++n4;
                    }
                } else {
                    object = Binding.NO_REFERENCE_TYPES;
                }
                if (referenceBinding.syntheticOuterLocalVariables() != null) {
                    blockScope.problemReporter().noSuchEnclosingInstance(referenceBinding.enclosingType(), this, false);
                    return;
                }
            }
            if (this.syntheticAccessor != null) {
                this.binding = sourceTypeBinding.addSyntheticFactoryMethod(this.binding, this.syntheticAccessor, (TypeBinding[])object);
            }
        }
        stringBuffer.append(')');
        stringBuffer.append('L');
        stringBuffer.append(this.resolvedType.constantPoolName());
        stringBuffer.append(';');
        int n5 = codeStream.classFile.recordBootstrapMethod(this);
        codeStream.invokeDynamic(n5, n2, 1, this.descriptor.selector, stringBuffer.toString().toCharArray(), this.isConstructorReference(), this.lhs instanceof TypeReference ? (TypeReference)this.lhs : null, this.typeArguments);
        if (!bl) {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0 || this.binding == null || !this.binding.isValidBinding()) {
            return;
        }
        MethodBinding methodBinding = this.binding.original();
        if (methodBinding.isVarargs()) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
        if (this.isConstructorReference()) {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (methodBinding.isPrivate() && TypeBinding.notEquals(sourceTypeBinding, referenceBinding = methodBinding.declaringClass)) {
                if ((referenceBinding.tagBits & 0x10L) != 0L) {
                    methodBinding.tagBits |= 0x200L;
                } else {
                    this.syntheticAccessor = ((SourceTypeBinding)referenceBinding).addSyntheticMethod(methodBinding, false);
                    blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
                }
            }
            return;
        }
        if (this.binding.isPrivate()) {
            if (TypeBinding.notEquals(sourceTypeBinding, methodBinding.declaringClass)) {
                this.syntheticAccessor = ((SourceTypeBinding)methodBinding.declaringClass).addSyntheticMethod(methodBinding, false);
                blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
            }
            return;
        }
        if (this.lhs.isSuper()) {
            SourceTypeBinding sourceTypeBinding2 = sourceTypeBinding;
            if (this.lhs instanceof QualifiedSuperReference) {
                QualifiedSuperReference qualifiedSuperReference = (QualifiedSuperReference)this.lhs;
                TypeReference typeReference = qualifiedSuperReference.qualification;
                if (!typeReference.resolvedType.isInterface()) {
                    sourceTypeBinding2 = (SourceTypeBinding)qualifiedSuperReference.currentCompatibleType;
                }
            }
            this.syntheticAccessor = sourceTypeBinding2.addSyntheticMethod(methodBinding, true);
            blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
            return;
        }
        if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0 && methodBinding.declaringClass.getPackage() != sourceTypeBinding.getPackage()) {
            SourceTypeBinding sourceTypeBinding3 = (SourceTypeBinding)sourceTypeBinding.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            this.syntheticAccessor = sourceTypeBinding3.addSyntheticMethod(methodBinding, this.isSuperAccess());
            blockScope.problemReporter().needToEmulateMethodAccess(methodBinding, this);
            return;
        }
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        TypeBinding typeBinding;
        if (this.haveReceiver) {
            this.lhs.checkNPE(blockScope, flowContext, flowInfo);
            this.lhs.analyseCode(blockScope, flowContext, flowInfo, true);
        } else if (this.isConstructorReference() && (typeBinding = this.receiverType.leafComponentType()).isMemberType() && typeBinding instanceof ReferenceBinding && !((ReferenceBinding)typeBinding).isStatic()) {
            blockScope.tagAsAccessingEnclosingInstanceStateOf((ReferenceBinding)typeBinding, false);
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public boolean checkingPotentialCompatibility() {
        return this.checkingPotentialCompatibility;
    }

    public void acceptPotentiallyCompatibleMethods(MethodBinding[] methodBindingArray) {
        if (this.checkingPotentialCompatibility) {
            this.potentialMethods = methodBindingArray;
        }
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceBinding[] referenceBindingArray;
        Object object;
        int n;
        TypeBinding typeBinding;
        CompilerOptions compilerOptions = blockScope.compilerOptions();
        if (this.constant != Constant.NotAConstant) {
            this.constant = Constant.NotAConstant;
            this.enclosingScope = blockScope;
            if (this.original == this) {
                this.recordFunctionalType(blockScope);
            }
            this.lhs.bits |= 0x40000000;
            typeBinding = this.lhs.resolveType(blockScope);
            this.lhs.computeConversion(blockScope, typeBinding, typeBinding);
            if (this.typeArguments != null) {
                int n2 = this.typeArguments.length;
                this.typeArgumentsHaveErrors = compilerOptions.sourceLevel < 0x310000L;
                this.resolvedTypeArguments = new TypeBinding[n2];
                n = 0;
                while (n < n2) {
                    TypeReference typeReference = this.typeArguments[n];
                    this.resolvedTypeArguments[n] = typeReference.resolveType(blockScope, true);
                    if (this.resolvedTypeArguments[n] == null) {
                        this.typeArgumentsHaveErrors = true;
                    }
                    if (this.typeArgumentsHaveErrors && typeReference instanceof Wildcard) {
                        blockScope.problemReporter().illegalUsageOfWildcard(typeReference);
                    }
                    ++n;
                }
                if (this.typeArgumentsHaveErrors || typeBinding == null) {
                    this.resolvedType = null;
                    return null;
                }
                if (this.isConstructorReference() && typeBinding.isRawType()) {
                    blockScope.problemReporter().rawConstructorReferenceNotWithExplicitTypeArguments(this.typeArguments);
                    this.resolvedType = null;
                    return null;
                }
            }
            if (this.typeArgumentsHaveErrors || typeBinding == null) {
                this.resolvedType = null;
                return null;
            }
            if (typeBinding.problemId() == 21) {
                typeBinding = typeBinding.closestMatch();
            }
            if (typeBinding == null || !typeBinding.isValidBinding()) {
                this.resolvedType = null;
                return null;
            }
            this.receiverType = typeBinding;
            this.haveReceiver = true;
            if (this.lhs instanceof NameReference) {
                if ((this.lhs.bits & 7) == 4) {
                    this.haveReceiver = false;
                } else if (this.isConstructorReference()) {
                    blockScope.problemReporter().invalidType(this.lhs, new ProblemReferenceBinding(((NameReference)this.lhs).getName(), null, 1));
                    this.resolvedType = null;
                    return null;
                }
            } else if (this.lhs instanceof TypeReference) {
                this.haveReceiver = false;
            }
            if (!(this.haveReceiver || this.lhs.isSuper() || this.isArrayConstructorReference())) {
                this.receiverType = typeBinding.capture(blockScope, this.sourceStart, this.sourceEnd);
            }
            if (!typeBinding.isRawType()) {
                this.exactMethodBinding = this.isMethodReference() ? blockScope.getExactMethod(typeBinding, this.selector, this) : blockScope.getExactConstructor(typeBinding, this);
                this.binding = this.exactMethodBinding;
            }
            if (this.isConstructorReference() && !typeBinding.canBeInstantiated()) {
                blockScope.problemReporter().cannotInstantiate(this.lhs, typeBinding);
                this.resolvedType = null;
                return null;
            }
            if (this.lhs instanceof TypeReference && ((TypeReference)this.lhs).hasNullTypeAnnotation(TypeReference.AnnotationPosition.ANY)) {
                blockScope.problemReporter().nullAnnotationUnsupportedLocation((TypeReference)this.lhs);
            }
            if (this.isConstructorReference() && typeBinding.isArrayType()) {
                TypeBinding typeBinding2 = typeBinding.leafComponentType();
                if (!typeBinding2.isReifiable()) {
                    blockScope.problemReporter().illegalGenericArray(typeBinding2, this);
                    this.resolvedType = null;
                    return null;
                }
                if (this.typeArguments != null) {
                    blockScope.problemReporter().invalidTypeArguments(this.typeArguments);
                    this.resolvedType = null;
                    return null;
                }
                this.binding = this.exactMethodBinding = blockScope.getExactConstructor(typeBinding, this);
            }
            if (this.isMethodReference() && this.haveReceiver && this.original == this) {
                this.receiverVariable = new LocalVariableBinding((SecretReceiverVariableName + this.nameSourceStart).toCharArray(), this.lhs.resolvedType, 0, false);
                blockScope.addLocalVariable(this.receiverVariable);
                this.receiverVariable.setConstant(Constant.NotAConstant);
                this.receiverVariable.useFlag = 1;
            }
            if (this.expectedType == null && this.expressionContext == ExpressionContext.INVOCATION_CONTEXT) {
                return new PolyTypeBinding(this);
            }
        } else {
            typeBinding = this.lhs.resolvedType;
            if (this.typeArgumentsHaveErrors || typeBinding == null) {
                this.resolvedType = null;
                return null;
            }
        }
        super.resolveType(blockScope);
        if (this.descriptor == null || !this.descriptor.isValidBinding()) {
            this.resolvedType = null;
            return null;
        }
        TypeBinding[] typeBindingArray = this.descriptorParametersAsArgumentExpressions();
        if (typeBinding.isBaseType()) {
            blockScope.problemReporter().errorNoMethodFor(this.lhs, typeBinding, this.selector, typeBindingArray);
            this.resolvedType = null;
            return null;
        }
        n = typeBindingArray.length;
        if (this.isConstructorReference() && typeBinding.isArrayType()) {
            if (n != 1 || blockScope.parameterCompatibilityLevel(typeBindingArray[0], TypeBinding.INT) == -1) {
                blockScope.problemReporter().invalidArrayConstructorReference(this, typeBinding, typeBindingArray);
                this.resolvedType = null;
                return null;
            }
            if (this.descriptor.returnType.isProperType(true) && !typeBinding.isCompatibleWith(this.descriptor.returnType) && this.descriptor.returnType.id != 6) {
                blockScope.problemReporter().constructedArrayIncompatible(this, typeBinding, this.descriptor.returnType);
                this.resolvedType = null;
                return null;
            }
            this.checkNullAnnotations(blockScope);
            return this.resolvedType;
        }
        boolean bl = this.isMethodReference();
        this.depth = 0;
        this.freeParameters = typeBindingArray;
        MethodBinding methodBinding = bl ? blockScope.getMethod(this.receiverType, this.selector, typeBindingArray, this) : blockScope.getConstructor((ReferenceBinding)this.receiverType, typeBindingArray, this);
        int n3 = this.depth;
        int n4 = 0;
        if (methodBinding != null && methodBinding.isValidBinding() && methodBinding.isStatic() && (this.haveReceiver || this.receiverType.isParameterizedTypeWithActualArguments())) {
            blockScope.problemReporter().methodMustBeAccessedStatically(this, methodBinding);
            this.resolvedType = null;
            return null;
        }
        if (this.lhs.isSuper() && this.lhs.resolvedType.isInterface()) {
            blockScope.checkAppropriateMethodAgainstSupers(this.selector, methodBinding, this.descriptor.parameters, this);
        }
        Binding binding = null;
        this.receiverPrecedesParameters = false;
        if (!this.haveReceiver && bl && n > 0 && (object = typeBindingArray[0]).isCompatibleWith(this.receiverType, blockScope)) {
            Object object2;
            referenceBindingArray = this.receiverType;
            if (this.receiverType.isRawType() && (object2 = object.findSuperTypeOriginatingFrom(this.receiverType)) != null) {
                referenceBindingArray = ((TypeBinding)object2).capture(blockScope, this.sourceStart, this.sourceEnd);
            }
            object2 = Binding.NO_PARAMETERS;
            if (n > 1) {
                object2 = new TypeBinding[n - 1];
                System.arraycopy(typeBindingArray, 1, object2, 0, n - 1);
            }
            this.depth = 0;
            this.freeParameters = object2;
            binding = blockScope.getMethod((TypeBinding)referenceBindingArray, this.selector, (TypeBinding[])object2, this);
            n4 = this.depth;
            this.depth = 0;
        }
        if (methodBinding != null && methodBinding.isValidBinding() && methodBinding.isStatic() && binding != null && binding.isValidBinding() && !((MethodBinding)binding).isStatic()) {
            blockScope.problemReporter().methodReferenceSwingsBothWays(this, (MethodBinding)binding, methodBinding);
            this.resolvedType = null;
            return null;
        }
        if (methodBinding != null && methodBinding.isValidBinding() && (binding == null || !binding.isValidBinding() || ((MethodBinding)binding).isStatic())) {
            this.binding = methodBinding;
            this.bits &= 0xFFFFE01F;
            if (n3 > 0) {
                this.bits |= (n3 & 0xFF) << 5;
            }
            if (!(this.haveReceiver || methodBinding.isStatic() || methodBinding.isConstructor())) {
                blockScope.problemReporter().methodMustBeAccessedWithInstance(this, methodBinding);
                this.resolvedType = null;
                return null;
            }
        } else if (!(binding == null || !binding.isValidBinding() || methodBinding != null && methodBinding.isValidBinding() && methodBinding.isStatic())) {
            this.binding = binding;
            this.receiverPrecedesParameters = true;
            this.bits &= 0xFFFFE01F;
            if (n4 > 0) {
                this.bits |= (n4 & 0xFF) << 5;
            }
            if (((MethodBinding)binding).isStatic()) {
                blockScope.problemReporter().methodMustBeAccessedStatically(this, (MethodBinding)binding);
                this.resolvedType = null;
                return null;
            }
        } else {
            this.binding = null;
            this.bits &= 0xFFFFE01F;
        }
        if (this.binding == null) {
            object = this.isConstructorReference() ? this.receiverType.sourceName() : this.selector;
            blockScope.problemReporter().danglingReference(this, this.receiverType, (char[])object, typeBindingArray);
            this.resolvedType = null;
            return null;
        }
        if (this.binding.isAbstract() && this.lhs.isSuper()) {
            blockScope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.binding.isStatic()) {
            if (TypeBinding.notEquals(this.binding.declaringClass, this.receiverType)) {
                blockScope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        } else {
            object = this.binding.sourceMethod();
            if (object != null && object.isMethod()) {
                object.bits &= 0xFFFFFEFF;
            }
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope, true)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.typeArguments != null && this.binding.original().typeVariables == Binding.NO_TYPE_VARIABLES) {
            blockScope.problemReporter().unnecessaryTypeArgumentsForMethodInvocation(this.binding, this.resolvedTypeArguments, this.typeArguments);
        }
        if ((this.binding.tagBits & 0x80L) != 0L) {
            blockScope.problemReporter().missingTypeInMethod(this, this.binding);
        }
        object = this.binding.thrownExceptions;
        referenceBindingArray = this.descriptor.thrownExceptions;
        int n5 = 0;
        int n6 = ((ReferenceBinding[])object).length;
        while (n5 < n6) {
            block69: {
                if (!((TypeBinding)object[n5]).isUncheckedException(false)) {
                    int n7 = 0;
                    int n8 = referenceBindingArray.length;
                    while (n7 < n8) {
                        if (!((TypeBinding)object[n5]).isCompatibleWith(referenceBindingArray[n7], blockScope)) {
                            ++n7;
                            continue;
                        }
                        break block69;
                    }
                    blockScope.problemReporter().unhandledException((TypeBinding)object[n5], this);
                }
            }
            ++n5;
        }
        this.checkNullAnnotations(blockScope);
        this.freeParameters = null;
        if (ReferenceExpression.checkInvocationArguments(blockScope, null, this.receiverType, this.binding, null, typeBindingArray, false, this)) {
            this.bits |= 0x10000;
        }
        if (this.descriptor.returnType.id != 6) {
            TypeBinding typeBinding3 = null;
            if (this.binding == blockScope.environment().arrayClone || this.binding.isConstructor()) {
                typeBinding3 = this.receiverType;
            } else if ((this.bits & 0x10000) != 0 && this.resolvedTypeArguments == null) {
                typeBinding3 = this.binding.returnType;
                if (typeBinding3 != null) {
                    typeBinding3 = blockScope.environment().convertToRawType(typeBinding3.erasure(), true);
                }
            } else {
                typeBinding3 = this.binding.returnType;
                if (typeBinding3 != null) {
                    typeBinding3 = typeBinding3.capture(blockScope, this.sourceStart, this.sourceEnd);
                }
            }
            if (this.descriptor.returnType.isProperType(true) && !typeBinding3.isCompatibleWith(this.descriptor.returnType, blockScope) && !this.isBoxingCompatible(typeBinding3, this.descriptor.returnType, this, blockScope)) {
                blockScope.problemReporter().incompatibleReturnType(this, this.binding, this.descriptor.returnType);
                this.binding = null;
                this.resolvedType = null;
            }
        }
        return this.resolvedType;
    }

    protected void checkNullAnnotations(BlockScope blockScope) {
        if (blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled && (this.expectedType == null || !NullAnnotationMatching.hasContradictions(this.expectedType))) {
            Object object;
            int n;
            int n2 = this.binding.parameters.length;
            int n3 = this.descriptor.parameters.length;
            if (this.receiverPrecedesParameters) {
                --n3;
            }
            boolean bl = false;
            if (this.binding.isVarargs()) {
                bl = n3 == n2 ? !this.descriptor.parameters[n2 - 1].isCompatibleWith(this.binding.parameters[n2 - 1]) : true;
                n = n3;
            } else {
                n = Math.min(n2, n3);
            }
            int n4 = 0;
            while (n4 < n) {
                object = this.descriptor.parameters[n4 + (this.receiverPrecedesParameters ? 1 : 0)];
                TypeBinding typeBinding = InferenceContext18.getParameter(this.binding.parameters, n4, bl);
                NullAnnotationMatching nullAnnotationMatching = NullAnnotationMatching.analyse(typeBinding, (TypeBinding)object, 1);
                if (nullAnnotationMatching.isAnyMismatch()) {
                    blockScope.problemReporter().referenceExpressionArgumentNullityMismatch(this, typeBinding, (TypeBinding)object, this.descriptor, n4, nullAnnotationMatching);
                }
                ++n4;
            }
            TypeBinding typeBinding = this.binding.returnType;
            if (this.binding.isConstructor() || this.binding == blockScope.environment().arrayClone) {
                typeBinding = blockScope.environment().createAnnotatedType(this.receiverType, new AnnotationBinding[]{blockScope.environment().getNonNullAnnotation()});
            }
            if (((NullAnnotationMatching)(object = NullAnnotationMatching.analyse(this.descriptor.returnType, typeBinding, 1))).isAnyMismatch()) {
                blockScope.problemReporter().illegalReturnRedefinition(this, this.descriptor, ((NullAnnotationMatching)object).isUnchecked(), typeBinding);
            }
        }
    }

    private TypeBinding[] descriptorParametersAsArgumentExpressions() {
        if (this.descriptor == null || this.descriptor.parameters == null || this.descriptor.parameters.length == 0) {
            return Binding.NO_PARAMETERS;
        }
        if (this.expectedType.isParameterizedType()) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this.expectedType;
            MethodBinding methodBinding = parameterizedTypeBinding.getSingleAbstractMethod(this.enclosingScope, true, this.sourceStart, this.sourceEnd);
            return methodBinding.parameters;
        }
        return this.descriptor.parameters;
    }

    private ReferenceExpression cachedResolvedCopy(TypeBinding typeBinding) {
        ReferenceExpression referenceExpression;
        ReferenceExpression referenceExpression2 = referenceExpression = this.copiesPerTargetType != null ? this.copiesPerTargetType.get(typeBinding) : null;
        if (referenceExpression != null) {
            return referenceExpression;
        }
        IErrorHandlingPolicy iErrorHandlingPolicy = this.enclosingScope.problemReporter().switchErrorHandlingPolicy(silentErrorHandlingPolicy);
        try {
            referenceExpression = this.copy();
            if (referenceExpression == null) {
                return null;
            }
            referenceExpression.setExpressionContext(this.expressionContext);
            referenceExpression.setExpectedType(typeBinding);
            referenceExpression.resolveType(this.enclosingScope);
            if (this.copiesPerTargetType == null) {
                this.copiesPerTargetType = new HashMap();
            }
            this.copiesPerTargetType.put(typeBinding, referenceExpression);
            ReferenceExpression referenceExpression3 = referenceExpression;
            return referenceExpression3;
        }
        finally {
            this.enclosingScope.problemReporter().switchErrorHandlingPolicy(iErrorHandlingPolicy);
        }
    }

    public void registerInferenceContext(ParameterizedGenericMethodBinding parameterizedGenericMethodBinding, InferenceContext18 inferenceContext18) {
        if (this.inferenceContexts == null) {
            this.inferenceContexts = new HashMap();
        }
        this.inferenceContexts.put(parameterizedGenericMethodBinding, inferenceContext18);
    }

    public InferenceContext18 getInferenceContext(ParameterizedMethodBinding parameterizedMethodBinding) {
        if (this.inferenceContexts == null) {
            return null;
        }
        return this.inferenceContexts.get(parameterizedMethodBinding);
    }

    public ReferenceExpression resolveExpressionExpecting(TypeBinding typeBinding, Scope scope, InferenceContext18 inferenceContext18) {
        if (this.exactMethodBinding != null) {
            MethodBinding methodBinding = typeBinding.getSingleAbstractMethod(scope, true);
            if (methodBinding == null) {
                return null;
            }
            int n = methodBinding.parameters.length;
            int n2 = this.exactMethodBinding.parameters.length;
            return n == n2 || n == n2 + 1 ? this : null;
        }
        ReferenceExpression referenceExpression = this.cachedResolvedCopy(typeBinding);
        return referenceExpression != null && referenceExpression.resolvedType != null && referenceExpression.resolvedType.isValidBinding() && referenceExpression.binding != null && referenceExpression.binding.isValidBinding() ? referenceExpression : null;
    }

    public boolean isConstructorReference() {
        return CharOperation.equals(this.selector, ConstantPool.Init);
    }

    public boolean isExactMethodReference() {
        return this.exactMethodBinding != null;
    }

    public MethodBinding getExactMethod() {
        return this.exactMethodBinding;
    }

    public boolean isMethodReference() {
        return !CharOperation.equals(this.selector, ConstantPool.Init);
    }

    public boolean isPertinentToApplicability(TypeBinding typeBinding, MethodBinding methodBinding) {
        if (!this.isExactMethodReference()) {
            return false;
        }
        return super.isPertinentToApplicability(typeBinding, methodBinding);
    }

    public TypeBinding[] genericTypeArguments() {
        return this.resolvedTypeArguments;
    }

    public InferenceContext18 freshInferenceContext(Scope scope) {
        if (this.expressionContext != ExpressionContext.VANILLA_CONTEXT) {
            Expression[] expressionArray = this.createPseudoExpressions(this.freeParameters);
            return new InferenceContext18(scope, expressionArray, this, null);
        }
        return null;
    }

    public boolean isSuperAccess() {
        return this.lhs.isSuper();
    }

    public boolean isTypeAccess() {
        return !this.haveReceiver;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n) {
        this.depth = n;
    }

    public void setFieldIndex(int n) {
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        this.lhs.print(0, stringBuffer);
        stringBuffer.append("::");
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            int n2 = this.typeArguments.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                this.typeArguments[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            this.typeArguments[n2].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if (this.isConstructorReference()) {
            stringBuffer.append("new");
        } else {
            stringBuffer.append(this.selector);
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.lhs.traverse(aSTVisitor, blockScope);
            int n = this.typeArguments == null ? 0 : this.typeArguments.length;
            int n2 = 0;
            while (n2 < n) {
                this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public Expression[] createPseudoExpressions(TypeBinding[] typeBindingArray) {
        Expression[] expressionArray = new Expression[typeBindingArray.length];
        long l = ((long)this.sourceStart << 32) + (long)this.sourceEnd;
        int n = 0;
        while (n < typeBindingArray.length) {
            expressionArray[n] = new SingleNameReference(("fakeArg" + n).toCharArray(), l);
            expressionArray[n].resolvedType = typeBindingArray[n];
            ++n;
        }
        return expressionArray;
    }

    public boolean isPotentiallyCompatibleWith(TypeBinding typeBinding, Scope scope) {
        Binding binding;
        boolean bl = this.isConstructorReference();
        if (bl && this.receiverType.isArrayType() && !((TypeBinding)(binding = this.receiverType.leafComponentType())).isReifiable()) {
            return false;
        }
        if (!super.isPertinentToApplicability(typeBinding, null)) {
            return true;
        }
        binding = typeBinding.getSingleAbstractMethod(this.enclosingScope, true);
        if (binding == null || !binding.isValidBinding()) {
            return false;
        }
        if (this.typeArgumentsHaveErrors || this.lhs.resolvedType == null || !this.lhs.resolvedType.isValidBinding()) {
            return false;
        }
        int n = ((MethodBinding)binding).parameters.length;
        TypeBinding[] typeBindingArray = new TypeBinding[n];
        int n2 = 0;
        while (n2 < n) {
            typeBindingArray[n2] = new ReferenceBinding(){
                {
                    this.compoundName = CharOperation.NO_CHAR_CHAR;
                }

                public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
                    return true;
                }

                public TypeBinding findSuperTypeOriginatingFrom(TypeBinding typeBinding) {
                    return typeBinding;
                }

                public String toString() {
                    return "(wildcard)";
                }
            };
            ++n2;
        }
        this.freeParameters = typeBindingArray;
        this.checkingPotentialCompatibility = true;
        try {
            MethodBinding methodBinding;
            MethodBinding methodBinding2 = this.exactMethodBinding != null ? this.exactMethodBinding : (methodBinding = bl ? scope.getConstructor((ReferenceBinding)this.receiverType, typeBindingArray, this) : scope.getMethod(this.receiverType, this.selector, typeBindingArray, this));
            if (methodBinding != null && methodBinding.isValidBinding()) {
                this.potentialMethods = new MethodBinding[]{methodBinding};
            }
            int n3 = 0;
            int n4 = this.potentialMethods.length;
            while (n3 < n4) {
                if (this.potentialMethods[n3].isStatic() || this.potentialMethods[n3].isConstructor() ? !this.haveReceiver : this.haveReceiver) {
                    return true;
                }
                ++n3;
            }
            if (this.haveReceiver || n == 0) {
                return false;
            }
            TypeBinding[] typeBindingArray2 = typeBindingArray;
            typeBindingArray = new TypeBinding[n - 1];
            System.arraycopy(typeBindingArray2, 1, typeBindingArray, 0, n - 1);
            this.freeParameters = typeBindingArray;
            MethodBinding methodBinding3 = methodBinding = this.exactMethodBinding != null ? this.exactMethodBinding : scope.getMethod(this.receiverType, this.selector, typeBindingArray, this);
            if (methodBinding != null && methodBinding.isValidBinding()) {
                this.potentialMethods = new MethodBinding[]{methodBinding};
            }
            n3 = 0;
            n4 = this.potentialMethods.length;
            while (n3 < n4) {
                if (!this.potentialMethods[n3].isStatic()) {
                    return true;
                }
                ++n3;
            }
        }
        finally {
            this.checkingPotentialCompatibility = false;
            this.potentialMethods = Binding.NO_METHODS;
            this.freeParameters = null;
        }
        return false;
    }

    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        ReferenceExpression referenceExpression = this.cachedResolvedCopy(typeBinding);
        return referenceExpression != null && referenceExpression.resolvedType != null && referenceExpression.resolvedType.isValidBinding() && referenceExpression.binding != null && referenceExpression.binding.isValidBinding();
    }

    public boolean sIsMoreSpecific(TypeBinding typeBinding, TypeBinding typeBinding2, Scope scope) {
        if (super.sIsMoreSpecific(typeBinding, typeBinding2, scope)) {
            return true;
        }
        if (this.exactMethodBinding == null || typeBinding2.findSuperTypeOriginatingFrom(typeBinding) != null) {
            return false;
        }
        MethodBinding methodBinding = (typeBinding = typeBinding.capture(this.enclosingScope, this.sourceStart, this.sourceEnd)).getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding == null || !methodBinding.isValidBinding()) {
            return false;
        }
        TypeBinding typeBinding3 = methodBinding.returnType;
        MethodBinding methodBinding2 = typeBinding2.getSingleAbstractMethod(this.enclosingScope, true);
        if (methodBinding2 == null || !methodBinding2.isValidBinding()) {
            return false;
        }
        TypeBinding typeBinding4 = methodBinding2.returnType;
        if (typeBinding4.id == 6) {
            return true;
        }
        if (typeBinding3.id == 6) {
            return false;
        }
        if (typeBinding3.isCompatibleWith(typeBinding4, scope)) {
            return true;
        }
        return typeBinding3.isBaseType() != typeBinding4.isBaseType() && typeBinding3.isBaseType() == this.exactMethodBinding.returnType.isBaseType();
    }

    public MethodBinding getMethodBinding() {
        if (this.actualMethodBinding == null) {
            this.actualMethodBinding = this.binding;
        }
        return this.actualMethodBinding;
    }

    public boolean isArrayConstructorReference() {
        return this.isConstructorReference() && this.lhs.resolvedType != null && this.lhs.resolvedType.isArrayType();
    }
}

