/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocAllocationExpression
extends AllocationExpression {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;
    public int memberStart;
    public char[][] qualification;

    public JavadocAllocationExpression(int n, int n2) {
        this.sourceStart = n;
        this.sourceEnd = n2;
        this.bits |= 0x8000;
    }

    public JavadocAllocationExpression(long l) {
        this((int)(l >>> 32), (int)l);
    }

    TypeBinding internalResolveType(Scope scope) {
        int n;
        Binding binding;
        Object object;
        this.constant = Constant.NotAConstant;
        this.resolvedType = this.type == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.type.resolveType((ClassScope)scope) : this.type.resolveType((BlockScope)scope, true));
        this.argumentTypes = Binding.NO_PARAMETERS;
        boolean bl = false;
        if (this.arguments != null) {
            this.argumentsHaveErrors = false;
            int n2 = this.arguments.length;
            this.argumentTypes = new TypeBinding[n2];
            int n3 = 0;
            while (n3 < n2) {
                object = this.arguments[n3];
                this.argumentTypes[n3] = scope.kind == 3 ? ((Expression)object).resolveType((ClassScope)scope) : ((Expression)object).resolveType((BlockScope)scope);
                if (this.argumentTypes[n3] == null) {
                    this.argumentsHaveErrors = true;
                } else if (!bl) {
                    bl = this.argumentTypes[n3].isTypeVariable();
                }
                ++n3;
            }
            if (this.argumentsHaveErrors) {
                return null;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        this.resolvedType = scope.environment().convertToRawType(this.type.resolvedType, true);
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding != null && sourceTypeBinding.isCompatibleWith(this.resolvedType)) {
            this.bits |= 0x4000;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(referenceBinding, this.argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            object = referenceBinding;
            binding = this.binding;
            while (!binding.isValidBinding() && (((TypeBinding)object).isMemberType() || ((TypeBinding)object).isLocalType())) {
                object = ((TypeBinding)object).enclosingType();
                binding = scope.getConstructor((ReferenceBinding)object, this.argumentTypes, this);
            }
            if (binding.isValidBinding()) {
                this.binding = binding;
            }
        }
        if (!this.binding.isValidBinding()) {
            object = scope.getMethod(this.resolvedType, this.resolvedType.sourceName(), this.argumentTypes, this);
            if (((Binding)object).isValidBinding()) {
                this.binding = object;
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = referenceBinding;
                }
                scope.problemReporter().javadocInvalidConstructor(this, this.binding, scope.getDeclarationModifiers());
            }
            return this.resolvedType;
        }
        if (this.binding.isVarargs()) {
            int n4 = this.argumentTypes.length;
            if (this.binding.parameters.length != n4 || !this.argumentTypes[n4 - 1].isArrayType()) {
                binding = new ProblemMethodBinding(this.binding, this.binding.selector, this.argumentTypes, 1);
                scope.problemReporter().javadocInvalidConstructor(this, (MethodBinding)binding, scope.getDeclarationModifiers());
            }
        } else if (bl) {
            object = new ProblemMethodBinding(this.binding, this.binding.selector, this.argumentTypes, 1);
            scope.problemReporter().javadocInvalidConstructor(this, (MethodBinding)object, scope.getDeclarationModifiers());
        } else if (this.binding instanceof ParameterizedMethodBinding) {
            object = (ParameterizedMethodBinding)this.binding;
            if (((ParameterizedMethodBinding)object).hasSubstitutedParameters()) {
                int n5 = this.argumentTypes.length;
                int n6 = 0;
                while (n6 < n5) {
                    if (TypeBinding.notEquals(((ParameterizedMethodBinding)object).parameters[n6], this.argumentTypes[n6]) && TypeBinding.notEquals(((ParameterizedMethodBinding)object).parameters[n6].erasure(), this.argumentTypes[n6].erasure())) {
                        ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(this.binding, this.binding.selector, this.argumentTypes, 1);
                        scope.problemReporter().javadocInvalidConstructor(this, problemMethodBinding, scope.getDeclarationModifiers());
                        break;
                    }
                    ++n6;
                }
            }
        } else if (this.resolvedType.isMemberType() && (n = this.qualification.length) > 1) {
            binding = referenceBinding;
            if (this.type instanceof JavadocQualifiedTypeReference && ((JavadocQualifiedTypeReference)this.type).tokens.length != n) {
                scope.problemReporter().javadocInvalidMemberTypeQualification(this.memberStart + 1, this.sourceEnd, scope.getDeclarationModifiers());
            } else {
                int n7 = n;
                while (n7 > 0 && CharOperation.equals(this.qualification[--n7], ((ReferenceBinding)binding).sourceName) && (binding = ((TypeBinding)binding).enclosingType()) != null) {
                }
                if (n7 > 0 || binding != null) {
                    scope.problemReporter().javadocInvalidMemberTypeQualification(this.memberStart + 1, this.sourceEnd, scope.getDeclarationModifiers());
                }
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope, true)) {
            scope.problemReporter().javadocDeprecatedMethod(this.binding, this, scope.getDeclarationModifiers());
        }
        return referenceBinding;
    }

    public boolean isSuperAccess() {
        return (this.bits & 0x4000) != 0;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return this.internalResolveType(blockScope);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            if (this.typeArguments != null) {
                n2 = 0;
                n = this.typeArguments.length;
                while (n2 < n) {
                    this.typeArguments[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
            if (this.arguments != null) {
                n2 = 0;
                n = this.arguments.length;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

