/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.Stack;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ContainerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public abstract class Annotation
extends Expression {
    Annotation persistibleAnnotation = this;
    static final MemberValuePair[] NoValuePairs = new MemberValuePair[0];
    static final int[] TYPE_PATH_ELEMENT_ARRAY = new int[2];
    static final int[] TYPE_PATH_INNER_TYPE;
    static final int[] TYPE_PATH_ANNOTATION_ON_WILDCARD_BOUND;
    public int declarationSourceEnd;
    public Binding recipient;
    public TypeReference type;
    protected AnnotationBinding compilerAnnotation = null;

    static {
        int[] nArray = new int[2];
        nArray[0] = 1;
        TYPE_PATH_INNER_TYPE = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 2;
        TYPE_PATH_ANNOTATION_ON_WILDCARD_BOUND = nArray2;
    }

    public static int[] getLocations(Expression expression, Annotation annotation) {
        if (expression == null) {
            return null;
        }
        class LocationCollector
        extends ASTVisitor {
            Stack typePathEntries = new Stack();
            Annotation searchedAnnotation;
            boolean continueSearch = true;

            public LocationCollector(Annotation annotation) {
                this.searchedAnnotation = annotation;
            }

            private int[] computeNestingDepth(TypeReference typeReference) {
                TypeBinding typeBinding = typeReference.resolvedType == null ? null : typeReference.resolvedType.leafComponentType();
                int[] nArray = new int[typeReference.getAnnotatableLevels()];
                if (typeBinding != null && typeBinding.isNestedType()) {
                    int n = 0;
                    TypeBinding typeBinding2 = typeBinding;
                    while (typeBinding2 != null) {
                        n += typeBinding2.isStatic() ? 0 : 1;
                        typeBinding2 = typeBinding2.enclosingType();
                    }
                    int n2 = nArray.length - 1;
                    while (typeBinding != null && n2 >= 0) {
                        nArray[n2--] = n;
                        n -= typeBinding.isStatic() ? 0 : 1;
                        typeBinding = typeBinding.enclosingType();
                    }
                }
                return nArray;
            }

            private void inspectAnnotations(Annotation[] annotationArray) {
                int n = 0;
                int n2 = annotationArray == null ? 0 : annotationArray.length;
                while (this.continueSearch && n < n2) {
                    if (annotationArray[n] == this.searchedAnnotation) {
                        this.continueSearch = false;
                    }
                    ++n;
                }
            }

            private void inspectArrayDimensions(Annotation[][] annotationArray, int n) {
                int n2 = 0;
                while (this.continueSearch && n2 < n) {
                    Annotation[] annotationArray2 = annotationArray == null ? null : annotationArray[n2];
                    this.inspectAnnotations(annotationArray2);
                    if (!this.continueSearch) {
                        return;
                    }
                    this.typePathEntries.push(TYPE_PATH_ELEMENT_ARRAY);
                    ++n2;
                }
            }

            private void inspectTypeArguments(TypeReference[] typeReferenceArray) {
                int n = 0;
                int n2 = typeReferenceArray == null ? 0 : typeReferenceArray.length;
                while (this.continueSearch && n < n2) {
                    int n3 = this.typePathEntries.size();
                    this.typePathEntries.add(new int[]{3, n});
                    typeReferenceArray[n].traverse((ASTVisitor)this, (BlockScope)null);
                    if (!this.continueSearch) {
                        return;
                    }
                    this.typePathEntries.setSize(n3);
                    ++n;
                }
            }

            public boolean visit(TypeReference typeReference, BlockScope blockScope) {
                if (this.continueSearch) {
                    this.inspectArrayDimensions(typeReference.getAnnotationsOnDimensions(), typeReference.dimensions());
                    if (this.continueSearch) {
                        int[] nArray = this.computeNestingDepth(typeReference);
                        Annotation[][] annotationArray = typeReference.annotations;
                        TypeReference[][] typeReferenceArray = typeReference.getTypeArguments();
                        int n = typeReference.getAnnotatableLevels();
                        int n2 = this.typePathEntries.size();
                        int n3 = n - 1;
                        while (this.continueSearch && n3 >= 0) {
                            this.typePathEntries.setSize(n2);
                            int n4 = 0;
                            int n5 = nArray[n3];
                            while (n4 < n5) {
                                this.typePathEntries.add(TYPE_PATH_INNER_TYPE);
                                ++n4;
                            }
                            if (annotationArray != null) {
                                this.inspectAnnotations(annotationArray[n3]);
                            }
                            if (this.continueSearch && typeReferenceArray != null) {
                                this.inspectTypeArguments(typeReferenceArray[n3]);
                            }
                            --n3;
                        }
                    }
                }
                return false;
            }

            public boolean visit(SingleTypeReference singleTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)singleTypeReference, blockScope);
            }

            public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)arrayTypeReference, blockScope);
            }

            public boolean visit(ParameterizedSingleTypeReference parameterizedSingleTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)parameterizedSingleTypeReference, blockScope);
            }

            public boolean visit(QualifiedTypeReference qualifiedTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)qualifiedTypeReference, blockScope);
            }

            public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)arrayQualifiedTypeReference, blockScope);
            }

            public boolean visit(ParameterizedQualifiedTypeReference parameterizedQualifiedTypeReference, BlockScope blockScope) {
                return this.visit((TypeReference)parameterizedQualifiedTypeReference, blockScope);
            }

            public boolean visit(Wildcard wildcard, BlockScope blockScope) {
                TypeReference typeReference;
                this.visit((TypeReference)wildcard, blockScope);
                if (this.continueSearch && (typeReference = wildcard.bound) != null) {
                    int n = this.typePathEntries.size();
                    this.typePathEntries.push(TYPE_PATH_ANNOTATION_ON_WILDCARD_BOUND);
                    typeReference.traverse((ASTVisitor)this, blockScope);
                    if (this.continueSearch) {
                        this.typePathEntries.setSize(n);
                    }
                }
                return false;
            }

            public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope blockScope) {
                if (this.continueSearch) {
                    this.inspectArrayDimensions(arrayAllocationExpression.getAnnotationsOnDimensions(), arrayAllocationExpression.dimensions.length);
                    if (this.continueSearch) {
                        arrayAllocationExpression.type.traverse((ASTVisitor)this, blockScope);
                    }
                    if (this.continueSearch) {
                        throw new IllegalStateException();
                    }
                }
                return false;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("search location for ").append(this.searchedAnnotation).append("\ncurrent type_path entries : ");
                int n = 0;
                int n2 = this.typePathEntries.size();
                while (n < n2) {
                    int[] nArray = (int[])this.typePathEntries.get(n);
                    stringBuffer.append('(').append(nArray[0]).append(',').append(nArray[1]).append(')');
                    ++n;
                }
                return String.valueOf(stringBuffer);
            }
        }
        LocationCollector locationCollector = new LocationCollector(annotation);
        expression.traverse((ASTVisitor)locationCollector, (BlockScope)null);
        if (locationCollector.typePathEntries.isEmpty()) {
            return null;
        }
        int n = locationCollector.typePathEntries.size();
        int[] nArray = new int[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int[] nArray2 = (int[])locationCollector.typePathEntries.get(n3);
            nArray[n2++] = nArray2[0];
            nArray[n2++] = nArray2[1];
            ++n3;
        }
        return nArray;
    }

    public static long getRetentionPolicy(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CLASS)) break;
                return 0x200000000000L;
            }
            case 'S': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_SOURCE)) break;
                return 0x100000000000L;
            }
            case 'R': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_RUNTIME)) break;
                return 0x300000000000L;
            }
        }
        return 0L;
    }

    public static long getTargetElementType(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'A': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_ANNOTATION_TYPE)) break;
                return 0x40000000000L;
            }
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CONSTRUCTOR)) break;
                return 0x10000000000L;
            }
            case 'F': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_FIELD)) break;
                return 0x2000000000L;
            }
            case 'L': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_LOCAL_VARIABLE)) break;
                return 0x20000000000L;
            }
            case 'M': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_METHOD)) break;
                return 0x4000000000L;
            }
            case 'P': {
                if (CharOperation.equals(cArray, TypeConstants.UPPER_PARAMETER)) {
                    return 0x8000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_PACKAGE)) break;
                return 0x80000000000L;
            }
            case 'T': {
                if (CharOperation.equals(cArray, TypeConstants.TYPE)) {
                    return 0x1000000000L;
                }
                if (CharOperation.equals(cArray, TypeConstants.TYPE_USE_TARGET)) {
                    return 0x20000000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.TYPE_PARAMETER_TARGET)) break;
                return 0x40000000000000L;
            }
        }
        return 0L;
    }

    public ElementValuePair[] computeElementValuePairs() {
        return Binding.NO_ELEMENT_VALUE_PAIRS;
    }

    private long detectStandardAnnotation(Scope scope, ReferenceBinding referenceBinding, MemberValuePair memberValuePair) {
        long l = 0L;
        switch (referenceBinding.id) {
            case 48: {
                FieldBinding fieldBinding;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 51) break;
                l |= Annotation.getRetentionPolicy(fieldBinding.name);
                break;
            }
            case 50: {
                FieldBinding fieldBinding;
                l |= 0x800000000L;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n = 0;
                    int n2 = expressionArray.length;
                    while (n < n2) {
                        FieldBinding fieldBinding2;
                        Expression expression2 = expressionArray[n];
                        if ((expression2.bits & 3) == 1 && (fieldBinding2 = ((Reference)expression2).fieldBinding()) != null && fieldBinding2.declaringClass.id == 52) {
                            long l2 = Annotation.getTargetElementType(fieldBinding2.name);
                            if ((l & l2) != 0L) {
                                scope.problemReporter().duplicateTargetInTargetAnnotation(referenceBinding, (NameReference)expression2);
                            } else {
                                l |= l2;
                            }
                        }
                        ++n;
                    }
                    break;
                }
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 52) break;
                l |= Annotation.getTargetElementType(fieldBinding.name);
                break;
            }
            case 44: {
                l |= 0x400000000000L;
                break;
            }
            case 45: {
                l |= 0x800000000000L;
                break;
            }
            case 46: {
                l |= 0x1000000000000L;
                break;
            }
            case 47: {
                l |= 0x2000000000000L;
                break;
            }
            case 77: {
                l |= 0x800000000000000L;
                break;
            }
            case 90: {
                l |= 0x1000000000000000L;
                break;
            }
            case 49: {
                l |= 0x4000000000000L;
                break;
            }
            case 60: {
                l |= 0x8000000000000L;
                break;
            }
            case 61: {
                l |= 0x10000000000000L;
                break;
            }
            case 65: {
                l |= 0x80000000000000L;
                break;
            }
            case 66: {
                l |= 0x100000000000000L;
                break;
            }
            case 67: {
                Object object = null;
                if (memberValuePair != null) {
                    if (memberValuePair.compilerElementPair != null) {
                        object = memberValuePair.compilerElementPair.value;
                    }
                } else {
                    MethodBinding[] methodBindingArray = referenceBinding.methods();
                    if (methodBindingArray != null && methodBindingArray.length == 1) {
                        object = methodBindingArray[0].getDefaultValue();
                    } else {
                        l |= 0x200000000000000L;
                    }
                }
                if (object instanceof BooleanConstant) {
                    l |= ((BooleanConstant)object).booleanValue() ? 0x200000000000000L : 0x400000000000000L;
                    break;
                }
                if (object == null) break;
                l |= (long)Annotation.nullLocationBitsFromAnnotationValue(object);
            }
        }
        return l;
    }

    public static int nullLocationBitsFromAnnotationValue(Object object) {
        if (object instanceof Object[]) {
            if (((Object[])object).length == 0) {
                return 2;
            }
            int n = 0;
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = objectArray[n3];
                n |= Annotation.evaluateDefaultNullnessLocation(object2);
                ++n3;
            }
            return n;
        }
        return Annotation.evaluateDefaultNullnessLocation(object);
    }

    private static int evaluateDefaultNullnessLocation(Object object) {
        char[] cArray = null;
        if (object instanceof FieldBinding) {
            cArray = ((FieldBinding)object).name;
        } else if (object instanceof EnumConstantSignature) {
            cArray = ((EnumConstantSignature)object).getEnumConstantName();
        } else if (object instanceof ElementValuePair.UnresolvedEnumConstant) {
            cArray = ((ElementValuePair.UnresolvedEnumConstant)object).getEnumConstantName();
        } else if (object instanceof BooleanConstant) {
            return ((BooleanConstant)object).booleanValue() ? 1 : 2;
        }
        if (cArray != null) {
            switch (cArray.length) {
                case 5: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__FIELD)) break;
                    return 32;
                }
                case 9: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__PARAMETER)) break;
                    return 8;
                }
                case 10: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__TYPE_BOUND)) break;
                    return 256;
                }
                case 11: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__RETURN_TYPE)) break;
                    return 16;
                }
                case 13: {
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__TYPE_ARGUMENT)) break;
                    return 64;
                }
                case 14: {
                    if (CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__TYPE_PARAMETER)) {
                        return 128;
                    }
                    if (!CharOperation.equals(cArray, TypeConstants.DEFAULT_LOCATION__ARRAY_CONTENTS)) break;
                    return 512;
                }
            }
        }
        return 0;
    }

    static String getRetentionName(long l) {
        if ((l & 0x300000000000L) == 0x300000000000L) {
            return new String(UPPER_RUNTIME);
        }
        if ((l & 0x100000000000L) != 0L) {
            return new String(UPPER_SOURCE);
        }
        return new String(TypeConstants.UPPER_CLASS);
    }

    private static long getAnnotationRetention(ReferenceBinding referenceBinding) {
        long l = referenceBinding.getAnnotationTagBits() & 0x300000000000L;
        return l != 0L ? l : 0x200000000000L;
    }

    public void checkRepeatableMetaAnnotation(BlockScope blockScope) {
        ReferenceBinding referenceBinding = (ReferenceBinding)this.recipient;
        MemberValuePair[] memberValuePairArray = this.memberValuePairs();
        if (memberValuePairArray == null || memberValuePairArray.length != 1) {
            return;
        }
        Object object = memberValuePairArray[0].compilerElementPair.value;
        if (!(object instanceof ReferenceBinding)) {
            return;
        }
        ReferenceBinding referenceBinding2 = (ReferenceBinding)object;
        if (!referenceBinding2.isAnnotationType()) {
            return;
        }
        referenceBinding.setContainerAnnotationType(referenceBinding2);
        Annotation.checkContainerAnnotationType(memberValuePairArray[0], blockScope, referenceBinding2, referenceBinding, false);
    }

    public static void checkContainerAnnotationType(ASTNode aSTNode, BlockScope blockScope, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, boolean bl) {
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        boolean bl2 = false;
        int n = 0;
        int n2 = methodBindingArray.length;
        while (n < n2) {
            MethodBinding methodBinding = methodBindingArray[n];
            if (CharOperation.equals(methodBinding.selector, TypeConstants.VALUE)) {
                ArrayBinding arrayBinding;
                bl2 = true;
                if (!methodBinding.returnType.isArrayType() || methodBinding.returnType.dimensions() != 1 || !TypeBinding.equalsEquals((arrayBinding = (ArrayBinding)methodBinding.returnType).elementsType(), referenceBinding2)) {
                    referenceBinding2.tagAsHavingDefectiveContainerType();
                    blockScope.problemReporter().containerAnnotationTypeHasWrongValueType(aSTNode, referenceBinding, referenceBinding2, methodBinding.returnType);
                }
            } else if ((methodBinding.modifiers & 0x20000) == 0) {
                referenceBinding2.tagAsHavingDefectiveContainerType();
                blockScope.problemReporter().containerAnnotationTypeHasNonDefaultMembers(aSTNode, referenceBinding, methodBinding.selector);
            }
            ++n;
        }
        if (!bl2) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().containerAnnotationTypeMustHaveValue(aSTNode, referenceBinding);
        }
        if (bl) {
            Annotation.checkContainingAnnotationTargetAtUse((Annotation)aSTNode, blockScope, referenceBinding, referenceBinding2);
        } else {
            Annotation.checkContainerAnnotationTypeTarget(aSTNode, blockScope, referenceBinding, referenceBinding2);
        }
        long l = Annotation.getAnnotationRetention(referenceBinding2);
        long l2 = Annotation.getAnnotationRetention(referenceBinding);
        if (l2 < l) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().containerAnnotationTypeHasShorterRetention(aSTNode, referenceBinding2, Annotation.getRetentionName(l), referenceBinding, Annotation.getRetentionName(l2));
        }
        if ((referenceBinding2.getAnnotationTagBits() & 0x800000000000L) != 0L && (referenceBinding.getAnnotationTagBits() & 0x800000000000L) == 0L) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().repeatableAnnotationTypeIsDocumented(aSTNode, referenceBinding2, referenceBinding);
        }
        if ((referenceBinding2.getAnnotationTagBits() & 0x1000000000000L) != 0L && (referenceBinding.getAnnotationTagBits() & 0x1000000000000L) == 0L) {
            referenceBinding2.tagAsHavingDefectiveContainerType();
            blockScope.problemReporter().repeatableAnnotationTypeIsInherited(aSTNode, referenceBinding2, referenceBinding);
        }
    }

    private static void checkContainerAnnotationTypeTarget(ASTNode aSTNode, Scope scope, ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        long l;
        long l2;
        long l3;
        long l4 = referenceBinding2.getAnnotationTagBits();
        if ((l4 & 0x600FF800000000L) == 0L) {
            l4 = 0xFF000000000L;
        }
        if (((l3 = referenceBinding.getAnnotationTagBits()) & 0x600FF800000000L) == 0L) {
            l3 = 0xFF000000000L;
        }
        if (((l2 = l3 & 0x600FF800000000L) & ((l = l4 & 0x600FF800000000L) ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            class MissingTargetBuilder {
                StringBuffer targetBuffer = new StringBuffer();
                private final /* synthetic */ long val$containerAnnotationTypeTargets;
                private final /* synthetic */ long val$targets;

                MissingTargetBuilder(long l, long l2) {
                    this.val$containerAnnotationTypeTargets = l;
                    this.val$targets = l2;
                }

                void check(long l, char[] cArray) {
                    if ((this.val$containerAnnotationTypeTargets & l & (this.val$targets ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                        if (l == 0x1000000000L && (this.val$targets & 0x20000000000000L) != 0L) {
                            return;
                        }
                        this.add(cArray);
                    }
                }

                void checkAnnotationType(char[] cArray) {
                    if ((this.val$containerAnnotationTypeTargets & 0x40000000000L) != 0L && (this.val$targets & 0x41000000000L) == 0L) {
                        this.add(cArray);
                    }
                }

                private void add(char[] cArray) {
                    if (this.targetBuffer.length() != 0) {
                        this.targetBuffer.append(", ");
                    }
                    this.targetBuffer.append(cArray);
                }

                public String toString() {
                    return this.targetBuffer.toString();
                }

                public boolean hasError() {
                    return this.targetBuffer.length() != 0;
                }
            }
            MissingTargetBuilder missingTargetBuilder = new MissingTargetBuilder(l2, l);
            missingTargetBuilder.check(0x1000000000L, TypeConstants.TYPE);
            missingTargetBuilder.check(0x2000000000L, TypeConstants.UPPER_FIELD);
            missingTargetBuilder.check(0x4000000000L, TypeConstants.UPPER_METHOD);
            missingTargetBuilder.check(0x8000000000L, TypeConstants.UPPER_PARAMETER);
            missingTargetBuilder.check(0x10000000000L, TypeConstants.UPPER_CONSTRUCTOR);
            missingTargetBuilder.check(0x20000000000L, TypeConstants.UPPER_LOCAL_VARIABLE);
            missingTargetBuilder.checkAnnotationType(TypeConstants.UPPER_ANNOTATION_TYPE);
            missingTargetBuilder.check(0x80000000000L, TypeConstants.UPPER_PACKAGE);
            missingTargetBuilder.check(0x40000000000000L, TypeConstants.TYPE_PARAMETER_TARGET);
            missingTargetBuilder.check(0x20000000000000L, TypeConstants.TYPE_USE_TARGET);
            if (missingTargetBuilder.hasError()) {
                referenceBinding2.tagAsHavingDefectiveContainerType();
                scope.problemReporter().repeatableAnnotationTypeTargetMismatch(aSTNode, referenceBinding2, referenceBinding, missingTargetBuilder.toString());
            }
        }
    }

    public static void checkContainingAnnotationTargetAtUse(Annotation annotation, BlockScope blockScope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (!typeBinding2.isValidBinding()) {
            return;
        }
        if (!Annotation.isAnnotationTargetAllowed(annotation, blockScope, typeBinding, annotation.recipient.kind())) {
            blockScope.problemReporter().disallowedTargetForContainerAnnotation(annotation, typeBinding);
        }
    }

    public AnnotationBinding getCompilerAnnotation() {
        return this.compilerAnnotation;
    }

    public boolean isRuntimeInvisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x60000000000000L) != 0L && (l & 0xFF000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return true;
        }
        return (l & 0x300000000000L) == 0x200000000000L;
    }

    public boolean isRuntimeTypeInvisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x600FF800000000L) == 0L) {
            return false;
        }
        if ((l & 0x60000000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return true;
        }
        return (l & 0x300000000000L) == 0x200000000000L;
    }

    public boolean isRuntimeTypeVisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x600FF800000000L) == 0L) {
            return false;
        }
        if ((l & 0x60000000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return false;
        }
        return (l & 0x300000000000L) == 0x300000000000L;
    }

    public boolean isRuntimeVisible() {
        TypeBinding typeBinding = this.resolvedType;
        if (typeBinding == null) {
            return false;
        }
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x60000000000000L) != 0L && (l & 0xFF000000000L) == 0L) {
            return false;
        }
        if ((l & 0x300000000000L) == 0L) {
            return false;
        }
        return (l & 0x300000000000L) == 0x300000000000L;
    }

    public abstract MemberValuePair[] memberValuePairs();

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        stringBuffer.append('@');
        this.type.printExpression(0, stringBuffer);
        return stringBuffer;
    }

    public void recordSuppressWarnings(Scope scope, int n, int n2, boolean bl) {
        IrritantSet irritantSet = null;
        MemberValuePair[] memberValuePairArray = this.memberValuePairs();
        int n3 = 0;
        int n4 = memberValuePairArray.length;
        while (n3 < n4) {
            MemberValuePair memberValuePair = memberValuePairArray[n3];
            if (CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) {
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n5 = 0;
                    int n6 = expressionArray.length;
                    while (n5 < n6) {
                        Constant constant = expressionArray[n5].constant;
                        if (constant != Constant.NotAConstant && constant.typeID() == 11) {
                            IrritantSet irritantSet2 = CompilerOptions.warningTokenToIrritants(constant.stringValue());
                            if (irritantSet2 != null) {
                                if (irritantSet == null) {
                                    irritantSet = new IrritantSet(irritantSet2);
                                } else if (irritantSet.set(irritantSet2) == null) {
                                    scope.problemReporter().unusedWarningToken(expressionArray[n5]);
                                }
                            } else {
                                scope.problemReporter().unhandledWarningToken(expressionArray[n5]);
                            }
                        }
                        ++n5;
                    }
                    break;
                }
                Constant constant = expression.constant;
                if (constant == Constant.NotAConstant || constant.typeID() != 11) break;
                IrritantSet irritantSet3 = CompilerOptions.warningTokenToIrritants(constant.stringValue());
                if (irritantSet3 != null) {
                    irritantSet = new IrritantSet(irritantSet3);
                    break;
                }
                scope.problemReporter().unhandledWarningToken(expression);
                break;
            }
            ++n3;
        }
        if (bl && irritantSet != null) {
            scope.referenceCompilationUnit().recordSuppressWarnings(irritantSet, this, n, n2, scope.referenceContext());
        }
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        ASTNode aSTNode;
        ASTNode aSTNode2;
        MemberValuePair[] memberValuePairArray;
        if (this.compilerAnnotation != null) {
            return this.resolvedType;
        }
        this.constant = Constant.NotAConstant;
        TypeBinding typeBinding = this.type.resolveType(blockScope);
        if (typeBinding == null) {
            return null;
        }
        this.resolvedType = typeBinding;
        if (!typeBinding.isAnnotationType() && typeBinding.isValidBinding()) {
            blockScope.problemReporter().notAnnotationType(typeBinding, this.type);
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        MemberValuePair[] memberValuePairArray2 = this.memberValuePairs();
        MemberValuePair memberValuePair = null;
        int n = memberValuePairArray2.length;
        if (n > 0) {
            memberValuePairArray = new MemberValuePair[n];
            System.arraycopy(memberValuePairArray2, 0, memberValuePairArray, 0, n);
        } else {
            memberValuePairArray = memberValuePairArray2;
        }
        int n2 = 0;
        int n3 = methodBindingArray.length;
        while (n2 < n3) {
            block35: {
                MethodBinding methodBinding = methodBindingArray[n2];
                char[] cArray = methodBinding.selector;
                boolean bl = false;
                int n4 = 0;
                while (n4 < n) {
                    char[] cArray2;
                    aSTNode2 = memberValuePairArray[n4];
                    if (aSTNode2 != null && CharOperation.equals(cArray2 = aSTNode2.name, cArray)) {
                        if (memberValuePair == null && CharOperation.equals(cArray2, TypeConstants.VALUE)) {
                            memberValuePair = aSTNode2;
                        }
                        aSTNode2.binding = methodBinding;
                        aSTNode2.resolveTypeExpecting(blockScope, methodBinding.returnType);
                        memberValuePairArray[n4] = null;
                        bl = true;
                        boolean bl2 = false;
                        int n5 = n4 + 1;
                        while (n5 < n) {
                            aSTNode = memberValuePairArray[n5];
                            if (aSTNode != null && CharOperation.equals(aSTNode.name, cArray)) {
                                bl2 = true;
                                blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, (MemberValuePair)aSTNode);
                                aSTNode.binding = methodBinding;
                                aSTNode.resolveTypeExpecting(blockScope, methodBinding.returnType);
                                memberValuePairArray[n5] = null;
                            }
                            ++n5;
                        }
                        if (bl2) {
                            blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, (MemberValuePair)aSTNode2);
                            break block35;
                        }
                    }
                    ++n4;
                }
                if (!bl && (methodBinding.modifiers & 0x20000) == 0 && (this.bits & 0x20) == 0 && referenceBinding.isValidBinding()) {
                    blockScope.problemReporter().missingValueForAnnotationMember(this, cArray);
                }
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (memberValuePairArray[n2] != null) {
                if (referenceBinding.isValidBinding()) {
                    blockScope.problemReporter().undefinedAnnotationValue(referenceBinding, memberValuePairArray[n2]);
                }
                memberValuePairArray[n2].resolveTypeExpecting(blockScope, null);
            }
            ++n2;
        }
        this.compilerAnnotation = blockScope.environment().createAnnotation((ReferenceBinding)this.resolvedType, this.computeElementValuePairs());
        long l = this.detectStandardAnnotation(blockScope, referenceBinding, memberValuePair);
        int n6 = (int)(l & 0x3FAL);
        l &= 0xFFFFFFFFFFFFFC05L;
        blockScope.referenceCompilationUnit().recordSuppressWarnings(IrritantSet.NLS, null, this.sourceStart, this.declarationSourceEnd, blockScope.referenceContext());
        if (this.recipient != null) {
            int n7 = this.recipient.kind();
            if (l != 0L || n6 != 0) {
                switch (n7) {
                    case 16: {
                        ((PackageBinding)this.recipient).tagBits |= l;
                        break;
                    }
                    case 4: 
                    case 2052: {
                        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.recipient;
                        if ((l & 0x1000000000000000L) == 0L || sourceTypeBinding.isAnnotationType()) {
                            sourceTypeBinding.tagBits |= l;
                        }
                        if ((l & 0x4000000000000L) != 0L) {
                            TypeDeclaration typeDeclaration = sourceTypeBinding.scope.referenceContext;
                            int n8 = blockScope.referenceCompilationUnit().types[0] == typeDeclaration ? 0 : typeDeclaration.declarationSourceStart;
                            this.recordSuppressWarnings(blockScope, n8, typeDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                        }
                        sourceTypeBinding.defaultNullness |= n6;
                        break;
                    }
                    case 8: {
                        long l2;
                        MethodBinding methodBinding = (MethodBinding)this.recipient;
                        methodBinding.tagBits |= l;
                        if ((l & 0x4000000000000L) != 0L) {
                            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)methodBinding.declaringClass;
                            aSTNode2 = sourceTypeBinding.scope.referenceContext.declarationOf(methodBinding);
                            this.recordSuppressWarnings(blockScope, ((AbstractMethodDeclaration)aSTNode2).declarationSourceStart, ((AbstractMethodDeclaration)aSTNode2).declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                        }
                        if ((l2 = methodBinding.tagBits & 0x180000000000000L) == 0x180000000000000L) {
                            blockScope.problemReporter().contradictoryNullAnnotations(this);
                            methodBinding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        }
                        if (l2 != 0L && methodBinding.isConstructor()) {
                            if (blockScope.compilerOptions().sourceLevel >= 0x340000L) {
                                blockScope.problemReporter().nullAnnotationUnsupportedLocation(this);
                            }
                            methodBinding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        }
                        methodBinding.defaultNullness |= n6;
                        break;
                    }
                    case 1: {
                        FieldBinding fieldBinding = (FieldBinding)this.recipient;
                        fieldBinding.tagBits |= l;
                        if ((l & 0x4000000000000L) != 0L) {
                            SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                            FieldDeclaration fieldDeclaration = sourceTypeBinding.scope.referenceContext.declarationOf(fieldBinding);
                            this.recordSuppressWarnings(blockScope, fieldDeclaration.declarationSourceStart, fieldDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                        }
                        if ((fieldBinding.tagBits & 0x180000000000000L) != 0x180000000000000L) break;
                        blockScope.problemReporter().contradictoryNullAnnotations(this);
                        fieldBinding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        break;
                    }
                    case 2: {
                        LocalVariableBinding localVariableBinding = (LocalVariableBinding)this.recipient;
                        localVariableBinding.tagBits |= l;
                        if ((localVariableBinding.tagBits & 0x180000000000000L) == 0x180000000000000L) {
                            blockScope.problemReporter().contradictoryNullAnnotations(this);
                            localVariableBinding.tagBits &= 0xFE7FFFFFFFFFFFFFL;
                        }
                        if ((l & 0x4000000000000L) == 0L) break;
                        aSTNode = localVariableBinding.declaration;
                        this.recordSuppressWarnings(blockScope, ((LocalDeclaration)aSTNode).declarationSourceStart, ((LocalDeclaration)aSTNode).declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    }
                }
            }
            if (n7 == 4) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.recipient;
                if (CharOperation.equals(sourceTypeBinding.sourceName, TypeConstants.PACKAGE_INFO_NAME)) {
                    n7 = 16;
                }
            }
            Annotation.checkAnnotationTarget(this, blockScope, referenceBinding, n7, this.recipient, l & 0x180000000000000L);
        }
        return this.resolvedType;
    }

    private static boolean isAnnotationTargetAllowed(Binding binding, BlockScope blockScope, TypeBinding typeBinding, int n, long l) {
        switch (n) {
            case 16: {
                if ((l & 0x80000000000L) != 0L) {
                    return true;
                }
                if (blockScope.compilerOptions().sourceLevel > 0x320000L) break;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)binding;
                if (!CharOperation.equals(sourceTypeBinding.sourceName, TypeConstants.PACKAGE_INFO_NAME)) break;
                return true;
            }
            case 16388: {
                if ((l & 0x20000000000000L) != 0L) {
                    return true;
                }
                if (blockScope.compilerOptions().sourceLevel >= 0x340000L) break;
                return true;
            }
            case 4: 
            case 2052: {
                if (((ReferenceBinding)binding).isAnnotationType()) {
                    if ((l & 0x20041000000000L) == 0L) break;
                    return true;
                }
                if ((l & 0x20001000000000L) != 0L) {
                    return true;
                }
                if ((l & 0x80000000000L) == 0L || !CharOperation.equals(((ReferenceBinding)binding).sourceName, TypeConstants.PACKAGE_INFO_NAME)) break;
                return true;
            }
            case 8: {
                MethodBinding methodBinding = (MethodBinding)binding;
                if (methodBinding.isConstructor()) {
                    if ((l & 0x20010000000000L) == 0L) break;
                    return true;
                }
                if ((l & 0x4000000000L) != 0L) {
                    return true;
                }
                if ((l & 0x20000000000000L) == 0L) break;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)methodBinding.declaringClass;
                MethodDeclaration methodDeclaration = (MethodDeclaration)sourceTypeBinding.scope.referenceContext.declarationOf(methodBinding);
                if (!Annotation.isTypeUseCompatible(methodDeclaration.returnType, blockScope)) break;
                return true;
            }
            case 1: {
                if ((l & 0x2000000000L) != 0L) {
                    return true;
                }
                if ((l & 0x20000000000000L) == 0L) break;
                FieldBinding fieldBinding = (FieldBinding)binding;
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                FieldDeclaration fieldDeclaration = sourceTypeBinding.scope.referenceContext.declarationOf(fieldBinding);
                if (!Annotation.isTypeUseCompatible(fieldDeclaration.type, blockScope)) break;
                return true;
            }
            case 2: {
                LocalVariableBinding localVariableBinding = (LocalVariableBinding)binding;
                if ((localVariableBinding.tagBits & 0x400L) != 0L) {
                    if ((l & 0x8000000000L) != 0L) {
                        return true;
                    }
                    if ((l & 0x20000000000000L) == 0L || !Annotation.isTypeUseCompatible(localVariableBinding.declaration.type, blockScope)) break;
                    return true;
                }
                if ((typeBinding.tagBits & 0x20000000000L) != 0L) {
                    return true;
                }
                if ((l & 0x20000000000000L) == 0L || !Annotation.isTypeUseCompatible(localVariableBinding.declaration.type, blockScope)) break;
                return true;
            }
            case 4100: {
                if ((l & 0x60000000000000L) == 0L) break;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotationTargetAllowed(BlockScope blockScope, TypeBinding typeBinding, Binding binding) {
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x600FF800000000L) == 0L) {
            return true;
        }
        return Annotation.isAnnotationTargetAllowed(binding, blockScope, typeBinding, binding.kind(), l);
    }

    static boolean isAnnotationTargetAllowed(Annotation annotation, BlockScope blockScope, TypeBinding typeBinding, int n) {
        long l = typeBinding.getAnnotationTagBits();
        if ((l & 0x600FF800000000L) == 0L) {
            if (n == 4100 || n == 16388) {
                blockScope.problemReporter().explitAnnotationTargetRequired(annotation);
            }
            return true;
        }
        if ((l & 0xFF000000000L) == 0L && (l & 0x60000000000000L) != 0L && blockScope.compilerOptions().sourceLevel < 0x340000L) {
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: 
                case 2052: {
                    blockScope.problemReporter().invalidUsageOfTypeAnnotations(annotation);
                }
            }
        }
        return Annotation.isAnnotationTargetAllowed(annotation.recipient, blockScope, typeBinding, n, l);
    }

    static void checkAnnotationTarget(Annotation annotation, BlockScope blockScope, ReferenceBinding referenceBinding, int n, Binding binding, long l) {
        if (!referenceBinding.isValidBinding()) {
            return;
        }
        if (!Annotation.isAnnotationTargetAllowed(annotation, blockScope, referenceBinding, n)) {
            blockScope.problemReporter().disallowedTargetForAnnotation(annotation);
            if (binding instanceof TypeBinding) {
                ((TypeBinding)binding).tagBits &= l ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
    }

    public static void checkForInstancesOfRepeatableWithRepeatingContainerAnnotation(BlockScope blockScope, ReferenceBinding referenceBinding, Annotation[] annotationArray) {
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(TypeConstants.VALUE);
        if (methodBindingArray.length != 1) {
            return;
        }
        TypeBinding typeBinding = methodBindingArray[0].returnType;
        if (!typeBinding.isArrayType() || typeBinding.dimensions() != 1) {
            return;
        }
        ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
        TypeBinding typeBinding2 = arrayBinding.elementsType();
        if (!typeBinding2.isRepeatableAnnotationType()) {
            return;
        }
        int n = 0;
        while (n < annotationArray.length) {
            Annotation annotation = annotationArray[n];
            if (TypeBinding.equalsEquals(typeBinding2, annotation.resolvedType)) {
                blockScope.problemReporter().repeatableAnnotationWithRepeatingContainer(annotation, referenceBinding);
                return;
            }
            ++n;
        }
    }

    public static boolean isTypeUseCompatible(TypeReference typeReference, Scope scope) {
        Binding binding;
        return typeReference == null || typeReference instanceof SingleTypeReference || !((binding = scope.getPackage(typeReference.getTypeName())) instanceof PackageBinding);
    }

    public static void isTypeUseCompatible(TypeReference typeReference, Scope scope, Annotation[] annotationArray) {
        TypeBinding typeBinding;
        if (annotationArray == null || typeReference == null || typeReference.getAnnotatableLevels() == 1) {
            return;
        }
        if (scope.environment().globalOptions.sourceLevel < 0x340000L) {
            return;
        }
        TypeBinding typeBinding2 = typeBinding = typeReference.resolvedType == null ? null : typeReference.resolvedType.leafComponentType();
        if (typeBinding == null || !typeBinding.isNestedType()) {
            return;
        }
        int n = 0;
        int n2 = annotationArray.length;
        while (n < n2) {
            Annotation annotation = annotationArray[n];
            long l = annotation.resolvedType.getAnnotationTagBits();
            if ((l & 0x20000000000000L) != 0L && (l & 0xFF000000000L) == 0L) {
                ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                while (referenceBinding.isNestedType()) {
                    if (referenceBinding.isStatic()) {
                        QualifiedTypeReference.rejectAnnotationsOnStaticMemberQualififer(scope, referenceBinding, new Annotation[]{annotation});
                        break;
                    }
                    int n3 = annotation.resolvedType.id;
                    if (n3 == 66 || n3 == 65) {
                        scope.problemReporter().nullAnnotationUnsupportedLocation(annotation);
                        break;
                    }
                    referenceBinding = referenceBinding.enclosingType();
                }
            }
            ++n;
        }
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    public abstract void traverse(ASTVisitor var1, ClassScope var2);

    public Annotation getPersistibleAnnotation() {
        return this.persistibleAnnotation;
    }

    public void setPersistibleAnnotation(ContainerAnnotation containerAnnotation) {
        this.persistibleAnnotation = containerAnnotation;
    }
}

