/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.AbstractAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IDebugRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ReadManager;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.CompilerStats;
import org.eclipse.jdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeCollisionException;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Compiler
implements ITypeRequestor,
ProblemSeverities {
    public Parser parser;
    public ICompilerRequestor requestor;
    public CompilerOptions options;
    public ProblemReporter problemReporter;
    protected PrintWriter out;
    public CompilerStats stats;
    public CompilationProgress progress;
    public int remainingIterations = 1;
    public CompilationUnitDeclaration[] unitsToProcess;
    public int totalUnits;
    private Map<String, APTProblem[]> aptProblems;
    public LookupEnvironment lookupEnvironment;
    public static boolean DEBUG = false;
    public int parseThreshold = -1;
    public AbstractAnnotationProcessorManager annotationProcessorManager;
    public int annotationProcessorStartIndex = 0;
    public ReferenceBinding[] referenceBindings;
    public boolean useSingleThread = true;
    public static IDebugRequestor DebugRequestor = null;

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory) {
        this(iNameEnvironment, iErrorHandlingPolicy, new CompilerOptions(map), iCompilerRequestor, iProblemFactory, null, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, Map map, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, boolean bl) {
        this(iNameEnvironment, iErrorHandlingPolicy, new CompilerOptions(map, bl), iCompilerRequestor, iProblemFactory, null, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory) {
        this(iNameEnvironment, iErrorHandlingPolicy, compilerOptions, iCompilerRequestor, iProblemFactory, null, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, PrintWriter printWriter) {
        this(iNameEnvironment, iErrorHandlingPolicy, compilerOptions, iCompilerRequestor, iProblemFactory, printWriter, null);
    }

    public Compiler(INameEnvironment iNameEnvironment, IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, final ICompilerRequestor iCompilerRequestor, IProblemFactory iProblemFactory, PrintWriter printWriter, CompilationProgress compilationProgress) {
        this.options = compilerOptions;
        this.progress = compilationProgress;
        this.requestor = DebugRequestor == null ? iCompilerRequestor : new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
                if (DebugRequestor.isActive()) {
                    DebugRequestor.acceptDebugResult(compilationResult);
                }
                iCompilerRequestor.acceptResult(compilationResult);
            }
        };
        this.problemReporter = new ProblemReporter(iErrorHandlingPolicy, this.options, iProblemFactory);
        this.lookupEnvironment = new LookupEnvironment(this, this.options, this.problemReporter, iNameEnvironment);
        this.out = printWriter == null ? new PrintWriter(System.out, true) : printWriter;
        this.stats = new CompilerStats();
        this.initializeParser();
    }

    public void accept(IBinaryType iBinaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        if (this.options.verbose) {
            this.out.println(Messages.bind(Messages.compilation_loadBinary, new String(iBinaryType.getName())));
        }
        this.lookupEnvironment.createBinaryTypeFrom(iBinaryType, packageBinding, accessRestriction);
    }

    public void accept(ICompilationUnit iCompilationUnit, AccessRestriction accessRestriction) {
        CompilationResult compilationResult = new CompilationResult(iCompilationUnit, this.totalUnits, this.totalUnits, this.options.maxProblemsPerUnit);
        compilationResult.checkSecondaryTypes = true;
        try {
            Object object;
            if (this.options.verbose) {
                object = String.valueOf(this.totalUnits + 1);
                this.out.println(Messages.bind(Messages.compilation_request, new String[]{object, object, new String(iCompilationUnit.getFileName())}));
            }
            object = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnit, compilationResult) : this.parser.dietParse(iCompilationUnit, compilationResult);
            this.lookupEnvironment.buildTypeBindings((CompilationUnitDeclaration)object, accessRestriction);
            this.addCompilationUnit(iCompilationUnit, (CompilationUnitDeclaration)object);
            this.lookupEnvironment.completeTypeBindings((CompilationUnitDeclaration)object);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            if (compilationResult.compilationUnit == iCompilationUnit) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
            throw abortCompilationUnit;
        }
    }

    public void accept(ISourceType[] iSourceTypeArray, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        this.problemReporter.abortDueToInternalError(Messages.bind(Messages.abort_againstSourceModel, new String[]{String.valueOf(iSourceTypeArray[0].getName()), String.valueOf(iSourceTypeArray[0].getFileName())}));
    }

    protected synchronized void addCompilationUnit(ICompilationUnit iCompilationUnit, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.unitsToProcess == null) {
            return;
        }
        int n = this.unitsToProcess.length;
        if (this.totalUnits == n) {
            this.unitsToProcess = new CompilationUnitDeclaration[n * 2];
            System.arraycopy(this.unitsToProcess, 0, this.unitsToProcess, 0, this.totalUnits);
        }
        this.unitsToProcess[this.totalUnits++] = compilationUnitDeclaration;
    }

    protected void beginToCompile(ICompilationUnit[] iCompilationUnitArray) {
        int n = iCompilationUnitArray.length;
        this.totalUnits = 0;
        this.unitsToProcess = new CompilationUnitDeclaration[n];
        this.internalBeginToCompile(iCompilationUnitArray, n);
    }

    protected void reportProgress(String string) {
        if (this.progress != null) {
            if (this.progress.isCanceled()) {
                throw new AbortCompilation(true, null);
            }
            this.progress.setTaskName(string);
        }
    }

    protected void reportWorked(int n, int n2) {
        if (this.progress != null) {
            if (this.progress.isCanceled()) {
                throw new AbortCompilation(true, null);
            }
            this.progress.worked(n, this.totalUnits * this.remainingIterations - n2 - 1);
        }
    }

    public void compile(ICompilationUnit[] iCompilationUnitArray) {
        this.stats.startTime = System.currentTimeMillis();
        try {
            this.reportProgress(Messages.compilation_beginningToCompile);
            if (this.annotationProcessorManager == null) {
                this.beginToCompile(iCompilationUnitArray);
            } else {
                ICompilationUnit[] iCompilationUnitArray2 = (ICompilationUnit[])iCompilationUnitArray.clone();
                try {
                    this.beginToCompile(iCompilationUnitArray);
                    this.processAnnotations();
                    if (!this.options.generateClassFiles) {
                        return;
                    }
                }
                catch (SourceTypeCollisionException sourceTypeCollisionException) {
                    this.backupAptProblems();
                    this.reset();
                    int n = iCompilationUnitArray2.length;
                    int n2 = sourceTypeCollisionException.newAnnotationProcessorUnits.length;
                    ICompilationUnit[] iCompilationUnitArray3 = new ICompilationUnit[n + n2];
                    System.arraycopy(iCompilationUnitArray2, 0, iCompilationUnitArray3, 0, n);
                    System.arraycopy(sourceTypeCollisionException.newAnnotationProcessorUnits, 0, iCompilationUnitArray3, n, n2);
                    this.annotationProcessorStartIndex = n;
                    this.compile(iCompilationUnitArray3);
                    return;
                }
            }
            this.restoreAptProblems();
            this.processCompiledUnits(0);
        }
        catch (AbortCompilation abortCompilation) {
            this.handleInternalException(abortCompilation, null);
        }
        if (this.options.verbose) {
            if (this.totalUnits > 1) {
                this.out.println(Messages.bind(Messages.compilation_units, String.valueOf(this.totalUnits)));
            } else {
                this.out.println(Messages.bind(Messages.compilation_unit, String.valueOf(this.totalUnits)));
            }
        }
    }

    protected void backupAptProblems() {
        if (this.unitsToProcess == null) {
            return;
        }
        int n = 0;
        while (n < this.totalUnits) {
            CompilationUnitDeclaration compilationUnitDeclaration = this.unitsToProcess[n];
            CompilationResult compilationResult = compilationUnitDeclaration.compilationResult;
            if (compilationResult != null && compilationResult.hasErrors()) {
                CategorizedProblem[] categorizedProblemArray;
                CategorizedProblem[] categorizedProblemArray2 = categorizedProblemArray = compilationResult.getErrors();
                int n2 = categorizedProblemArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    CategorizedProblem categorizedProblem = categorizedProblemArray2[n3];
                    if (categorizedProblem.getCategoryID() == 0) {
                        APTProblem[] aPTProblemArray;
                        if (this.aptProblems == null) {
                            this.aptProblems = new HashMap<String, APTProblem[]>();
                        }
                        if ((aPTProblemArray = this.aptProblems.get(new String(compilationUnitDeclaration.getFileName()))) == null) {
                            this.aptProblems.put(new String(compilationUnitDeclaration.getFileName()), new APTProblem[]{new APTProblem(categorizedProblem, compilationResult.getContext(categorizedProblem))});
                        } else {
                            APTProblem[] aPTProblemArray2 = new APTProblem[aPTProblemArray.length + 1];
                            System.arraycopy(aPTProblemArray, 0, aPTProblemArray2, 0, aPTProblemArray.length);
                            aPTProblemArray2[aPTProblemArray.length] = new APTProblem(categorizedProblem, compilationResult.getContext(categorizedProblem));
                            this.aptProblems.put(new String(compilationUnitDeclaration.getFileName()), aPTProblemArray2);
                        }
                    }
                    ++n3;
                }
            }
            ++n;
        }
    }

    protected void restoreAptProblems() {
        if (this.unitsToProcess != null && this.aptProblems != null) {
            int n = 0;
            while (n < this.totalUnits) {
                CompilationUnitDeclaration compilationUnitDeclaration = this.unitsToProcess[n];
                APTProblem[] aPTProblemArray = this.aptProblems.get(new String(compilationUnitDeclaration.getFileName()));
                if (aPTProblemArray != null) {
                    APTProblem[] aPTProblemArray2 = aPTProblemArray;
                    int n2 = aPTProblemArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        APTProblem aPTProblem = aPTProblemArray2[n3];
                        compilationUnitDeclaration.compilationResult.record(aPTProblem.problem, aPTProblem.context);
                        ++n3;
                    }
                }
                ++n;
            }
        }
        this.aptProblems = null;
    }

    /*
     * Exception decompiling
     */
    protected void processCompiledUnits(int var1_1) throws Error {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized CompilationUnitDeclaration getUnitToProcess(int n) {
        if (n < this.totalUnits) {
            CompilationUnitDeclaration compilationUnitDeclaration = this.unitsToProcess[n];
            if (this.annotationProcessorManager == null || n < this.annotationProcessorStartIndex) {
                this.unitsToProcess[n] = null;
            }
            return compilationUnitDeclaration;
        }
        return null;
    }

    public boolean shouldCleanup(int n) {
        return n < this.annotationProcessorStartIndex;
    }

    public void setBinaryTypes(ReferenceBinding[] referenceBindingArray) {
        this.referenceBindings = referenceBindingArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalException(Throwable throwable, CompilationUnitDeclaration compilationUnitDeclaration, CompilationResult compilationResult) {
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null) {
            Compiler compiler = this;
            synchronized (compiler) {
                if (this.unitsToProcess != null && this.totalUnits > 0) {
                    compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
                }
            }
        }
        boolean bl = true;
        if (compilationResult != null) {
            String[] stringArray = new String[]{Messages.bind(Messages.compilation_internalError, Util.getExceptionSummary(throwable))};
            compilationResult.record(this.problemReporter.createProblem(compilationResult.getFileName(), 0, stringArray, stringArray, 1, 0, 0, 0, 0), compilationUnitDeclaration, true);
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
                bl = false;
            }
        }
        if (bl) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalException(AbortCompilation abortCompilation, CompilationUnitDeclaration compilationUnitDeclaration) {
        Object object;
        if (abortCompilation.isSilent) {
            if (abortCompilation.silentException == null) {
                return;
            }
            throw abortCompilation.silentException;
        }
        CompilationResult compilationResult = abortCompilation.compilationResult;
        if (compilationResult == null && compilationUnitDeclaration != null) {
            compilationResult = compilationUnitDeclaration.compilationResult;
        }
        if (compilationResult == null && this.lookupEnvironment.unitBeingCompleted != null) {
            compilationResult = this.lookupEnvironment.unitBeingCompleted.compilationResult;
        }
        if (compilationResult == null) {
            object = this;
            synchronized (object) {
                if (this.unitsToProcess != null && this.totalUnits > 0) {
                    compilationResult = this.unitsToProcess[this.totalUnits - 1].compilationResult;
                }
            }
        }
        if (compilationResult != null && !compilationResult.hasBeenAccepted) {
            block18: {
                if (abortCompilation.problem != null) {
                    object = abortCompilation.problem;
                    CategorizedProblem[] categorizedProblemArray = compilationResult.problems;
                    int n = 0;
                    while (n < compilationResult.problemCount) {
                        if (categorizedProblemArray[n] != object) {
                            ++n;
                            continue;
                        }
                        break block18;
                    }
                    if (object instanceof DefaultProblem) {
                        ((DefaultProblem)object).setOriginatingFileName(compilationResult.getFileName());
                    }
                    compilationResult.record((CategorizedProblem)object, compilationUnitDeclaration, true);
                } else if (abortCompilation.exception != null) {
                    this.handleInternalException(abortCompilation.exception, null, compilationResult);
                    return;
                }
            }
            if (!compilationResult.hasBeenAccepted) {
                this.requestor.acceptResult(compilationResult.tagAsAccepted());
            }
        } else {
            abortCompilation.printStackTrace();
        }
    }

    public void initializeParser() {
        this.parser = new Parser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }

    protected void internalBeginToCompile(ICompilationUnit[] iCompilationUnitArray, int n) {
        if (!this.useSingleThread && n >= 10) {
            this.parser.readManager = new ReadManager(iCompilationUnitArray, n);
        }
        int n2 = 0;
        while (n2 < n) {
            CompilationResult compilationResult = null;
            try {
                try {
                    if (this.options.verbose) {
                        this.out.println(Messages.bind(Messages.compilation_request, new String[]{String.valueOf(n2 + 1), String.valueOf(n), new String(iCompilationUnitArray[n2].getFileName())}));
                    }
                    compilationResult = new CompilationResult(iCompilationUnitArray[n2], n2, n, this.options.maxProblemsPerUnit);
                    long l = System.currentTimeMillis();
                    CompilationUnitDeclaration compilationUnitDeclaration = this.totalUnits < this.parseThreshold ? this.parser.parse(iCompilationUnitArray[n2], compilationResult) : this.parser.dietParse(iCompilationUnitArray[n2], compilationResult);
                    long l2 = System.currentTimeMillis();
                    this.stats.parseTime += l2 - l;
                    this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                    this.stats.resolveTime += System.currentTimeMillis() - l2;
                    this.addCompilationUnit(iCompilationUnitArray[n2], compilationUnitDeclaration);
                    ImportReference importReference = compilationUnitDeclaration.currentPackage;
                    if (importReference != null) {
                        compilationResult.recordPackageName(importReference.tokens);
                    }
                }
                catch (AbortCompilation abortCompilation) {
                    if (abortCompilation.compilationResult == null) {
                        abortCompilation.compilationResult = compilationResult;
                    }
                    throw abortCompilation;
                }
            }
            finally {
                iCompilationUnitArray[n2] = null;
            }
            ++n2;
        }
        if (this.parser.readManager != null) {
            this.parser.readManager.shutdown();
            this.parser.readManager = null;
        }
        this.lookupEnvironment.completeTypeBindings();
    }

    public void process(CompilationUnitDeclaration compilationUnitDeclaration, int n) {
        this.lookupEnvironment.unitBeingCompleted = compilationUnitDeclaration;
        long l = System.currentTimeMillis();
        this.parser.getMethodBodies(compilationUnitDeclaration);
        long l2 = System.currentTimeMillis();
        this.stats.parseTime += l2 - l;
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.faultInTypes();
        }
        if (compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
        }
        compilationUnitDeclaration.resolve();
        long l3 = System.currentTimeMillis();
        this.stats.resolveTime += l3 - l2;
        if (!this.options.ignoreMethodBodies) {
            compilationUnitDeclaration.analyseCode();
        }
        long l4 = System.currentTimeMillis();
        this.stats.analyzeTime += l4 - l3;
        if (!this.options.ignoreMethodBodies) {
            compilationUnitDeclaration.generateCode();
        }
        if (this.options.produceReferenceInfo && compilationUnitDeclaration.scope != null) {
            compilationUnitDeclaration.scope.storeDependencyInfo();
        }
        compilationUnitDeclaration.finalizeProblems();
        this.stats.generateTime += System.currentTimeMillis() - l4;
        compilationUnitDeclaration.compilationResult.totalUnitsKnown = this.totalUnits;
        this.lookupEnvironment.unitBeingCompleted = null;
    }

    protected void processAnnotations() {
        block18: {
            Object[] objectArray;
            int n = 0;
            int n2 = 0;
            int n3 = this.annotationProcessorStartIndex;
            int n4 = this.totalUnits;
            ReferenceBinding[] referenceBindingArray = this.referenceBindings;
            if (n4 == 0 && referenceBindingArray == null) {
                return;
            }
            this.referenceBindings = null;
            do {
                ReferenceBinding[] referenceBindingArray2;
                int n5 = n4 - n3;
                objectArray = new CompilationUnitDeclaration[n5];
                int n6 = 0;
                int n7 = n3;
                while (n7 < n4) {
                    referenceBindingArray2 = this.unitsToProcess[n7];
                    objectArray[n6++] = referenceBindingArray2;
                    ++n7;
                }
                if (n6 != n5) {
                    CompilationUnitDeclaration[] compilationUnitDeclarationArray = objectArray;
                    objectArray = new CompilationUnitDeclaration[n6];
                    System.arraycopy(compilationUnitDeclarationArray, 0, objectArray, 0, n6);
                }
                this.annotationProcessorManager.processAnnotations((CompilationUnitDeclaration[])objectArray, referenceBindingArray, false);
                if (n4 < this.totalUnits) {
                    n5 = this.totalUnits - n4;
                    CompilationUnitDeclaration[] compilationUnitDeclarationArray = new CompilationUnitDeclaration[n5];
                    System.arraycopy(this.unitsToProcess, n4, compilationUnitDeclarationArray, 0, n5);
                    this.annotationProcessorManager.processAnnotations(compilationUnitDeclarationArray, referenceBindingArray, false);
                }
                this.annotationProcessorStartIndex = n4;
                ICompilationUnit[] iCompilationUnitArray = this.annotationProcessorManager.getNewUnits();
                n = iCompilationUnitArray.length;
                referenceBindingArray2 = this.annotationProcessorManager.getNewClassFiles();
                referenceBindingArray = referenceBindingArray2;
                n2 = referenceBindingArray2.length;
                if (n != 0) {
                    ICompilationUnit[] iCompilationUnitArray2 = (ICompilationUnit[])iCompilationUnitArray.clone();
                    try {
                        try {
                            this.lookupEnvironment.isProcessingAnnotations = true;
                            this.internalBeginToCompile(iCompilationUnitArray, n);
                        }
                        catch (SourceTypeCollisionException sourceTypeCollisionException) {
                            sourceTypeCollisionException.newAnnotationProcessorUnits = iCompilationUnitArray2;
                            throw sourceTypeCollisionException;
                        }
                    }
                    finally {
                        this.lookupEnvironment.isProcessingAnnotations = false;
                        this.annotationProcessorManager.reset();
                    }
                    n3 = n4;
                    this.annotationProcessorStartIndex = n4 = this.totalUnits;
                    continue;
                }
                n3 = n4;
                this.annotationProcessorManager.reset();
            } while (n != 0 || n2 != 0);
            this.annotationProcessorManager.processAnnotations(null, null, true);
            ICompilationUnit[] iCompilationUnitArray = this.annotationProcessorManager.getNewUnits();
            n = iCompilationUnitArray.length;
            if (n != 0) {
                objectArray = (ICompilationUnit[])iCompilationUnitArray.clone();
                try {
                    try {
                        this.lookupEnvironment.isProcessingAnnotations = true;
                        this.internalBeginToCompile(iCompilationUnitArray, n);
                        break block18;
                    }
                    catch (SourceTypeCollisionException sourceTypeCollisionException) {
                        sourceTypeCollisionException.newAnnotationProcessorUnits = objectArray;
                        throw sourceTypeCollisionException;
                    }
                }
                finally {
                    this.lookupEnvironment.isProcessingAnnotations = false;
                    this.annotationProcessorManager.reset();
                }
            }
            this.annotationProcessorManager.reset();
        }
        this.annotationProcessorStartIndex = this.totalUnits;
    }

    public void reset() {
        this.lookupEnvironment.reset();
        this.parser.scanner.source = null;
        this.unitsToProcess = null;
        if (DebugRequestor != null) {
            DebugRequestor.reset();
        }
        this.problemReporter.reset();
    }

    public CompilationUnitDeclaration resolve(CompilationUnitDeclaration compilationUnitDeclaration, ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3) {
        try {
            if (compilationUnitDeclaration == null) {
                this.parseThreshold = 0;
                this.beginToCompile(new ICompilationUnit[]{iCompilationUnit});
                int n = 0;
                while (n < this.totalUnits) {
                    if (this.unitsToProcess[n] != null && this.unitsToProcess[n].compilationResult.compilationUnit == iCompilationUnit) {
                        compilationUnitDeclaration = this.unitsToProcess[n];
                        break;
                    }
                    ++n;
                }
                if (compilationUnitDeclaration == null) {
                    compilationUnitDeclaration = this.unitsToProcess[0];
                }
            } else {
                this.lookupEnvironment.buildTypeBindings(compilationUnitDeclaration, null);
                this.lookupEnvironment.completeTypeBindings();
            }
            this.lookupEnvironment.unitBeingCompleted = compilationUnitDeclaration;
            this.parser.getMethodBodies(compilationUnitDeclaration);
            if (compilationUnitDeclaration.scope != null) {
                compilationUnitDeclaration.scope.faultInTypes();
                if (compilationUnitDeclaration.scope != null && bl) {
                    compilationUnitDeclaration.scope.verifyMethods(this.lookupEnvironment.methodVerifier());
                }
                compilationUnitDeclaration.resolve();
                if (bl2) {
                    compilationUnitDeclaration.analyseCode();
                }
                if (bl3) {
                    compilationUnitDeclaration.generateCode();
                }
                compilationUnitDeclaration.finalizeProblems();
            }
            if (this.unitsToProcess != null) {
                this.unitsToProcess[0] = null;
            }
            this.requestor.acceptResult(compilationUnitDeclaration.compilationResult.tagAsAccepted());
            return compilationUnitDeclaration;
        }
        catch (AbortCompilation abortCompilation) {
            this.handleInternalException(abortCompilation, compilationUnitDeclaration);
            return compilationUnitDeclaration == null ? this.unitsToProcess[0] : compilationUnitDeclaration;
        }
        catch (Error error) {
            this.handleInternalException(error, compilationUnitDeclaration, null);
            throw error;
        }
        catch (RuntimeException runtimeException) {
            this.handleInternalException(runtimeException, compilationUnitDeclaration, null);
            throw runtimeException;
        }
    }

    public CompilationUnitDeclaration resolve(ICompilationUnit iCompilationUnit, boolean bl, boolean bl2, boolean bl3) {
        return this.resolve(null, iCompilationUnit, bl, bl2, bl3);
    }

    class APTProblem {
        CategorizedProblem problem;
        ReferenceContext context;

        APTProblem(CategorizedProblem categorizedProblem, ReferenceContext referenceContext) {
            this.problem = categorizedProblem;
            this.context = referenceContext;
        }
    }
}

