/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.torproject.descriptor.index.IndexNode;
import org.torproject.metrics.web.DirectoryListing;

public class CollectorDirectoryProvider
implements Runnable {
    private String host;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final AtomicReference<Map<String, List<String[]>>> index = new AtomicReference<Object>(null);

    CollectorDirectoryProvider(String host) {
        this.host = host;
        this.scheduler.scheduleAtFixedRate(this, 0L, 1L, TimeUnit.MINUTES);
    }

    Map<String, List<String[]>> getIndex() {
        if (null == this.index.get()) {
            long waitingSinceMillis = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (null == this.index.get() && System.currentTimeMillis() < waitingSinceMillis + 10000L);
        }
        return this.index.get();
    }

    @Override
    public void run() {
        IndexNode indexNode;
        try {
            indexNode = IndexNode.fetchIndex(this.host + "/index/index.json.gz");
        }
        catch (Exception e) {
            return;
        }
        this.index.set(new DirectoryListing(indexNode));
    }
}

