/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.torproject.metrics.web.AnyServlet;
import org.torproject.metrics.web.CollectorDirectoryProvider;

public class CollecTorServlet
extends AnyServlet {
    private static final long serialVersionUID = -7054057945737357463L;
    private static final String COLLECTOR_HOST = "https://collector.torproject.org";
    private CollectorDirectoryProvider collectorDirectory;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.collectorDirectory = new CollectorDirectoryProvider(COLLECTOR_HOST);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String requestedPath = request.getRequestURI();
        if (requestedPath.contains("/collector")) {
            requestedPath = requestedPath.substring(requestedPath.indexOf("/collector"));
        }
        if ("/collector.html".equals(requestedPath)) {
            request.setAttribute("categories", this.categories);
            request.getRequestDispatcher("WEB-INF/collector.jsp").forward(request, response);
        } else {
            Map<String, List<String[]>> index = this.collectorDirectory.getIndex();
            if (null == index) {
                response.sendError(500, "Index of CollecTor files unavailable.");
            } else if (!requestedPath.endsWith("/") && index.containsKey(requestedPath + "/")) {
                response.setStatus(301);
                response.setHeader("Location", requestedPath + "/");
            } else if (index.containsKey(requestedPath)) {
                request.setAttribute("categories", this.categories);
                request.setAttribute("files", index.get(requestedPath));
                request.getRequestDispatcher("/WEB-INF/collector-files.jsp").forward(request, response);
            } else {
                response.sendError(404, "Unknown directory: " + requestedPath);
            }
        }
    }
}

