/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.torproject.metrics.web.AnyServlet;
import org.torproject.metrics.web.ContentProvider;
import org.torproject.metrics.web.Countries;
import org.torproject.metrics.web.News;

public class NewsServlet
extends AnyServlet {
    private static final long serialVersionUID = -7696996243187241242L;
    protected List<News> sortedNews;
    protected SortedMap<String, String> countries;

    @Override
    public void init() throws ServletException {
        super.init();
        ArrayList<News> sortedNews = new ArrayList<News>();
        for (News news : ContentProvider.getInstance().getNewsList()) {
            if (news.getStart() == null) continue;
            sortedNews.add(news);
        }
        sortedNews.sort((o1, o2) -> o1.getStart().compareTo(o2.getStart()) * -1);
        this.sortedNews = sortedNews;
        TreeMap<String, String> countries = new TreeMap<String, String>();
        for (String[] country : Countries.getInstance().getCountryList()) {
            countries.put(country[0], country[1]);
        }
        this.countries = countries;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getRequestURI().endsWith("news.atom")) {
            this.doGetAtom(request, response);
        } else {
            this.doGetHtml(request, response);
        }
    }

    private void doGetHtml(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LinkedHashMap<String, String[]> cutOffDates = new LinkedHashMap<String, String[]>();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        cal.set(7, 1);
        cutOffDates.put(String.format("%tF", cal), new String[]{"This week", "week"});
        cal.set(5, 1);
        cutOffDates.put(String.format("%tF", cal), new String[]{"This month", "month"});
        cal.set(2, cal.get(2) / 3 * 3);
        cutOffDates.put(String.format("%tF", cal), new String[]{"This quarter", "quarter"});
        cal.set(2, 0);
        String yearStart = String.format("%tF", cal);
        cutOffDates.put(yearStart, new String[]{"This year", "year"});
        do {
            cal.add(1, -1);
            yearStart = String.format("%tF", cal);
            String year = String.format("%tY", cal);
            cutOffDates.put(yearStart, new String[]{year, year});
        } while (!this.sortedNews.isEmpty() && yearStart.compareTo(this.sortedNews.get(this.sortedNews.size() - 1).getStart()) > 0);
        LinkedHashMap newsByCategory = new LinkedHashMap();
        for (String[] category : cutOffDates.values()) {
            newsByCategory.put(category, new ArrayList());
        }
        block2: for (News news : this.sortedNews) {
            for (Map.Entry category : cutOffDates.entrySet()) {
                if (news.getStart().compareTo((String)category.getKey()) < 0) continue;
                ((List)newsByCategory.get(category.getValue())).add(news);
                continue block2;
            }
        }
        for (String[] category : cutOffDates.values()) {
            if (!((List)newsByCategory.get(category)).isEmpty()) continue;
            newsByCategory.remove(category);
        }
        request.setAttribute("categories", (Object)this.categories);
        request.setAttribute("news", newsByCategory);
        request.getRequestDispatcher("WEB-INF/news.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void doGetAtom(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("news", this.sortedNews);
        request.setAttribute("updated", (Object)this.sortedNews.get(0).getStart());
        request.getRequestDispatcher("WEB-INF/news-atom.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

