/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.torproject.metrics.web.Countries;

public class News {
    String start;
    String end;
    Boolean ongoing;
    List<String> places;
    List<String> protocols;
    String shortDescription;
    String description;
    List<Link> links;
    Boolean unknown;
    static SortedMap<String, String> countries = new TreeMap<String, String>();

    void addLink(String label, String target) {
        if (null == this.links) {
            this.links = new ArrayList<Link>();
        }
        Link link = new Link();
        link.label = label;
        link.target = target;
        this.links.add(link);
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public boolean isOngoing() {
        if (this.ongoing != null) {
            return this.ongoing;
        }
        return false;
    }

    public List<String> getPlaces() {
        return this.places;
    }

    public List<String> getPlaceNames() {
        if (null == this.places) {
            return null;
        }
        ArrayList<String> placeNames = new ArrayList<String>();
        for (String place : this.places) {
            placeNames.add(countries.getOrDefault(place, "Unknown Country"));
        }
        return placeNames;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public boolean isUnknown() {
        if (this.unknown != null) {
            return this.unknown;
        }
        return false;
    }

    static {
        for (String[] country : Countries.getInstance().getCountryList()) {
            countries.put(country[0], country[1]);
        }
    }

    public static class Link {
        String label;
        String target;

        public String getLabel() {
            return this.label;
        }

        public String getTarget() {
            return this.target;
        }
    }
}

