/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.stats.servers.Configuration;
import org.torproject.metrics.stats.servers.ConsensusStatsFileHandler;
import org.torproject.metrics.stats.servers.LockFile;
import org.torproject.metrics.stats.servers.RelayDescriptorDatabaseImporter;

public class Main {
    private static Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        ConsensusStatsFileHandler csfh;
        log.info("Starting ERNIE.");
        Configuration config = new Configuration();
        LockFile lf = new LockFile();
        if (!lf.acquireLock()) {
            log.error("Warning: ERNIE is already running or has not exited cleanly! Exiting!");
            System.exit(1);
        }
        File statsDirectory = new File("stats");
        if (config.getImportDirectoryArchives()) {
            RelayDescriptorDatabaseImporter rddi;
            RelayDescriptorDatabaseImporter relayDescriptorDatabaseImporter = config.getWriteRelayDescriptorDatabase() || config.getWriteRelayDescriptorsRawFiles() ? new RelayDescriptorDatabaseImporter(config.getWriteRelayDescriptorDatabase() ? config.getRelayDescriptorDatabaseJdbc() : null, config.getWriteRelayDescriptorsRawFiles() ? config.getRelayDescriptorRawFilesDirectory() : null, config.getDirectoryArchivesDirectories(), statsDirectory, config.getKeepDirectoryArchiveImportHistory()) : (rddi = null);
            if (null != rddi) {
                rddi.importRelayDescriptors();
                rddi.closeConnection();
            }
        }
        ConsensusStatsFileHandler consensusStatsFileHandler = csfh = config.getWriteBridgeStats() ? new ConsensusStatsFileHandler(config.getRelayDescriptorDatabaseJdbc(), new File(config.getSanitizedBridgesDirectory()), statsDirectory, config.getKeepSanitizedBridgesImportHistory()) : null;
        if (csfh != null) {
            if (config.getImportSanitizedBridges()) {
                csfh.importSanitizedBridges();
            }
            csfh.writeFiles();
        }
        lf.releaseLock();
        log.info("Terminating ERNIE.");
    }
}

