/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockFile {
    private File lockFile = new File("lock");
    private static Logger log = LoggerFactory.getLogger(LockFile.class);

    public boolean acquireLock() {
        log.debug("Trying to acquire lock...");
        try {
            if (this.lockFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader("lock"));
                long runStarted = Long.parseLong(br.readLine());
                br.close();
                if (System.currentTimeMillis() - runStarted < 82800000L) {
                    return false;
                }
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter("lock"));
            bw.append("").append(String.valueOf(System.currentTimeMillis())).append("\n");
            bw.close();
            log.debug("Acquired lock.");
            return true;
        }
        catch (IOException e) {
            log.warn("Caught exception while trying to acquire lock!");
            return false;
        }
    }

    public void releaseLock() {
        log.debug("Releasing lock...");
        this.lockFile.delete();
        log.debug("Released lock.");
    }
}

