/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.NetworkStatusEntry;

public class ConsensusStatsFileHandler {
    private File bridgeConsensusStatsRawFile;
    private SortedMap<String, String> bridgesRaw;
    private SortedMap<String, String> bridgesPerDay;
    private static Logger log = LoggerFactory.getLogger(ConsensusStatsFileHandler.class);
    private int bridgeResultsAdded = 0;
    private String connectionUrl;
    private SimpleDateFormat dateTimeFormat;
    private File bridgesDir;
    private File statsDirectory;
    private boolean keepImportHistory;

    public ConsensusStatsFileHandler(String connectionUrl, File bridgesDir, File statsDirectory, boolean keepImportHistory) {
        if (bridgesDir == null || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        this.bridgesDir = bridgesDir;
        this.statsDirectory = statsDirectory;
        this.keepImportHistory = keepImportHistory;
        this.bridgesPerDay = new TreeMap<String, String>();
        this.bridgesRaw = new TreeMap<String, String>();
        this.bridgeConsensusStatsRawFile = new File("stats/bridge-consensus-stats-raw");
        this.connectionUrl = connectionUrl;
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.bridgeConsensusStatsRawFile.exists()) {
            log.debug("Reading file {}...", (Object)this.bridgeConsensusStatsRawFile.getAbsolutePath());
            try (BufferedReader br = new BufferedReader(new FileReader(this.bridgeConsensusStatsRawFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("date")) continue;
                    String[] parts = line.split(",");
                    if (parts.length < 2 || parts.length > 4) {
                        log.warn("Corrupt line '{}' in file {}! Aborting to read this file!", (Object)line, (Object)this.bridgeConsensusStatsRawFile.getAbsolutePath());
                        break;
                    }
                    String key = parts[0] + "," + (parts.length < 4 ? "Tonga" : parts[1]);
                    String value = null;
                    if (parts.length == 2) {
                        value = key + "," + parts[1] + ",0";
                    } else if (parts.length == 3) {
                        value = key + "," + parts[1] + "," + parts[2];
                    } else if (parts.length == 4) {
                        value = key + "," + parts[2] + "," + parts[3];
                    }
                    this.bridgesRaw.put(key, value);
                }
                log.debug("Finished reading file {}.", (Object)this.bridgeConsensusStatsRawFile.getAbsolutePath());
            }
            catch (IOException e) {
                log.warn("Failed to read file {}!", (Object)this.bridgeConsensusStatsRawFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    public void addBridgeConsensusResults(long publishedMillis, String authorityNickname, int running, int runningEc2Bridges) {
        String publishedAuthority = this.dateTimeFormat.format(publishedMillis) + "," + authorityNickname;
        String line = publishedAuthority + "," + running + "," + runningEc2Bridges;
        if (!this.bridgesRaw.containsKey(publishedAuthority)) {
            log.debug("Adding new bridge numbers: {}", (Object)line);
            this.bridgesRaw.put(publishedAuthority, line);
            ++this.bridgeResultsAdded;
        } else if (!line.equals(this.bridgesRaw.get(publishedAuthority))) {
            log.warn("The numbers of running bridges we were just given ({}) are different from what we learned before ({})! Overwriting!", (Object)line, this.bridgesRaw.get(publishedAuthority));
            this.bridgesRaw.put(publishedAuthority, line);
        }
    }

    public void importSanitizedBridges() {
        if (this.bridgesDir.exists()) {
            log.debug("Importing files in directory {}/...", (Object)this.bridgesDir);
            DescriptorReader reader = DescriptorSourceFactory.createDescriptorReader();
            File historyFile = new File(this.statsDirectory, "consensus-stats-bridge-descriptor-history");
            if (this.keepImportHistory) {
                reader.setHistoryFile(historyFile);
            }
            for (Descriptor descriptor : reader.readDescriptors(new File[]{this.bridgesDir})) {
                if (!(descriptor instanceof BridgeNetworkStatus)) continue;
                String descriptorFileName = descriptor.getDescriptorFile().getName();
                String authority = null;
                if (descriptorFileName.contains("4A0CCD2DDC7995083D73F5D667100C8A5831F16D")) {
                    authority = "Tonga";
                } else if (descriptorFileName.contains("1D8F3A91C37C5D1C4C19B1AD1D0CFBE8BF72D8E1")) {
                    authority = "Bifroest";
                } else if (descriptorFileName.contains("BA44A889E64B93FAA2B114E02C2A279A8555C533")) {
                    authority = "Serge";
                }
                if (authority == null) {
                    log.warn("Did not recognize the bridge authority that generated {}. Skipping.", (Object)descriptorFileName);
                    continue;
                }
                this.addBridgeNetworkStatus((BridgeNetworkStatus)descriptor, authority);
            }
            if (this.keepImportHistory) {
                reader.saveHistoryFile(historyFile);
            }
            log.info("Finished importing bridge descriptors.");
        }
    }

    private void addBridgeNetworkStatus(BridgeNetworkStatus status, String authority) {
        int runningBridges = 0;
        int runningEc2Bridges = 0;
        for (NetworkStatusEntry statusEntry : status.getStatusEntries().values()) {
            if (!statusEntry.getFlags().contains("Running")) continue;
            ++runningBridges;
            if (!statusEntry.getNickname().startsWith("ec2bridge")) continue;
            ++runningEc2Bridges;
        }
        this.addBridgeConsensusResults(status.getPublishedMillis(), authority, runningBridges, runningEc2Bridges);
    }

    public void writeFiles() {
        int brunning;
        HashMap bridgesPerDayAndAuthority = new HashMap();
        for (String string : this.bridgesRaw.values()) {
            String[] parts = string.split(",");
            brunning = Integer.parseInt(parts[2]);
            if (brunning <= 0) continue;
            String date = string.substring(0, 10);
            bridgesPerDayAndAuthority.putIfAbsent(date, new TreeMap());
            String authority = parts[1];
            ((Map)bridgesPerDayAndAuthority.get(date)).putIfAbsent(authority, new int[3]);
            int[] bridges = (int[])((Map)bridgesPerDayAndAuthority.get(date)).get(authority);
            bridges[0] = bridges[0] + brunning;
            bridges[1] = bridges[1] + Integer.parseInt(parts[3]);
            bridges[2] = bridges[2] + 1;
        }
        for (Map.Entry entry : bridgesPerDayAndAuthority.entrySet()) {
            String date = (String)entry.getKey();
            brunning = 0;
            int brunningEc2 = 0;
            for (int[] perAuthority : ((Map)entry.getValue()).values()) {
                int n = perAuthority[2];
                if (n < 12) continue;
                brunning += perAuthority[0] / n;
                brunningEc2 += perAuthority[1] / n;
            }
            String line = "," + brunning + "," + brunningEc2;
            if (!this.bridgesPerDay.containsKey(date)) {
                log.debug("Adding new average bridge numbers: {}{}", (Object)date, (Object)line);
                this.bridgesPerDay.put(date, line);
                continue;
            }
            if (line.equals(this.bridgesPerDay.get(date))) continue;
            log.debug("Replacing existing average bridge numbers ({} with new numbers: {}", this.bridgesPerDay.get(date), (Object)line);
            this.bridgesPerDay.put(date, line);
        }
        log.debug("Writing file {}...", (Object)this.bridgeConsensusStatsRawFile.getAbsolutePath());
        this.bridgeConsensusStatsRawFile.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.bridgeConsensusStatsRawFile));){
                bw.append("datetime,authority,brunning,brunningec2");
                bw.newLine();
                for (String line : this.bridgesRaw.values()) {
                    bw.append(line);
                    bw.newLine();
                }
                log.debug("Finished writing file {}.", (Object)this.bridgeConsensusStatsRawFile.getAbsolutePath());
            }
            catch (Throwable date) {
                Throwable throwable2 = date;
                throw date;
            }
        }
        catch (IOException e) {
            log.warn("Failed to write file {}!", (Object)this.bridgeConsensusStatsRawFile.getAbsolutePath(), (Object)e);
        }
        if (this.connectionUrl != null) {
            try {
                HashMap<String, Object> updateRows = new HashMap<String, Object>();
                HashMap<String, String> hashMap = new HashMap<String, String>(this.bridgesPerDay);
                Connection conn = DriverManager.getConnection(this.connectionUrl);
                conn.setAutoCommit(false);
                Statement statement = conn.createStatement();
                ResultSet rs = statement.executeQuery("SELECT date, avg_running, avg_running_ec2 FROM bridge_network_size");
                while (rs.next()) {
                    String date = rs.getDate(1).toString();
                    if (!hashMap.containsKey(date)) continue;
                    String insertRow = (String)hashMap.remove(date);
                    String[] stringArray = insertRow.substring(1).split(",");
                    long newAvgRunning = Long.parseLong(stringArray[0]);
                    long newAvgRunningEc2 = Long.parseLong(stringArray[1]);
                    long oldAvgRunning = rs.getLong(2);
                    long oldAvgRunningEc2 = rs.getLong(3);
                    if (newAvgRunning == oldAvgRunning && newAvgRunningEc2 == oldAvgRunningEc2) continue;
                    updateRows.put(date, insertRow);
                }
                rs.close();
                PreparedStatement psU = conn.prepareStatement("UPDATE bridge_network_size SET avg_running = ?, avg_running_ec2 = ? WHERE date = ?");
                for (Map.Entry entry : updateRows.entrySet()) {
                    Date date = Date.valueOf((String)entry.getKey());
                    String[] parts = ((String)entry.getValue()).substring(1).split(",");
                    long avgRunning = Long.parseLong(parts[0]);
                    long avgRunningEc2 = Long.parseLong(parts[1]);
                    psU.clearParameters();
                    psU.setLong(1, avgRunning);
                    psU.setLong(2, avgRunningEc2);
                    psU.setDate(3, date);
                    psU.executeUpdate();
                }
                PreparedStatement psI = conn.prepareStatement("INSERT INTO bridge_network_size (avg_running, avg_running_ec2, date) VALUES (?, ?, ?)");
                for (Map.Entry e : hashMap.entrySet()) {
                    Date date = Date.valueOf((String)e.getKey());
                    String[] parts = ((String)e.getValue()).substring(1).split(",");
                    long avgRunning = Long.parseLong(parts[0]);
                    long avgRunningEc2 = Long.parseLong(parts[1]);
                    psI.clearParameters();
                    psI.setLong(1, avgRunning);
                    psI.setLong(2, avgRunningEc2);
                    psI.setDate(3, date);
                    psI.executeUpdate();
                }
                conn.commit();
                conn.close();
            }
            catch (SQLException e) {
                log.warn("Failed to add average bridge numbers to database.", (Throwable)e);
            }
        }
        StringBuilder dumpStats = new StringBuilder("Finished writing statistics on bridge network statuses to disk.\nAdded " + this.bridgeResultsAdded + " bridge network status(es) in this execution.");
        long l = System.currentTimeMillis();
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.bridgesRaw.isEmpty()) {
            dumpStats.append("\nNo bridge status known yet.");
        } else {
            dumpStats.append("\nLast known bridge status was published ").append(this.bridgesRaw.lastKey()).append(".");
            try {
                if (l - 21600000L > dateTimeFormat.parse(this.bridgesRaw.lastKey()).getTime()) {
                    log.warn("Last known bridge status is more than 6 hours old: {}", (Object)this.bridgesRaw.lastKey());
                }
            }
            catch (ParseException e) {
                log.warn("Can't parse the timestamp? Reason: {}", (Throwable)e);
            }
        }
        log.info(dumpStats.toString());
    }
}

