/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.ipv6servers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.torproject.metrics.stats.ipv6servers.OutputLine;

class Writer {
    Writer() {
    }

    void write(Path filePath, Iterable<OutputLine> outputLines) throws IOException {
        File parentFile = filePath.toFile().getParentFile();
        if (null != parentFile && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Unable to create parent directory of output file. Not writing this file.");
        }
        ArrayList<String> formattedOutputLines = new ArrayList<String>();
        formattedOutputLines.add(OutputLine.columnHeadersDelimitedBy(","));
        for (OutputLine line : outputLines) {
            formattedOutputLines.add(line.toString());
        }
        Files.write(filePath, formattedOutputLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

