/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.ipv6servers;

import java.time.Instant;
import java.time.ZoneId;
import org.apache.commons.lang3.StringUtils;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.RelayServerDescriptor;
import org.torproject.descriptor.ServerDescriptor;
import org.torproject.metrics.stats.ipv6servers.Ipv6NetworkStatus;
import org.torproject.metrics.stats.ipv6servers.Ipv6ServerDescriptor;

class Parser {
    Parser() {
    }

    Ipv6ServerDescriptor parseServerDescriptor(ServerDescriptor serverDescriptor) {
        Ipv6ServerDescriptor parsedDescriptor = new Ipv6ServerDescriptor();
        parsedDescriptor.digest = serverDescriptor.getDigestSha1Hex();
        for (String orAddress : serverDescriptor.getOrAddresses()) {
            if (StringUtils.countMatches((CharSequence)orAddress, (CharSequence)":") < 2) continue;
            parsedDescriptor.announced = true;
            break;
        }
        if (serverDescriptor instanceof RelayServerDescriptor) {
            parsedDescriptor.advertisedBandwidth = Math.min(serverDescriptor.getBandwidthRate(), serverDescriptor.getBandwidthBurst());
            if (serverDescriptor.getBandwidthObserved() >= 0) {
                parsedDescriptor.advertisedBandwidth = Math.min(parsedDescriptor.advertisedBandwidth, serverDescriptor.getBandwidthObserved());
            }
            parsedDescriptor.exiting = null != serverDescriptor.getIpv6DefaultPolicy() && (!"reject".equals(serverDescriptor.getIpv6DefaultPolicy()) || !"1-65535".equals(serverDescriptor.getIpv6PortList()));
        }
        return parsedDescriptor;
    }

    Ipv6NetworkStatus parseRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        return this.parseStatus(true, consensus.getValidAfterMillis(), consensus.getStatusEntries().values());
    }

    Ipv6NetworkStatus parseBridgeNetworkStatus(BridgeNetworkStatus status) {
        return this.parseStatus(false, status.getPublishedMillis(), status.getStatusEntries().values());
    }

    private Ipv6NetworkStatus parseStatus(boolean isRelay, long timestampMillis, Iterable<NetworkStatusEntry> entries) {
        Ipv6NetworkStatus parsedStatus = new Ipv6NetworkStatus();
        parsedStatus.isRelay = isRelay;
        parsedStatus.timestamp = Instant.ofEpochMilli(timestampMillis).atZone(ZoneId.of("UTC")).toLocalDateTime();
        for (NetworkStatusEntry entry : entries) {
            if (!entry.getFlags().contains("Running")) continue;
            ++parsedStatus.running;
        }
        for (NetworkStatusEntry entry : entries) {
            if (!entry.getFlags().contains("Running")) continue;
            Ipv6NetworkStatus.Entry parsedEntry = new Ipv6NetworkStatus.Entry();
            parsedEntry.digest = entry.getDescriptor().toLowerCase();
            if (isRelay) {
                parsedEntry.guard = entry.getFlags().contains("Guard");
                parsedEntry.exit = entry.getFlags().contains("Exit") && !entry.getFlags().contains("BadExit");
                parsedEntry.reachable = false;
                for (String orAddress : entry.getOrAddresses()) {
                    if (StringUtils.countMatches((CharSequence)orAddress, (CharSequence)":") < 2) continue;
                    parsedEntry.reachable = true;
                    break;
                }
            }
            parsedStatus.entries.add(parsedEntry);
        }
        return parsedStatus;
    }
}

