/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.metrics.stats.hidserv.Document;

public class DocumentStore<T extends Document> {
    private static Logger log = LoggerFactory.getLogger(DocumentStore.class);
    private Class<T> clazz;

    DocumentStore(Class<T> clazz) {
        this.clazz = clazz;
    }

    public boolean store(File documentFile, Set<T> documentsToStore) {
        Set<T> retrievedDocuments = this.retrieve(documentFile);
        if (retrievedDocuments == null) {
            log.warn("Unable to read and update {}. Not storing documents.", (Object)documentFile.getAbsoluteFile());
            return false;
        }
        retrievedDocuments.addAll(documentsToStore);
        TreeMap formattedDocuments = new TreeMap();
        for (Document retrieveDocument : retrievedDocuments) {
            String[] formattedDocument = retrieveDocument.format();
            formattedDocuments.putIfAbsent(formattedDocument[0], new TreeSet());
            ((SortedSet)formattedDocuments.get(formattedDocument[0])).add(formattedDocument[1]);
        }
        File documentTempFile = new File(documentFile.getAbsoluteFile() + ".tmp");
        if (documentTempFile.exists()) {
            log.warn("Temporary document file {} still exists, indicating that a previous execution did not terminate cleanly.  Not storing documents.", (Object)documentTempFile.getAbsoluteFile());
            return false;
        }
        documentTempFile.getParentFile().mkdirs();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(documentTempFile));){
            for (Map.Entry e : formattedDocuments.entrySet()) {
                bw.write((String)e.getKey() + "\n");
                for (String s : (SortedSet)e.getValue()) {
                    bw.write(" " + s + "\n");
                }
            }
            documentFile.delete();
            documentTempFile.renameTo(documentFile);
        }
        catch (IOException e) {
            log.warn("Unable to write {}. Not storing documents.", (Object)documentFile.getAbsolutePath(), (Object)e);
            return false;
        }
        return true;
    }

    public Set<T> retrieve(File documentFile) {
        return this.retrieve(documentFile, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<T> retrieve(File documentFile, String prefix) {
        HashSet<Document> result = new HashSet<Document>();
        if (!documentFile.exists()) {
            return result;
        }
        try (LineNumberReader lnr = new LineNumberReader(new BufferedReader(new FileReader(documentFile)));){
            String line;
            String formattedString0 = null;
            while ((line = lnr.readLine()) != null) {
                if (!line.startsWith(" ")) {
                    formattedString0 = line;
                    continue;
                }
                if (formattedString0 == null) {
                    log.warn("First line in {} must not start with a space. Not retrieving any previously stored documents.", (Object)documentFile.getAbsolutePath());
                    Set<T> set = null;
                    return set;
                }
                if (prefix.length() > formattedString0.length() && !(formattedString0 + line.substring(1)).startsWith(prefix) || prefix.length() > 0 && !formattedString0.startsWith(prefix)) continue;
                Document document = (Document)this.clazz.newInstance();
                if (!document.parse(new String[]{formattedString0, line.substring(1)})) {
                    log.warn("Unable to read line {} from {}. Not retrieving any previously stored documents.", (Object)lnr.getLineNumber(), (Object)documentFile.getAbsolutePath());
                    Set<T> set = null;
                    return set;
                }
                result.add(document);
            }
            return result;
        }
        catch (IOException e) {
            log.warn("Unable to read {}. Not retrieving any previously stored documents.", (Object)documentFile.getAbsolutePath(), (Object)e);
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.warn("Unable to read {}. Cannot instantiate document object.", (Object)documentFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }
}

