/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import org.torproject.metrics.web.AnyServlet;
import org.torproject.metrics.web.Category;
import org.torproject.metrics.web.ContentProvider;
import org.torproject.metrics.web.Metric;
import org.torproject.metrics.web.News;

public abstract class MetricServlet
extends AnyServlet {
    protected List<Metric> metrics;
    protected Map<String, Set<String>> idsByType = new HashMap<String, Set<String>>();
    protected Map<String, String> descriptions = new HashMap<String, String>();
    protected Map<String, String> titles = new HashMap<String, String>();
    protected Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    protected Map<String, String[]> tableHeaders = new HashMap<String, String[]>();
    protected Map<String, String[]> tableCellFormats = new HashMap<String, String[]>();
    protected Map<String, Category> categoriesById = new HashMap<String, Category>();
    protected Set<String> includeRelatedEvents = new HashSet<String>();
    protected List<News> sortedEvents = new ArrayList<News>();

    @Override
    public void init() throws ServletException {
        super.init();
        this.metrics = ContentProvider.getInstance().getMetricsList();
        for (Metric metric : this.metrics) {
            String id = metric.getId();
            String title = metric.getTitle();
            String type = metric.getType();
            if (!this.idsByType.containsKey(type)) {
                this.idsByType.put(type, new HashSet());
            }
            this.idsByType.get(type).add(id);
            this.titles.put(id, title);
            this.descriptions.put(id, metric.getDescription());
            if (metric.getParameters() != null) {
                this.parameters.put(id, Arrays.asList(metric.getParameters()));
            }
            if (metric.getTableHeaders() != null) {
                this.tableHeaders.put(id, metric.getTableHeaders());
            }
            if (metric.getTableCellFormats() != null) {
                this.tableCellFormats.put(id, metric.getTableCellFormats());
            }
            if (!metric.getIncludeRelatedEvents()) continue;
            this.includeRelatedEvents.add(id);
        }
        for (Category category : ContentProvider.getInstance().getCategoriesList()) {
            for (String id : category.getMetrics()) {
                this.categoriesById.put(id, category);
            }
        }
        this.sortedEvents.addAll(ContentProvider.getInstance().getNewsList());
        Collections.sort(this.sortedEvents, (o1, o2) -> o2.getStart().compareTo(o1.getStart()));
    }
}

