/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.torproject.descriptor.index.DirectoryNode;
import org.torproject.descriptor.index.FileNode;
import org.torproject.descriptor.index.IndexNode;

public class DirectoryListing
extends HashMap<String, List<String[]>>
implements Map<String, List<String[]>> {
    private IndexNode index;

    DirectoryListing(IndexNode index) {
        this.index = index;
        this.extractDirectoryListings();
    }

    private void extractDirectoryListings() {
        HashMap<DirectoryNode, String> directoryNodes = new HashMap<DirectoryNode, String>();
        this.put("/collector/", this.formatTableEntries("", "/", this.index.directories, this.index.files));
        for (DirectoryNode directory : this.index.directories) {
            directoryNodes.put(directory, "/");
        }
        while (!directoryNodes.isEmpty()) {
            DirectoryNode currentDirectoryNode = (DirectoryNode)directoryNodes.keySet().iterator().next();
            String parentPath = (String)directoryNodes.remove(currentDirectoryNode);
            if (null != currentDirectoryNode.directories) {
                for (DirectoryNode subDirectoryNode : currentDirectoryNode.directories) {
                    directoryNodes.put(subDirectoryNode, String.format("%s%s/", parentPath, currentDirectoryNode.path));
                }
            }
            this.put(String.format("/collector%s%s/", parentPath, currentDirectoryNode.path), this.formatTableEntries(parentPath, currentDirectoryNode.path + "/", currentDirectoryNode.directories, currentDirectoryNode.files));
        }
    }

    private List<String[]> formatTableEntries(String parentPath, String path, SortedSet<DirectoryNode> directories, SortedSet<FileNode> files) {
        ArrayList<String[]> tableEntries = new ArrayList<String[]>();
        tableEntries.add(new String[]{"Parent Directory", String.format("/collector%s", parentPath.isEmpty() ? ".html" : parentPath), "", ""});
        if (null != directories) {
            for (DirectoryNode subDirectoryNode : directories) {
                tableEntries.add(new String[]{subDirectoryNode.path, String.format("/collector%s%s%s/", parentPath, path, subDirectoryNode.path), "", ""});
            }
        }
        if (null != files) {
            for (FileNode fileNode : new TreeSet<FileNode>(files).descendingSet()) {
                tableEntries.add(new String[]{fileNode.path, String.format("%s%s%s%s", this.index.path, parentPath, path, fileNode.path), fileNode.lastModified, DirectoryListing.formatBytes(fileNode.size)});
            }
        }
        return tableEntries;
    }

    static String formatBytes(long bytes) {
        if (bytes < 1024L) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(1024.0));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format(Locale.US, "%.1f %siB", (double)bytes / Math.pow(1024.0, exp), Character.valueOf(pre));
    }
}

