/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.util.PGbytea;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.ServerDescriptor;

public final class RelayDescriptorDatabaseImporter {
    private final long autoCommitCount = 500L;
    private int rdsCount = 0;
    private int resCount = 0;
    private int rhsCount = 0;
    private int rrsCount = 0;
    private int rcsCount = 0;
    private int rvsCount = 0;
    private int rqsCount = 0;
    private Connection conn;
    private PreparedStatement psSs;
    private PreparedStatement psDs;
    private PreparedStatement psCs;
    private Set<Long> scheduledUpdates;
    private PreparedStatement psU;
    private PreparedStatement psR;
    private PreparedStatement psD;
    private CallableStatement csH;
    private PreparedStatement psC;
    private Logger logger;
    private String rawFilesDirectory;
    private BufferedWriter statusentryOut;
    private BufferedWriter descriptorOut;
    private BufferedWriter bwhistOut;
    private BufferedWriter consensusOut;
    private SimpleDateFormat dateTimeFormat;
    private long lastCheckedStatusEntries;
    private Set<String> insertedStatusEntries = new HashSet<String>();
    private boolean importIntoDatabase;
    private boolean writeRawImportFiles;
    private List<File> archivesDirectories;
    private File statsDirectory;
    private boolean keepImportHistory;

    public RelayDescriptorDatabaseImporter(String connectionUrl, String rawFilesDirectory, List<File> archivesDirectories, File statsDirectory, boolean keepImportHistory) {
        if (archivesDirectories == null || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        this.archivesDirectories = archivesDirectories;
        this.statsDirectory = statsDirectory;
        this.keepImportHistory = keepImportHistory;
        this.logger = Logger.getLogger(RelayDescriptorDatabaseImporter.class.getName());
        if (connectionUrl != null) {
            try {
                this.conn = DriverManager.getConnection(connectionUrl);
                this.conn.setAutoCommit(false);
                this.psSs = this.conn.prepareStatement("SELECT fingerprint FROM statusentry WHERE validafter = ?");
                this.psDs = this.conn.prepareStatement("SELECT COUNT(*) FROM descriptor WHERE descriptor = ?");
                this.psCs = this.conn.prepareStatement("SELECT COUNT(*) FROM consensus WHERE validafter = ?");
                this.psR = this.conn.prepareStatement("INSERT INTO statusentry (validafter, nickname, fingerprint, descriptor, published, address, orport, dirport, isauthority, isbadexit, isbaddirectory, isexit, isfast, isguard, ishsdir, isnamed, isstable, isrunning, isunnamed, isvalid, isv2dir, isv3dir, version, bandwidth, ports, rawdesc) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.psD = this.conn.prepareStatement("INSERT INTO descriptor (descriptor, nickname, address, orport, dirport, fingerprint, bandwidthavg, bandwidthburst, bandwidthobserved, platform, published, uptime, extrainfo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                this.csH = this.conn.prepareCall("{call insert_bwhist(?, ?, ?, ?, ?, ?)}");
                this.psC = this.conn.prepareStatement("INSERT INTO consensus (validafter) VALUES (?)");
                this.psU = this.conn.prepareStatement("INSERT INTO scheduled_updates (date) VALUES (?)");
                this.scheduledUpdates = new HashSet<Long>();
                this.importIntoDatabase = true;
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not connect to database or prepare statements.", e);
            }
        }
        if (rawFilesDirectory != null) {
            this.rawFilesDirectory = rawFilesDirectory;
            this.writeRawImportFiles = true;
        }
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    private void addDateToScheduledUpdates(long timestamp) throws SQLException {
        long dateMillis;
        if (!this.importIntoDatabase) {
            return;
        }
        try {
            dateMillis = this.dateTimeFormat.parse(this.dateTimeFormat.format(timestamp).substring(0, 10) + " 00:00:00").getTime();
        }
        catch (ParseException e) {
            this.logger.log(Level.WARNING, "Internal parsing error.", e);
            return;
        }
        if (!this.scheduledUpdates.contains(dateMillis)) {
            this.psU.setDate(1, new Date(dateMillis));
            this.psU.execute();
            this.scheduledUpdates.add(dateMillis);
        }
    }

    public void addStatusEntryContents(long validAfter, String nickname, String fingerprint, String descriptor, long published, String address, long orPort, long dirPort, SortedSet<String> flags, String version, long bandwidth, String ports, byte[] rawDescriptor) {
        if (this.importIntoDatabase) {
            try {
                this.addDateToScheduledUpdates(validAfter);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                Timestamp validAfterTimestamp = new Timestamp(validAfter);
                if (this.lastCheckedStatusEntries != validAfter) {
                    this.insertedStatusEntries.clear();
                    this.psSs.setTimestamp(1, validAfterTimestamp, cal);
                    ResultSet rs = this.psSs.executeQuery();
                    while (rs.next()) {
                        String insertedFingerprint = rs.getString(1);
                        this.insertedStatusEntries.add(insertedFingerprint);
                    }
                    rs.close();
                    this.lastCheckedStatusEntries = validAfter;
                }
                if (!this.insertedStatusEntries.contains(fingerprint)) {
                    this.psR.clearParameters();
                    this.psR.setTimestamp(1, validAfterTimestamp, cal);
                    this.psR.setString(2, nickname);
                    this.psR.setString(3, fingerprint);
                    this.psR.setString(4, descriptor);
                    this.psR.setTimestamp(5, new Timestamp(published), cal);
                    this.psR.setString(6, address);
                    this.psR.setLong(7, orPort);
                    this.psR.setLong(8, dirPort);
                    this.psR.setBoolean(9, flags.contains("Authority"));
                    this.psR.setBoolean(10, flags.contains("BadExit"));
                    this.psR.setBoolean(11, flags.contains("BadDirectory"));
                    this.psR.setBoolean(12, flags.contains("Exit"));
                    this.psR.setBoolean(13, flags.contains("Fast"));
                    this.psR.setBoolean(14, flags.contains("Guard"));
                    this.psR.setBoolean(15, flags.contains("HSDir"));
                    this.psR.setBoolean(16, flags.contains("Named"));
                    this.psR.setBoolean(17, flags.contains("Stable"));
                    this.psR.setBoolean(18, flags.contains("Running"));
                    this.psR.setBoolean(19, flags.contains("Unnamed"));
                    this.psR.setBoolean(20, flags.contains("Valid"));
                    this.psR.setBoolean(21, flags.contains("V2Dir"));
                    this.psR.setBoolean(22, flags.contains("V3Dir"));
                    this.psR.setString(23, version);
                    this.psR.setLong(24, bandwidth);
                    this.psR.setString(25, ports);
                    this.psR.setBytes(26, rawDescriptor);
                    this.psR.executeUpdate();
                    ++this.rrsCount;
                    if ((long)this.rrsCount % 500L == 0L) {
                        this.conn.commit();
                    }
                    this.insertedStatusEntries.add(fingerprint);
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not add network status consensus entry.  We won't make any further SQL requests in this execution.", e);
                this.importIntoDatabase = false;
            }
        }
        if (this.writeRawImportFiles) {
            try {
                if (this.statusentryOut == null) {
                    new File(this.rawFilesDirectory).mkdirs();
                    this.statusentryOut = new BufferedWriter(new FileWriter(this.rawFilesDirectory + "/statusentry.sql"));
                    this.statusentryOut.write(" COPY statusentry (validafter, nickname, fingerprint, descriptor, published, address, orport, dirport, isauthority, isbadExit, isbaddirectory, isexit, isfast, isguard, ishsdir, isnamed, isstable, isrunning, isunnamed, isvalid, isv2dir, isv3dir, version, bandwidth, ports, rawdesc) FROM stdin;\n");
                }
                this.statusentryOut.write(this.dateTimeFormat.format(validAfter) + "\t" + nickname + "\t" + fingerprint.toLowerCase() + "\t" + descriptor.toLowerCase() + "\t" + this.dateTimeFormat.format(published) + "\t" + address + "\t" + orPort + "\t" + dirPort + "\t" + (flags.contains("Authority") ? "t" : "f") + "\t" + (flags.contains("BadExit") ? "t" : "f") + "\t" + (flags.contains("BadDirectory") ? "t" : "f") + "\t" + (flags.contains("Exit") ? "t" : "f") + "\t" + (flags.contains("Fast") ? "t" : "f") + "\t" + (flags.contains("Guard") ? "t" : "f") + "\t" + (flags.contains("HSDir") ? "t" : "f") + "\t" + (flags.contains("Named") ? "t" : "f") + "\t" + (flags.contains("Stable") ? "t" : "f") + "\t" + (flags.contains("Running") ? "t" : "f") + "\t" + (flags.contains("Unnamed") ? "t" : "f") + "\t" + (flags.contains("Valid") ? "t" : "f") + "\t" + (flags.contains("V2Dir") ? "t" : "f") + "\t" + (flags.contains("V3Dir") ? "t" : "f") + "\t" + (version != null ? version : "\\N") + "\t" + (bandwidth >= 0L ? Long.valueOf(bandwidth) : "\\N") + "\t" + (ports != null ? ports : "\\N") + "\t");
                this.statusentryOut.write(PGbytea.toPGString(rawDescriptor).replaceAll("\\\\", "\\\\\\\\") + "\n");
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not write network status consensus entry to raw database import file.  We won't make any further attempts to write raw import files in this execution.", e);
                this.writeRawImportFiles = false;
            }
        }
    }

    public void addServerDescriptorContents(String descriptor, String nickname, String address, int orPort, int dirPort, String relayIdentifier, long bandwidthAvg, long bandwidthBurst, long bandwidthObserved, String platform, long published, Long uptime, String extraInfoDigest) {
        if (this.importIntoDatabase) {
            try {
                this.addDateToScheduledUpdates(published);
                this.addDateToScheduledUpdates(published + 86400000L);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                this.psDs.setString(1, descriptor);
                ResultSet rs = this.psDs.executeQuery();
                rs.next();
                if (rs.getInt(1) == 0) {
                    this.psD.clearParameters();
                    this.psD.setString(1, descriptor);
                    this.psD.setString(2, nickname);
                    this.psD.setString(3, address);
                    this.psD.setInt(4, orPort);
                    this.psD.setInt(5, dirPort);
                    this.psD.setString(6, relayIdentifier);
                    this.psD.setLong(7, bandwidthAvg);
                    this.psD.setLong(8, bandwidthBurst);
                    this.psD.setLong(9, bandwidthObserved);
                    this.psD.setString(10, new String(platform.getBytes(), StandardCharsets.US_ASCII).replaceAll("[^\\p{ASCII}]", ""));
                    this.psD.setTimestamp(11, new Timestamp(published), cal);
                    if (null != uptime) {
                        this.psD.setLong(12, uptime);
                    } else {
                        this.psD.setNull(12, -5);
                    }
                    this.psD.setString(13, extraInfoDigest);
                    this.psD.executeUpdate();
                    ++this.rdsCount;
                    if ((long)this.rdsCount % 500L == 0L) {
                        this.conn.commit();
                    }
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not add server descriptor.  We won't make any further SQL requests in this execution.", e);
                this.importIntoDatabase = false;
            }
        }
        if (this.writeRawImportFiles) {
            try {
                if (this.descriptorOut == null) {
                    new File(this.rawFilesDirectory).mkdirs();
                    this.descriptorOut = new BufferedWriter(new FileWriter(this.rawFilesDirectory + "/descriptor.sql"));
                    this.descriptorOut.write(" COPY descriptor (descriptor, nickname, address, orport, dirport, fingerprint, bandwidthavg, bandwidthburst, bandwidthobserved, platform, published, uptime, extrainfo) FROM stdin;\n");
                }
                this.descriptorOut.write(descriptor.toLowerCase() + "\t" + nickname + "\t" + address + "\t" + orPort + "\t" + dirPort + "\t" + relayIdentifier + "\t" + bandwidthAvg + "\t" + bandwidthBurst + "\t" + bandwidthObserved + "\t" + (platform != null && platform.length() > 0 ? new String(platform.getBytes(), StandardCharsets.US_ASCII) : "\\N") + "\t" + this.dateTimeFormat.format(published) + "\t" + (uptime >= 0L ? uptime : "\\N") + "\t" + (extraInfoDigest != null ? extraInfoDigest : "\\N") + "\n");
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not write server descriptor to raw database import file.  We won't make any further attempts to write raw import files in this execution.", e);
                this.writeRawImportFiles = false;
            }
        }
    }

    public void addExtraInfoDescriptorContents(String extraInfoDigest, String nickname, String fingerprint, long published, List<String> bandwidthHistoryLines) {
        if (!bandwidthHistoryLines.isEmpty()) {
            this.addBandwidthHistory(fingerprint.toLowerCase(), published, bandwidthHistoryLines);
        }
    }

    public void addBandwidthHistory(String fingerprint, long published, List<String> bandwidthHistoryStrings) {
        TreeSet historyLinesByDate = new TreeSet();
        for (String bandwidthHistoryString : bandwidthHistoryStrings) {
            long dateStart;
            long intervalEnd;
            long intervalLength;
            String[] parts = bandwidthHistoryString.split(" ");
            if (parts.length != 6) {
                this.logger.finer("Bandwidth history line does not have expected number of elements. Ignoring this line.");
                continue;
            }
            try {
                intervalLength = Long.parseLong(parts[3].substring(1));
            }
            catch (NumberFormatException e) {
                this.logger.fine("Bandwidth history line does not have valid interval length '" + parts[3] + " " + parts[4] + "'. Ignoring this line.");
                continue;
            }
            String[] values = parts[5].split(",");
            if (intervalLength % 900L != 0L) {
                this.logger.fine("Bandwidth history line does not contain multiples of 15-minute intervals. Ignoring this line.");
                continue;
            }
            if (intervalLength != 900L) {
                try {
                    long factor = intervalLength / 900L;
                    String[] newValues = new String[values.length * (int)factor];
                    for (int i = 0; i < newValues.length; ++i) {
                        newValues[i] = String.valueOf(Long.parseLong(values[i / (int)factor]) / factor);
                    }
                    values = newValues;
                    intervalLength = 900L;
                }
                catch (NumberFormatException e) {
                    this.logger.fine("Number format exception while parsing bandwidth history line. Ignoring this line.");
                    continue;
                }
            }
            String type = parts[0];
            String intervalEndTime = parts[1] + " " + parts[2];
            try {
                intervalEnd = this.dateTimeFormat.parse(intervalEndTime).getTime();
                dateStart = this.dateTimeFormat.parse(parts[1] + " 00:00:00").getTime();
            }
            catch (ParseException e) {
                this.logger.fine("Parse exception while parsing timestamp in bandwidth history line. Ignoring this line.");
                continue;
            }
            if (Math.abs(published - intervalEnd) > 604800000L) {
                this.logger.fine("Extra-info descriptor publication time " + this.dateTimeFormat.format(published) + " and last interval time " + intervalEndTime + " in " + type + " line differ by more than 7 days! Not adding this line!");
                continue;
            }
            long currentIntervalEnd = intervalEnd;
            StringBuilder sb = new StringBuilder();
            TreeSet<String> newHistoryLines = new TreeSet<String>();
            try {
                for (int i = values.length - 1; i >= -1; --i) {
                    if (i == -1 || currentIntervalEnd < dateStart) {
                        sb.insert(0, intervalEndTime + " " + type + " (" + intervalLength + " s) ");
                        sb.setLength(sb.length() - 1);
                        String historyLine = sb.toString();
                        newHistoryLines.add(historyLine);
                        sb = new StringBuilder();
                        dateStart -= 86400000L;
                        intervalEndTime = this.dateTimeFormat.format(currentIntervalEnd);
                    }
                    if (i != -1) {
                        Long.parseLong(values[i]);
                        sb.insert(0, values[i] + ",");
                        currentIntervalEnd -= intervalLength * 1000L;
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException e) {
                this.logger.fine("Number format exception while parsing bandwidth history line. Ignoring this line.");
                continue;
            }
            historyLinesByDate.addAll(newHistoryLines);
        }
        String lastDate = null;
        historyLinesByDate.add("EOL");
        long[] readArray = null;
        long[] writtenArray = null;
        long[] dirreadArray = null;
        long[] dirwrittenArray = null;
        int readOffset = 0;
        int writtenOffset = 0;
        int dirreadOffset = 0;
        int dirwrittenOffset = 0;
        for (String historyLine : historyLinesByDate) {
            String type;
            long lastIntervalTime;
            String[] parts = historyLine.split(" ");
            String currentDate = parts[0];
            if (lastDate != null && (historyLine.equals("EOL") || !currentDate.equals(lastDate))) {
                BigIntArray readIntArray = new BigIntArray(readArray, readOffset);
                BigIntArray writtenIntArray = new BigIntArray(writtenArray, writtenOffset);
                BigIntArray dirreadIntArray = new BigIntArray(dirreadArray, dirreadOffset);
                BigIntArray dirwrittenIntArray = new BigIntArray(dirwrittenArray, dirwrittenOffset);
                if (this.importIntoDatabase) {
                    try {
                        long dateMillis = this.dateTimeFormat.parse(lastDate + " 00:00:00").getTime();
                        this.addDateToScheduledUpdates(dateMillis);
                        this.csH.setString(1, fingerprint);
                        this.csH.setDate(2, new Date(dateMillis));
                        this.csH.setArray(3, readIntArray);
                        this.csH.setArray(4, writtenIntArray);
                        this.csH.setArray(5, dirreadIntArray);
                        this.csH.setArray(6, dirwrittenIntArray);
                        this.csH.addBatch();
                        ++this.rhsCount;
                        if ((long)this.rhsCount % 500L == 0L) {
                            this.csH.executeBatch();
                        }
                    }
                    catch (SQLException | ParseException e) {
                        this.logger.log(Level.WARNING, "Could not insert bandwidth history line into database.  We won't make any further SQL requests in this execution.", e);
                        this.importIntoDatabase = false;
                    }
                }
                if (this.writeRawImportFiles) {
                    try {
                        if (this.bwhistOut == null) {
                            new File(this.rawFilesDirectory).mkdirs();
                            this.bwhistOut = new BufferedWriter(new FileWriter(this.rawFilesDirectory + "/bwhist.sql"));
                        }
                        this.bwhistOut.write("SELECT insert_bwhist('" + fingerprint + "','" + lastDate + "','" + readIntArray.toString() + "','" + writtenIntArray.toString() + "','" + dirreadIntArray.toString() + "','" + dirwrittenIntArray.toString() + "');\n");
                    }
                    catch (IOException e) {
                        this.logger.log(Level.WARNING, "Could not write bandwidth history to raw database import file.  We won't make any further attempts to write raw import files in this execution.", e);
                        this.writeRawImportFiles = false;
                    }
                }
                dirwrittenArray = null;
                dirreadArray = null;
                writtenArray = null;
                readArray = null;
            }
            if (historyLine.equals("EOL")) break;
            try {
                lastIntervalTime = this.dateTimeFormat.parse(parts[0] + " " + parts[1]).getTime() - this.dateTimeFormat.parse(parts[0] + " 00:00:00").getTime();
            }
            catch (ParseException e) {
                continue;
            }
            String[] stringValues = parts[5].split(",");
            long[] longValues = new long[stringValues.length];
            for (int i = 0; i < longValues.length; ++i) {
                longValues[i] = Long.parseLong(stringValues[i]);
            }
            int offset = (int)(lastIntervalTime / 900000L) - longValues.length + 1;
            switch (type = parts[2]) {
                case "read-history": {
                    readArray = longValues;
                    readOffset = offset;
                    break;
                }
                case "write-history": {
                    writtenArray = longValues;
                    writtenOffset = offset;
                    break;
                }
                case "dirreq-read-history": {
                    dirreadArray = longValues;
                    dirreadOffset = offset;
                    break;
                }
                case "dirreq-write-history": {
                    dirwrittenArray = longValues;
                    dirwrittenOffset = offset;
                    break;
                }
            }
            lastDate = currentDate;
        }
    }

    public void addConsensus(long validAfter) {
        if (this.importIntoDatabase) {
            try {
                this.addDateToScheduledUpdates(validAfter);
                Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                Timestamp validAfterTimestamp = new Timestamp(validAfter);
                this.psCs.setTimestamp(1, validAfterTimestamp, cal);
                ResultSet rs = this.psCs.executeQuery();
                rs.next();
                if (rs.getInt(1) == 0) {
                    this.psC.clearParameters();
                    this.psC.setTimestamp(1, validAfterTimestamp, cal);
                    this.psC.executeUpdate();
                    ++this.rcsCount;
                    if ((long)this.rcsCount % 500L == 0L) {
                        this.conn.commit();
                    }
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not add network status consensus.  We won't make any further SQL requests in this execution.", e);
                this.importIntoDatabase = false;
            }
        }
        if (this.writeRawImportFiles) {
            try {
                if (this.consensusOut == null) {
                    new File(this.rawFilesDirectory).mkdirs();
                    this.consensusOut = new BufferedWriter(new FileWriter(this.rawFilesDirectory + "/consensus.sql"));
                    this.consensusOut.write(" COPY consensus (validafter) FROM stdin;\n");
                }
                String validAfterString = this.dateTimeFormat.format(validAfter);
                this.consensusOut.write(validAfterString + "\n");
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Could not write network status consensus to raw database import file.  We won't make any further attempts to write raw import files in this execution.", e);
                this.writeRawImportFiles = false;
            }
        }
    }

    public void importRelayDescriptors() {
        this.logger.fine("Importing files in directories " + this.archivesDirectories + "/...");
        if (!this.archivesDirectories.isEmpty()) {
            DescriptorReader reader = DescriptorSourceFactory.createDescriptorReader();
            reader.setMaxDescriptorsInQueue(10);
            File historyFile = new File(this.statsDirectory, "database-importer-relay-descriptor-history");
            if (this.keepImportHistory) {
                reader.setHistoryFile(historyFile);
            }
            for (Descriptor descriptor : reader.readDescriptors(this.archivesDirectories.toArray(new File[this.archivesDirectories.size()]))) {
                if (descriptor instanceof RelayNetworkStatusConsensus) {
                    this.addRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor);
                    continue;
                }
                if (descriptor instanceof ServerDescriptor) {
                    this.addServerDescriptor((ServerDescriptor)descriptor);
                    continue;
                }
                if (!(descriptor instanceof ExtraInfoDescriptor)) continue;
                this.addExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
            }
            if (this.keepImportHistory) {
                reader.saveHistoryFile(historyFile);
            }
        }
        this.logger.info("Finished importing relay descriptors.");
    }

    private void addRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) {
        for (NetworkStatusEntry statusEntry : consensus.getStatusEntries().values()) {
            this.addStatusEntryContents(consensus.getValidAfterMillis(), statusEntry.getNickname(), statusEntry.getFingerprint().toLowerCase(), statusEntry.getDescriptor().toLowerCase(), statusEntry.getPublishedMillis(), statusEntry.getAddress(), statusEntry.getOrPort(), statusEntry.getDirPort(), statusEntry.getFlags(), statusEntry.getVersion(), statusEntry.getBandwidth(), statusEntry.getPortList(), statusEntry.getStatusEntryBytes());
        }
        this.addConsensus(consensus.getValidAfterMillis());
    }

    private void addServerDescriptor(ServerDescriptor descriptor) {
        this.addServerDescriptorContents(descriptor.getDigestSha1Hex(), descriptor.getNickname(), descriptor.getAddress(), descriptor.getOrPort(), descriptor.getDirPort(), descriptor.getFingerprint(), descriptor.getBandwidthRate(), descriptor.getBandwidthBurst(), descriptor.getBandwidthObserved(), descriptor.getPlatform(), descriptor.getPublishedMillis(), descriptor.getUptime(), descriptor.getExtraInfoDigestSha1Hex());
    }

    private void addExtraInfoDescriptor(ExtraInfoDescriptor descriptor) {
        ArrayList<String> bandwidthHistoryLines = new ArrayList<String>();
        if (descriptor.getWriteHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getWriteHistory().getLine());
        }
        if (descriptor.getReadHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getReadHistory().getLine());
        }
        if (descriptor.getDirreqWriteHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getDirreqWriteHistory().getLine());
        }
        if (descriptor.getDirreqReadHistory() != null) {
            bandwidthHistoryLines.add(descriptor.getDirreqReadHistory().getLine());
        }
        this.addExtraInfoDescriptorContents(descriptor.getDigestSha1Hex(), descriptor.getNickname(), descriptor.getFingerprint().toLowerCase(), descriptor.getPublishedMillis(), bandwidthHistoryLines);
    }

    public void closeConnection() {
        this.logger.info(String.format("Finished importing relay descriptors: %d consensuses, %d network status entries, %d votes, %d server descriptors, %d extra-info descriptors, %d bandwidth history elements, and %d dirreq stats elements", this.rcsCount, this.rrsCount, this.rvsCount, this.rdsCount, this.resCount, this.rhsCount, this.rqsCount));
        if (this.importIntoDatabase) {
            try {
                for (long dateMillis : this.scheduledUpdates) {
                    this.psU.setDate(1, new Date(dateMillis));
                    this.psU.execute();
                }
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not add scheduled dates for the next refresh run.", e);
            }
        }
        if (this.conn != null) {
            try {
                this.csH.executeBatch();
                this.conn.commit();
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not commit final records to database", e);
            }
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Could not close database connection.", e);
            }
        }
        try {
            if (this.statusentryOut != null) {
                this.statusentryOut.write("\\.\n");
                this.statusentryOut.close();
            }
            if (this.descriptorOut != null) {
                this.descriptorOut.write("\\.\n");
                this.descriptorOut.close();
            }
            if (this.bwhistOut != null) {
                this.bwhistOut.write("\\.\n");
                this.bwhistOut.close();
            }
            if (this.consensusOut != null) {
                this.consensusOut.write("\\.\n");
                this.consensusOut.close();
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Could not close one or more raw database import files.", e);
        }
    }

    private static class BigIntArray
    implements Array {
        private final String stringValue;

        public BigIntArray(long[] array, int offset) {
            if (array == null) {
                this.stringValue = "[-1:-1]={0}";
            } else {
                StringBuilder sb = new StringBuilder("[" + offset + ":" + (offset + array.length - 1) + "]={");
                for (int i = 0; i < array.length; ++i) {
                    sb.append(i > 0 ? "," : "").append(array[i]);
                }
                sb.append('}');
                this.stringValue = sb.toString();
            }
        }

        public String toString() {
            return this.stringValue;
        }

        @Override
        public String getBaseTypeName() {
            return "int8";
        }

        @Override
        public void free() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray(long index, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray(long index, int count, Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getArray(Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getBaseType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet(long index, int count) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ResultSet getResultSet(Map<String, Class<?>> map) {
            throw new UnsupportedOperationException();
        }
    }
}

