/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.servers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.NetworkStatusEntry;

public class ConsensusStatsFileHandler {
    private File bridgeConsensusStatsRawFile;
    private SortedMap<String, String> bridgesRaw;
    private SortedMap<String, String> bridgesPerDay;
    private Logger logger;
    private int bridgeResultsAdded = 0;
    private String connectionUrl = null;
    private SimpleDateFormat dateTimeFormat;
    private File bridgesDir;
    private File statsDirectory;
    private boolean keepImportHistory;

    public ConsensusStatsFileHandler(String connectionUrl, File bridgesDir, File statsDirectory, boolean keepImportHistory) {
        if (bridgesDir == null || statsDirectory == null) {
            throw new IllegalArgumentException();
        }
        this.bridgesDir = bridgesDir;
        this.statsDirectory = statsDirectory;
        this.keepImportHistory = keepImportHistory;
        this.bridgesPerDay = new TreeMap<String, String>();
        this.bridgesRaw = new TreeMap<String, String>();
        this.bridgeConsensusStatsRawFile = new File("stats/bridge-consensus-stats-raw");
        this.connectionUrl = connectionUrl;
        this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.logger = Logger.getLogger(ConsensusStatsFileHandler.class.getName());
        if (this.bridgeConsensusStatsRawFile.exists()) {
            this.logger.fine("Reading file " + this.bridgeConsensusStatsRawFile.getAbsolutePath() + "...");
            try (BufferedReader br = new BufferedReader(new FileReader(this.bridgeConsensusStatsRawFile));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("date")) continue;
                    String[] parts = line.split(",");
                    if (parts.length < 2 || parts.length > 4) {
                        this.logger.warning("Corrupt line '" + line + "' in file " + this.bridgeConsensusStatsRawFile.getAbsolutePath() + "! Aborting to read this file!");
                        break;
                    }
                    String key = parts[0] + "," + (parts.length < 4 ? "Tonga" : parts[1]);
                    String value = null;
                    if (parts.length == 2) {
                        value = key + "," + parts[1] + ",0";
                    } else if (parts.length == 3) {
                        value = key + "," + parts[1] + "," + parts[2];
                    } else if (parts.length == 4) {
                        value = key + "," + parts[2] + "," + parts[3];
                    }
                    this.bridgesRaw.put(key, value);
                }
                this.logger.fine("Finished reading file " + this.bridgeConsensusStatsRawFile.getAbsolutePath() + ".");
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "Failed to read file " + this.bridgeConsensusStatsRawFile.getAbsolutePath() + "!", e);
            }
        }
    }

    public void addBridgeConsensusResults(long publishedMillis, String authorityNickname, int running, int runningEc2Bridges) {
        String publishedAuthority = this.dateTimeFormat.format(publishedMillis) + "," + authorityNickname;
        String line = publishedAuthority + "," + running + "," + runningEc2Bridges;
        if (!this.bridgesRaw.containsKey(publishedAuthority)) {
            this.logger.finer("Adding new bridge numbers: " + line);
            this.bridgesRaw.put(publishedAuthority, line);
            ++this.bridgeResultsAdded;
        } else if (!line.equals(this.bridgesRaw.get(publishedAuthority))) {
            this.logger.warning("The numbers of running bridges we were just given (" + line + ") are different from what we learned before (" + (String)this.bridgesRaw.get(publishedAuthority) + ")! Overwriting!");
            this.bridgesRaw.put(publishedAuthority, line);
        }
    }

    public void importSanitizedBridges() {
        if (this.bridgesDir.exists()) {
            this.logger.fine("Importing files in directory " + this.bridgesDir + "/...");
            DescriptorReader reader = DescriptorSourceFactory.createDescriptorReader();
            File historyFile = new File(this.statsDirectory, "consensus-stats-bridge-descriptor-history");
            if (this.keepImportHistory) {
                reader.setHistoryFile(historyFile);
            }
            for (Descriptor descriptor : reader.readDescriptors(this.bridgesDir)) {
                if (!(descriptor instanceof BridgeNetworkStatus)) continue;
                String descriptorFileName = descriptor.getDescriptorFile().getName();
                String authority = null;
                if (descriptorFileName.contains("4A0CCD2DDC7995083D73F5D667100C8A5831F16D")) {
                    authority = "Tonga";
                } else if (descriptorFileName.contains("1D8F3A91C37C5D1C4C19B1AD1D0CFBE8BF72D8E1")) {
                    authority = "Bifroest";
                }
                if (authority == null) {
                    this.logger.warning("Did not recognize the bridge authority that generated " + descriptorFileName + ".  Skipping.");
                    continue;
                }
                this.addBridgeNetworkStatus((BridgeNetworkStatus)descriptor, authority);
            }
            if (this.keepImportHistory) {
                reader.saveHistoryFile(historyFile);
            }
            this.logger.info("Finished importing bridge descriptors.");
        }
    }

    private void addBridgeNetworkStatus(BridgeNetworkStatus status, String authority) {
        int runningBridges = 0;
        int runningEc2Bridges = 0;
        for (NetworkStatusEntry statusEntry : status.getStatusEntries().values()) {
            if (!statusEntry.getFlags().contains("Running")) continue;
            ++runningBridges;
            if (!statusEntry.getNickname().startsWith("ec2bridge")) continue;
            ++runningEc2Bridges;
        }
        this.addBridgeConsensusResults(status.getPublishedMillis(), authority, runningBridges, runningEc2Bridges);
    }

    public void writeFiles() {
        int brunning;
        HashMap bridgesPerDayAndAuthority = new HashMap();
        for (String string : this.bridgesRaw.values()) {
            String[] parts = string.split(",");
            brunning = Integer.parseInt(parts[2]);
            if (brunning <= 0) continue;
            String date = string.substring(0, 10);
            if (!bridgesPerDayAndAuthority.containsKey(date)) {
                bridgesPerDayAndAuthority.put(date, new TreeMap());
            }
            String authority = parts[1];
            if (!((Map)bridgesPerDayAndAuthority.get(date)).containsKey(authority)) {
                ((Map)bridgesPerDayAndAuthority.get(date)).put(authority, new int[3]);
            }
            int[] bridges = (int[])((Map)bridgesPerDayAndAuthority.get(date)).get(authority);
            bridges[0] = bridges[0] + brunning;
            bridges[1] = bridges[1] + Integer.parseInt(parts[3]);
            bridges[2] = bridges[2] + 1;
        }
        for (Map.Entry entry : bridgesPerDayAndAuthority.entrySet()) {
            String date = (String)entry.getKey();
            brunning = 0;
            int brunningEc2 = 0;
            for (int[] perAuthority : ((Map)entry.getValue()).values()) {
                int n = perAuthority[2];
                if (n < 12) continue;
                brunning += perAuthority[0] / n;
                brunningEc2 += perAuthority[1] / n;
            }
            String line = "," + brunning + "," + brunningEc2;
            if (!this.bridgesPerDay.containsKey(date)) {
                this.logger.finer("Adding new average bridge numbers: " + (String)date + line);
                this.bridgesPerDay.put(date, line);
                continue;
            }
            if (line.equals(this.bridgesPerDay.get(date))) continue;
            this.logger.finer("Replacing existing average bridge numbers (" + (String)this.bridgesPerDay.get(date) + " with new numbers: " + line);
            this.bridgesPerDay.put(date, line);
        }
        this.logger.fine("Writing file " + this.bridgeConsensusStatsRawFile.getAbsolutePath() + "...");
        this.bridgeConsensusStatsRawFile.getParentFile().mkdirs();
        try {
            Throwable throwable = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(this.bridgeConsensusStatsRawFile));){
                bw.append("datetime,authority,brunning,brunningec2");
                bw.newLine();
                for (String line : this.bridgesRaw.values()) {
                    bw.append(line);
                    bw.newLine();
                }
                this.logger.fine("Finished writing file " + this.bridgeConsensusStatsRawFile.getAbsolutePath() + ".");
            }
            catch (Throwable date) {
                Throwable throwable2 = date;
                throw date;
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Failed to write file " + this.bridgeConsensusStatsRawFile.getAbsolutePath() + "!", e);
        }
        if (this.connectionUrl != null) {
            try {
                HashMap<String, String> insertRows = new HashMap<String, String>();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                insertRows.putAll(this.bridgesPerDay);
                Connection conn = DriverManager.getConnection(this.connectionUrl);
                conn.setAutoCommit(false);
                Statement statement = conn.createStatement();
                ResultSet rs = statement.executeQuery("SELECT date, avg_running, avg_running_ec2 FROM bridge_network_size");
                while (rs.next()) {
                    String date = rs.getDate(1).toString();
                    if (!insertRows.containsKey(date)) continue;
                    String insertRow = (String)insertRows.remove(date);
                    String[] stringArray = insertRow.substring(1).split(",");
                    long newAvgRunning = Long.parseLong(stringArray[0]);
                    long newAvgRunningEc2 = Long.parseLong(stringArray[1]);
                    long oldAvgRunning = rs.getLong(2);
                    long oldAvgRunningEc2 = rs.getLong(3);
                    if (newAvgRunning == oldAvgRunning && newAvgRunningEc2 == oldAvgRunningEc2) continue;
                    hashMap.put(date, insertRow);
                }
                rs.close();
                PreparedStatement psU = conn.prepareStatement("UPDATE bridge_network_size SET avg_running = ?, avg_running_ec2 = ? WHERE date = ?");
                for (Map.Entry entry : hashMap.entrySet()) {
                    Date date = Date.valueOf((String)entry.getKey());
                    String[] parts = ((String)entry.getValue()).substring(1).split(",");
                    long avgRunning = Long.parseLong(parts[0]);
                    long avgRunningEc2 = Long.parseLong(parts[1]);
                    psU.clearParameters();
                    psU.setLong(1, avgRunning);
                    psU.setLong(2, avgRunningEc2);
                    psU.setDate(3, date);
                    psU.executeUpdate();
                }
                PreparedStatement psI = conn.prepareStatement("INSERT INTO bridge_network_size (avg_running, avg_running_ec2, date) VALUES (?, ?, ?)");
                for (Map.Entry e : insertRows.entrySet()) {
                    Date date = Date.valueOf((String)e.getKey());
                    String[] parts = ((String)e.getValue()).substring(1).split(",");
                    long avgRunning = Long.parseLong(parts[0]);
                    long avgRunningEc2 = Long.parseLong(parts[1]);
                    psI.clearParameters();
                    psI.setLong(1, avgRunning);
                    psI.setLong(2, avgRunningEc2);
                    psI.setDate(3, date);
                    psI.executeUpdate();
                }
                conn.commit();
                conn.close();
            }
            catch (SQLException e) {
                this.logger.log(Level.WARNING, "Failed to add average bridge numbers to database.", e);
            }
        }
        StringBuilder dumpStats = new StringBuilder("Finished writing statistics on bridge network statuses to disk.\nAdded " + this.bridgeResultsAdded + " bridge network status(es) in this execution.");
        long l = System.currentTimeMillis();
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (this.bridgesRaw.isEmpty()) {
            dumpStats.append("\nNo bridge status known yet.");
        } else {
            dumpStats.append("\nLast known bridge status was published ").append(this.bridgesRaw.lastKey()).append(".");
            try {
                if (l - 21600000L > dateTimeFormat.parse(this.bridgesRaw.lastKey()).getTime()) {
                    this.logger.warning("Last known bridge status is more than 6 hours old: " + this.bridgesRaw.lastKey());
                }
            }
            catch (ParseException e) {
                this.logger.warning("Can't parse the timestamp? Reason: " + e);
            }
        }
        this.logger.info(dumpStats.toString());
    }
}

