/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.ipv6servers;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.stream.Collectors;

class OutputLine {
    LocalDate date;
    String server;
    String guard;
    String exit;
    String announced;
    String exiting;
    String reachable;
    long count;
    Long advertisedBandwidth;

    OutputLine() {
    }

    static String columnHeadersDelimitedBy(String delimiter) {
        return Arrays.stream(Column.values()).map(c -> c.toString().toLowerCase()).collect(Collectors.joining(delimiter));
    }

    public String toString() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s", this.date, this.server, OutputLine.emptyNull(this.guard), OutputLine.emptyNull(this.exit), OutputLine.emptyNull(this.announced), OutputLine.emptyNull(this.exiting), OutputLine.emptyNull(this.reachable), OutputLine.emptyNull(this.count), OutputLine.emptyNull(this.advertisedBandwidth));
    }

    private static String emptyNull(Object text) {
        return null == text ? "" : text.toString();
    }

    static enum Column {
        VALID_AFTER_DATE,
        SERVER,
        GUARD_RELAY,
        EXIT_RELAY,
        ANNOUNCED_IPV6,
        EXITING_IPV6_RELAY,
        REACHABLE_IPV6_RELAY,
        SERVER_COUNT_SUM_AVG,
        ADVERTISED_BANDWIDTH_BYTES_SUM_AVG;

    }
}

