/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.ipv6servers;

import java.io.File;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.RelayNetworkStatusConsensus;
import org.torproject.descriptor.ServerDescriptor;
import org.torproject.metrics.stats.ipv6servers.Configuration;
import org.torproject.metrics.stats.ipv6servers.Database;
import org.torproject.metrics.stats.ipv6servers.OutputLine;
import org.torproject.metrics.stats.ipv6servers.Parser;
import org.torproject.metrics.stats.ipv6servers.Writer;

public class Main {
    private static Logger log = LoggerFactory.getLogger(Main.class);
    private static String[][] paths = new String[][]{{"recent", "relay-descriptors", "consensuses"}, {"recent", "relay-descriptors", "server-descriptors"}, {"recent", "bridge-descriptors", "statuses"}, {"recent", "bridge-descriptors", "server-descriptors"}, {"archive", "relay-descriptors", "consensuses"}, {"archive", "relay-descriptors", "server-descriptors"}, {"archive", "bridge-descriptors", "statuses"}, {"archive", "bridge-descriptors", "server-descriptors"}};

    public static void main(String[] args) throws Exception {
        log.info("Starting ipv6servers module.");
        log.info("Reading descriptors and inserting relevant parts into the database.");
        DescriptorReader reader = DescriptorSourceFactory.createDescriptorReader();
        File historyFile = new File(Configuration.history);
        reader.setHistoryFile(historyFile);
        Parser parser = new Parser();
        try (Database database = new Database(Configuration.database);){
            try {
                for (Descriptor descriptor : reader.readDescriptors((File[])Arrays.stream(paths).map(path -> Paths.get(Configuration.descriptors, path).toFile()).toArray(File[]::new))) {
                    if (descriptor instanceof ServerDescriptor) {
                        database.insertServerDescriptor(parser.parseServerDescriptor((ServerDescriptor)descriptor));
                        continue;
                    }
                    if (descriptor instanceof RelayNetworkStatusConsensus) {
                        database.insertStatus(parser.parseRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor));
                        continue;
                    }
                    if (descriptor instanceof BridgeNetworkStatus) {
                        database.insertStatus(parser.parseBridgeNetworkStatus((BridgeNetworkStatus)descriptor));
                        continue;
                    }
                    log.debug("Skipping unknown descriptor of type {}.", (Object)descriptor.getClass());
                }
                log.info("Aggregating database entries.");
                database.aggregate();
                log.info("Committing all updated parts in the database.");
                database.commit();
            }
            catch (SQLException sqle) {
                log.error("Cannot recover from SQL exception while inserting or aggregating data. Rolling back and exiting.", sqle);
                database.rollback();
                if (database != null) {
                    if (var5_6 != null) {
                        try {
                            database.close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        database.close();
                    }
                }
                return;
            }
            reader.saveHistoryFile(historyFile);
            log.info("Querying aggregated statistics from the database.");
            Iterable<OutputLine> output = database.queryServersIpv6();
            log.info("Writing aggregated statistics to {}.", (Object)Configuration.output);
            if (null != output) {
                new Writer().write(Paths.get(Configuration.output, new String[0]), output);
            }
            log.info("Terminating ipv6servers module.");
        }
        catch (SQLException sqle) {
            log.error("Cannot recover from SQL exception while querying. Not writing output file.", sqle);
        }
    }
}

