/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import org.torproject.metrics.stats.hidserv.DateTimeHelper;
import org.torproject.metrics.stats.hidserv.Document;

public class ReportedHidServStats
implements Document {
    private String fingerprint;
    private long statsEndMillis;
    private long statsIntervalSeconds;
    private long rendRelayedCells;
    private long dirOnionsSeen;

    public String getFingerprint() {
        return this.fingerprint;
    }

    public long getStatsEndMillis() {
        return this.statsEndMillis;
    }

    public void setStatsIntervalSeconds(long statsIntervalSeconds) {
        this.statsIntervalSeconds = statsIntervalSeconds;
    }

    public long getStatsIntervalSeconds() {
        return this.statsIntervalSeconds;
    }

    public void setRendRelayedCells(long rendRelayedCells) {
        this.rendRelayedCells = rendRelayedCells;
    }

    public long getRendRelayedCells() {
        return this.rendRelayedCells;
    }

    public void setDirOnionsSeen(long dirOnionsSeen) {
        this.dirOnionsSeen = dirOnionsSeen;
    }

    public long getDirOnionsSeen() {
        return this.dirOnionsSeen;
    }

    public ReportedHidServStats(String fingerprint, long statsEndMillis) {
        this.fingerprint = fingerprint;
        this.statsEndMillis = statsEndMillis;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ReportedHidServStats)) {
            return false;
        }
        ReportedHidServStats other = (ReportedHidServStats)otherObject;
        return this.fingerprint.equals(other.fingerprint) && this.statsEndMillis == other.statsEndMillis;
    }

    public int hashCode() {
        return this.fingerprint.hashCode() + (int)this.statsEndMillis;
    }

    @Override
    public String[] format() {
        String first = this.fingerprint;
        String second = String.format("%s,%d,%d,%d", DateTimeHelper.format(this.statsEndMillis), this.statsIntervalSeconds, this.rendRelayedCells, this.dirOnionsSeen);
        return new String[]{first, second};
    }

    ReportedHidServStats() {
    }

    @Override
    public boolean parse(String[] formattedStrings) {
        if (formattedStrings.length != 2) {
            System.err.printf("Invalid number of formatted strings.  Skipping.%n", new Object[0]);
            return false;
        }
        String[] secondParts = formattedStrings[1].split(",", 4);
        if (secondParts.length != 4) {
            return false;
        }
        long statsEndMillis = DateTimeHelper.parse(secondParts[0]);
        if (statsEndMillis == -1L) {
            return false;
        }
        long statsIntervalSeconds = -1L;
        long rendRelayedCells = -1L;
        long dirOnionsSeen = -1L;
        try {
            statsIntervalSeconds = Long.parseLong(secondParts[1]);
            rendRelayedCells = Long.parseLong(secondParts[2]);
            dirOnionsSeen = Long.parseLong(secondParts[3]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.fingerprint = formattedStrings[0];
        this.statsEndMillis = statsEndMillis;
        this.statsIntervalSeconds = statsIntervalSeconds;
        this.rendRelayedCells = rendRelayedCells;
        this.dirOnionsSeen = dirOnionsSeen;
        return true;
    }
}

