/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import org.torproject.metrics.stats.hidserv.DateTimeHelper;
import org.torproject.metrics.stats.hidserv.Document;

public class ExtrapolatedHidServStats
implements Document {
    private long statsDateMillis;
    private String fingerprint;
    private double extrapolatedRendRelayedCells;
    private double fractionRendRelayedCells;
    private double extrapolatedDirOnionsSeen;
    private double fractionDirOnionsSeen;

    public long getStatsDateMillis() {
        return this.statsDateMillis;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setExtrapolatedRendRelayedCells(double extrapolatedRendRelayedCells) {
        this.extrapolatedRendRelayedCells = extrapolatedRendRelayedCells;
    }

    public double getExtrapolatedRendRelayedCells() {
        return this.extrapolatedRendRelayedCells;
    }

    public void setFractionRendRelayedCells(double fractionRendRelayedCells) {
        this.fractionRendRelayedCells = fractionRendRelayedCells;
    }

    public double getFractionRendRelayedCells() {
        return this.fractionRendRelayedCells;
    }

    public void setExtrapolatedDirOnionsSeen(double extrapolatedDirOnionsSeen) {
        this.extrapolatedDirOnionsSeen = extrapolatedDirOnionsSeen;
    }

    public double getExtrapolatedDirOnionsSeen() {
        return this.extrapolatedDirOnionsSeen;
    }

    public void setFractionDirOnionsSeen(double fractionDirOnionsSeen) {
        this.fractionDirOnionsSeen = fractionDirOnionsSeen;
    }

    public double getFractionDirOnionsSeen() {
        return this.fractionDirOnionsSeen;
    }

    public ExtrapolatedHidServStats(long statsDateMillis, String fingerprint) {
        this.statsDateMillis = statsDateMillis;
        this.fingerprint = fingerprint;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ExtrapolatedHidServStats)) {
            return false;
        }
        ExtrapolatedHidServStats other = (ExtrapolatedHidServStats)otherObject;
        return this.fingerprint.equals(other.fingerprint) && this.statsDateMillis == other.statsDateMillis;
    }

    public int hashCode() {
        return this.fingerprint.hashCode() + (int)this.statsDateMillis;
    }

    @Override
    public String[] format() {
        String first = DateTimeHelper.format(this.statsDateMillis, "yyyy-MM-dd");
        String second = this.fingerprint + (this.fractionRendRelayedCells == 0.0 ? ",," : String.format(",%.0f,%f", this.extrapolatedRendRelayedCells, this.fractionRendRelayedCells)) + (this.fractionDirOnionsSeen == 0.0 ? ",," : String.format(",%.0f,%f", this.extrapolatedDirOnionsSeen, this.fractionDirOnionsSeen));
        return new String[]{first, second};
    }

    ExtrapolatedHidServStats() {
    }

    @Override
    public boolean parse(String[] formattedStrings) {
        if (formattedStrings.length != 2) {
            System.err.printf("Invalid number of formatted strings.  Skipping.%n", new Object[0]);
            return false;
        }
        long statsDateMillis = DateTimeHelper.parse(formattedStrings[0], "yyyy-MM-dd");
        String[] secondParts = formattedStrings[1].split(",", 5);
        if (secondParts.length != 5) {
            System.err.printf("Invalid number of comma-separated values.  Skipping.%n", new Object[0]);
            return false;
        }
        String fingerprint = secondParts[0];
        double extrapolatedRendRelayedCells = 0.0;
        double fractionRendRelayedCells = 0.0;
        double extrapolatedDirOnionsSeen = 0.0;
        double fractionDirOnionsSeen = 0.0;
        try {
            extrapolatedRendRelayedCells = secondParts[1].equals("") ? 0.0 : Double.parseDouble(secondParts[1]);
            fractionRendRelayedCells = secondParts[2].equals("") ? 0.0 : Double.parseDouble(secondParts[2]);
            extrapolatedDirOnionsSeen = secondParts[3].equals("") ? 0.0 : Double.parseDouble(secondParts[3]);
            fractionDirOnionsSeen = secondParts[4].equals("") ? 0.0 : Double.parseDouble(secondParts[4]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        this.statsDateMillis = statsDateMillis;
        this.fingerprint = fingerprint;
        this.extrapolatedRendRelayedCells = extrapolatedRendRelayedCells;
        this.fractionRendRelayedCells = fractionRendRelayedCells;
        this.extrapolatedDirOnionsSeen = extrapolatedDirOnionsSeen;
        this.fractionDirOnionsSeen = fractionDirOnionsSeen;
        return true;
    }
}

