/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.torproject.metrics.stats.hidserv.Document;

public class DocumentStore<T extends Document> {
    private Class<T> clazz;

    DocumentStore(Class<T> clazz) {
        this.clazz = clazz;
    }

    public boolean store(File documentFile, Set<T> documentsToStore) {
        Set<T> retrievedDocuments = this.retrieve(documentFile);
        if (retrievedDocuments == null) {
            System.err.printf("Unable to read and update %s.  Not storing documents.%n", documentFile.getAbsoluteFile());
            return false;
        }
        retrievedDocuments.addAll(documentsToStore);
        TreeMap formattedDocuments = new TreeMap();
        for (Document retrieveDocument : retrievedDocuments) {
            String[] formattedDocument = retrieveDocument.format();
            if (!formattedDocuments.containsKey(formattedDocument[0])) {
                formattedDocuments.put(formattedDocument[0], new TreeSet());
            }
            ((SortedSet)formattedDocuments.get(formattedDocument[0])).add(formattedDocument[1]);
        }
        File documentTempFile = new File(documentFile.getAbsoluteFile() + ".tmp");
        if (documentTempFile.exists()) {
            System.err.printf("Temporary document file %s still exists, indicating that a previous execution did not terminate cleanly.  Not storing documents.%n", documentTempFile.getAbsoluteFile());
            return false;
        }
        documentTempFile.getParentFile().mkdirs();
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(documentTempFile));){
            for (Map.Entry e : formattedDocuments.entrySet()) {
                bw.write((String)e.getKey() + "\n");
                for (String s : (SortedSet)e.getValue()) {
                    bw.write(" " + s + "\n");
                }
            }
            documentFile.delete();
            documentTempFile.renameTo(documentFile);
        }
        catch (IOException e) {
            System.err.printf("Unable to write %s.  Not storing documents.%n", documentFile.getAbsolutePath());
            return false;
        }
        return true;
    }

    public Set<T> retrieve(File documentFile) {
        return this.retrieve(documentFile, "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<T> retrieve(File documentFile, String prefix) {
        HashSet<Document> result = new HashSet<Document>();
        if (!documentFile.exists()) {
            return result;
        }
        try (LineNumberReader lnr = new LineNumberReader(new BufferedReader(new FileReader(documentFile)));){
            String line;
            String formattedString0 = null;
            while ((line = lnr.readLine()) != null) {
                if (!line.startsWith(" ")) {
                    formattedString0 = line;
                    continue;
                }
                if (formattedString0 == null) {
                    System.err.printf("First line in %s must not start with a space.  Not retrieving any previously stored documents.%n", documentFile.getAbsolutePath());
                    Set<T> set = null;
                    return set;
                }
                if (prefix.length() > formattedString0.length() && !(formattedString0 + line.substring(1)).startsWith(prefix) || prefix.length() > 0 && !formattedString0.startsWith(prefix)) continue;
                Document document = (Document)this.clazz.newInstance();
                if (!document.parse(new String[]{formattedString0, line.substring(1)})) {
                    System.err.printf("Unable to read line %d from %s.  Not retrieving any previously stored documents.%n", lnr.getLineNumber(), documentFile.getAbsolutePath());
                    Set<T> set = null;
                    return set;
                }
                result.add(document);
            }
            return result;
        }
        catch (IOException e) {
            System.err.printf("Unable to read %s.  Not retrieving any previously stored documents.%n", documentFile.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException | InstantiationException e) {
            System.err.printf("Unable to read %s.  Cannot instantiate document object.%n", documentFile.getAbsolutePath());
            e.printStackTrace();
            return null;
        }
    }
}

