/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.hidserv;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.torproject.metrics.stats.hidserv.DateTimeHelper;
import org.torproject.metrics.stats.hidserv.Document;

public class ComputedNetworkFractions
implements Document {
    private String fingerprint;
    private long validAfterMillis;
    private double fractionRendRelayedCells;
    private double fractionDirOnionsSeen;
    private static Map<Long, String> previouslyFormattedDates = Collections.synchronizedMap(new HashMap());
    private static Map<String, Long> previouslyParsedDates = Collections.synchronizedMap(new HashMap());

    public String getFingerprint() {
        return this.fingerprint;
    }

    public long getValidAfterMillis() {
        return this.validAfterMillis;
    }

    public void setFractionRendRelayedCells(double fractionRendRelayedCells) {
        this.fractionRendRelayedCells = fractionRendRelayedCells;
    }

    public double getFractionRendRelayedCells() {
        return this.fractionRendRelayedCells;
    }

    public void setFractionDirOnionsSeen(double fractionDirOnionsSeen) {
        this.fractionDirOnionsSeen = fractionDirOnionsSeen;
    }

    public double getFractionDirOnionsSeen() {
        return this.fractionDirOnionsSeen;
    }

    public ComputedNetworkFractions(String fingerprint, long validAfterMillis) {
        this.fingerprint = fingerprint;
        this.validAfterMillis = validAfterMillis;
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof ComputedNetworkFractions)) {
            return false;
        }
        ComputedNetworkFractions other = (ComputedNetworkFractions)otherObject;
        return this.fingerprint.equals(other.fingerprint) && this.validAfterMillis == other.validAfterMillis;
    }

    public int hashCode() {
        return this.fingerprint.hashCode() + (int)this.validAfterMillis;
    }

    @Override
    public String[] format() {
        String validAfterDate;
        long validAfterDateMillis = this.validAfterMillis / 86400000L * 86400000L;
        if (previouslyFormattedDates.containsKey(validAfterDateMillis)) {
            validAfterDate = previouslyFormattedDates.get(validAfterDateMillis);
        } else {
            validAfterDate = DateTimeHelper.format(validAfterDateMillis, "yyyy-MM-dd");
            previouslyFormattedDates.put(validAfterDateMillis, validAfterDate);
        }
        long validAfterHourMillis = this.validAfterMillis % 86400000L;
        String validAfterHour = String.format("%02d", validAfterHourMillis / 3600000L);
        String first = String.format("%s,%s", this.fingerprint, validAfterDate);
        String second = validAfterHour + (this.fractionRendRelayedCells == 0.0 ? "," : String.format(",%f", this.fractionRendRelayedCells)) + (this.fractionDirOnionsSeen == 0.0 ? "," : String.format(",%f", this.fractionDirOnionsSeen));
        return new String[]{first, second};
    }

    ComputedNetworkFractions() {
    }

    @Override
    public boolean parse(String[] formattedStrings) {
        long validAfterDateMillis;
        if (formattedStrings.length != 2) {
            System.err.printf("Invalid number of formatted strings.  Skipping.%n", new Object[0]);
            return false;
        }
        String[] firstParts = formattedStrings[0].split(",", 2);
        if (firstParts.length != 2) {
            System.err.printf("Invalid number of comma-separated values.  Skipping.%n", new Object[0]);
            return false;
        }
        String fingerprint = firstParts[0];
        String[] secondParts = formattedStrings[1].split(",", 3);
        if (secondParts.length != 3) {
            System.err.printf("Invalid number of comma-separated values.  Skipping.%n", new Object[0]);
            return false;
        }
        String validAfterDate = firstParts[1];
        String validAfterHour = secondParts[0];
        if (previouslyParsedDates.containsKey(validAfterDate)) {
            validAfterDateMillis = previouslyParsedDates.get(validAfterDate);
        } else {
            validAfterDateMillis = DateTimeHelper.parse(validAfterDate, "yyyy-MM-dd");
            previouslyParsedDates.put(validAfterDate, validAfterDateMillis);
        }
        long validAfterTimeMillis = Long.parseLong(validAfterHour) * 3600000L;
        if (validAfterDateMillis == -1L || validAfterTimeMillis < 0L || validAfterTimeMillis >= 86400000L) {
            System.err.printf("Invalid date/hour format.  Skipping.%n", new Object[0]);
            return false;
        }
        long validAfterMillis = validAfterDateMillis + validAfterTimeMillis;
        try {
            this.fingerprint = fingerprint;
            this.validAfterMillis = validAfterMillis;
            this.fractionRendRelayedCells = secondParts[1].equals("") ? 0.0 : Double.parseDouble(secondParts[1]);
            this.fractionDirOnionsSeen = secondParts[2].equals("") ? 0.0 : Double.parseDouble(secondParts[2]);
            return true;
        }
        catch (NumberFormatException e) {
            System.err.printf("Invalid number format.  Skipping.%n", new Object[0]);
            return false;
        }
    }
}

