/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.stats.clients;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.torproject.descriptor.BandwidthHistory;
import org.torproject.descriptor.BridgeNetworkStatus;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.descriptor.ExtraInfoDescriptor;
import org.torproject.descriptor.NetworkStatusEntry;
import org.torproject.descriptor.RelayNetworkStatusConsensus;

public class Main {
    private static boolean writeToSingleFile = true;
    private static boolean byStatsDateNotByDescHour = false;
    private static final long ONE_HOUR_MILLIS = 3600000L;
    private static final long ONE_DAY_MILLIS = 86400000L;
    private static final long ONE_WEEK_MILLIS = 604800000L;
    private static Map<String, BufferedWriter> openOutputFiles = new HashMap<String, BufferedWriter>();
    private static SimpleDateFormat dateTimeFormat = null;

    public static void main(String[] args) throws Exception {
        Main.parseArgs(args);
        Main.parseRelayDescriptors();
        Main.parseBridgeDescriptors();
        Main.closeOutputFiles();
    }

    private static void parseArgs(String[] args) {
        if (args.length == 0) {
            writeToSingleFile = true;
        } else if (args.length == 1 && args[0].equals("--stats-date")) {
            writeToSingleFile = false;
            byStatsDateNotByDescHour = true;
        } else if (args.length == 1 && args[0].equals("--desc-hour")) {
            writeToSingleFile = false;
            byStatsDateNotByDescHour = false;
        } else {
            System.err.println("Usage: java " + Main.class.getName() + " [ --stats-date | --desc-hour ]");
            System.exit(1);
        }
    }

    private static void parseRelayDescriptors() throws Exception {
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        File historyFile = new File("status/relay-descriptors");
        descriptorReader.setHistoryFile(historyFile);
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File("../../shared/in/recent/relay-descriptors/consensuses"), new File("../../shared/in/recent/relay-descriptors/extra-infos"), new File("../../shared/in/archive/relay-descriptors/consensuses"), new File("../../shared/in/archive/relay-descriptors/extra-infos"))) {
            if (descriptor instanceof ExtraInfoDescriptor) {
                Main.parseRelayExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
                continue;
            }
            if (!(descriptor instanceof RelayNetworkStatusConsensus)) continue;
            Main.parseRelayNetworkStatusConsensus((RelayNetworkStatusConsensus)descriptor);
        }
        descriptorReader.saveHistoryFile(historyFile);
    }

    private static void parseRelayExtraInfoDescriptor(ExtraInfoDescriptor descriptor) throws IOException {
        long publishedMillis = descriptor.getPublishedMillis();
        String fingerprint = descriptor.getFingerprint().toUpperCase();
        long dirreqStatsEndMillis = descriptor.getDirreqStatsEndMillis();
        long dirreqStatsIntervalLengthMillis = descriptor.getDirreqStatsIntervalLength() * 1000L;
        SortedMap<String, Integer> requests = descriptor.getDirreqV3Reqs();
        BandwidthHistory dirreqWriteHistory = descriptor.getDirreqWriteHistory();
        Main.parseRelayDirreqV3Reqs(fingerprint, publishedMillis, dirreqStatsEndMillis, dirreqStatsIntervalLengthMillis, requests);
        Main.parseRelayDirreqWriteHistory(fingerprint, publishedMillis, dirreqWriteHistory);
    }

    private static void parseRelayDirreqV3Reqs(String fingerprint, long publishedMillis, long dirreqStatsEndMillis, long dirreqStatsIntervalLengthMillis, SortedMap<String, Integer> requests) throws IOException {
        if (requests == null || publishedMillis - dirreqStatsEndMillis > 604800000L || dirreqStatsIntervalLengthMillis != 86400000L) {
            return;
        }
        long statsStartMillis = dirreqStatsEndMillis - dirreqStatsIntervalLengthMillis;
        long utcBreakMillis = dirreqStatsEndMillis / 86400000L * 86400000L;
        for (int i = 0; i < 2; ++i) {
            long toMillis;
            long fromMillis = i == 0 ? statsStartMillis : utcBreakMillis;
            long l = toMillis = i == 0 ? utcBreakMillis : dirreqStatsEndMillis;
            if (fromMillis >= toMillis) continue;
            double intervalFraction = (double)(toMillis - fromMillis) / (double)dirreqStatsIntervalLengthMillis;
            double sum = 0.0;
            for (Map.Entry<String, Integer> e : requests.entrySet()) {
                String country = e.getKey();
                double reqs = (double)e.getValue().intValue() - 4.0;
                sum += reqs;
                Main.writeOutputLine(fingerprint, "relay", "responses", country, "", "", fromMillis, toMillis, reqs * intervalFraction, publishedMillis);
            }
            Main.writeOutputLine(fingerprint, "relay", "responses", "", "", "", fromMillis, toMillis, sum * intervalFraction, publishedMillis);
        }
    }

    private static void parseRelayDirreqWriteHistory(String fingerprint, long publishedMillis, BandwidthHistory dirreqWriteHistory) throws IOException {
        if (dirreqWriteHistory == null || publishedMillis - dirreqWriteHistory.getHistoryEndMillis() > 604800000L) {
            return;
        }
        long intervalLengthMillis = dirreqWriteHistory.getIntervalLength() * 1000L;
        block0: for (Map.Entry<Long, Long> e : dirreqWriteHistory.getBandwidthValues().entrySet()) {
            long intervalEndMillis = e.getKey();
            long intervalStartMillis = intervalEndMillis - intervalLengthMillis;
            for (int i = 0; i < 2; ++i) {
                long fromMillis = intervalStartMillis;
                long toMillis = intervalEndMillis;
                double writtenBytes = e.getValue().longValue();
                if (intervalStartMillis / 86400000L < intervalEndMillis / 86400000L) {
                    long utcBreakMillis = intervalEndMillis / 86400000L * 86400000L;
                    if (i == 0) {
                        toMillis = utcBreakMillis;
                    } else if (i == 1) {
                        fromMillis = utcBreakMillis;
                    }
                    double intervalFraction = (double)(toMillis - fromMillis) / (double)intervalLengthMillis;
                    writtenBytes *= intervalFraction;
                } else if (i == 1) continue block0;
                Main.writeOutputLine(fingerprint, "relay", "bytes", "", "", "", fromMillis, toMillis, writtenBytes, publishedMillis);
            }
        }
    }

    private static void parseRelayNetworkStatusConsensus(RelayNetworkStatusConsensus consensus) throws IOException {
        long fromMillis = consensus.getValidAfterMillis();
        long toMillis = consensus.getFreshUntilMillis();
        for (NetworkStatusEntry statusEntry : consensus.getStatusEntries().values()) {
            String fingerprint = statusEntry.getFingerprint().toUpperCase();
            if (!statusEntry.getFlags().contains("Running")) continue;
            Main.writeOutputLine(fingerprint, "relay", "status", "", "", "", fromMillis, toMillis, 0.0, fromMillis);
        }
    }

    private static void parseBridgeDescriptors() throws Exception {
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        File historyFile = new File("status/bridge-descriptors");
        descriptorReader.setHistoryFile(historyFile);
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File("../../shared/in/recent/bridge-descriptors"), new File("../../shared/in/archive/bridge-descriptors"))) {
            if (descriptor instanceof ExtraInfoDescriptor) {
                Main.parseBridgeExtraInfoDescriptor((ExtraInfoDescriptor)descriptor);
                continue;
            }
            if (!(descriptor instanceof BridgeNetworkStatus)) continue;
            Main.parseBridgeNetworkStatus((BridgeNetworkStatus)descriptor);
        }
        descriptorReader.saveHistoryFile(historyFile);
    }

    private static void parseBridgeExtraInfoDescriptor(ExtraInfoDescriptor descriptor) throws IOException {
        String fingerprint = descriptor.getFingerprint().toUpperCase();
        long publishedMillis = descriptor.getPublishedMillis();
        long dirreqStatsEndMillis = descriptor.getDirreqStatsEndMillis();
        long dirreqStatsIntervalLengthMillis = descriptor.getDirreqStatsIntervalLength() * 1000L;
        Main.parseBridgeDirreqV3Resp(fingerprint, publishedMillis, dirreqStatsEndMillis, dirreqStatsIntervalLengthMillis, descriptor.getDirreqV3Resp(), descriptor.getBridgeIps(), descriptor.getBridgeIpTransports(), descriptor.getBridgeIpVersions());
        Main.parseBridgeDirreqWriteHistory(fingerprint, publishedMillis, descriptor.getDirreqWriteHistory());
    }

    private static void parseBridgeDirreqV3Resp(String fingerprint, long publishedMillis, long dirreqStatsEndMillis, long dirreqStatsIntervalLengthMillis, SortedMap<String, Integer> responses, SortedMap<String, Integer> bridgeIps, SortedMap<String, Integer> bridgeIpTransports, SortedMap<String, Integer> bridgeIpVersions) throws IOException {
        if (responses == null || publishedMillis - dirreqStatsEndMillis > 604800000L || dirreqStatsIntervalLengthMillis != 86400000L) {
            return;
        }
        long statsStartMillis = dirreqStatsEndMillis - dirreqStatsIntervalLengthMillis;
        long utcBreakMillis = dirreqStatsEndMillis / 86400000L * 86400000L;
        double resp = (double)((Integer)responses.get("ok")).intValue() - 4.0;
        if (resp > 0.0) {
            for (int i = 0; i < 2; ++i) {
                long toMillis;
                long fromMillis = i == 0 ? statsStartMillis : utcBreakMillis;
                long l = toMillis = i == 0 ? utcBreakMillis : dirreqStatsEndMillis;
                if (fromMillis >= toMillis) continue;
                double intervalFraction = (double)(toMillis - fromMillis) / (double)dirreqStatsIntervalLengthMillis;
                Main.writeOutputLine(fingerprint, "bridge", "responses", "", "", "", fromMillis, toMillis, resp * intervalFraction, publishedMillis);
                Main.parseBridgeRespByCategory(fingerprint, fromMillis, toMillis, resp, dirreqStatsIntervalLengthMillis, "country", bridgeIps, publishedMillis);
                Main.parseBridgeRespByCategory(fingerprint, fromMillis, toMillis, resp, dirreqStatsIntervalLengthMillis, "transport", bridgeIpTransports, publishedMillis);
                Main.parseBridgeRespByCategory(fingerprint, fromMillis, toMillis, resp, dirreqStatsIntervalLengthMillis, "version", bridgeIpVersions, publishedMillis);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void parseBridgeRespByCategory(String fingerprint, long fromMillis, long toMillis, double resp, long dirreqStatsIntervalLengthMillis, String category, SortedMap<String, Integer> frequencies, long publishedMillis) throws IOException {
        double total = 0.0;
        TreeMap frequenciesCopy = new TreeMap();
        if (frequencies != null) {
            for (Map.Entry entry : frequencies.entrySet()) {
                if ((double)((Integer)entry.getValue()).intValue() < 4.0) continue;
                double frequency = (double)((Integer)entry.getValue()).intValue() - 4.0;
                frequenciesCopy.put(entry.getKey(), frequency);
                total += frequency;
            }
        }
        if (total == 0.0) {
            void var17_16;
            Iterator iterator = category;
            int n = -1;
            switch (((String)((Object)iterator)).hashCode()) {
                case 957831062: {
                    if (!((String)((Object)iterator)).equals("country")) break;
                    boolean bl = false;
                    break;
                }
                case 1052964649: {
                    if (!((String)((Object)iterator)).equals("transport")) break;
                    boolean bl = true;
                    break;
                }
                case 351608024: {
                    if (!((String)((Object)iterator)).equals("version")) break;
                    int n2 = 2;
                }
            }
            switch (var17_16) {
                case 0: {
                    frequenciesCopy.put("??", 4.0);
                    break;
                }
                case 1: {
                    frequenciesCopy.put("<OR>", 4.0);
                    break;
                }
                case 2: {
                    frequenciesCopy.put("v4", 4.0);
                    break;
                }
            }
            total = 4.0;
        }
        for (Map.Entry entry : frequenciesCopy.entrySet()) {
            double intervalFraction = (double)(toMillis - fromMillis) / (double)dirreqStatsIntervalLengthMillis;
            double val = resp * intervalFraction * (Double)entry.getValue() / total;
            switch (category) {
                case "country": {
                    Main.writeOutputLine(fingerprint, "bridge", "responses", (String)entry.getKey(), "", "", fromMillis, toMillis, val, publishedMillis);
                    break;
                }
                case "transport": {
                    Main.writeOutputLine(fingerprint, "bridge", "responses", "", (String)entry.getKey(), "", fromMillis, toMillis, val, publishedMillis);
                    break;
                }
                case "version": {
                    Main.writeOutputLine(fingerprint, "bridge", "responses", "", "", (String)entry.getKey(), fromMillis, toMillis, val, publishedMillis);
                    break;
                }
            }
        }
    }

    private static void parseBridgeDirreqWriteHistory(String fingerprint, long publishedMillis, BandwidthHistory dirreqWriteHistory) throws IOException {
        if (dirreqWriteHistory == null || publishedMillis - dirreqWriteHistory.getHistoryEndMillis() > 604800000L) {
            return;
        }
        long intervalLengthMillis = dirreqWriteHistory.getIntervalLength() * 1000L;
        block0: for (Map.Entry<Long, Long> e : dirreqWriteHistory.getBandwidthValues().entrySet()) {
            long intervalEndMillis = e.getKey();
            long intervalStartMillis = intervalEndMillis - intervalLengthMillis;
            for (int i = 0; i < 2; ++i) {
                long fromMillis = intervalStartMillis;
                long toMillis = intervalEndMillis;
                double writtenBytes = e.getValue().longValue();
                if (intervalStartMillis / 86400000L < intervalEndMillis / 86400000L) {
                    long utcBreakMillis = intervalEndMillis / 86400000L * 86400000L;
                    if (i == 0) {
                        toMillis = utcBreakMillis;
                    } else if (i == 1) {
                        fromMillis = utcBreakMillis;
                    }
                    double intervalFraction = (double)(toMillis - fromMillis) / (double)intervalLengthMillis;
                    writtenBytes *= intervalFraction;
                } else if (i == 1) continue block0;
                Main.writeOutputLine(fingerprint, "bridge", "bytes", "", "", "", fromMillis, toMillis, writtenBytes, publishedMillis);
            }
        }
    }

    private static void parseBridgeNetworkStatus(BridgeNetworkStatus status) throws IOException {
        long publishedMillis = status.getPublishedMillis();
        long fromMillis = publishedMillis / 3600000L * 3600000L;
        long toMillis = fromMillis + 3600000L;
        for (NetworkStatusEntry statusEntry : status.getStatusEntries().values()) {
            String fingerprint = statusEntry.getFingerprint().toUpperCase();
            if (!statusEntry.getFlags().contains("Running")) continue;
            Main.writeOutputLine(fingerprint, "bridge", "status", "", "", "", fromMillis, toMillis, 0.0, publishedMillis);
        }
    }

    private static void writeOutputLine(String fingerprint, String node, String metric, String country, String transport, String version, long fromMillis, long toMillis, double val, long publishedMillis) throws IOException {
        if (fromMillis > toMillis) {
            return;
        }
        String fromDateTime = Main.formatDateTimeMillis(fromMillis);
        String toDateTime = Main.formatDateTimeMillis(toMillis);
        BufferedWriter bw = Main.getOutputFile(fromDateTime, publishedMillis);
        bw.write(String.format("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%.1f\n", fingerprint, node, metric, country, transport, version, fromDateTime, toDateTime, val));
    }

    private static String formatDateTimeMillis(long millis) {
        if (dateTimeFormat == null) {
            dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateTimeFormat.setLenient(false);
            dateTimeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return dateTimeFormat.format(millis);
    }

    private static BufferedWriter getOutputFile(String fromDateTime, long publishedMillis) throws IOException {
        String outputFileName;
        if (writeToSingleFile) {
            outputFileName = "out/userstats.sql";
        } else if (byStatsDateNotByDescHour) {
            outputFileName = "out/userstats-" + fromDateTime.substring(0, 10) + ".sql";
        } else {
            String publishedHourDateTime = Main.formatDateTimeMillis(publishedMillis / 3600000L * 3600000L);
            outputFileName = "out/userstats-" + publishedHourDateTime.substring(0, 10) + "-" + publishedHourDateTime.substring(11, 13) + ".sql";
        }
        BufferedWriter bw = openOutputFiles.get(outputFileName);
        if (bw == null) {
            bw = Main.openOutputFile(outputFileName);
            openOutputFiles.put(outputFileName, bw);
        }
        return bw;
    }

    private static BufferedWriter openOutputFile(String outputFileName) throws IOException {
        File outputFile = new File(outputFileName);
        outputFile.getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileName));
        bw.write("BEGIN;\n");
        bw.write("LOCK TABLE imported NOWAIT;\n");
        bw.write("COPY imported (fingerprint, node, metric, country, transport, version, stats_start, stats_end, val) FROM stdin;\n");
        return bw;
    }

    private static void closeOutputFiles() throws IOException {
        for (BufferedWriter bw : openOutputFiles.values()) {
            bw.write("\\.\n");
            bw.write("SELECT merge();\n");
            bw.write("SELECT aggregate();\n");
            bw.write("SELECT combine();\n");
            bw.write("TRUNCATE imported;\n");
            bw.write("COMMIT;\n");
            bw.close();
        }
    }
}

