/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.postgresql.core.Utils;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class PSQLSavepoint
implements Savepoint {
    private boolean _isValid = true;
    private boolean _isNamed;
    private int _id;
    private String _name;

    public PSQLSavepoint(int id) {
        this._isNamed = false;
        this._id = id;
    }

    public PSQLSavepoint(String name) {
        this._isNamed = true;
        this._name = name;
    }

    public int getSavepointId() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this._isNamed) {
            throw new PSQLException(GT.tr("Cannot retrieve the id of a named savepoint.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this._id;
    }

    public String getSavepointName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (!this._isNamed) {
            throw new PSQLException(GT.tr("Cannot retrieve the name of an unnamed savepoint.", new Object[0]), PSQLState.WRONG_OBJECT_TYPE);
        }
        return this._name;
    }

    public void invalidate() {
        this._isValid = false;
    }

    public String getPGName() throws SQLException {
        if (!this._isValid) {
            throw new PSQLException(GT.tr("Cannot reference a savepoint after it has been released.", new Object[0]), PSQLState.INVALID_SAVEPOINT_SPECIFICATION);
        }
        if (this._isNamed) {
            return Utils.escapeIdentifier(null, this._name).toString();
        }
        return "JDBC_SAVEPOINT_" + this._id;
    }
}

