/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblem
extends CategorizedProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    public int column;
    private int severity;
    private String[] arguments;
    private String message;
    private static final String MARKER_TYPE_PROBLEM = "org.eclipse.jdt.core.problem";
    private static final String MARKER_TYPE_TASK = "org.eclipse.jdt.core.task";
    public static final Object[] EMPTY_VALUES = new Object[0];

    public DefaultProblem(char[] cArray, String string, int n, String[] stringArray, int n2, int n3, int n4, int n5, int n6) {
        this.fileName = cArray;
        this.message = string;
        this.id = n;
        this.arguments = stringArray;
        this.severity = n2;
        this.startPosition = n3;
        this.endPosition = n4;
        this.line = n5;
        this.column = n6;
    }

    public String errorReportSource(char[] cArray) {
        char c;
        if (this.startPosition > this.endPosition || this.startPosition < 0 && this.endPosition < 0 || cArray.length == 0) {
            return Messages.problem_noSourceInformation;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(' ').append(Messages.bind(Messages.problem_atLine, String.valueOf(this.line)));
        stringBuffer.append(Util.LINE_SEPARATOR);
        stringBuffer.append('\t');
        int n = cArray.length;
        int n2 = this.startPosition >= n ? n - 1 : this.startPosition;
        while (n2 > 0) {
            c = cArray[n2 - 1];
            if (c == '\n' || c == '\r') break;
            --n2;
        }
        int n3 = this.endPosition >= n ? n - 1 : this.endPosition;
        while (n3 + 1 < n) {
            c = cArray[n3 + 1];
            if (c == '\r' || c == '\n') break;
            ++n3;
        }
        while ((c = cArray[n2]) == ' ' || c == '\t') {
            ++n2;
        }
        stringBuffer.append(cArray, n2, n3 - n2 + 1);
        stringBuffer.append(Util.LINE_SEPARATOR).append("\t");
        int n4 = n2;
        while (n4 < this.startPosition) {
            stringBuffer.append(cArray[n4] == '\t' ? (char)'\t' : ' ');
            ++n4;
        }
        n4 = this.startPosition;
        while (n4 <= (this.endPosition >= n ? n - 1 : this.endPosition)) {
            stringBuffer.append('^');
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getCategoryID() {
        return ProblemReporter.getProblemCategory(this.severity, this.id);
    }

    public int getID() {
        return this.id;
    }

    public String getInternalCategoryMessage() {
        switch (this.getCategoryID()) {
            case 0: {
                return "unspecified";
            }
            case 10: {
                return "buildpath";
            }
            case 20: {
                return "syntax";
            }
            case 30: {
                return "import";
            }
            case 40: {
                return "type";
            }
            case 50: {
                return "member";
            }
            case 60: {
                return "internal";
            }
            case 70: {
                return "javadoc";
            }
            case 80: {
                return "code style";
            }
            case 90: {
                return "potential programming problem";
            }
            case 100: {
                return "name shadowing conflict";
            }
            case 110: {
                return "deprecation";
            }
            case 120: {
                return "unnecessary code";
            }
            case 130: {
                return "unchecked/raw";
            }
            case 140: {
                return "nls";
            }
            case 150: {
                return "restriction";
            }
        }
        return null;
    }

    public String getMarkerType() {
        return this.id == 536871362 ? MARKER_TYPE_TASK : MARKER_TYPE_PROBLEM;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceColumnNumber() {
        return this.column;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setOriginatingFileName(char[] cArray) {
        this.fileName = cArray;
    }

    public void setSourceEnd(int n) {
        this.endPosition = n;
    }

    public void setSourceLineNumber(int n) {
        this.line = n;
    }

    public void setSourceStart(int n) {
        this.startPosition = n;
    }

    public String toString() {
        String string = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            string = String.valueOf(string) + this.message;
        } else if (this.arguments != null) {
            int n = 0;
            while (n < this.arguments.length) {
                string = String.valueOf(string) + " " + this.arguments[n];
                ++n;
            }
        }
        return string;
    }
}

