/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.HashSet;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredAnnotation;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredImport;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;

public class RecoveredUnit
extends RecoveredElement {
    public CompilationUnitDeclaration unitDeclaration;
    public RecoveredImport[] imports;
    public int importCount;
    public RecoveredType[] types;
    public int typeCount;
    int pendingModifiers;
    int pendingModifersSourceStart = -1;
    RecoveredAnnotation[] pendingAnnotations;
    int pendingAnnotationCount;

    public RecoveredUnit(CompilationUnitDeclaration compilationUnitDeclaration, int n, Parser parser) {
        super(null, n, parser);
        this.unitDeclaration = compilationUnitDeclaration;
    }

    public RecoveredElement addAnnotationName(int n, int n2, int n3, int n4) {
        if (this.pendingAnnotations == null) {
            this.pendingAnnotations = new RecoveredAnnotation[5];
            this.pendingAnnotationCount = 0;
        } else if (this.pendingAnnotationCount == this.pendingAnnotations.length) {
            this.pendingAnnotations = new RecoveredAnnotation[2 * this.pendingAnnotationCount];
            System.arraycopy(this.pendingAnnotations, 0, this.pendingAnnotations, 0, this.pendingAnnotationCount);
        }
        RecoveredAnnotation recoveredAnnotation = new RecoveredAnnotation(n, n2, n3, this, n4);
        this.pendingAnnotations[this.pendingAnnotationCount++] = recoveredAnnotation;
        return recoveredAnnotation;
    }

    public void addModifier(int n, int n2) {
        this.pendingModifiers |= n;
        if (this.pendingModifersSourceStart < 0) {
            this.pendingModifersSourceStart = n2;
        }
    }

    public RecoveredElement add(AbstractMethodDeclaration abstractMethodDeclaration, int n) {
        if (this.typeCount > 0) {
            RecoveredType recoveredType = this.types[this.typeCount - 1];
            int n2 = recoveredType.bodyEnd;
            int n3 = recoveredType.typeDeclaration.bodyEnd;
            recoveredType.bodyEnd = 0;
            recoveredType.typeDeclaration.declarationSourceEnd = 0;
            recoveredType.typeDeclaration.bodyEnd = 0;
            int n4 = TypeDeclaration.kind(recoveredType.typeDeclaration.modifiers);
            if (n2 > 0 && n2 < n3 && n4 != 2 && n4 != 4) {
                Block block = new Block(0);
                block.sourceStart = block.sourceEnd = n3;
                Initializer initializer = new Initializer(block, 0);
                initializer.bodyStart = n3;
                initializer.bodyEnd = n3;
                initializer.declarationSourceStart = n3;
                initializer.declarationSourceEnd = n3;
                initializer.sourceStart = n3;
                initializer.sourceEnd = n3;
                recoveredType.add(initializer, n);
            }
            this.resetPendingModifiers();
            return recoveredType.add(abstractMethodDeclaration, n);
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n) {
        if (this.typeCount > 0) {
            RecoveredType recoveredType = this.types[this.typeCount - 1];
            recoveredType.bodyEnd = 0;
            recoveredType.typeDeclaration.declarationSourceEnd = 0;
            recoveredType.typeDeclaration.bodyEnd = 0;
            this.resetPendingModifiers();
            return recoveredType.add(fieldDeclaration, n);
        }
        return this;
    }

    public RecoveredElement add(ImportReference importReference, int n) {
        this.resetPendingModifiers();
        if (this.imports == null) {
            this.imports = new RecoveredImport[5];
            this.importCount = 0;
        } else if (this.importCount == this.imports.length) {
            this.imports = new RecoveredImport[2 * this.importCount];
            System.arraycopy(this.imports, 0, this.imports, 0, this.importCount);
        }
        RecoveredImport recoveredImport = new RecoveredImport(importReference, this, n);
        this.imports[this.importCount++] = recoveredImport;
        if (importReference.declarationSourceEnd == 0) {
            return recoveredImport;
        }
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n) {
        if ((typeDeclaration.bits & 0x200) != 0 && this.typeCount > 0) {
            RecoveredType recoveredType = this.types[this.typeCount - 1];
            recoveredType.bodyEnd = 0;
            recoveredType.typeDeclaration.bodyEnd = 0;
            recoveredType.typeDeclaration.declarationSourceEnd = 0;
            recoveredType.bracketBalance = recoveredType.bracketBalance + 1;
            this.resetPendingModifiers();
            return recoveredType.add(typeDeclaration, n);
        }
        if (this.types == null) {
            this.types = new RecoveredType[5];
            this.typeCount = 0;
        } else if (this.typeCount == this.types.length) {
            this.types = new RecoveredType[2 * this.typeCount];
            System.arraycopy(this.types, 0, this.types, 0, this.typeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n);
        this.types[this.typeCount++] = recoveredType;
        if (this.pendingAnnotationCount > 0) {
            recoveredType.attach(this.pendingAnnotations, this.pendingAnnotationCount, this.pendingModifiers, this.pendingModifersSourceStart);
        }
        this.resetPendingModifiers();
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    public ASTNode parseTree() {
        return this.unitDeclaration;
    }

    public void resetPendingModifiers() {
        this.pendingAnnotations = null;
        this.pendingAnnotationCount = 0;
        this.pendingModifiers = 0;
        this.pendingModifersSourceStart = -1;
    }

    public int sourceEnd() {
        return this.unitDeclaration.sourceEnd;
    }

    public String toString(int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n));
        stringBuffer.append("Recovered unit: [\n");
        this.unitDeclaration.print(n + 1, stringBuffer);
        stringBuffer.append(this.tabString(n + 1));
        stringBuffer.append("]");
        if (this.imports != null) {
            n2 = 0;
            while (n2 < this.importCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.imports[n2].toString(n + 1));
                ++n2;
            }
        }
        if (this.types != null) {
            n2 = 0;
            while (n2 < this.typeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.types[n2].toString(n + 1));
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public CompilationUnitDeclaration updatedCompilationUnitDeclaration() {
        if (this.importCount > 0) {
            ImportReference[] importReferenceArray = new ImportReference[this.importCount];
            int n = 0;
            while (n < this.importCount) {
                importReferenceArray[n] = this.imports[n].updatedImportReference();
                ++n;
            }
            this.unitDeclaration.imports = importReferenceArray;
        }
        if (this.typeCount > 0) {
            int n = this.unitDeclaration.types == null ? 0 : this.unitDeclaration.types.length;
            TypeDeclaration[] typeDeclarationArray = new TypeDeclaration[n + this.typeCount];
            if (n > 0) {
                System.arraycopy(this.unitDeclaration.types, 0, typeDeclarationArray, 0, n);
            }
            if (this.types[this.typeCount - 1].typeDeclaration.declarationSourceEnd == 0) {
                this.types[this.typeCount - 1].typeDeclaration.declarationSourceEnd = this.unitDeclaration.sourceEnd;
                this.types[this.typeCount - 1].typeDeclaration.bodyEnd = this.unitDeclaration.sourceEnd;
            }
            HashSet hashSet = new HashSet();
            int n2 = n;
            int n3 = 0;
            while (n3 < this.typeCount) {
                TypeDeclaration typeDeclaration = this.types[n3].updatedTypeDeclaration(0, hashSet);
                if (typeDeclaration != null && (typeDeclaration.bits & 0x100) == 0) {
                    typeDeclarationArray[n2++] = typeDeclaration;
                }
                ++n3;
            }
            if (n2 != this.typeCount) {
                TypeDeclaration[] typeDeclarationArray2 = typeDeclarationArray;
                typeDeclarationArray = new TypeDeclaration[n + n2];
                System.arraycopy(typeDeclarationArray2, 0, typeDeclarationArray, 0, n + n2);
            }
            this.unitDeclaration.types = typeDeclarationArray;
        }
        return this.unitDeclaration;
    }

    public void updateParseTree() {
        this.updatedCompilationUnitDeclaration();
    }

    public void updateSourceEndIfNecessary(int n, int n2) {
        if (this.unitDeclaration.sourceEnd == 0) {
            this.unitDeclaration.sourceEnd = n2;
        }
    }
}

