/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ImplicitNullAnnotationVerifier {
    ImplicitNullAnnotationVerifier buddyImplicitNullAnnotationsVerifier;
    private boolean inheritNullAnnotations;
    protected LookupEnvironment environment;

    public ImplicitNullAnnotationVerifier(LookupEnvironment lookupEnvironment, boolean bl) {
        this.buddyImplicitNullAnnotationsVerifier = this;
        this.inheritNullAnnotations = bl;
        this.environment = lookupEnvironment;
    }

    ImplicitNullAnnotationVerifier(LookupEnvironment lookupEnvironment) {
        CompilerOptions compilerOptions = lookupEnvironment.globalOptions;
        this.buddyImplicitNullAnnotationsVerifier = new ImplicitNullAnnotationVerifier(lookupEnvironment, compilerOptions.inheritNullAnnotations);
        this.inheritNullAnnotations = compilerOptions.inheritNullAnnotations;
        this.environment = lookupEnvironment;
    }

    public void checkImplicitNullAnnotations(MethodBinding methodBinding, AbstractMethodDeclaration abstractMethodDeclaration, boolean bl, Scope scope) {
        try {
            ReferenceBinding referenceBinding = methodBinding.declaringClass;
            if (referenceBinding.id == 1) {
                return;
            }
            boolean bl2 = scope.environment().usesNullTypeAnnotations();
            boolean bl3 = methodBinding.hasNonNullDefaultFor(16, bl2);
            boolean bl4 = methodBinding.hasNonNullDefaultFor(8, bl2);
            boolean bl5 = bl3 | bl4;
            boolean bl6 = !methodBinding.isConstructor() && !methodBinding.isStatic();
            if (!(bl5 || (bl &= bl6) || this.inheritNullAnnotations && bl6)) {
                return;
            }
            if (bl6) {
                ArrayList arrayList = new ArrayList();
                if (referenceBinding instanceof SourceTypeBinding && !referenceBinding.isHierarchyConnected() && !referenceBinding.isAnonymousType()) {
                    ((SourceTypeBinding)referenceBinding).scope.connectTypeHierarchy();
                }
                int n = methodBinding.parameters.length;
                this.findAllOverriddenMethods(methodBinding.original(), methodBinding.selector, n, referenceBinding, new HashSet(), arrayList);
                InheritedNonNullnessInfo[] inheritedNonNullnessInfoArray = new InheritedNonNullnessInfo[n + 1];
                int n2 = 0;
                while (n2 < n + 1) {
                    inheritedNonNullnessInfoArray[n2] = new InheritedNonNullnessInfo();
                    ++n2;
                }
                int n3 = n2 = arrayList.size();
                while (--n3 >= 0) {
                    MethodBinding methodBinding2 = (MethodBinding)arrayList.get(n3);
                    if ((methodBinding2.tagBits & 0x1000L) == 0L) {
                        this.checkImplicitNullAnnotations(methodBinding2, null, false, scope);
                    }
                    this.checkNullSpecInheritance(methodBinding, abstractMethodDeclaration, bl3, bl4, bl, methodBinding2, null, scope, inheritedNonNullnessInfoArray);
                    bl5 = false;
                }
                InheritedNonNullnessInfo inheritedNonNullnessInfo = inheritedNonNullnessInfoArray[0];
                if (!inheritedNonNullnessInfo.complained) {
                    long l = 0L;
                    if (inheritedNonNullnessInfo.inheritedNonNullness == Boolean.TRUE) {
                        l = 0x100000000000000L;
                    } else if (inheritedNonNullnessInfo.inheritedNonNullness == Boolean.FALSE) {
                        l = 0x80000000000000L;
                    }
                    if (l != 0L) {
                        if (!bl2) {
                            methodBinding.tagBits |= l;
                        } else if (!methodBinding.returnType.isBaseType()) {
                            LookupEnvironment lookupEnvironment = scope.environment();
                            methodBinding.returnType = lookupEnvironment.createAnnotatedType(methodBinding.returnType, lookupEnvironment.nullAnnotationsFromTagBits(l));
                        }
                    }
                }
                int n4 = 0;
                while (n4 < n) {
                    inheritedNonNullnessInfo = inheritedNonNullnessInfoArray[n4 + 1];
                    if (!inheritedNonNullnessInfo.complained && inheritedNonNullnessInfo.inheritedNonNullness != null) {
                        Argument argument;
                        Argument argument2 = argument = abstractMethodDeclaration == null ? null : abstractMethodDeclaration.arguments[n4];
                        if (!bl2) {
                            this.recordArgNonNullness(methodBinding, n, n4, argument, inheritedNonNullnessInfo.inheritedNonNullness);
                        } else {
                            this.recordArgNonNullness18(methodBinding, n4, argument, inheritedNonNullnessInfo.inheritedNonNullness, scope.environment());
                        }
                    }
                    ++n4;
                }
            }
            if (bl5) {
                if (!bl2) {
                    methodBinding.fillInDefaultNonNullness(abstractMethodDeclaration);
                } else {
                    methodBinding.fillInDefaultNonNullness18(abstractMethodDeclaration, scope.environment());
                }
            }
        }
        finally {
            methodBinding.tagBits |= 0x1000L;
        }
    }

    private void findAllOverriddenMethods(MethodBinding methodBinding, char[] cArray, int n, ReferenceBinding referenceBinding, Set set, List list) {
        if (referenceBinding.id == 1) {
            return;
        }
        ReferenceBinding referenceBinding2 = referenceBinding.superclass();
        if (referenceBinding2 == null) {
            return;
        }
        this.collectOverriddenMethods(methodBinding, cArray, n, referenceBinding2, set, list);
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        int n2 = referenceBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ReferenceBinding referenceBinding3 = referenceBindingArray[n3];
            if (set.add(referenceBinding3.original())) {
                this.collectOverriddenMethods(methodBinding, cArray, n, referenceBinding3, set, list);
            }
            ++n3;
        }
    }

    private void collectOverriddenMethods(MethodBinding methodBinding, char[] cArray, int n, ReferenceBinding referenceBinding, Set set, List list) {
        MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray, n);
        int n2 = methodBindingArray.length;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            MethodBinding methodBinding2 = methodBindingArray[n3];
            if (!methodBinding2.isStatic() && MethodVerifier.doesMethodOverride(methodBinding, methodBinding2, this.environment)) {
                list.add(methodBinding2);
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            this.findAllOverriddenMethods(methodBinding, cArray, n, referenceBinding, set, list);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void checkNullSpecInheritance(MethodBinding var1_1, AbstractMethodDeclaration var2_2, boolean var3_3, boolean var4_4, boolean var5_5, MethodBinding var6_6, MethodBinding[] var7_7, Scope var8_8, InheritedNonNullnessInfo[] var9_9) {
        block46: {
            block47: {
                block48: {
                    if ((var6_6.tagBits & 4096L) == 0L) {
                        this.buddyImplicitNullAnnotationsVerifier.checkImplicitNullAnnotations(var6_6, null, false, var8_8);
                    }
                    var10_10 = this.environment.usesNullTypeAnnotations();
                    var11_11 = this.getReturnTypeNullnessTagBits(var6_6, var10_10);
                    var13_12 = this.getReturnTypeNullnessTagBits(var1_1, var10_10);
                    var15_13 = this.inheritNullAnnotations;
                    if (var1_1.returnType == null || var1_1.returnType.isBaseType()) break block46;
                    if (var13_12 != 0L) break block47;
                    if (!var15_13 || var11_11 == 0L) break block48;
                    if (var3_3 && var5_5 && var11_11 == 0x80000000000000L) {
                        var8_8.problemReporter().conflictingNullAnnotations(var1_1, ((MethodDeclaration)var2_2).returnType, var6_6);
                    }
                    if (var9_9 != null && var2_2 != null) {
                        this.recordDeferredInheritedNullness(var8_8, ((MethodDeclaration)var2_2).returnType, var6_6, var11_11 == 0x100000000000000L, var9_9[0]);
                    } else {
                        this.applyReturnNullBits(var1_1, var11_11);
                    }
                    break block46;
                }
                if (var3_3 && (!var10_10 || var1_1.returnType.acceptsNonNullDefault())) {
                    var13_12 = 0x100000000000000L;
                    this.applyReturnNullBits(var1_1, var13_12);
                }
            }
            if (!var5_5) break block46;
            if ((var11_11 & 0x100000000000000L) == 0L || var13_12 == 0x100000000000000L) ** GOTO lbl29
            if (var2_2 != null) {
                var8_8.problemReporter().illegalReturnRedefinition(var2_2, var6_6, this.environment.getNonNullAnnotationName());
            } else {
                var8_8.problemReporter().cannotImplementIncompatibleNullness(var1_1, var6_6, var10_10);
                return;
lbl29:
                // 1 sources

                if (var10_10) {
                    var16_14 /* !! */  = null;
                    var17_15 = var6_6.original().typeVariables;
                    if (var17_15 != null && var1_1.returnType.id != 6) {
                        var18_16 = this.environment.createParameterizedGenericMethod(var1_1, (TypeBinding[])var17_15);
                        var16_14 /* !! */  = var18_16.returnType;
                    }
                    if (NullAnnotationMatching.analyse(var6_6.returnType, var1_1.returnType, (TypeBinding)var16_14 /* !! */ , 0, NullAnnotationMatching.CheckMode.OVERRIDE).isAnyMismatch()) {
                        if (var2_2 != null) {
                            var8_8.problemReporter().illegalReturnRedefinition(var2_2, var6_6, this.environment.getNonNullAnnotationName());
                        } else {
                            var8_8.problemReporter().cannotImplementIncompatibleNullness(var1_1, var6_6, var10_10);
                        }
                        return;
                    }
                }
            }
        }
        var16_14 /* !! */  = null;
        if (var5_5 && (var17_15 = var1_1.original().typeVariables) != Binding.NO_TYPE_VARIABLES) {
            var18_16 = this.environment.createParameterizedGenericMethod(var6_6, (TypeBinding[])var17_15);
            var16_14 /* !! */  = var18_16.parameters;
        }
        var17_15 = var2_2 == null ? null : var2_2.arguments;
        var18_17 = 0;
        if (var17_15 != null) {
            var18_17 = var17_15.length;
        }
        if (var10_10) {
            var18_17 = var1_1.parameters.length;
        } else if (var6_6.parameterNonNullness != null) {
            var18_17 = var6_6.parameterNonNullness.length;
        } else if (var1_1.parameterNonNullness != null) {
            var18_17 = var1_1.parameterNonNullness.length;
        }
        var19_18 = 0;
        while (var19_18 < var18_17) {
            block49: {
                block52: {
                    block50: {
                        block51: {
                            if (var1_1.parameters[var19_18].isBaseType()) break block49;
                            var20_19 = var17_15 == null ? null : var17_15[var19_18];
                            var21_20 = this.getParameterNonNullness(var6_6, var19_18, var10_10);
                            var22_21 = this.getParameterNonNullness(var1_1, var19_18, var10_10);
                            if (var22_21 != null) break block50;
                            if (var21_20 == null || !var15_13) break block51;
                            if (var4_4 && var5_5 && var21_20 == Boolean.FALSE && var20_19 != null) {
                                var8_8.problemReporter().conflictingNullAnnotations(var1_1, (ASTNode)var20_19, var6_6);
                            }
                            if (var9_9 != null && var2_2 != null) {
                                this.recordDeferredInheritedNullness(var8_8, var2_2.arguments[var19_18].type, var6_6, var21_20, var9_9[var19_18 + 1]);
                            } else if (!var10_10) {
                                this.recordArgNonNullness(var1_1, var18_17, var19_18, (Argument)var20_19, var21_20);
                            } else {
                                this.recordArgNonNullness18(var1_1, var19_18, (Argument)var20_19, var21_20, this.environment);
                            }
                            break block49;
                        }
                        if (var4_4) {
                            var22_21 = Boolean.TRUE;
                            if (!var10_10) {
                                this.recordArgNonNullness(var1_1, var18_17, var19_18, (Argument)var20_19, Boolean.TRUE);
                            } else if (var1_1.parameters[var19_18].acceptsNonNullDefault()) {
                                this.recordArgNonNullness18(var1_1, var19_18, (Argument)var20_19, Boolean.TRUE, this.environment);
                            } else {
                                var22_21 = null;
                            }
                        }
                    }
                    if (!var5_5) break block49;
                    var23_22 = var21_20 == Boolean.TRUE ? this.environment.getNonNullAnnotationName() : this.environment.getNullableAnnotationName();
                    if (var21_20 == Boolean.TRUE || var22_21 != Boolean.TRUE) break block52;
                    if (var20_19 != null) {
                        var8_8.problemReporter().illegalRedefinitionToNonNullParameter((Argument)var20_19, var6_6.declaringClass, var21_20 == null ? null : this.environment.getNullableAnnotationName());
                    } else {
                        var8_8.problemReporter().cannotImplementIncompatibleNullness(var1_1, var6_6, false);
                    }
                    break block49;
                }
                if (var22_21 != null) ** GOTO lbl-1000
                if (var21_20 == Boolean.FALSE) {
                    if (var20_19 != null) {
                        var8_8.problemReporter().parameterLackingNullableAnnotation((Argument)var20_19, var6_6.declaringClass, var23_22);
                    } else {
                        var8_8.problemReporter().cannotImplementIncompatibleNullness(var1_1, var6_6, false);
                    }
                } else if (var21_20 == Boolean.TRUE) {
                    if (var7_7 != null) {
                        var27_27 = var7_7;
                        var26_26 = var7_7.length;
                        var25_24 = 0;
                        while (var25_24 < var26_26) {
                            var24_23 /* !! */  = var27_27[var25_24];
                            if (!TypeBinding.equalsEquals(var6_6.declaringClass, var24_23 /* !! */ .declaringClass) || this.getParameterNonNullness((MethodBinding)var24_23 /* !! */ , var19_18, var10_10) == Boolean.TRUE) {
                                ++var25_24;
                                continue;
                            }
                            break;
                        }
                    } else {
                        var8_8.problemReporter().parameterLackingNonnullAnnotation((Argument)var20_19, var6_6.declaringClass, var23_22);
                    }
                } else if (var10_10) {
                    var24_23 /* !! */  = var6_6.parameters[var19_18];
                    v0 = var25_25 = var16_14 /* !! */  != null ? var16_14 /* !! */ [var19_18] : null;
                    if (NullAnnotationMatching.analyse(var1_1.parameters[var19_18], var24_23 /* !! */ , var25_25, 0, NullAnnotationMatching.CheckMode.OVERRIDE).isAnyMismatch()) {
                        if (var20_19 != null) {
                            var8_8.problemReporter().illegalParameterRedefinition((Argument)var20_19, var6_6.declaringClass, var24_23 /* !! */ );
                        } else {
                            var8_8.problemReporter().cannotImplementIncompatibleNullness(var1_1, var6_6, false);
                        }
                    }
                }
            }
            ++var19_18;
        }
    }

    void applyReturnNullBits(MethodBinding methodBinding, long l) {
        if (this.environment.usesNullTypeAnnotations()) {
            if (!methodBinding.returnType.isBaseType()) {
                methodBinding.returnType = this.environment.createAnnotatedType(methodBinding.returnType, this.environment.nullAnnotationsFromTagBits(l));
            }
        } else {
            methodBinding.tagBits |= l;
        }
    }

    private Boolean getParameterNonNullness(MethodBinding methodBinding, int n, boolean bl) {
        if (bl) {
            long l;
            TypeBinding typeBinding = methodBinding.parameters[n];
            if (typeBinding != null && (l = NullAnnotationMatching.validNullTagBits(typeBinding.tagBits)) != 0L) {
                return l == 0x100000000000000L;
            }
            return null;
        }
        return methodBinding.parameterNonNullness == null ? null : methodBinding.parameterNonNullness[n];
    }

    private long getReturnTypeNullnessTagBits(MethodBinding methodBinding, boolean bl) {
        if (bl) {
            if (methodBinding.returnType == null) {
                return 0L;
            }
            return NullAnnotationMatching.validNullTagBits(methodBinding.returnType.tagBits);
        }
        return methodBinding.tagBits & 0x180000000000000L;
    }

    protected void recordDeferredInheritedNullness(Scope scope, ASTNode aSTNode, MethodBinding methodBinding, Boolean bl, InheritedNonNullnessInfo inheritedNonNullnessInfo) {
        if (inheritedNonNullnessInfo.inheritedNonNullness != null && inheritedNonNullnessInfo.inheritedNonNullness != bl) {
            scope.problemReporter().conflictingInheritedNullAnnotations(aSTNode, inheritedNonNullnessInfo.inheritedNonNullness, inheritedNonNullnessInfo.annotationOrigin, bl, methodBinding);
            inheritedNonNullnessInfo.complained = true;
        } else {
            inheritedNonNullnessInfo.inheritedNonNullness = bl;
            inheritedNonNullnessInfo.annotationOrigin = methodBinding;
        }
    }

    void recordArgNonNullness(MethodBinding methodBinding, int n, int n2, Argument argument, Boolean bl) {
        if (methodBinding.parameterNonNullness == null) {
            methodBinding.parameterNonNullness = new Boolean[n];
        }
        methodBinding.parameterNonNullness[n2] = bl;
        if (argument != null) {
            argument.binding.tagBits = argument.binding.tagBits | (bl != false ? 0x100000000000000L : 0x80000000000000L);
        }
    }

    void recordArgNonNullness18(MethodBinding methodBinding, int n, Argument argument, Boolean bl, LookupEnvironment lookupEnvironment) {
        AnnotationBinding annotationBinding = bl != false ? lookupEnvironment.getNonNullAnnotation() : lookupEnvironment.getNullableAnnotation();
        methodBinding.parameters[n] = lookupEnvironment.createAnnotatedType(methodBinding.parameters[n], new AnnotationBinding[]{annotationBinding});
        if (argument != null) {
            argument.binding.type = methodBinding.parameters[n];
        }
    }

    static boolean areParametersEqual(MethodBinding methodBinding, MethodBinding methodBinding2) {
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        TypeBinding[] typeBindingArray2 = methodBinding2.parameters;
        if (typeBindingArray == typeBindingArray2) {
            return true;
        }
        int n = typeBindingArray.length;
        if (n != typeBindingArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (!ImplicitNullAnnotationVerifier.areTypesEqual(typeBindingArray[n2], typeBindingArray2[n2])) {
                if (typeBindingArray[n2].leafComponentType().isRawType() && typeBindingArray[n2].dimensions() == typeBindingArray2[n2].dimensions() && typeBindingArray[n2].leafComponentType().isEquivalentTo(typeBindingArray2[n2].leafComponentType())) {
                    if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                        return false;
                    }
                    int n3 = 0;
                    while (n3 < n2) {
                        if (typeBindingArray[n3].leafComponentType().isParameterizedTypeWithActualArguments()) {
                            return false;
                        }
                        ++n3;
                    }
                    break;
                }
                return false;
            }
            ++n2;
        }
        ++n2;
        while (n2 < n) {
            if (!ImplicitNullAnnotationVerifier.areTypesEqual(typeBindingArray[n2], typeBindingArray2[n2])) {
                if (!typeBindingArray[n2].leafComponentType().isRawType() || typeBindingArray[n2].dimensions() != typeBindingArray2[n2].dimensions() || !typeBindingArray[n2].leafComponentType().isEquivalentTo(typeBindingArray2[n2].leafComponentType())) {
                    return false;
                }
            } else if (typeBindingArray[n2].leafComponentType().isParameterizedTypeWithActualArguments()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    static boolean areTypesEqual(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (TypeBinding.equalsEquals(typeBinding, typeBinding2)) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 4: {
                switch (typeBinding2.kind()) {
                    case 260: 
                    case 1028: {
                        if (!TypeBinding.equalsEquals(typeBinding, typeBinding2.erasure())) break;
                        return true;
                    }
                }
                break;
            }
            case 260: 
            case 1028: {
                switch (typeBinding2.kind()) {
                    case 4: {
                        if (!TypeBinding.equalsEquals(typeBinding.erasure(), typeBinding2)) break;
                        return true;
                    }
                }
                break;
            }
        }
        if (typeBinding.isParameterizedType() && typeBinding2.isParameterizedType()) {
            return typeBinding.isEquivalentTo(typeBinding2) && typeBinding2.isEquivalentTo(typeBinding);
        }
        return false;
    }

    static class InheritedNonNullnessInfo {
        Boolean inheritedNonNullness;
        MethodBinding annotationOrigin;
        boolean complained;

        InheritedNonNullnessInfo() {
        }
    }
}

