/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.impl;

import org.eclipse.jdt.internal.compiler.impl.Constant;

public class DoubleConstant
extends Constant {
    private double value;

    public static Constant fromValue(double d) {
        return new DoubleConstant(d);
    }

    private DoubleConstant(double d) {
        this.value = d;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String stringValue() {
        return String.valueOf(this.value);
    }

    public String toString() {
        if (this == NotAConstant) {
            return "(Constant) NotAConstant";
        }
        return "(double)" + this.value;
    }

    public int typeID() {
        return 8;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DoubleConstant doubleConstant = (DoubleConstant)object;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(doubleConstant.value);
    }
}

