/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnionTypeReference;
import org.eclipse.jdt.internal.compiler.codegen.ObjectCache;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionHandlingFlowContext
extends FlowContext {
    public static final int BitCacheSize = 32;
    public ReferenceBinding[] handledExceptions;
    int[] isReached;
    int[] isNeeded;
    UnconditionalFlowInfo[] initsOnExceptions;
    ObjectCache indexes = new ObjectCache();
    boolean isMethodContext;
    public UnconditionalFlowInfo initsOnReturn;
    public FlowContext initializationParent;
    public ArrayList extendedExceptions;
    private static final Argument[] NO_ARGUMENTS = new Argument[0];
    public Argument[] catchArguments;
    private int[] exceptionToCatchBlockMap;

    public ExceptionHandlingFlowContext(FlowContext flowContext, ASTNode aSTNode, ReferenceBinding[] referenceBindingArray, FlowContext flowContext2, BlockScope blockScope, UnconditionalFlowInfo unconditionalFlowInfo) {
        this(flowContext, aSTNode, referenceBindingArray, null, NO_ARGUMENTS, flowContext2, blockScope, unconditionalFlowInfo);
    }

    public ExceptionHandlingFlowContext(FlowContext flowContext, TryStatement tryStatement, ReferenceBinding[] referenceBindingArray, int[] nArray, FlowContext flowContext2, BlockScope blockScope, FlowInfo flowInfo) {
        this(flowContext, tryStatement, referenceBindingArray, nArray, tryStatement.catchArguments, flowContext2, blockScope, flowInfo.unconditionalInits());
        UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.unconditionalCopy();
        unconditionalFlowInfo.iNBit = -1L;
        unconditionalFlowInfo.iNNBit = -1L;
        unconditionalFlowInfo.tagBits |= 0x40;
        this.initsOnFinally = unconditionalFlowInfo;
    }

    ExceptionHandlingFlowContext(FlowContext flowContext, ASTNode aSTNode, ReferenceBinding[] referenceBindingArray, int[] nArray, Argument[] argumentArray, FlowContext flowContext2, BlockScope blockScope, UnconditionalFlowInfo unconditionalFlowInfo) {
        super(flowContext, aSTNode);
        this.isMethodContext = blockScope == blockScope.methodScope();
        this.handledExceptions = referenceBindingArray;
        this.catchArguments = argumentArray;
        this.exceptionToCatchBlockMap = nArray;
        int n = referenceBindingArray.length;
        int n2 = n / 32 + 1;
        this.isReached = new int[n2];
        this.isNeeded = new int[n2];
        this.initsOnExceptions = new UnconditionalFlowInfo[n];
        boolean bl = !this.isMethodContext || blockScope.compilerOptions().reportUnusedDeclaredThrownExceptionExemptExceptionAndThrowable;
        int n3 = 0;
        while (n3 < n) {
            ReferenceBinding referenceBinding = referenceBindingArray[n3];
            int n4 = this.exceptionToCatchBlockMap != null ? this.exceptionToCatchBlockMap[n3] : n3;
            this.indexes.put(referenceBinding, n3);
            if (referenceBinding.isUncheckedException(true)) {
                if (bl || referenceBinding.id != 21 && referenceBinding.id != 25) {
                    int n5 = n3 / 32;
                    this.isReached[n5] = this.isReached[n5] | 1 << n3 % 32;
                }
                this.initsOnExceptions[n4] = unconditionalFlowInfo.unconditionalCopy();
            } else {
                this.initsOnExceptions[n4] = FlowInfo.DEAD_END;
            }
            ++n3;
        }
        if (!this.isMethodContext) {
            System.arraycopy(this.isReached, 0, this.isNeeded, 0, n2);
        }
        this.initsOnReturn = FlowInfo.DEAD_END;
        this.initializationParent = flowContext2;
    }

    public void complainIfUnusedExceptionHandlers(AbstractMethodDeclaration abstractMethodDeclaration) {
        int n;
        MethodScope methodScope = abstractMethodDeclaration.scope;
        if ((abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0 && !methodScope.compilerOptions().reportUnusedDeclaredThrownExceptionWhenOverriding) {
            return;
        }
        TypeBinding[] typeBindingArray = null;
        int n2 = 0;
        if (methodScope.compilerOptions().reportUnusedDeclaredThrownExceptionIncludeDocCommentReference && abstractMethodDeclaration.javadoc != null && abstractMethodDeclaration.javadoc.exceptionReferences != null && (n2 = abstractMethodDeclaration.javadoc.exceptionReferences.length) > 0) {
            typeBindingArray = new TypeBinding[n2];
            n = 0;
            while (n < n2) {
                typeBindingArray[n] = abstractMethodDeclaration.javadoc.exceptionReferences[n].resolvedType;
                ++n;
            }
        }
        n = 0;
        int n3 = this.handledExceptions.length;
        while (n < n3) {
            block7: {
                int n4 = this.indexes.get(this.handledExceptions[n]);
                if ((this.isReached[n4 / 32] & 1 << n4 % 32) == 0) {
                    int n5 = 0;
                    while (n5 < n2) {
                        if (!TypeBinding.equalsEquals(typeBindingArray[n5], this.handledExceptions[n])) {
                            ++n5;
                            continue;
                        }
                        break block7;
                    }
                    methodScope.problemReporter().unusedDeclaredThrownException(this.handledExceptions[n4], abstractMethodDeclaration, abstractMethodDeclaration.thrownExceptions[n4]);
                }
            }
            ++n;
        }
    }

    public void complainIfUnusedExceptionHandlers(BlockScope blockScope, TryStatement tryStatement) {
        int n = 0;
        int n2 = this.handledExceptions.length;
        while (n < n2) {
            int n3 = n / 32;
            int n4 = 1 << n % 32;
            if ((this.isReached[n3] & n4) == 0) {
                blockScope.problemReporter().unreachableCatchBlock(this.handledExceptions[n], this.getExceptionType(n));
            } else if ((this.isNeeded[n3] & n4) == 0) {
                blockScope.problemReporter().hiddenCatchBlock(this.handledExceptions[n], this.getExceptionType(n));
            }
            ++n;
        }
    }

    private ASTNode getExceptionType(int n) {
        if (this.exceptionToCatchBlockMap == null) {
            return this.catchArguments[n].type;
        }
        int n2 = this.exceptionToCatchBlockMap[n];
        TypeReference typeReference = this.catchArguments[n2].type;
        if (typeReference instanceof UnionTypeReference) {
            TypeReference[] typeReferenceArray = ((UnionTypeReference)typeReference).typeReferences;
            int n3 = 0;
            int n4 = typeReferenceArray.length;
            while (n3 < n4) {
                TypeReference typeReference2 = typeReferenceArray[n3];
                if (TypeBinding.equalsEquals(typeReference2.resolvedType, this.handledExceptions[n])) {
                    return typeReference2;
                }
                ++n3;
            }
        }
        return typeReference;
    }

    public FlowContext getInitializationContext() {
        return this.initializationParent;
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Exception flow context");
        int n = this.handledExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 / 32;
            int n4 = 1 << n2 % 32;
            stringBuffer.append('[').append(this.handledExceptions[n2].readableName());
            if ((this.isReached[n3] & n4) != 0) {
                if ((this.isNeeded[n3] & n4) == 0) {
                    stringBuffer.append("-masked");
                } else {
                    stringBuffer.append("-reached");
                }
            } else {
                stringBuffer.append("-not reached");
            }
            int n5 = this.exceptionToCatchBlockMap != null ? this.exceptionToCatchBlockMap[n2] : n2;
            stringBuffer.append('-').append(this.initsOnExceptions[n5].toString()).append(']');
            ++n2;
        }
        stringBuffer.append("[initsOnReturn -").append(this.initsOnReturn.toString()).append(']');
        return stringBuffer.toString();
    }

    public UnconditionalFlowInfo initsOnException(int n) {
        return this.initsOnExceptions[n];
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return this.initsOnReturn;
    }

    public void mergeUnhandledException(TypeBinding typeBinding) {
        int n;
        if (this.extendedExceptions == null) {
            this.extendedExceptions = new ArrayList(5);
            n = 0;
            while (n < this.handledExceptions.length) {
                this.extendedExceptions.add(this.handledExceptions[n]);
                ++n;
            }
        }
        n = 0;
        int n2 = this.extendedExceptions.size() - 1;
        while (n2 >= 0) {
            switch (Scope.compareTypes(typeBinding, (TypeBinding)this.extendedExceptions.get(n2))) {
                case 1: {
                    this.extendedExceptions.remove(n2);
                    break;
                }
                case -1: {
                    n = 1;
                    break;
                }
            }
            --n2;
        }
        if (n == 0) {
            this.extendedExceptions.add(typeBinding);
        }
    }

    public void recordHandlingException(ReferenceBinding referenceBinding, UnconditionalFlowInfo unconditionalFlowInfo, TypeBinding typeBinding, TypeBinding typeBinding2, ASTNode aSTNode, boolean bl) {
        int n;
        int n2 = this.indexes.get(referenceBinding);
        int n3 = n2 / 32;
        int n4 = 1 << n2 % 32;
        if (!bl) {
            int n5 = n3;
            this.isNeeded[n5] = this.isNeeded[n5] | n4;
        }
        int n6 = n3;
        this.isReached[n6] = this.isReached[n6] | n4;
        int n7 = n = this.exceptionToCatchBlockMap != null ? this.exceptionToCatchBlockMap[n2] : n2;
        if (typeBinding2 != null && this.catchArguments != null && this.catchArguments.length > 0 && !bl) {
            CatchParameterBinding catchParameterBinding = (CatchParameterBinding)this.catchArguments[n].binding;
            catchParameterBinding.setPreciseType(typeBinding2);
        }
        this.initsOnExceptions[n] = (this.initsOnExceptions[n].tagBits & 3) == 0 ? this.initsOnExceptions[n].mergedWith(unconditionalFlowInfo) : unconditionalFlowInfo.unconditionalCopy();
    }

    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
        if ((unconditionalFlowInfo.tagBits & 1) == 0) {
            this.initsOnReturn = (this.initsOnReturn.tagBits & 1) == 0 ? this.initsOnReturn.mergedWith(unconditionalFlowInfo) : (UnconditionalFlowInfo)unconditionalFlowInfo.copy();
        }
    }

    public SubRoutineStatement subroutine() {
        if (this.associatedNode instanceof SubRoutineStatement) {
            if (this.parent.subroutine() == this.associatedNode) {
                return null;
            }
            return (SubRoutineStatement)this.associatedNode;
        }
        return null;
    }
}

