/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.AnnotationInfo;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfoWithAnnotations;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfoWithParameterAnnotations;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfoWithTypeAnnotations;
import org.eclipse.jdt.internal.compiler.classfmt.TypeAnnotationInfo;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.util.Util;

public class MethodInfo
extends ClassFileStruct
implements IBinaryMethod,
Comparable {
    private static final char[][] noException = CharOperation.NO_CHAR_CHAR;
    private static final char[][] noArgumentNames = CharOperation.NO_CHAR_CHAR;
    private static final char[] ARG = "arg".toCharArray();
    protected int accessFlags = -1;
    protected int attributeBytes;
    protected char[] descriptor;
    protected char[][] exceptionNames;
    protected char[] name;
    protected char[] signature;
    protected int signatureUtf8Offset = -1;
    protected long tagBits;
    protected char[][] argumentNames;

    public static MethodInfo createMethod(byte[] byArray, int[] nArray, int n) {
        MethodInfo methodInfo = new MethodInfo(byArray, nArray, n);
        int n2 = methodInfo.u2At(6);
        int n3 = 8;
        ClassFileStruct[] classFileStructArray = null;
        AnnotationInfo[][] annotationInfoArray = null;
        ClassFileStruct[] classFileStructArray2 = null;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = methodInfo.constantPoolOffsets[methodInfo.u2At(n3)] - methodInfo.structOffset;
            char[] cArray = methodInfo.utf8At(n5 + 3, methodInfo.u2At(n5 + 1));
            if (cArray.length > 0) {
                switch (cArray[0]) {
                    case 'M': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.MethodParametersName)) break;
                        methodInfo.decodeMethodParameters(n3, methodInfo);
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, cArray)) break;
                        methodInfo.signatureUtf8Offset = methodInfo.constantPoolOffsets[methodInfo.u2At(n3 + 6)] - methodInfo.structOffset;
                        break;
                    }
                    case 'R': {
                        ClassFileStruct[] classFileStructArray3;
                        int n6;
                        AnnotationInfo[] annotationInfoArray2 = null;
                        AnnotationInfo[][] annotationInfoArray3 = null;
                        TypeAnnotationInfo[] typeAnnotationInfoArray = null;
                        if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleAnnotationsName)) {
                            annotationInfoArray2 = MethodInfo.decodeMethodAnnotations(n3, true, methodInfo);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleAnnotationsName)) {
                            annotationInfoArray2 = MethodInfo.decodeMethodAnnotations(n3, false, methodInfo);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleParameterAnnotationsName)) {
                            annotationInfoArray3 = MethodInfo.decodeParamAnnotations(n3, true, methodInfo);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleParameterAnnotationsName)) {
                            annotationInfoArray3 = MethodInfo.decodeParamAnnotations(n3, false, methodInfo);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeVisibleTypeAnnotationsName)) {
                            typeAnnotationInfoArray = MethodInfo.decodeTypeAnnotations(n3, true, methodInfo);
                        } else if (CharOperation.equals(cArray, AttributeNamesConstants.RuntimeInvisibleTypeAnnotationsName)) {
                            typeAnnotationInfoArray = MethodInfo.decodeTypeAnnotations(n3, false, methodInfo);
                        }
                        if (annotationInfoArray2 != null) {
                            if (classFileStructArray == null) {
                                classFileStructArray = annotationInfoArray2;
                                break;
                            }
                            n6 = classFileStructArray.length;
                            classFileStructArray3 = new AnnotationInfo[n6 + annotationInfoArray2.length];
                            System.arraycopy(classFileStructArray, 0, classFileStructArray3, 0, n6);
                            System.arraycopy(annotationInfoArray2, 0, classFileStructArray3, n6, annotationInfoArray2.length);
                            classFileStructArray = classFileStructArray3;
                            break;
                        }
                        if (annotationInfoArray3 != null) {
                            n6 = annotationInfoArray3.length;
                            if (annotationInfoArray == null) {
                                annotationInfoArray = annotationInfoArray3;
                                break;
                            }
                            int n7 = 0;
                            while (n7 < n6) {
                                int n8;
                                int n9 = n8 = annotationInfoArray3[n7] == null ? 0 : annotationInfoArray3[n7].length;
                                if (n8 > 0) {
                                    if (annotationInfoArray[n7] == null) {
                                        annotationInfoArray[n7] = annotationInfoArray3[n7];
                                    } else {
                                        int n10 = annotationInfoArray[n7].length;
                                        AnnotationInfo[] annotationInfoArray4 = new AnnotationInfo[n10 + n8];
                                        System.arraycopy(annotationInfoArray[n7], 0, annotationInfoArray4, 0, n10);
                                        System.arraycopy(annotationInfoArray3[n7], 0, annotationInfoArray4, n10, n8);
                                        annotationInfoArray[n7] = annotationInfoArray4;
                                    }
                                }
                                ++n7;
                            }
                            break;
                        }
                        if (typeAnnotationInfoArray == null) break;
                        if (classFileStructArray2 == null) {
                            classFileStructArray2 = typeAnnotationInfoArray;
                            break;
                        }
                        n6 = classFileStructArray2.length;
                        classFileStructArray3 = new TypeAnnotationInfo[n6 + typeAnnotationInfoArray.length];
                        System.arraycopy(classFileStructArray2, 0, classFileStructArray3, 0, n6);
                        System.arraycopy(typeAnnotationInfoArray, 0, classFileStructArray3, n6, typeAnnotationInfoArray.length);
                        classFileStructArray2 = classFileStructArray3;
                    }
                }
            }
            n3 = (int)((long)n3 + (6L + methodInfo.u4At(n3 + 2)));
            ++n4;
        }
        methodInfo.attributeBytes = n3;
        if (classFileStructArray2 != null) {
            return new MethodInfoWithTypeAnnotations(methodInfo, (AnnotationInfo[])classFileStructArray, annotationInfoArray, (TypeAnnotationInfo[])classFileStructArray2);
        }
        if (annotationInfoArray != null) {
            return new MethodInfoWithParameterAnnotations(methodInfo, (AnnotationInfo[])classFileStructArray, annotationInfoArray);
        }
        if (classFileStructArray != null) {
            return new MethodInfoWithAnnotations(methodInfo, (AnnotationInfo[])classFileStructArray);
        }
        return methodInfo;
    }

    static AnnotationInfo[] decodeAnnotations(int n, boolean bl, int n2, MethodInfo methodInfo) {
        AnnotationInfo[] annotationInfoArray = new AnnotationInfo[n2];
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            annotationInfoArray[n4] = new AnnotationInfo(methodInfo.reference, methodInfo.constantPoolOffsets, n3 + methodInfo.structOffset, bl, false);
            n3 += annotationInfoArray[n4].readOffset;
            ++n4;
        }
        return annotationInfoArray;
    }

    static AnnotationInfo[] decodeMethodAnnotations(int n, boolean bl, MethodInfo methodInfo) {
        int n2 = methodInfo.u2At(n + 6);
        if (n2 > 0) {
            AnnotationInfo[] annotationInfoArray = MethodInfo.decodeAnnotations(n + 8, bl, n2, methodInfo);
            if (bl) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    long l = annotationInfoArray[n4].standardAnnotationTagBits;
                    methodInfo.tagBits |= l;
                    if (l != 0L) {
                        annotationInfoArray[n4] = null;
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 != 0) {
                    if (n3 == n2) {
                        return null;
                    }
                    AnnotationInfo[] annotationInfoArray2 = new AnnotationInfo[n2 - n3];
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n2) {
                        if (annotationInfoArray[n6] != null) {
                            annotationInfoArray2[n5++] = annotationInfoArray[n6];
                        }
                        ++n6;
                    }
                    annotationInfoArray = annotationInfoArray2;
                }
            }
            return annotationInfoArray;
        }
        return null;
    }

    static TypeAnnotationInfo[] decodeTypeAnnotations(int n, boolean bl, MethodInfo methodInfo) {
        int n2 = methodInfo.u2At(n + 6);
        if (n2 > 0) {
            int n3 = n + 8;
            TypeAnnotationInfo[] typeAnnotationInfoArray = new TypeAnnotationInfo[n2];
            int n4 = 0;
            while (n4 < n2) {
                TypeAnnotationInfo typeAnnotationInfo = new TypeAnnotationInfo(methodInfo.reference, methodInfo.constantPoolOffsets, n3 + methodInfo.structOffset, bl, false);
                n3 += typeAnnotationInfo.readOffset;
                typeAnnotationInfoArray[n4] = typeAnnotationInfo;
                ++n4;
            }
            return typeAnnotationInfoArray;
        }
        return null;
    }

    static AnnotationInfo[][] decodeParamAnnotations(int n, boolean bl, MethodInfo methodInfo) {
        AnnotationInfo[][] annotationInfoArrayArray = null;
        int n2 = methodInfo.u1At(n + 6);
        if (n2 > 0) {
            int n3 = n + 7;
            int n4 = 0;
            while (n4 < n2) {
                int n5 = methodInfo.u2At(n3);
                n3 += 2;
                if (n5 > 0) {
                    if (annotationInfoArrayArray == null) {
                        annotationInfoArrayArray = new AnnotationInfo[n2][];
                    }
                    AnnotationInfo[] annotationInfoArray = MethodInfo.decodeAnnotations(n3, bl, n5, methodInfo);
                    annotationInfoArrayArray[n4] = annotationInfoArray;
                    int n6 = 0;
                    while (n6 < annotationInfoArray.length) {
                        n3 += annotationInfoArray[n6].readOffset;
                        ++n6;
                    }
                }
                ++n4;
            }
        }
        return annotationInfoArrayArray;
    }

    protected MethodInfo(byte[] byArray, int[] nArray, int n) {
        super(byArray, nArray, n);
    }

    public int compareTo(Object object) {
        MethodInfo methodInfo = (MethodInfo)object;
        int n = new String(this.getSelector()).compareTo(new String(methodInfo.getSelector()));
        if (n != 0) {
            return n;
        }
        return new String(this.getMethodDescriptor()).compareTo(new String(methodInfo.getMethodDescriptor()));
    }

    public boolean equals(Object object) {
        if (!(object instanceof MethodInfo)) {
            return false;
        }
        MethodInfo methodInfo = (MethodInfo)object;
        return CharOperation.equals(this.getSelector(), methodInfo.getSelector()) && CharOperation.equals(this.getMethodDescriptor(), methodInfo.getMethodDescriptor());
    }

    public int hashCode() {
        return CharOperation.hashCode(this.getSelector()) + CharOperation.hashCode(this.getMethodDescriptor());
    }

    public IBinaryAnnotation[] getAnnotations() {
        return null;
    }

    public char[][] getArgumentNames() {
        if (this.argumentNames == null) {
            this.readCodeAttribute();
        }
        return this.argumentNames;
    }

    public Object getDefaultValue() {
        return null;
    }

    public char[][] getExceptionTypeNames() {
        if (this.exceptionNames == null) {
            this.readExceptionAttributes();
        }
        return this.exceptionNames;
    }

    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    public char[] getMethodDescriptor() {
        if (this.descriptor == null) {
            int n = this.constantPoolOffsets[this.u2At(4)] - this.structOffset;
            this.descriptor = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.descriptor;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readModifierRelatedAttributes();
        }
        return this.accessFlags;
    }

    public IBinaryAnnotation[] getParameterAnnotations(int n) {
        return null;
    }

    public int getAnnotatedParametersCount() {
        return 0;
    }

    public IBinaryTypeAnnotation[] getTypeAnnotations() {
        return null;
    }

    public char[] getSelector() {
        if (this.name == null) {
            int n = this.constantPoolOffsets[this.u2At(2)] - this.structOffset;
            this.name = this.utf8At(n + 3, this.u2At(n + 1));
        }
        return this.name;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    protected void initialize() {
        this.getModifiers();
        this.getSelector();
        this.getMethodDescriptor();
        this.getExceptionTypeNames();
        this.getGenericSignature();
        this.getArgumentNames();
        this.reset();
    }

    public boolean isClinit() {
        char[] cArray = this.getSelector();
        return cArray[0] == '<' && cArray.length == 8;
    }

    public boolean isConstructor() {
        char[] cArray = this.getSelector();
        return cArray[0] == '<' && cArray.length == 6;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private void readExceptionAttributes() {
        int n = this.u2At(6);
        int n2 = 8;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
            char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
            if (CharOperation.equals(cArray, AttributeNamesConstants.ExceptionsName)) {
                int n5 = this.u2At(n2 + 6);
                n2 += 8;
                if (n5 == 0) {
                    this.exceptionNames = noException;
                } else {
                    this.exceptionNames = new char[n5][];
                    int n6 = 0;
                    while (n6 < n5) {
                        n4 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n2)] - this.structOffset + 1)] - this.structOffset;
                        this.exceptionNames[n6] = this.utf8At(n4 + 3, this.u2At(n4 + 1));
                        n2 += 2;
                        ++n6;
                    }
                }
            } else {
                n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
            }
            ++n3;
        }
        if (this.exceptionNames == null) {
            this.exceptionNames = noException;
        }
    }

    private void readModifierRelatedAttributes() {
        int n = this.u2At(6);
        int n2 = 8;
        int n3 = 0;
        while (n3 < n) {
            int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
            char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
            if (cArray.length != 0) {
                switch (cArray[0]) {
                    case 'D': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.SyntheticName)) break;
                        this.accessFlags |= 0x1000;
                        break;
                    }
                    case 'A': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.AnnotationDefaultName)) break;
                        this.accessFlags |= 0x20000;
                        break;
                    }
                    case 'V': {
                        if (!CharOperation.equals(cArray, AttributeNamesConstants.VarargsName)) break;
                        this.accessFlags |= 0x80;
                    }
                }
            }
            n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
            ++n3;
        }
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getClass().getName());
        this.toStringContent(stringBuffer);
    }

    protected void toStringContent(StringBuffer stringBuffer) {
        int n = this.getModifiers();
        char[] cArray = this.getGenericSignature();
        if (cArray == null) {
            cArray = this.getMethodDescriptor();
        }
        stringBuffer.append('{').append(String.valueOf((n & 0x100000) != 0 ? "deprecated " : Util.EMPTY_STRING) + ((n & 1) == 1 ? "public " : Util.EMPTY_STRING) + ((n & 2) == 2 ? "private " : Util.EMPTY_STRING) + ((n & 4) == 4 ? "protected " : Util.EMPTY_STRING) + ((n & 8) == 8 ? "static " : Util.EMPTY_STRING) + ((n & 0x10) == 16 ? "final " : Util.EMPTY_STRING) + ((n & 0x40) == 64 ? "bridge " : Util.EMPTY_STRING) + ((n & 0x80) == 128 ? "varargs " : Util.EMPTY_STRING)).append(this.getSelector()).append(cArray).append('}');
    }

    private void readCodeAttribute() {
        int n = this.u2At(6);
        int n2 = 8;
        if (n != 0) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.structOffset;
                char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
                if (CharOperation.equals(cArray, AttributeNamesConstants.CodeName)) {
                    this.decodeCodeAttribute(n2);
                    if (this.argumentNames == null) {
                        this.argumentNames = noArgumentNames;
                    }
                    return;
                }
                n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
                ++n3;
            }
        }
        this.argumentNames = noArgumentNames;
    }

    private void decodeCodeAttribute(int n) {
        int n2;
        int n3 = n + 10;
        int n4 = (int)this.u4At(n3);
        int n5 = this.u2At(n3 += 4 + n4);
        n3 += 2;
        if (n5 != 0) {
            n2 = 0;
            while (n2 < n5) {
                n3 += 8;
                ++n2;
            }
        }
        n2 = this.u2At(n3);
        n3 += 2;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = this.constantPoolOffsets[this.u2At(n3)] - this.structOffset;
            char[] cArray = this.utf8At(n7 + 3, this.u2At(n7 + 1));
            if (CharOperation.equals(cArray, AttributeNamesConstants.LocalVariableTableName)) {
                this.decodeLocalVariableAttribute(n3, n4);
            }
            n3 = (int)((long)n3 + (6L + this.u4At(n3 + 2)));
            ++n6;
        }
    }

    private void decodeLocalVariableAttribute(int n, int n2) {
        int n3 = n + 6;
        int n4 = this.u2At(n3);
        if (n4 != 0) {
            n3 += 2;
            this.argumentNames = new char[n4][];
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                int n7 = this.u2At(n3);
                if (n7 != 0) break;
                int n8 = this.u2At(4 + n3);
                int n9 = this.constantPoolOffsets[n8] - this.structOffset;
                char[] cArray = this.utf8At(n9 + 3, this.u2At(n9 + 1));
                if (!CharOperation.equals(cArray, ConstantPool.This)) {
                    this.argumentNames[n5++] = cArray;
                }
                n3 += 10;
                ++n6;
            }
            if (n5 != this.argumentNames.length) {
                char[][] cArrayArray = new char[n5][];
                this.argumentNames = cArrayArray;
                System.arraycopy(this.argumentNames, 0, cArrayArray, 0, n5);
            }
        }
    }

    private void decodeMethodParameters(int n, MethodInfo methodInfo) {
        int n2 = n + 6;
        int n3 = this.u1At(n2);
        if (n3 != 0) {
            ++n2;
            this.argumentNames = new char[n3][];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.u2At(n2);
                if (n5 != 0) {
                    int n6 = this.constantPoolOffsets[n5] - this.structOffset;
                    char[] cArray = this.utf8At(n6 + 3, this.u2At(n6 + 1));
                    this.argumentNames[n4] = cArray;
                } else {
                    this.argumentNames[n4] = CharOperation.concat(ARG, String.valueOf(n4).toCharArray());
                }
                n2 += 4;
                ++n4;
            }
        }
    }
}

