/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocSingleTypeReference
extends SingleTypeReference {
    public int tagSourceStart;
    public int tagSourceEnd;
    public PackageBinding packageBinding;

    public JavadocSingleTypeReference(char[] cArray, long l, int n, int n2) {
        super(cArray, l);
        this.tagSourceStart = n;
        this.tagSourceEnd = n2;
        this.bits |= 0x8000;
    }

    protected TypeBinding internalResolveType(Scope scope, int n) {
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            if (this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            switch (this.resolvedType.problemId()) {
                case 1: 
                case 2: 
                case 5: {
                    TypeBinding typeBinding = this.resolvedType.closestMatch();
                    return typeBinding;
                }
            }
            return null;
        }
        this.resolvedType = this.getTypeBinding(scope);
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.isValidBinding()) {
            char[][] cArrayArray = new char[][]{this.token};
            Binding binding = scope.getTypeOrPackage(cArrayArray);
            if (binding instanceof PackageBinding) {
                this.packageBinding = (PackageBinding)binding;
            } else {
                TypeBinding typeBinding;
                if (this.resolvedType.problemId() == 7 && (typeBinding = this.resolvedType.closestMatch()) != null && typeBinding.isTypeVariable()) {
                    this.resolvedType = typeBinding;
                    return this.resolvedType;
                }
                this.reportInvalidType(scope);
            }
            return null;
        }
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(this.resolvedType, scope);
        }
        if (this.resolvedType.isGenericType() || this.resolvedType.isParameterizedType()) {
            this.resolvedType = scope.environment().convertToRawType(this.resolvedType, true);
        }
        return this.resolvedType;
    }

    protected void reportDeprecatedType(TypeBinding typeBinding, Scope scope) {
        scope.problemReporter().javadocDeprecatedType(typeBinding, this, scope.getDeclarationModifiers());
    }

    protected void reportInvalidType(Scope scope) {
        scope.problemReporter().javadocInvalidType(this, this.resolvedType, scope.getDeclarationModifiers());
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

