/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocMessageSend
extends MessageSend {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;

    public JavadocMessageSend(char[] cArray, long l) {
        this.selector = cArray;
        this.nameSourcePosition = l;
        this.sourceStart = (int)(this.nameSourcePosition >>> 32);
        this.sourceEnd = (int)this.nameSourcePosition;
        this.bits |= 0x8000;
    }

    public JavadocMessageSend(char[] cArray, long l, JavadocArgumentExpression[] javadocArgumentExpressionArray) {
        this(cArray, l);
        this.arguments = javadocArgumentExpressionArray;
    }

    private TypeBinding internalResolveType(Scope scope) {
        MethodBinding methodBinding;
        Object object;
        this.constant = Constant.NotAConstant;
        this.actualReceiverType = this.receiver == null ? scope.enclosingReceiverType() : (scope.kind == 3 ? this.receiver.resolveType((ClassScope)scope) : this.receiver.resolveType((BlockScope)scope));
        boolean bl = false;
        if (this.arguments != null) {
            this.argumentsHaveErrors = false;
            int n = this.arguments.length;
            this.argumentTypes = new TypeBinding[n];
            int n2 = 0;
            while (n2 < n) {
                object = this.arguments[n2];
                this.argumentTypes[n2] = scope.kind == 3 ? ((Expression)object).resolveType((ClassScope)scope) : ((Expression)object).resolveType((BlockScope)scope);
                if (this.argumentTypes[n2] == null) {
                    this.argumentsHaveErrors = true;
                } else if (!bl) {
                    bl = this.argumentTypes[n2].isTypeVariable();
                }
                ++n2;
            }
            if (this.argumentsHaveErrors) {
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        this.actualReceiverType = scope.environment().convertToRawType(this.receiver.resolvedType, true);
        ReferenceBinding referenceBinding = scope.enclosingReceiverType();
        if (referenceBinding != null && referenceBinding.isCompatibleWith(this.actualReceiverType)) {
            this.bits |= 0x4000;
        }
        if (this.actualReceiverType.isBaseType()) {
            scope.problemReporter().javadocErrorNoMethodFor(this, this.actualReceiverType, this.argumentTypes, scope.getDeclarationModifiers());
            return null;
        }
        this.binding = scope.getMethod(this.actualReceiverType, this.selector, this.argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            TypeBinding typeBinding = this.actualReceiverType;
            object = this.binding;
            while (!((Binding)object).isValidBinding() && (typeBinding.isMemberType() || typeBinding.isLocalType())) {
                typeBinding = typeBinding.enclosingType();
                object = scope.getMethod(typeBinding, this.selector, this.argumentTypes, this);
            }
            if (((Binding)object).isValidBinding()) {
                this.binding = object;
            } else {
                typeBinding = this.actualReceiverType;
                methodBinding = this.binding;
                if (!methodBinding.isValidBinding() && CharOperation.equals(this.selector, typeBinding.shortReadableName())) {
                    methodBinding = scope.getConstructor((ReferenceBinding)typeBinding, this.argumentTypes, this);
                }
                while (!methodBinding.isValidBinding() && (typeBinding.isMemberType() || typeBinding.isLocalType())) {
                    if (!CharOperation.equals(this.selector, (typeBinding = typeBinding.enclosingType()).shortReadableName())) continue;
                    methodBinding = scope.getConstructor((ReferenceBinding)typeBinding, this.argumentTypes, this);
                }
                if (methodBinding.isValidBinding()) {
                    this.binding = methodBinding;
                }
            }
        }
        if (!this.binding.isValidBinding()) {
            switch (this.binding.problemId()) {
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    MethodBinding methodBinding2 = ((ProblemMethodBinding)this.binding).closestMatch;
                    if (methodBinding2 == null) break;
                    this.binding = methodBinding2;
                }
            }
        }
        if (!this.binding.isValidBinding()) {
            MethodBinding methodBinding3;
            if (this.receiver.resolvedType instanceof ProblemReferenceBinding) {
                return null;
            }
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    scope.problemReporter().javadocErrorNoMethodFor(this, this.actualReceiverType, this.argumentTypes, scope.getDeclarationModifiers());
                    return null;
                }
            }
            scope.problemReporter().javadocInvalidMethod(this, this.binding, scope.getDeclarationModifiers());
            if (this.binding instanceof ProblemMethodBinding && (methodBinding3 = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                this.binding = methodBinding3;
            }
            this.resolvedType = this.binding == null ? null : this.binding.returnType;
            return this.resolvedType;
        }
        if (bl) {
            ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(this.binding, this.selector, this.argumentTypes, 1);
            scope.problemReporter().javadocInvalidMethod(this, problemMethodBinding, scope.getDeclarationModifiers());
        } else if (this.binding.isVarargs()) {
            int n = this.argumentTypes.length;
            if (this.binding.parameters.length != n || !this.argumentTypes[n - 1].isArrayType()) {
                object = new ProblemMethodBinding(this.binding, this.selector, this.argumentTypes, 1);
                scope.problemReporter().javadocInvalidMethod(this, (MethodBinding)object, scope.getDeclarationModifiers());
            }
        } else {
            int n = this.argumentTypes.length;
            int n3 = 0;
            while (n3 < n) {
                if (TypeBinding.notEquals(this.binding.parameters[n3].erasure(), this.argumentTypes[n3].erasure())) {
                    methodBinding = new ProblemMethodBinding(this.binding, this.selector, this.argumentTypes, 1);
                    scope.problemReporter().javadocInvalidMethod(this, methodBinding, scope.getDeclarationModifiers());
                    break;
                }
                ++n3;
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope, true)) {
            scope.problemReporter().javadocDeprecatedMethod(this.binding, this, scope.getDeclarationModifiers());
        }
        this.resolvedType = this.binding.returnType;
        return this.resolvedType;
    }

    public boolean isSuperAccess() {
        return (this.bits & 0x4000) != 0;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.receiver != null) {
            this.receiver.printExpression(0, stringBuffer);
        }
        stringBuffer.append('#').append(this.selector).append('(');
        if (this.arguments != null) {
            int n2 = 0;
            while (n2 < this.arguments.length) {
                if (n2 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n2].printExpression(0, stringBuffer);
                ++n2;
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return this.internalResolveType(blockScope);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.receiver != null) {
                this.receiver.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                int n = this.arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.receiver != null) {
                this.receiver.traverse(aSTVisitor, classScope);
            }
            if (this.arguments != null) {
                int n = this.arguments.length;
                int n2 = 0;
                while (n2 < n) {
                    this.arguments[n2].traverse(aSTVisitor, classScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

