/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class BinaryExpression
extends OperatorExpression {
    public Expression left;
    public Expression right;
    public Constant optimizedBooleanConstant;

    public BinaryExpression(Expression expression, Expression expression2, int n) {
        this.left = expression;
        this.right = expression2;
        this.bits |= n << 6;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = expression2.sourceEnd;
    }

    public BinaryExpression(BinaryExpression binaryExpression) {
        this.left = binaryExpression.left;
        this.right = binaryExpression.right;
        this.bits = binaryExpression.bits;
        this.sourceStart = binaryExpression.sourceStart;
        this.sourceEnd = binaryExpression.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            if (this.resolvedType.id == 11) {
                UnconditionalFlowInfo unconditionalFlowInfo = this.right.analyseCode(blockScope, flowContext, this.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
                return unconditionalFlowInfo;
            }
            this.left.checkNPE(blockScope, flowContext, flowInfo);
            flowInfo = this.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            if ((this.bits & 0xFC0) >> 6 != 2) {
                flowContext.expireNullCheckedFieldInfo();
            }
            this.right.checkNPE(blockScope, flowContext, flowInfo);
            flowInfo = this.right.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
            if ((this.bits & 0xFC0) >> 6 != 2) {
                flowContext.expireNullCheckedFieldInfo();
            }
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            flowContext.recordAbruptExit();
        }
    }

    public void computeConstant(BlockScope blockScope, int n, int n2) {
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            try {
                this.constant = Constant.computeConstantOperation(this.left.constant, n, (this.bits & 0xFC0) >> 6, this.right.constant, n2);
            }
            catch (ArithmeticException arithmeticException) {
                this.constant = Constant.NotAConstant;
            }
        } else {
            this.constant = Constant.NotAConstant;
            this.optimizedBooleanConstant(n, (this.bits & 0xFC0) >> 6, n2);
        }
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        switch ((this.bits & 0xFC0) >> 6) {
            case 14: {
                switch (this.bits & 0xF) {
                    case 11: {
                        codeStream.generateStringConcatenationAppend(blockScope, this.left, this.right);
                        if (bl) break;
                        codeStream.pop();
                        break;
                    }
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.iadd();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.ladd();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.dadd();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.fadd();
                    }
                }
                break;
            }
            case 13: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.isub();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.lsub();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.dsub();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.fsub();
                    }
                }
                break;
            }
            case 15: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.imul();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.lmul();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.dmul();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.fmul();
                    }
                }
                break;
            }
            case 9: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.idiv();
                        if (bl) break;
                        codeStream.pop();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.ldiv();
                        if (bl) break;
                        codeStream.pop2();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.ddiv();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.fdiv();
                    }
                }
                break;
            }
            case 16: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.irem();
                        if (bl) break;
                        codeStream.pop();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.lrem();
                        if (bl) break;
                        codeStream.pop2();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.drem();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.frem();
                    }
                }
                break;
            }
            case 2: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(blockScope, codeStream, false);
                            if (!bl) break;
                            codeStream.iconst_0();
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(blockScope, codeStream, false);
                            if (!bl) break;
                            codeStream.iconst_0();
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.iand();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(blockScope, codeStream, false);
                            if (!bl) break;
                            codeStream.lconst_0();
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(blockScope, codeStream, false);
                            if (!bl) break;
                            codeStream.lconst_0();
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.land();
                        break;
                    }
                    case 5: {
                        this.generateLogicalAnd(blockScope, codeStream, bl);
                    }
                }
                break;
            }
            case 3: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.ior();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.lor();
                        break;
                    }
                    case 5: {
                        this.generateLogicalOr(blockScope, codeStream, bl);
                    }
                }
                break;
            }
            case 8: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.ixor();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(blockScope, codeStream, bl);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.lxor();
                        break;
                    }
                    case 5: {
                        this.generateLogicalXor(blockScope, codeStream, bl);
                    }
                }
                break;
            }
            case 10: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.ishl();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.lshl();
                    }
                }
                break;
            }
            case 17: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.ishr();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.lshr();
                    }
                }
                break;
            }
            case 19: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.iushr();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl);
                        this.right.generateCode(blockScope, codeStream, bl);
                        if (!bl) break;
                        codeStream.lushr();
                    }
                }
                break;
            }
            case 6: {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                this.generateOptimizedGreaterThan(blockScope, codeStream, null, branchLabel, bl);
                if (!bl) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    branchLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                BranchLabel branchLabel2 = new BranchLabel(codeStream);
                codeStream.goto_(branchLabel2);
                codeStream.decrStackSize(1);
                branchLabel.place();
                codeStream.iconst_0();
                branchLabel2.place();
                break;
            }
            case 7: {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                this.generateOptimizedGreaterThanOrEqual(blockScope, codeStream, null, branchLabel, bl);
                if (!bl) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    branchLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                BranchLabel branchLabel3 = new BranchLabel(codeStream);
                codeStream.goto_(branchLabel3);
                codeStream.decrStackSize(1);
                branchLabel.place();
                codeStream.iconst_0();
                branchLabel3.place();
                break;
            }
            case 4: {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                this.generateOptimizedLessThan(blockScope, codeStream, null, branchLabel, bl);
                if (!bl) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    branchLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                BranchLabel branchLabel4 = new BranchLabel(codeStream);
                codeStream.goto_(branchLabel4);
                codeStream.decrStackSize(1);
                branchLabel.place();
                codeStream.iconst_0();
                branchLabel4.place();
                break;
            }
            case 5: {
                BranchLabel branchLabel = new BranchLabel(codeStream);
                this.generateOptimizedLessThanOrEqual(blockScope, codeStream, null, branchLabel, bl);
                if (!bl) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    branchLabel.place();
                    codeStream.iconst_0();
                    break;
                }
                BranchLabel branchLabel5 = new BranchLabel(codeStream);
                codeStream.goto_(branchLabel5);
                codeStream.decrStackSize(1);
                branchLabel.place();
                codeStream.iconst_0();
                branchLabel5.place();
            }
        }
        if (bl) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5) {
            super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
            return;
        }
        switch ((this.bits & 0xFC0) >> 6) {
            case 4: {
                this.generateOptimizedLessThan(blockScope, codeStream, branchLabel, branchLabel2, bl);
                return;
            }
            case 5: {
                this.generateOptimizedLessThanOrEqual(blockScope, codeStream, branchLabel, branchLabel2, bl);
                return;
            }
            case 6: {
                this.generateOptimizedGreaterThan(blockScope, codeStream, branchLabel, branchLabel2, bl);
                return;
            }
            case 7: {
                this.generateOptimizedGreaterThanOrEqual(blockScope, codeStream, branchLabel, branchLabel2, bl);
                return;
            }
            case 2: {
                this.generateOptimizedLogicalAnd(blockScope, codeStream, branchLabel, branchLabel2, bl);
                return;
            }
            case 3: {
                this.generateOptimizedLogicalOr(blockScope, codeStream, branchLabel, branchLabel2, bl);
                return;
            }
            case 8: {
                this.generateOptimizedLogicalXor(blockScope, codeStream, branchLabel, branchLabel2, bl);
                return;
            }
        }
        super.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
    }

    public void generateOptimizedGreaterThan(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        int n = (this.left.implicitConversion & 0xFF) >> 4;
        if (n == 10) {
            if (this.left.constant != Constant.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.iflt(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.ifge(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
            if (this.right.constant != Constant.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.ifgt(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.ifle(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    switch (n) {
                        case 10: {
                            codeStream.if_icmpgt(branchLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifgt(branchLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifgt(branchLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifgt(branchLabel);
                        }
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                    return;
                }
            } else if (branchLabel == null) {
                switch (n) {
                    case 10: {
                        codeStream.if_icmple(branchLabel2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifle(branchLabel2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifle(branchLabel2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifle(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
    }

    public void generateOptimizedGreaterThanOrEqual(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        int n = (this.left.implicitConversion & 0xFF) >> 4;
        if (n == 10) {
            if (this.left.constant != Constant.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.ifle(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.ifgt(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
            if (this.right.constant != Constant.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.ifge(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.iflt(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    switch (n) {
                        case 10: {
                            codeStream.if_icmpge(branchLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifge(branchLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifge(branchLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifge(branchLabel);
                        }
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                    return;
                }
            } else if (branchLabel == null) {
                switch (n) {
                    case 10: {
                        codeStream.if_icmplt(branchLabel2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.iflt(branchLabel2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.iflt(branchLabel2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.iflt(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
    }

    public void generateOptimizedLessThan(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        int n = (this.left.implicitConversion & 0xFF) >> 4;
        if (n == 10) {
            if (this.left.constant != Constant.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.ifgt(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.ifle(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
            if (this.right.constant != Constant.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.iflt(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.ifge(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    switch (n) {
                        case 10: {
                            codeStream.if_icmplt(branchLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpg();
                            codeStream.iflt(branchLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.iflt(branchLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpg();
                            codeStream.iflt(branchLabel);
                        }
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                    return;
                }
            } else if (branchLabel == null) {
                switch (n) {
                    case 10: {
                        codeStream.if_icmpge(branchLabel2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpg();
                        codeStream.ifge(branchLabel2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifge(branchLabel2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpg();
                        codeStream.ifge(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
    }

    public void generateOptimizedLessThanOrEqual(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        int n = (this.left.implicitConversion & 0xFF) >> 4;
        if (n == 10) {
            if (this.left.constant != Constant.NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.ifge(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.iflt(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
            if (this.right.constant != Constant.NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl);
                if (bl) {
                    if (branchLabel2 == null) {
                        if (branchLabel != null) {
                            codeStream.ifle(branchLabel);
                        }
                    } else if (branchLabel == null) {
                        codeStream.ifgt(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    switch (n) {
                        case 10: {
                            codeStream.if_icmple(branchLabel);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpg();
                            codeStream.ifle(branchLabel);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifle(branchLabel);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpg();
                            codeStream.ifle(branchLabel);
                        }
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                    return;
                }
            } else if (branchLabel == null) {
                switch (n) {
                    case 10: {
                        codeStream.if_icmpgt(branchLabel2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpg();
                        codeStream.ifgt(branchLabel2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifgt(branchLabel2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpg();
                        codeStream.ifgt(branchLabel2);
                    }
                }
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                return;
            }
        }
    }

    public void generateLogicalAnd(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateCode(blockScope, codeStream, false);
                    this.right.generateCode(blockScope, codeStream, bl);
                } else {
                    this.left.generateCode(blockScope, codeStream, false);
                    this.right.generateCode(blockScope, codeStream, false);
                    if (bl) {
                        codeStream.iconst_0();
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateCode(blockScope, codeStream, bl);
                    this.right.generateCode(blockScope, codeStream, false);
                } else {
                    this.left.generateCode(blockScope, codeStream, false);
                    this.right.generateCode(blockScope, codeStream, false);
                    if (bl) {
                        codeStream.iconst_0();
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            codeStream.iand();
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
    }

    public void generateLogicalOr(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateCode(blockScope, codeStream, false);
                    this.right.generateCode(blockScope, codeStream, false);
                    if (bl) {
                        codeStream.iconst_1();
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                } else {
                    this.left.generateCode(blockScope, codeStream, false);
                    this.right.generateCode(blockScope, codeStream, bl);
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateCode(blockScope, codeStream, false);
                    this.right.generateCode(blockScope, codeStream, false);
                    if (bl) {
                        codeStream.iconst_1();
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                } else {
                    this.left.generateCode(blockScope, codeStream, bl);
                    this.right.generateCode(blockScope, codeStream, false);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            codeStream.ior();
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
    }

    public void generateLogicalXor(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateCode(blockScope, codeStream, false);
                    if (bl) {
                        codeStream.iconst_1();
                    }
                    this.right.generateCode(blockScope, codeStream, bl);
                    if (bl) {
                        codeStream.ixor();
                        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                    }
                } else {
                    this.left.generateCode(blockScope, codeStream, false);
                    this.right.generateCode(blockScope, codeStream, bl);
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateCode(blockScope, codeStream, bl);
                    this.right.generateCode(blockScope, codeStream, false);
                    if (bl) {
                        codeStream.iconst_1();
                        codeStream.ixor();
                        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                    }
                } else {
                    this.left.generateCode(blockScope, codeStream, bl);
                    this.right.generateCode(blockScope, codeStream, false);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            codeStream.ixor();
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
    }

    public void generateOptimizedLogicalAnd(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    if (bl && branchLabel2 != null) {
                        codeStream.goto_(branchLabel2);
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                } else {
                    BranchLabel branchLabel3 = new BranchLabel(codeStream);
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel3, branchLabel2, false);
                    branchLabel3.place();
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    if (bl && branchLabel2 != null) {
                        codeStream.goto_(branchLabel2);
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            codeStream.iand();
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    codeStream.ifne(branchLabel);
                }
            } else if (branchLabel == null) {
                codeStream.ifeq(branchLabel2);
            }
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
    }

    public void generateOptimizedLogicalOr(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    BranchLabel branchLabel3 = new BranchLabel(codeStream);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel3, false);
                    branchLabel3.place();
                    if (bl && branchLabel != null) {
                        codeStream.goto_(branchLabel);
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    BranchLabel branchLabel4 = new BranchLabel(codeStream);
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel4, false);
                    branchLabel4.place();
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    if (bl && branchLabel != null) {
                        codeStream.goto_(branchLabel);
                    }
                    codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            codeStream.ior();
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    codeStream.ifne(branchLabel);
                }
            } else if (branchLabel == null) {
                codeStream.ifeq(branchLabel2);
            }
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
    }

    public void generateOptimizedLogicalXor(BlockScope blockScope, CodeStream codeStream, BranchLabel branchLabel, BranchLabel branchLabel2, boolean bl) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel2, branchLabel, bl);
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != Constant.NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel2, branchLabel, bl);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, bl);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, branchLabel, branchLabel2, false);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl);
        this.right.generateCode(blockScope, codeStream, bl);
        if (bl) {
            codeStream.ixor();
            if (branchLabel2 == null) {
                if (branchLabel != null) {
                    codeStream.ifne(branchLabel);
                }
            } else if (branchLabel == null) {
                codeStream.ifeq(branchLabel2);
            }
        }
        codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd);
    }

    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int n) {
        if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != Constant.NotAConstant) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                codeStream.invokeStringConcatenationAppendForType(this.implicitConversion & 0xF);
            } else {
                int n2 = codeStream.position;
                this.left.generateOptimizedStringConcatenation(blockScope, codeStream, this.left.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n2, this.left.sourceStart);
                n2 = codeStream.position;
                this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n2, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringConcatenation(blockScope, codeStream, n);
        }
    }

    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int n) {
        if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != Constant.NotAConstant) {
                codeStream.newStringContatenation();
                codeStream.dup();
                codeStream.ldc(this.constant.stringValue());
                codeStream.invokeStringConcatenationStringConstructor();
            } else {
                int n2 = codeStream.position;
                this.left.generateOptimizedStringConcatenationCreation(blockScope, codeStream, this.left.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n2, this.left.sourceStart);
                n2 = codeStream.position;
                this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n2, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringConcatenationCreation(blockScope, codeStream, n);
        }
    }

    public boolean isCompactableOperation() {
        return true;
    }

    void nonRecursiveResolveTypeUpwards(BlockScope blockScope) {
        boolean bl;
        TypeBinding typeBinding = this.left.resolvedType;
        boolean bl2 = this.right instanceof CastExpression;
        if (bl2) {
            this.right.bits |= 0x20;
        }
        TypeBinding typeBinding2 = this.right.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            this.constant = Constant.NotAConstant;
            return;
        }
        int n = typeBinding.id;
        int n2 = typeBinding2.id;
        boolean bl3 = bl = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        if (bl) {
            if (!typeBinding.isBaseType() && n2 != 11 && n2 != 12) {
                n = blockScope.environment().computeBoxingType((TypeBinding)typeBinding).id;
            }
            if (!typeBinding2.isBaseType() && n != 11 && n != 12) {
                n2 = blockScope.environment().computeBoxingType((TypeBinding)typeBinding2).id;
            }
        }
        if (n > 15 || n2 > 15) {
            if (n == 11) {
                n2 = 1;
            } else if (n2 == 11) {
                n = 1;
            } else {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding, typeBinding2);
                return;
            }
        }
        if ((this.bits & 0xFC0) >> 6 == 14) {
            if (n == 11) {
                this.left.computeConversion(blockScope, typeBinding, typeBinding);
                if (typeBinding2.isArrayType() && TypeBinding.equalsEquals(((ArrayBinding)typeBinding2).elementsType(), TypeBinding.CHAR)) {
                    blockScope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.right);
                }
            }
            if (n2 == 11) {
                this.right.computeConversion(blockScope, typeBinding2, typeBinding2);
                if (typeBinding.isArrayType() && TypeBinding.equalsEquals(((ArrayBinding)typeBinding).elementsType(), TypeBinding.CHAR)) {
                    blockScope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.left);
                }
            }
        }
        int n3 = (this.bits & 0xFC0) >> 6;
        int n4 = OperatorExpression.OperatorSignatures[n3][(n << 4) + n2];
        this.left.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 16 & 0xF), typeBinding);
        this.right.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 8 & 0xF), typeBinding2);
        this.bits |= n4 & 0xF;
        switch (n4 & 0xF) {
            case 5: {
                this.resolvedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                this.resolvedType = TypeBinding.BYTE;
                break;
            }
            case 2: {
                this.resolvedType = TypeBinding.CHAR;
                break;
            }
            case 8: {
                this.resolvedType = TypeBinding.DOUBLE;
                break;
            }
            case 9: {
                this.resolvedType = TypeBinding.FLOAT;
                break;
            }
            case 10: {
                this.resolvedType = TypeBinding.INT;
                break;
            }
            case 7: {
                this.resolvedType = TypeBinding.LONG;
                break;
            }
            case 11: {
                this.resolvedType = blockScope.getJavaLangString();
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding, typeBinding2);
                return;
            }
        }
        boolean bl4 = this.left instanceof CastExpression;
        if (bl4 || bl2) {
            CastExpression.checkNeedForArgumentCasts(blockScope, n3, n4, this.left, n, bl4, this.right, n2, bl2);
        }
        this.computeConstant(blockScope, n, n2);
    }

    public void optimizedBooleanConstant(int n, int n2, int n3) {
        switch (n2) {
            case 2: {
                if (n != 5 || n3 != 5) {
                    return;
                }
            }
            case 0: {
                Constant constant = this.left.optimizedBooleanConstant();
                if (constant != Constant.NotAConstant) {
                    if (!constant.booleanValue()) {
                        this.optimizedBooleanConstant = constant;
                        return;
                    }
                    constant = this.right.optimizedBooleanConstant();
                    if (constant != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = constant;
                    }
                    return;
                }
                constant = this.right.optimizedBooleanConstant();
                if (constant != Constant.NotAConstant && !constant.booleanValue()) {
                    this.optimizedBooleanConstant = constant;
                }
                return;
            }
            case 3: {
                if (n != 5 || n3 != 5) {
                    return;
                }
            }
            case 1: {
                Constant constant = this.left.optimizedBooleanConstant();
                if (constant != Constant.NotAConstant) {
                    if (constant.booleanValue()) {
                        this.optimizedBooleanConstant = constant;
                        return;
                    }
                    constant = this.right.optimizedBooleanConstant();
                    if (constant != Constant.NotAConstant) {
                        this.optimizedBooleanConstant = constant;
                    }
                    return;
                }
                constant = this.right.optimizedBooleanConstant();
                if (constant == Constant.NotAConstant || !constant.booleanValue()) break;
                this.optimizedBooleanConstant = constant;
            }
        }
    }

    public StringBuffer printExpressionNoParenthesis(int n, StringBuffer stringBuffer) {
        this.left.printExpression(n, stringBuffer).append(' ').append(this.operatorToString()).append(' ');
        return this.right.printExpression(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        boolean bl;
        boolean bl2 = this.left instanceof CastExpression;
        if (bl2) {
            this.left.bits |= 0x20;
        }
        TypeBinding typeBinding = this.left.resolveType(blockScope);
        boolean bl3 = this.right instanceof CastExpression;
        if (bl3) {
            this.right.bits |= 0x20;
        }
        TypeBinding typeBinding2 = this.right.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        int n = typeBinding.id;
        int n2 = typeBinding2.id;
        boolean bl4 = bl = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        if (bl) {
            if (!typeBinding.isBaseType() && n2 != 11 && n2 != 12) {
                n = blockScope.environment().computeBoxingType((TypeBinding)typeBinding).id;
            }
            if (!typeBinding2.isBaseType() && n != 11 && n != 12) {
                n2 = blockScope.environment().computeBoxingType((TypeBinding)typeBinding2).id;
            }
        }
        if (n > 15 || n2 > 15) {
            if (n == 11) {
                n2 = 1;
            } else if (n2 == 11) {
                n = 1;
            } else {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding, typeBinding2);
                return null;
            }
        }
        if ((this.bits & 0xFC0) >> 6 == 14) {
            if (n == 11) {
                this.left.computeConversion(blockScope, typeBinding, typeBinding);
                if (typeBinding2.isArrayType() && TypeBinding.equalsEquals(((ArrayBinding)typeBinding2).elementsType(), TypeBinding.CHAR)) {
                    blockScope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.right);
                }
            }
            if (n2 == 11) {
                this.right.computeConversion(blockScope, typeBinding2, typeBinding2);
                if (typeBinding.isArrayType() && TypeBinding.equalsEquals(((ArrayBinding)typeBinding).elementsType(), TypeBinding.CHAR)) {
                    blockScope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.left);
                }
            }
        }
        int n3 = (this.bits & 0xFC0) >> 6;
        int n4 = OperatorExpression.OperatorSignatures[n3][(n << 4) + n2];
        this.left.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 16 & 0xF), typeBinding);
        this.right.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 8 & 0xF), typeBinding2);
        this.bits |= n4 & 0xF;
        switch (n4 & 0xF) {
            case 5: {
                this.resolvedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                this.resolvedType = TypeBinding.BYTE;
                break;
            }
            case 2: {
                this.resolvedType = TypeBinding.CHAR;
                break;
            }
            case 8: {
                this.resolvedType = TypeBinding.DOUBLE;
                break;
            }
            case 9: {
                this.resolvedType = TypeBinding.FLOAT;
                break;
            }
            case 10: {
                this.resolvedType = TypeBinding.INT;
                break;
            }
            case 7: {
                this.resolvedType = TypeBinding.LONG;
                break;
            }
            case 11: {
                this.resolvedType = blockScope.getJavaLangString();
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding, typeBinding2);
                return null;
            }
        }
        if (bl2 || bl3) {
            CastExpression.checkNeedForArgumentCasts(blockScope, n3, n4, this.left, n, bl2, this.right, n2, bl3);
        }
        this.computeConstant(blockScope, n, n2);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.left.traverse(aSTVisitor, blockScope);
            this.right.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

