/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblemFactory
implements IProblemFactory {
    public HashtableOfInt messageTemplates;
    private Locale locale;
    private static HashtableOfInt DEFAULT_LOCALE_TEMPLATES;
    private static final char[] DOUBLE_QUOTES;
    private static final char[] SINGLE_QUOTE;
    private static final char[] FIRST_ARGUMENT;

    static {
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
        FIRST_ARGUMENT = "{0}".toCharArray();
    }

    public DefaultProblemFactory() {
        this(Locale.getDefault());
    }

    public DefaultProblemFactory(Locale locale) {
        this.setLocale(locale);
    }

    public CategorizedProblem createProblem(char[] cArray, int n, String[] stringArray, String[] stringArray2, int n2, int n3, int n4, int n5, int n6) {
        return new DefaultProblem(cArray, this.getLocalizedMessage(n, stringArray2), n, stringArray, n2, n3, n4, n5, n6);
    }

    public CategorizedProblem createProblem(char[] cArray, int n, String[] stringArray, int n2, String[] stringArray2, int n3, int n4, int n5, int n6, int n7) {
        return new DefaultProblem(cArray, this.getLocalizedMessage(n, n2, stringArray2), n, stringArray, n3, n4, n5, n6, n7);
    }

    private static final int keyFromID(int n) {
        return n + 1;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == this.locale) {
            return;
        }
        this.locale = locale;
        if (Locale.getDefault().equals(locale)) {
            if (DEFAULT_LOCALE_TEMPLATES == null) {
                DEFAULT_LOCALE_TEMPLATES = DefaultProblemFactory.loadMessageTemplates(locale);
            }
            this.messageTemplates = DEFAULT_LOCALE_TEMPLATES;
        } else {
            this.messageTemplates = DefaultProblemFactory.loadMessageTemplates(locale);
        }
    }

    public final String getLocalizedMessage(int n, String[] stringArray) {
        return this.getLocalizedMessage(n, 0, stringArray);
    }

    public final String getLocalizedMessage(int n, int n2, String[] stringArray) {
        StringBuffer stringBuffer;
        block12: {
            String string = (String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(n & 0xFFFFFF));
            if (string == null) {
                return "Unable to retrieve the error message for problem id: " + (n & 0xFFFFFF) + ". Check compiler resources.";
            }
            char[] cArray = string.toCharArray();
            if (n2 != 0) {
                String string2 = (String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(n2));
                if (string2 == null) {
                    return "Unable to retrieve the error message elaboration for elaboration id: " + n2 + ". Check compiler resources.";
                }
                cArray = CharOperation.replace(cArray, FIRST_ARGUMENT, string2.toCharArray());
            }
            cArray = CharOperation.replace(cArray, DOUBLE_QUOTES, SINGLE_QUOTE);
            if (stringArray == null) {
                return new String(cArray);
            }
            int n3 = cArray.length;
            int n4 = 0;
            int n5 = n3;
            stringBuffer = null;
            if ((n & Integer.MIN_VALUE) != 0) {
                stringBuffer = new StringBuffer(10 + n3 + stringArray.length * 20);
                stringBuffer.append((String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(514)));
            }
            while ((n5 = CharOperation.indexOf('{', cArray, n4)) > -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n3 + stringArray.length * 20);
                }
                stringBuffer.append(cArray, n4, n5 - n4);
                n4 = CharOperation.indexOf('}', cArray, n5 + 1);
                if (n4 > -1) {
                    try {
                        stringBuffer.append(stringArray[CharOperation.parseInt(cArray, n5 + 1, n4 - n5 - 1)]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(cArray, n5 + 1, n4 - n5);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return "Cannot bind message for problem (id: " + (n & 0xFFFFFF) + ") \"" + new String(cArray) + "\" with arguments: {" + Util.toString(stringArray) + "}";
                    }
                    ++n4;
                    continue;
                }
                stringBuffer.append(cArray, n5, n3);
                break block12;
            }
            if (stringBuffer == null) {
                return new String(cArray);
            }
            stringBuffer.append(cArray, n4, n3 - n4);
        }
        return new String(stringBuffer.toString());
    }

    public final String localizedMessage(CategorizedProblem categorizedProblem) {
        return this.getLocalizedMessage(categorizedProblem.getID(), categorizedProblem.getArguments());
    }

    public static HashtableOfInt loadMessageTemplates(Locale locale) {
        ResourceBundle resourceBundle = null;
        String string = "org.eclipse.jdt.internal.compiler.problem.messages";
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + string.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
        HashtableOfInt hashtableOfInt = new HashtableOfInt(700);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            try {
                int n = Integer.parseInt(string2);
                hashtableOfInt.put(DefaultProblemFactory.keyFromID(n), resourceBundle.getString(string2));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return hashtableOfInt;
    }
}

