/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ImplicitNullAnnotationVerifier;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.Sorting;

public abstract class MethodVerifier
extends ImplicitNullAnnotationVerifier {
    SourceTypeBinding type = null;
    HashtableOfObject inheritedMethods = null;
    HashtableOfObject currentMethods = null;

    MethodVerifier(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
    }

    boolean areMethodsCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.areMethodsCompatible(methodBinding, methodBinding2, this.environment);
    }

    static boolean areMethodsCompatible(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        methodBinding2 = (methodBinding = methodBinding.original()).findOriginalInheritedMethod(methodBinding2);
        if (methodBinding2 == null) {
            return false;
        }
        return MethodVerifier.isParameterSubsignature(methodBinding, methodBinding2, lookupEnvironment);
    }

    boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.areReturnTypesCompatible(methodBinding, methodBinding2, this.type.scope.environment());
    }

    public static boolean areReturnTypesCompatible(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        if (TypeBinding.equalsEquals(methodBinding.returnType, methodBinding2.returnType)) {
            return true;
        }
        if (lookupEnvironment.globalOptions.sourceLevel >= 0x310000L) {
            if (methodBinding.returnType.isBaseType()) {
                return false;
            }
            if (!methodBinding.declaringClass.isInterface() && methodBinding.declaringClass.id == 1) {
                return methodBinding2.returnType.isCompatibleWith(methodBinding.returnType);
            }
            return methodBinding.returnType.isCompatibleWith(methodBinding2.returnType);
        }
        return MethodVerifier.areTypesEqual(methodBinding.returnType.erasure(), methodBinding2.returnType.erasure());
    }

    boolean canSkipInheritedMethods() {
        if (this.type.superclass() != null && this.type.superclass().isAbstract()) {
            return false;
        }
        return this.type.superInterfaces() == Binding.NO_SUPERINTERFACES;
    }

    boolean canSkipInheritedMethods(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return methodBinding2 == null || TypeBinding.equalsEquals(methodBinding.declaringClass, methodBinding2.declaringClass);
    }

    void checkAbstractMethod(MethodBinding methodBinding) {
        if (this.mustImplementAbstractMethod(methodBinding.declaringClass)) {
            TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
            if (typeDeclaration != null) {
                MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding);
                methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding);
            }
        }
    }

    void checkAgainstInheritedMethods(MethodBinding methodBinding, MethodBinding[] methodBindingArray, int n, MethodBinding[] methodBindingArray2) {
        if (this.type.isAnnotationType()) {
            this.problemReporter().annotationCannotOverrideMethod(methodBinding, methodBindingArray[n - 1]);
            return;
        }
        CompilerOptions compilerOptions = this.type.scope.compilerOptions();
        int[] nArray = n > 1 ? this.findOverriddenInheritedMethods(methodBindingArray, n) : null;
        int n2 = n;
        block0: while (--n2 >= 0) {
            MethodBinding methodBinding2 = methodBindingArray[n2];
            if (nArray == null || nArray[n2] == 0) {
                if (methodBinding.isStatic() != methodBinding2.isStatic()) {
                    this.problemReporter(methodBinding).staticAndInstanceConflict(methodBinding, methodBinding2);
                    continue;
                }
                if (methodBinding2.isAbstract()) {
                    methodBinding.modifiers = methodBinding2.declaringClass.isInterface() ? (methodBinding.modifiers |= 0x20000000) : (methodBinding.modifiers |= 0x30000000);
                } else if (methodBinding2.isPublic() || !this.type.isInterface()) {
                    if (methodBinding.isDefaultMethod() && !methodBinding2.isFinal() && methodBinding2.declaringClass.id == 1) {
                        this.problemReporter(methodBinding).defaultMethodOverridesObjectMethod(methodBinding);
                    } else {
                        methodBinding.modifiers = methodBinding2.isDefaultMethod() ? (methodBinding.modifiers |= 0x20000000) : (methodBinding.modifiers |= 0x10000000);
                    }
                }
                if (!this.areReturnTypesCompatible(methodBinding, methodBinding2) && (methodBinding.returnType.tagBits & 0x80L) == 0L && this.reportIncompatibleReturnTypeError(methodBinding, methodBinding2)) continue;
                this.reportRawReferences(methodBinding, methodBinding2);
                if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
                    this.checkExceptions(methodBinding, methodBinding2);
                }
                if (methodBinding2.isFinal()) {
                    this.problemReporter(methodBinding).finalMethodCannotBeOverridden(methodBinding, methodBinding2);
                }
                if (!this.isAsVisible(methodBinding, methodBinding2)) {
                    this.problemReporter(methodBinding).visibilityConflict(methodBinding, methodBinding2);
                }
                if (methodBinding2.isSynchronized() && !methodBinding.isSynchronized()) {
                    this.problemReporter(methodBinding).missingSynchronizedOnInheritedMethod(methodBinding, methodBinding2);
                }
                if (compilerOptions.reportDeprecationWhenOverridingDeprecatedMethod && methodBinding2.isViewedAsDeprecated() && (!methodBinding.isViewedAsDeprecated() || compilerOptions.reportDeprecationInsideDeprecatedCode)) {
                    ReferenceBinding referenceBinding = methodBinding2.declaringClass;
                    if (referenceBinding.isInterface()) {
                        int n3 = n;
                        while (--n3 >= 0) {
                            if (n2 != n3 && methodBindingArray[n3].declaringClass.implementsInterface(referenceBinding, false)) continue block0;
                        }
                    }
                    this.problemReporter(methodBinding).overridesDeprecatedMethod(methodBinding, methodBinding2);
                }
            }
            this.checkForBridgeMethod(methodBinding, methodBinding2, methodBindingArray2);
        }
    }

    public void reportRawReferences(MethodBinding methodBinding, MethodBinding methodBinding2) {
    }

    void checkConcreteInheritedMethod(MethodBinding methodBinding, MethodBinding[] methodBindingArray) {
        int n;
        if (methodBinding.isStatic()) {
            this.problemReporter().staticInheritedMethodConflicts(this.type, methodBinding, methodBindingArray);
        }
        if (!methodBinding.isPublic()) {
            n = 0;
            int n2 = methodBindingArray.length;
            if (methodBinding.isProtected()) {
                while (n < n2) {
                    if (!methodBindingArray[n].isPublic()) {
                        ++n;
                        continue;
                    }
                    break;
                }
            } else if (methodBinding.isDefault()) {
                while (n < n2) {
                    if (methodBindingArray[n].isDefault()) {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            if (n < n2) {
                this.problemReporter().inheritedMethodReducesVisibility(this.type, methodBinding, methodBindingArray);
            }
        }
        if (methodBinding.thrownExceptions != Binding.NO_EXCEPTIONS) {
            n = methodBindingArray.length;
            while (--n >= 0) {
                this.checkExceptions(methodBinding, methodBindingArray[n]);
            }
        }
        if (methodBinding.isOrEnclosedByPrivateType()) {
            methodBinding.original().modifiers |= 0x8000000;
        }
    }

    void checkExceptions(MethodBinding methodBinding, MethodBinding methodBinding2) {
        ReferenceBinding[] referenceBindingArray = this.resolvedExceptionTypesFor(methodBinding);
        ReferenceBinding[] referenceBindingArray2 = this.resolvedExceptionTypesFor(methodBinding2);
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            ReferenceBinding referenceBinding = referenceBindingArray[n];
            int n2 = referenceBindingArray2.length;
            while (--n2 > -1 && !this.isSameClassOrSubclassOf(referenceBinding, referenceBindingArray2[n2])) {
            }
            if (n2 != -1 || referenceBinding.isUncheckedException(false) || (referenceBinding.tagBits & 0x80L) != 0L) continue;
            this.problemReporter(methodBinding).incompatibleExceptionInThrowsClause(this.type, methodBinding, methodBinding2, referenceBinding);
        }
    }

    void checkForBridgeMethod(MethodBinding methodBinding, MethodBinding methodBinding2, MethodBinding[] methodBindingArray) {
    }

    void checkForMissingHashCodeMethod() {
        MethodBinding methodBinding;
        MethodBinding[] methodBindingArray = this.type.getMethods(TypeConstants.EQUALS);
        boolean bl = false;
        int n = methodBindingArray.length;
        while (!bl && --n >= 0) {
            boolean bl2 = bl = methodBindingArray[n].parameters.length == 1 && methodBindingArray[n].parameters[0].id == 1;
        }
        if (bl && (methodBinding = this.type.getExactMethod(TypeConstants.HASHCODE, Binding.NO_PARAMETERS, null)) != null && methodBinding.declaringClass.id == 1) {
            this.problemReporter().shouldImplementHashcode(this.type);
        }
    }

    void checkForRedundantSuperinterfaces(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        TypeReference[] typeReferenceArray;
        Object[] objectArray;
        int n2;
        Object object;
        if (referenceBindingArray == Binding.NO_SUPERINTERFACES) {
            return;
        }
        SimpleSet simpleSet = new SimpleSet(referenceBindingArray.length);
        SimpleSet simpleSet2 = null;
        int n3 = 0;
        int n4 = referenceBindingArray.length;
        while (n3 < n4) {
            object = referenceBindingArray[n3];
            n2 = 0;
            while (n2 < n4) {
                block23: {
                    block25: {
                        block24: {
                            objectArray = referenceBindingArray[n2];
                            if (n3 == n2 || !((ReferenceBinding)object).implementsInterface((ReferenceBinding)objectArray, true)) break block23;
                            if (simpleSet2 != null) break block24;
                            simpleSet2 = new SimpleSet(3);
                            break block25;
                        }
                        if (simpleSet2.includes(objectArray)) break block23;
                    }
                    simpleSet2.add(objectArray);
                    typeReferenceArray = this.type.scope.referenceContext.superInterfaces;
                    int n5 = 0;
                    n = typeReferenceArray.length;
                    while (n5 < n) {
                        if (TypeBinding.equalsEquals(typeReferenceArray[n5].resolvedType, (TypeBinding)object)) {
                            this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray[n2], (ReferenceBinding)objectArray, (ReferenceBinding)object);
                            break;
                        }
                        ++n5;
                    }
                }
                ++n2;
            }
            simpleSet.add(object);
            ++n3;
        }
        ReferenceBinding[] referenceBindingArray2 = null;
        SimpleSet simpleSet3 = new SimpleSet(5);
        object = referenceBinding;
        while (object != null && ((Binding)object).isValidBinding()) {
            block26: {
                referenceBindingArray2 = ((ReferenceBinding)object).superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) break block26;
                n2 = 0;
                int n6 = referenceBindingArray2.length;
                while (n2 < n6) {
                    block21: {
                        block27: {
                            block29: {
                                block28: {
                                    typeReferenceArray = referenceBindingArray2[n2];
                                    if (simpleSet3.includes(typeReferenceArray) || !typeReferenceArray.isValidBinding()) break block21;
                                    if (!simpleSet.includes(typeReferenceArray)) break block27;
                                    if (simpleSet2 != null) break block28;
                                    simpleSet2 = new SimpleSet(3);
                                    break block29;
                                }
                                if (simpleSet2.includes(typeReferenceArray)) break block21;
                            }
                            simpleSet2.add(typeReferenceArray);
                            TypeReference[] typeReferenceArray2 = this.type.scope.referenceContext.superInterfaces;
                            n = 0;
                            int n7 = typeReferenceArray2.length;
                            while (n < n7) {
                                if (TypeBinding.equalsEquals(typeReferenceArray2[n].resolvedType, (TypeBinding)typeReferenceArray)) {
                                    this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray2[n], (ReferenceBinding)typeReferenceArray, (ReferenceBinding)object);
                                    break block21;
                                }
                                ++n;
                            }
                            break block21;
                        }
                        simpleSet3.add(typeReferenceArray);
                    }
                    ++n2;
                }
            }
            object = ((ReferenceBinding)object).superclass();
        }
        n2 = simpleSet3.elementSize;
        if (n2 == 0) {
            return;
        }
        objectArray = new ReferenceBinding[n2];
        simpleSet3.asArray(objectArray);
        int n8 = 0;
        while (n8 < n2) {
            block30: {
                object = objectArray[n8];
                referenceBindingArray2 = ((ReferenceBinding)object).superInterfaces();
                if (referenceBindingArray2 == Binding.NO_SUPERINTERFACES) break block30;
                int n9 = referenceBindingArray2.length;
                if (n2 + n9 >= objectArray.length) {
                    Object[] objectArray2 = objectArray;
                    objectArray = new ReferenceBinding[n2 + n9 + 5];
                    System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                }
                n = 0;
                while (n < n9) {
                    block22: {
                        ReferenceBinding referenceBinding2;
                        block31: {
                            block33: {
                                block32: {
                                    referenceBinding2 = referenceBindingArray2[n];
                                    if (simpleSet3.includes(referenceBinding2) || !referenceBinding2.isValidBinding()) break block22;
                                    if (!simpleSet.includes(referenceBinding2)) break block31;
                                    if (simpleSet2 != null) break block32;
                                    simpleSet2 = new SimpleSet(3);
                                    break block33;
                                }
                                if (simpleSet2.includes(referenceBinding2)) break block22;
                            }
                            simpleSet2.add(referenceBinding2);
                            TypeReference[] typeReferenceArray3 = this.type.scope.referenceContext.superInterfaces;
                            int n10 = 0;
                            int n11 = typeReferenceArray3.length;
                            while (n10 < n11) {
                                if (TypeBinding.equalsEquals(typeReferenceArray3[n10].resolvedType, referenceBinding2)) {
                                    this.problemReporter().redundantSuperInterface(this.type, typeReferenceArray3[n10], referenceBinding2, (ReferenceBinding)object);
                                    break block22;
                                }
                                ++n10;
                            }
                            break block22;
                        }
                        simpleSet3.add(referenceBinding2);
                        objectArray[n2++] = referenceBinding2;
                    }
                    ++n;
                }
            }
            ++n8;
        }
    }

    void checkInheritedMethods(MethodBinding[] methodBindingArray, int n, boolean[] blArray, boolean[] blArray2) {
        MethodBinding methodBinding;
        MethodBinding methodBinding2 = methodBinding = this.type.isInterface() || methodBindingArray[0].isAbstract() ? null : methodBindingArray[0];
        if (methodBinding == null) {
            boolean bl;
            MethodBinding methodBinding3 = n == 1 ? methodBindingArray[0] : this.findBestInheritedAbstractOrDefaultMethod(methodBindingArray, n);
            boolean bl2 = bl = methodBinding3 == null;
            if (bl) {
                methodBinding3 = methodBindingArray[0];
            }
            if (this.mustImplementAbstractMethod(methodBinding3.declaringClass)) {
                TypeDeclaration typeDeclaration = this.type.scope.referenceContext;
                MethodBinding methodBinding4 = methodBindingArray[0];
                if (methodBinding4 == methodBinding3 || methodBinding4.declaringClass.isInterface()) {
                    if (typeDeclaration != null) {
                        MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding3);
                        methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3);
                    } else {
                        this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3);
                    }
                } else if (typeDeclaration != null) {
                    MethodDeclaration methodDeclaration = typeDeclaration.addMissingAbstractMethodFor(methodBinding3);
                    methodDeclaration.scope.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3, methodBinding4);
                } else {
                    this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding3, methodBinding4);
                }
            } else if (bl) {
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n, blArray);
            }
            return;
        }
        if (n < 2) {
            return;
        }
        int n2 = n;
        while (--n2 > 0 && this.checkInheritedReturnTypes(methodBinding, methodBindingArray[n2])) {
        }
        if (n2 > 0) {
            MethodBinding methodBinding5 = this.findBestInheritedAbstractOrDefaultMethod(methodBindingArray, n);
            if (methodBinding5 == null) {
                this.problemReporter().inheritedMethodsHaveIncompatibleReturnTypes(this.type, methodBindingArray, n, blArray);
            } else {
                this.problemReporter().abstractMethodMustBeImplemented(this.type, methodBinding5, methodBinding);
            }
            return;
        }
        MethodBinding[] methodBindingArray2 = new MethodBinding[n - 1];
        n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (methodBindingArray[n3].isAbstract() || methodBindingArray[n3] != methodBinding && methodBindingArray[n3].isDefaultMethod()) {
                methodBindingArray2[n2++] = methodBindingArray[n3];
            }
            ++n3;
        }
        if (n2 == 0) {
            return;
        }
        if (n2 < methodBindingArray2.length) {
            MethodBinding[] methodBindingArray3 = methodBindingArray2;
            methodBindingArray2 = new MethodBinding[n2];
            System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, n2);
        }
        this.checkConcreteInheritedMethod(methodBinding, methodBindingArray2);
    }

    boolean checkInheritedReturnTypes(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (this.areReturnTypesCompatible(methodBinding, methodBinding2)) {
            return true;
        }
        return !(this.type.isInterface() || !methodBinding.declaringClass.isClass() && this.type.implementsInterface(methodBinding.declaringClass, false) || !methodBinding2.declaringClass.isClass() && this.type.implementsInterface(methodBinding2.declaringClass, false));
    }

    abstract void checkMethods();

    void checkPackagePrivateAbstractMethod(MethodBinding methodBinding) {
        PackageBinding packageBinding = methodBinding.declaringClass.fPackage;
        if (packageBinding == this.type.fPackage) {
            return;
        }
        ReferenceBinding referenceBinding = this.type.superclass();
        char[] cArray = methodBinding.selector;
        do {
            if (!referenceBinding.isValidBinding()) {
                return;
            }
            if (!referenceBinding.isAbstract()) {
                return;
            }
            if (packageBinding != referenceBinding.fPackage) continue;
            MethodBinding[] methodBindingArray = referenceBinding.getMethods(cArray);
            int n = methodBindingArray.length;
            while (--n >= 0) {
                MethodBinding methodBinding2 = methodBindingArray[n];
                if (methodBinding2.isPrivate() || methodBinding2.isConstructor() || methodBinding2.isDefaultAbstract() || !this.areMethodsCompatible(methodBinding2, methodBinding)) continue;
                return;
            }
        } while (TypeBinding.notEquals(referenceBinding = referenceBinding.superclass(), methodBinding.declaringClass));
        this.problemReporter().abstractMethodCannotBeOverridden(this.type, methodBinding);
    }

    void computeInheritedMethods() {
        ReferenceBinding referenceBinding = this.type.isInterface() ? this.type.scope.getJavaLangObject() : this.type.superclass();
        this.computeInheritedMethods(referenceBinding, this.type.superInterfaces());
        this.checkForRedundantSuperinterfaces(referenceBinding, this.type.superInterfaces());
    }

    void computeInheritedMethods(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        int n;
        MethodBinding[] methodBindingArray;
        int n2;
        Object object;
        Binding binding;
        MethodBinding[] methodBindingArray2;
        this.inheritedMethods = new HashtableOfObject(51);
        ReferenceBinding referenceBinding2 = referenceBinding;
        HashtableOfObject hashtableOfObject = new HashtableOfObject(3);
        while (referenceBinding2 != null && referenceBinding2.isValidBinding()) {
            methodBindingArray2 = referenceBinding2.unResolvedMethods();
            int n3 = methodBindingArray2.length;
            block1: while (--n3 >= 0) {
                MethodBinding[] methodBindingArray3;
                int n4;
                binding = methodBindingArray2[n3];
                if (((MethodBinding)binding).isPrivate() || ((MethodBinding)binding).isConstructor() || ((MethodBinding)binding).isDefaultAbstract()) continue;
                object = (MethodBinding[])this.inheritedMethods.get(((MethodBinding)binding).selector);
                if (object != null) {
                    n4 = 0;
                    n2 = ((MethodBinding[])object).length;
                    while (n4 < n2) {
                        methodBindingArray = object[n4];
                        if (TypeBinding.notEquals(methodBindingArray.declaringClass, ((MethodBinding)binding).declaringClass) && this.areMethodsCompatible((MethodBinding)methodBindingArray, (MethodBinding)binding) && !this.canOverridingMethodDifferInErasure((MethodBinding)methodBindingArray, (MethodBinding)binding)) {
                            if (!((MethodBinding)binding).isDefault()) continue block1;
                            if (((MethodBinding)binding).isAbstract()) {
                                this.checkPackagePrivateAbstractMethod((MethodBinding)binding);
                                continue block1;
                            }
                            if (methodBindingArray.declaringClass.fPackage == ((MethodBinding)binding).declaringClass.fPackage || this.type.fPackage != ((MethodBinding)binding).declaringClass.fPackage || this.areReturnTypesCompatible((MethodBinding)binding, (MethodBinding)methodBindingArray)) continue block1;
                        }
                        ++n4;
                    }
                }
                if (!((MethodBinding)binding).isDefault() || ((MethodBinding)binding).declaringClass.fPackage == this.type.fPackage) {
                    if (object == null) {
                        object = new MethodBinding[]{binding};
                    } else {
                        n4 = ((MethodBinding[])object).length;
                        Object object2 = object;
                        object = new MethodBinding[n4 + 1];
                        System.arraycopy(object2, 0, object, 0, n4);
                        object[n4] = binding;
                    }
                    this.inheritedMethods.put(((MethodBinding)binding).selector, object);
                    continue;
                }
                MethodBinding[] methodBindingArray4 = (MethodBinding[])hashtableOfObject.get(((MethodBinding)binding).selector);
                if (methodBindingArray4 != null) {
                    n2 = 0;
                    int n5 = methodBindingArray4.length;
                    while (n2 < n5) {
                        if (this.areMethodsCompatible(methodBindingArray4[n2], (MethodBinding)binding)) continue block1;
                        ++n2;
                    }
                }
                if (methodBindingArray4 == null) {
                    methodBindingArray4 = new MethodBinding[]{binding};
                } else {
                    n2 = methodBindingArray4.length;
                    MethodBinding[] methodBindingArray5 = methodBindingArray4;
                    methodBindingArray4 = new MethodBinding[n2 + 1];
                    System.arraycopy(methodBindingArray5, 0, methodBindingArray4, 0, n2);
                    methodBindingArray4[n2] = binding;
                }
                hashtableOfObject.put(((MethodBinding)binding).selector, methodBindingArray4);
                if (((MethodBinding)binding).isAbstract() && !this.type.isAbstract()) {
                    this.problemReporter().abstractMethodCannotBeOverridden(this.type, (MethodBinding)binding);
                }
                if ((methodBindingArray3 = (MethodBinding[])this.currentMethods.get(((MethodBinding)binding).selector)) == null || ((MethodBinding)binding).isStatic()) continue;
                int n6 = 0;
                n = methodBindingArray3.length;
                while (n6 < n) {
                    if (!methodBindingArray3[n6].isStatic() && this.areMethodsCompatible(methodBindingArray3[n6], (MethodBinding)binding)) {
                        this.problemReporter().overridesPackageDefaultMethod(methodBindingArray3[n6], (MethodBinding)binding);
                        continue block1;
                    }
                    ++n6;
                }
            }
            referenceBinding2 = referenceBinding2.superclass();
        }
        methodBindingArray2 = new ArrayList();
        HashSet hashSet = new HashSet();
        this.collectAllDistinctSuperInterfaces(referenceBindingArray, hashSet, (List)methodBindingArray2);
        binding = referenceBinding;
        while (binding != null && ((ReferenceBinding)binding).id != 1) {
            this.collectAllDistinctSuperInterfaces(((ReferenceBinding)binding).superInterfaces(), hashSet, (List)methodBindingArray2);
            binding = ((ReferenceBinding)binding).superclass();
        }
        if (methodBindingArray2.size() == 0) {
            return;
        }
        if (methodBindingArray2.size() == 1) {
            referenceBindingArray = new ReferenceBinding[]{(ReferenceBinding)methodBindingArray2.get(0)};
        } else {
            referenceBindingArray = methodBindingArray2.toArray(new ReferenceBinding[methodBindingArray2.size()]);
            referenceBindingArray = Sorting.sortTypes(referenceBindingArray);
        }
        object = this.findSuperinterfaceCollisions(referenceBinding, referenceBindingArray);
        int n7 = referenceBindingArray.length;
        n2 = n7 - 1;
        while (n2 >= 0) {
            referenceBinding2 = referenceBindingArray[n2];
            if (referenceBinding2.isValidBinding() && (object == null || !((SimpleSet)object).includes(referenceBinding2))) {
                methodBindingArray = referenceBinding2.unResolvedMethods();
                n = methodBindingArray.length;
                block7: while (--n >= 0) {
                    MethodBinding methodBinding = methodBindingArray[n];
                    if (methodBinding.isStatic()) continue;
                    MethodBinding[] methodBindingArray6 = (MethodBinding[])this.inheritedMethods.get(methodBinding.selector);
                    if (methodBindingArray6 == null) {
                        methodBindingArray6 = new MethodBinding[]{methodBinding};
                    } else {
                        int n8 = methodBindingArray6.length;
                        int n9 = 0;
                        while (n9 < n8) {
                            if (this.isInterfaceMethodImplemented(methodBinding, methodBindingArray6[n9], referenceBinding2) && !this.canOverridingMethodDifferInErasure(methodBindingArray6[n9], methodBinding)) continue block7;
                            ++n9;
                        }
                        MethodBinding[] methodBindingArray7 = methodBindingArray6;
                        methodBindingArray6 = new MethodBinding[n8 + 1];
                        System.arraycopy(methodBindingArray7, 0, methodBindingArray6, 0, n8);
                        methodBindingArray6[n8] = methodBinding;
                    }
                    this.inheritedMethods.put(methodBinding.selector, methodBindingArray6);
                }
            }
            --n2;
        }
    }

    void collectAllDistinctSuperInterfaces(ReferenceBinding[] referenceBindingArray, Set set, List list) {
        int n = referenceBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReferenceBinding referenceBinding = referenceBindingArray[n2];
            if (set.add(referenceBinding)) {
                list.add(referenceBinding);
                this.collectAllDistinctSuperInterfaces(referenceBinding.superInterfaces(), set, list);
            }
            ++n2;
        }
    }

    protected boolean canOverridingMethodDifferInErasure(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return false;
    }

    void computeMethods() {
        MethodBinding[] methodBindingArray = this.type.methods();
        int n = methodBindingArray.length;
        this.currentMethods = new HashtableOfObject(n == 0 ? 1 : n);
        int n2 = n;
        while (--n2 >= 0) {
            MethodBinding methodBinding = methodBindingArray[n2];
            if (methodBinding.isConstructor() || methodBinding.isDefaultAbstract()) continue;
            MethodBinding[] methodBindingArray2 = (MethodBinding[])this.currentMethods.get(methodBinding.selector);
            if (methodBindingArray2 == null) {
                methodBindingArray2 = new MethodBinding[1];
            } else {
                MethodBinding[] methodBindingArray3 = methodBindingArray2;
                methodBindingArray2 = new MethodBinding[methodBindingArray2.length + 1];
                System.arraycopy(methodBindingArray3, 0, methodBindingArray2, 0, methodBindingArray2.length - 1);
            }
            methodBindingArray2[methodBindingArray2.length - 1] = methodBinding;
            this.currentMethods.put(methodBinding.selector, methodBindingArray2);
        }
    }

    MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.computeSubstituteMethod(methodBinding, methodBinding2, this.environment);
    }

    public static MethodBinding computeSubstituteMethod(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        TypeVariableBinding[] typeVariableBindingArray;
        int n;
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding2.parameters.length != methodBinding.parameters.length) {
            return null;
        }
        if (methodBinding2.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding2.declaringClass).resolveTypesFor(methodBinding2);
        }
        if (methodBinding.declaringClass instanceof BinaryTypeBinding) {
            ((BinaryTypeBinding)methodBinding.declaringClass).resolveTypesFor(methodBinding);
        }
        if ((n = (typeVariableBindingArray = methodBinding.typeVariables).length) == 0) {
            return methodBinding;
        }
        TypeVariableBinding[] typeVariableBindingArray2 = methodBinding2.typeVariables;
        int n2 = typeVariableBindingArray2.length;
        if (n2 == 0) {
            return methodBinding.asRawMethod(lookupEnvironment);
        }
        if (n2 != n) {
            return methodBinding;
        }
        TypeBinding[] typeBindingArray = new TypeBinding[n2];
        System.arraycopy(typeVariableBindingArray2, 0, typeBindingArray, 0, n2);
        ParameterizedGenericMethodBinding parameterizedGenericMethodBinding = lookupEnvironment.createParameterizedGenericMethod(methodBinding, typeBindingArray);
        int n3 = 0;
        while (n3 < n) {
            block17: {
                TypeVariableBinding typeVariableBinding;
                TypeVariableBinding typeVariableBinding2;
                block16: {
                    block15: {
                        typeVariableBinding2 = typeVariableBindingArray[n3];
                        typeVariableBinding = (TypeVariableBinding)typeBindingArray[n3];
                        if (!TypeBinding.equalsEquals(typeVariableBinding.firstBound, typeVariableBinding2.firstBound)) break block15;
                        if (typeVariableBinding.firstBound != null) break block16;
                        break block17;
                    }
                    if (typeVariableBinding.firstBound != null && typeVariableBinding2.firstBound != null && typeVariableBinding.firstBound.isClass() != typeVariableBinding2.firstBound.isClass()) {
                        return methodBinding;
                    }
                }
                if (TypeBinding.notEquals(Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding2.superclass), typeVariableBinding.superclass)) {
                    return methodBinding;
                }
                int n4 = typeVariableBinding2.superInterfaces.length;
                ReferenceBinding[] referenceBindingArray = typeVariableBinding.superInterfaces;
                if (n4 != referenceBindingArray.length) {
                    return methodBinding;
                }
                int n5 = 0;
                while (n5 < n4) {
                    block14: {
                        TypeBinding typeBinding = Scope.substitute((Substitution)parameterizedGenericMethodBinding, typeVariableBinding2.superInterfaces[n5]);
                        int n6 = 0;
                        while (n6 < n4) {
                            if (!TypeBinding.equalsEquals(typeBinding, referenceBindingArray[n6])) {
                                ++n6;
                                continue;
                            }
                            break block14;
                        }
                        return methodBinding;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return parameterizedGenericMethodBinding;
    }

    static boolean couldMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (!CharOperation.equals(methodBinding.selector, methodBinding2.selector)) {
            return false;
        }
        if (methodBinding == methodBinding2 || methodBinding.isStatic() || methodBinding2.isStatic()) {
            return false;
        }
        if (methodBinding2.isPrivate()) {
            return false;
        }
        if (methodBinding2.isDefault() && methodBinding.declaringClass.getPackage() != methodBinding2.declaringClass.getPackage()) {
            return false;
        }
        if (!methodBinding.isPublic()) {
            if (methodBinding2.isPublic()) {
                return false;
            }
            if (methodBinding2.isProtected() && !methodBinding.isProtected()) {
                return false;
            }
        }
        return true;
    }

    public boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.doesMethodOverride(methodBinding, methodBinding2, this.environment);
    }

    public static boolean doesMethodOverride(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        return MethodVerifier.couldMethodOverride(methodBinding, methodBinding2) && MethodVerifier.areMethodsCompatible(methodBinding, methodBinding2, lookupEnvironment);
    }

    SimpleSet findSuperinterfaceCollisions(ReferenceBinding referenceBinding, ReferenceBinding[] referenceBindingArray) {
        return null;
    }

    MethodBinding findBestInheritedAbstractOrDefaultMethod(MethodBinding[] methodBindingArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            block5: {
                MethodBinding methodBinding = methodBindingArray[n2];
                if (methodBinding.isAbstract() || methodBinding.isDefaultMethod()) {
                    int n3 = 0;
                    while (n3 < n) {
                        if (n2 != n3 && !this.checkInheritedReturnTypes(methodBinding, methodBindingArray[n3])) {
                            if (this.type.isInterface() && methodBindingArray[n3].declaringClass.id == 1) {
                                return methodBinding;
                            }
                            break block5;
                        }
                        ++n3;
                    }
                    return methodBinding;
                }
            }
            ++n2;
        }
        return null;
    }

    int[] findOverriddenInheritedMethods(MethodBinding[] methodBindingArray, int n) {
        int[] nArray = null;
        int n2 = 0;
        ReferenceBinding referenceBinding = methodBindingArray[n2].declaringClass;
        if (!referenceBinding.isInterface()) {
            ReferenceBinding referenceBinding2 = methodBindingArray[++n2].declaringClass;
            while (TypeBinding.equalsEquals(referenceBinding, referenceBinding2)) {
                if (++n2 == n) {
                    return null;
                }
                referenceBinding2 = methodBindingArray[n2].declaringClass;
            }
            if (!referenceBinding2.isInterface()) {
                if (referenceBinding.fPackage != referenceBinding2.fPackage && methodBindingArray[n2].isDefault()) {
                    return null;
                }
                nArray = new int[n];
                do {
                    nArray[n2] = -1;
                    if (++n2 != n) continue;
                    return nArray;
                } while (!(referenceBinding2 = methodBindingArray[n2].declaringClass).isInterface());
            }
        }
        while (n2 < n) {
            if (nArray == null || nArray[n2] != -1) {
                referenceBinding = methodBindingArray[n2].declaringClass;
                int n3 = n2 + 1;
                while (n3 < n) {
                    ReferenceBinding referenceBinding3;
                    if (!(nArray != null && nArray[n3] == -1 || TypeBinding.equalsEquals(referenceBinding, referenceBinding3 = methodBindingArray[n3].declaringClass))) {
                        if (referenceBinding.implementsInterface(referenceBinding3, true)) {
                            if (nArray == null) {
                                nArray = new int[n];
                            }
                            nArray[n3] = -1;
                        } else if (referenceBinding3.implementsInterface(referenceBinding, true)) {
                            if (nArray == null) {
                                nArray = new int[n];
                            }
                            nArray[n2] = -1;
                            break;
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return nArray;
    }

    boolean isAsVisible(MethodBinding methodBinding, MethodBinding methodBinding2) {
        if (methodBinding2.modifiers == methodBinding.modifiers) {
            return true;
        }
        if (methodBinding.isPublic()) {
            return true;
        }
        if (methodBinding2.isPublic()) {
            return false;
        }
        if (methodBinding.isProtected()) {
            return true;
        }
        if (methodBinding2.isProtected()) {
            return false;
        }
        return !methodBinding.isPrivate();
    }

    boolean isInterfaceMethodImplemented(MethodBinding methodBinding, MethodBinding methodBinding2, ReferenceBinding referenceBinding) {
        return MethodVerifier.areParametersEqual(methodBinding2, methodBinding) && methodBinding2.declaringClass.implementsInterface(referenceBinding, true);
    }

    public boolean isMethodSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return CharOperation.equals(methodBinding.selector, methodBinding2.selector) && this.isParameterSubsignature(methodBinding, methodBinding2);
    }

    boolean isParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.isParameterSubsignature(methodBinding, methodBinding2, this.environment);
    }

    static boolean isParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        MethodBinding methodBinding3 = MethodVerifier.computeSubstituteMethod(methodBinding2, methodBinding, lookupEnvironment);
        return methodBinding3 != null && MethodVerifier.isSubstituteParameterSubsignature(methodBinding, methodBinding3, lookupEnvironment);
    }

    boolean isSubstituteParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2) {
        return MethodVerifier.isSubstituteParameterSubsignature(methodBinding, methodBinding2, this.environment);
    }

    public static boolean isSubstituteParameterSubsignature(MethodBinding methodBinding, MethodBinding methodBinding2, LookupEnvironment lookupEnvironment) {
        if (!MethodVerifier.areParametersEqual(methodBinding, methodBinding2)) {
            if (methodBinding2.hasSubstitutedParameters() && methodBinding.areParameterErasuresEqual(methodBinding2)) {
                return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES && !MethodVerifier.hasGenericParameter(methodBinding);
            }
            if (methodBinding.declaringClass.isRawType() && methodBinding2.declaringClass.isRawType() && methodBinding.hasSubstitutedParameters() && methodBinding2.hasSubstitutedParameters()) {
                return MethodVerifier.areMethodsCompatible(methodBinding, methodBinding2, lookupEnvironment);
            }
            return false;
        }
        if (methodBinding2 instanceof ParameterizedGenericMethodBinding) {
            if (methodBinding.typeVariables != Binding.NO_TYPE_VARIABLES) {
                return !((ParameterizedGenericMethodBinding)methodBinding2).isRaw;
            }
            return !MethodVerifier.hasGenericParameter(methodBinding);
        }
        return methodBinding.typeVariables == Binding.NO_TYPE_VARIABLES;
    }

    static boolean hasGenericParameter(MethodBinding methodBinding) {
        if (methodBinding.genericSignature() == null) {
            return false;
        }
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n = 0;
        int n2 = typeBindingArray.length;
        while (n < n2) {
            int n3;
            TypeBinding typeBinding = typeBindingArray[n].leafComponentType();
            if (typeBinding instanceof ReferenceBinding && ((n3 = ((ReferenceBinding)typeBinding).modifiers) & 0x40000000) != 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    boolean isSameClassOrSubclassOf(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        do {
            if (!TypeBinding.equalsEquals(referenceBinding, referenceBinding2)) continue;
            return true;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    /*
     * Unable to fully structure code
     */
    boolean mustImplementAbstractMethod(ReferenceBinding var1_1) {
        block4: {
            block3: {
                if (!this.mustImplementAbstractMethods()) {
                    return false;
                }
                var2_2 = this.type.superclass();
                if (!var1_1.isClass()) break block3;
                while (var2_2.isAbstract() && TypeBinding.notEquals(var2_2, var1_1)) {
                    var2_2 = var2_2.superclass();
                }
                break block4;
            }
            if (!this.type.implementsInterface(var1_1, false) || var2_2.implementsInterface(var1_1, true)) ** GOTO lbl13
            return true;
lbl-1000:
            // 1 sources

            {
                var2_2 = var2_2.superclass();
lbl13:
                // 2 sources

                ** while (var2_2.isAbstract() && !var2_2.implementsInterface((ReferenceBinding)var1_1, (boolean)false))
            }
        }
        return var2_2.isAbstract();
    }

    boolean mustImplementAbstractMethods() {
        return !this.type.isInterface() && !this.type.isAbstract();
    }

    ProblemReporter problemReporter() {
        return this.type.scope.problemReporter();
    }

    ProblemReporter problemReporter(MethodBinding methodBinding) {
        ProblemReporter problemReporter = this.problemReporter();
        if (TypeBinding.equalsEquals(methodBinding.declaringClass, this.type) && methodBinding.sourceMethod() != null) {
            problemReporter.referenceContext = methodBinding.sourceMethod();
        }
        return problemReporter;
    }

    boolean reportIncompatibleReturnTypeError(MethodBinding methodBinding, MethodBinding methodBinding2) {
        this.problemReporter(methodBinding).incompatibleReturnType(methodBinding, methodBinding2);
        return true;
    }

    ReferenceBinding[] resolvedExceptionTypesFor(MethodBinding methodBinding) {
        ReferenceBinding[] referenceBindingArray = methodBinding.thrownExceptions;
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return referenceBindingArray;
        }
        if (!(methodBinding.declaringClass instanceof BinaryTypeBinding)) {
            return Binding.NO_EXCEPTIONS;
        }
        int n = referenceBindingArray.length;
        while (--n >= 0) {
            referenceBindingArray[n] = (ReferenceBinding)BinaryTypeBinding.resolveType(referenceBindingArray[n], this.environment, true);
        }
        return referenceBindingArray;
    }

    void verify() {
        this.computeMethods();
        this.computeInheritedMethods();
        this.checkMethods();
        if (this.type.isClass()) {
            this.checkForMissingHashCodeMethod();
        }
    }

    void verify(SourceTypeBinding sourceTypeBinding) {
        if (this.type == null) {
            try {
                this.type = sourceTypeBinding;
                this.verify();
            }
            finally {
                this.type = null;
            }
        } else {
            this.environment.newMethodVerifier().verify(sourceTypeBinding);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append("MethodVerifier for type: ");
        stringBuffer.append(this.type.readableName());
        stringBuffer.append('\n');
        stringBuffer.append("\t-inherited methods: ");
        stringBuffer.append(this.inheritedMethods);
        return stringBuffer.toString();
    }
}

