/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class ElementValuePair {
    char[] name;
    public Object value;
    public MethodBinding binding;

    public static Object getValue(Expression expression) {
        if (expression == null) {
            return null;
        }
        Constant constant = expression.constant;
        if (constant != null && constant != Constant.NotAConstant) {
            return constant;
        }
        if (expression instanceof Annotation) {
            return ((Annotation)expression).getCompilerAnnotation();
        }
        if (expression instanceof ArrayInitializer) {
            Expression[] expressionArray = ((ArrayInitializer)expression).expressions;
            int n = expressionArray == null ? 0 : expressionArray.length;
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = ElementValuePair.getValue(expressionArray[n2]);
                ++n2;
            }
            return objectArray;
        }
        if (expression instanceof ClassLiteralAccess) {
            return ((ClassLiteralAccess)expression).targetType;
        }
        if (expression instanceof Reference) {
            Binding binding;
            FieldBinding fieldBinding = null;
            if (expression instanceof FieldReference) {
                fieldBinding = ((FieldReference)expression).fieldBinding();
            } else if (expression instanceof NameReference && (binding = ((NameReference)expression).binding) != null && binding.kind() == 1) {
                fieldBinding = (FieldBinding)binding;
            }
            if (fieldBinding != null && (fieldBinding.modifiers & 0x4000) > 0) {
                return fieldBinding;
            }
        }
        return null;
    }

    public ElementValuePair(char[] cArray, Expression expression, MethodBinding methodBinding) {
        this(cArray, ElementValuePair.getValue(expression), methodBinding);
    }

    public ElementValuePair(char[] cArray, Object object, MethodBinding methodBinding) {
        this.name = cArray;
        this.value = object;
        this.binding = methodBinding;
    }

    public char[] getName() {
        return this.name;
    }

    public MethodBinding getMethodBinding() {
        return this.binding;
    }

    public Object getValue() {
        if (this.value instanceof UnresolvedEnumConstant) {
            this.value = ((UnresolvedEnumConstant)this.value).getResolved();
        } else if (this.value instanceof Object[]) {
            Object[] objectArray = (Object[])this.value;
            int n = 0;
            while (n < objectArray.length) {
                Object object = objectArray[n];
                if (object instanceof UnresolvedEnumConstant) {
                    objectArray[n] = ((UnresolvedEnumConstant)object).getResolved();
                }
                ++n;
            }
        }
        return this.value;
    }

    void setMethodBinding(MethodBinding methodBinding) {
        this.binding = methodBinding;
    }

    void setValue(Object object) {
        this.value = object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(this.name).append(" = ");
        stringBuffer.append(this.value);
        return stringBuffer.toString();
    }

    public static class UnresolvedEnumConstant {
        ReferenceBinding enumType;
        LookupEnvironment environment;
        char[] enumConstantName;

        UnresolvedEnumConstant(ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment, char[] cArray) {
            this.enumType = referenceBinding;
            this.environment = lookupEnvironment;
            this.enumConstantName = cArray;
        }

        FieldBinding getResolved() {
            if (this.enumType.isUnresolvedType()) {
                this.enumType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.enumType, this.environment, false);
            }
            return this.enumType.getField(this.enumConstantName, false);
        }

        public char[] getEnumConstantName() {
            return this.enumConstantName;
        }
    }
}

