/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocArgumentExpression
extends Expression {
    public char[] token;
    public Argument argument;

    public JavadocArgumentExpression(char[] cArray, int n, int n2, TypeReference typeReference) {
        this.token = cArray;
        this.sourceStart = n;
        this.sourceEnd = n2;
        long l = ((long)n << 32) + (long)n2;
        this.argument = new Argument(cArray, l, typeReference, 0);
        this.bits |= 0x8000;
    }

    private TypeBinding internalResolveType(Scope scope) {
        TypeReference typeReference;
        this.constant = Constant.NotAConstant;
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        if (this.argument != null && (typeReference = this.argument.type) != null) {
            ReferenceBinding referenceBinding;
            typeReference.resolvedType = this.resolvedType = typeReference.getTypeBinding(scope);
            if (this.resolvedType == null) {
                return null;
            }
            if (typeReference instanceof SingleTypeReference && this.resolvedType.leafComponentType().enclosingType() != null && scope.compilerOptions().complianceLevel <= 0x300000L) {
                scope.problemReporter().javadocInvalidMemberTypeQualification(this.sourceStart, this.sourceEnd, scope.getDeclarationModifiers());
            } else if (typeReference instanceof QualifiedTypeReference && (referenceBinding = this.resolvedType.leafComponentType().enclosingType()) != null) {
                int n = 2;
                while ((referenceBinding = referenceBinding.enclosingType()) != null) {
                    ++n;
                }
                int n2 = typeReference.getTypeName().length;
                if (n2 != n && n2 != n + this.resolvedType.getPackage().compoundName.length) {
                    scope.problemReporter().javadocInvalidMemberTypeQualification(typeReference.sourceStart, typeReference.sourceEnd, scope.getDeclarationModifiers());
                }
            }
            if (!this.resolvedType.isValidBinding()) {
                scope.problemReporter().javadocInvalidType(typeReference, this.resolvedType, scope.getDeclarationModifiers());
                return null;
            }
            if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
                scope.problemReporter().javadocDeprecatedType(this.resolvedType, typeReference, scope.getDeclarationModifiers());
            }
            this.resolvedType = scope.environment().convertToRawType(this.resolvedType, true);
            return this.resolvedType;
        }
        return null;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        if (this.argument == null) {
            if (this.token != null) {
                stringBuffer.append(this.token);
            }
        } else {
            this.argument.print(n, stringBuffer);
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
        if (this.argument != null) {
            this.argument.resolve(blockScope);
        }
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return this.internalResolveType(blockScope);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.argument != null) {
            this.argument.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope) && this.argument != null) {
            this.argument.traverse(aSTVisitor, classScope);
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

