/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.IntLiteralMinValue;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;

public class IntLiteral
extends NumberLiteral {
    private static final char[] HEXA_MIN_VALUE = "0x80000000".toCharArray();
    private static final char[] HEXA_MINUS_ONE_VALUE = "0xffffffff".toCharArray();
    private static final char[] OCTAL_MIN_VALUE = "020000000000".toCharArray();
    private static final char[] OCTAL_MINUS_ONE_VALUE = "037777777777".toCharArray();
    private static final char[] DECIMAL_MIN_VALUE = "2147483648".toCharArray();
    private static final char[] DECIMAL_MAX_VALUE = "2147483647".toCharArray();
    private char[] reducedForm;
    public int value;
    public static final IntLiteral One = new IntLiteral(new char[]{'1'}, null, 0, 0, 1, IntConstant.fromValue(1));

    public static IntLiteral buildIntLiteral(char[] cArray, int n, int n2) {
        char[] cArray2 = IntLiteral.removePrefixZerosAndUnderscores(cArray, false);
        switch (cArray2.length) {
            case 10: {
                if (!CharOperation.equals(cArray2, HEXA_MIN_VALUE)) break;
                return new IntLiteralMinValue(cArray, (char[])(cArray2 != cArray ? cArray2 : null), n, n2);
            }
            case 12: {
                if (!CharOperation.equals(cArray2, OCTAL_MIN_VALUE)) break;
                return new IntLiteralMinValue(cArray, (char[])(cArray2 != cArray ? cArray2 : null), n, n2);
            }
        }
        return new IntLiteral(cArray, (char[])(cArray2 != cArray ? cArray2 : null), n, n2);
    }

    IntLiteral(char[] cArray, char[] cArray2, int n, int n2) {
        super(cArray, n, n2);
        this.reducedForm = cArray2;
    }

    IntLiteral(char[] cArray, char[] cArray2, int n, int n2, int n3, Constant constant) {
        super(cArray, n, n2);
        this.reducedForm = cArray2;
        this.value = n3;
        this.constant = constant;
    }

    public void computeConstant() {
        char[] cArray = this.reducedForm != null ? this.reducedForm : this.source;
        int n = cArray.length;
        int n2 = 10;
        int n3 = 0;
        if (cArray[0] == '0') {
            if (n == 1) {
                this.constant = IntConstant.fromValue(0);
                return;
            }
            if (cArray[1] == 'x' || cArray[1] == 'X') {
                n2 = 16;
                n3 = 2;
            } else if (cArray[1] == 'b' || cArray[1] == 'B') {
                n2 = 2;
                n3 = 2;
            } else {
                n2 = 8;
                n3 = 1;
            }
        }
        switch (n2) {
            case 2: {
                if (n - 2 > 32) {
                    return;
                }
                this.computeValue(cArray, n, n2, n3);
                return;
            }
            case 16: {
                if (n > 10) break;
                if (CharOperation.equals(cArray, HEXA_MINUS_ONE_VALUE)) {
                    this.constant = IntConstant.fromValue(-1);
                    return;
                }
                this.computeValue(cArray, n, n2, n3);
                return;
            }
            case 10: {
                if (n > DECIMAL_MAX_VALUE.length || n == DECIMAL_MAX_VALUE.length && CharOperation.compareTo(cArray, DECIMAL_MAX_VALUE) > 0) {
                    return;
                }
                this.computeValue(cArray, n, n2, n3);
                break;
            }
            case 8: {
                if (n > 12) break;
                if (n == 12 && cArray[n3] > '4') {
                    return;
                }
                if (CharOperation.equals(cArray, OCTAL_MINUS_ONE_VALUE)) {
                    this.constant = IntConstant.fromValue(-1);
                    return;
                }
                this.computeValue(cArray, n, n2, n3);
                return;
            }
        }
    }

    private void computeValue(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n3 < n) {
            int n5;
            if ((n5 = ScannerHelper.digit(cArray[n3++], n2)) < 0) {
                return;
            }
            n4 = n4 * n2 + n5;
        }
        this.constant = IntConstant.fromValue(n4);
    }

    public IntLiteral convertToMinValue() {
        if ((this.bits & 0x1FE00000) >> 21 != 0) {
            return this;
        }
        char[] cArray = this.reducedForm != null ? this.reducedForm : this.source;
        switch (cArray.length) {
            case 10: {
                if (!CharOperation.equals(cArray, DECIMAL_MIN_VALUE)) break;
                return new IntLiteralMinValue(this.source, this.reducedForm, this.sourceStart, this.sourceEnd);
            }
        }
        return this;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.INT;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

