/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class ArrayQualifiedTypeReference
extends QualifiedTypeReference {
    int dimensions;
    private Annotation[][] annotationsOnDimensions;
    public int extendedDimensions;

    public ArrayQualifiedTypeReference(char[][] cArray, int n, long[] lArray) {
        super(cArray, lArray);
        this.dimensions = n;
        this.annotationsOnDimensions = null;
    }

    public ArrayQualifiedTypeReference(char[][] cArray, int n, Annotation[][] annotationArray, long[] lArray) {
        this(cArray, n, lArray);
        this.annotationsOnDimensions = annotationArray;
        if (annotationArray != null) {
            this.bits |= 0x100000;
        }
    }

    public int dimensions() {
        return this.dimensions;
    }

    public int extraDimensions() {
        return this.extendedDimensions;
    }

    public Annotation[][] getAnnotationsOnDimensions(boolean bl) {
        if (bl || this.annotationsOnDimensions == null || this.annotationsOnDimensions.length == 0 || this.extendedDimensions == 0 || this.extendedDimensions == this.dimensions) {
            return this.annotationsOnDimensions;
        }
        Annotation[][] annotationArray = new Annotation[this.dimensions][];
        int n = this.dimensions - this.extendedDimensions;
        System.arraycopy(this.annotationsOnDimensions, n, annotationArray, 0, this.extendedDimensions);
        System.arraycopy(this.annotationsOnDimensions, 0, annotationArray, this.extendedDimensions, n);
        return annotationArray;
    }

    public void setAnnotationsOnDimensions(Annotation[][] annotationArray) {
        this.annotationsOnDimensions = annotationArray;
    }

    public char[][] getParameterizedTypeName() {
        int n = this.dimensions;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 * 2;
            cArray[n3] = 91;
            cArray[n3 + 1] = 93;
            ++n2;
        }
        n2 = this.tokens.length;
        char[][] cArrayArray = new char[n2][];
        System.arraycopy(this.tokens, 0, cArrayArray, 0, n2 - 1);
        cArrayArray[n2 - 1] = CharOperation.concat(this.tokens[n2 - 1], cArray);
        return cArrayArray;
    }

    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        LookupEnvironment lookupEnvironment = scope.environment();
        try {
            lookupEnvironment.missingClassFileLocation = this;
            TypeBinding typeBinding = super.getTypeBinding(scope);
            if (typeBinding != null) {
                this.resolvedType = scope.createArrayType(typeBinding, this.dimensions);
                ArrayBinding arrayBinding = this.resolvedType;
                return arrayBinding;
            }
            return null;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
        finally {
            lookupEnvironment.missingClassFileLocation = null;
        }
    }

    protected TypeBinding internalResolveType(Scope scope, int n) {
        TypeBinding typeBinding = super.internalResolveType(scope, n);
        return typeBinding;
    }

    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        super.printExpression(n, stringBuffer);
        if ((this.bits & 0x4000) != 0) {
            int n2 = 0;
            while (n2 < this.dimensions - 1) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[n2] != null) {
                    stringBuffer.append(' ');
                    ArrayQualifiedTypeReference.printAnnotations(this.annotationsOnDimensions[n2], stringBuffer);
                    stringBuffer.append(' ');
                }
                stringBuffer.append("[]");
                ++n2;
            }
            if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[this.dimensions - 1] != null) {
                stringBuffer.append(' ');
                ArrayQualifiedTypeReference.printAnnotations(this.annotationsOnDimensions[this.dimensions - 1], stringBuffer);
                stringBuffer.append(' ');
            }
            stringBuffer.append("...");
        } else {
            int n3 = 0;
            while (n3 < this.dimensions) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[n3] != null) {
                    stringBuffer.append(" ");
                    ArrayQualifiedTypeReference.printAnnotations(this.annotationsOnDimensions[n3], stringBuffer);
                    stringBuffer.append(" ");
                }
                stringBuffer.append("[]");
                ++n3;
            }
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n;
            int n2;
            int n3;
            if (this.annotations != null) {
                n3 = this.annotations.length;
                n2 = 0;
                while (n2 < n3) {
                    int n4 = this.annotations[n2] == null ? 0 : this.annotations[n2].length;
                    n = 0;
                    while (n < n4) {
                        this.annotations[n2][n].traverse(aSTVisitor, blockScope);
                        ++n;
                    }
                    ++n2;
                }
            }
            if (this.annotationsOnDimensions != null) {
                n3 = 0;
                n2 = this.annotationsOnDimensions.length;
                while (n3 < n2) {
                    Annotation[] annotationArray = this.annotationsOnDimensions[n3];
                    n = 0;
                    int n5 = annotationArray == null ? 0 : annotationArray.length;
                    while (n < n5) {
                        Annotation annotation = annotationArray[n];
                        annotation.traverse(aSTVisitor, blockScope);
                        ++n;
                    }
                    ++n3;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n;
            int n2;
            int n3;
            if (this.annotations != null) {
                n3 = this.annotations.length;
                n2 = 0;
                while (n2 < n3) {
                    int n4 = this.annotations[n2] == null ? 0 : this.annotations[n2].length;
                    n = 0;
                    while (n < n4) {
                        this.annotations[n2][n].traverse(aSTVisitor, classScope);
                        ++n;
                    }
                    ++n2;
                }
            }
            if (this.annotationsOnDimensions != null) {
                n3 = 0;
                n2 = this.annotationsOnDimensions.length;
                while (n3 < n2) {
                    Annotation[] annotationArray = this.annotationsOnDimensions[n3];
                    n = 0;
                    int n5 = annotationArray == null ? 0 : annotationArray.length;
                    while (n < n5) {
                        Annotation annotation = annotationArray[n];
                        annotation.traverse(aSTVisitor, classScope);
                        ++n;
                    }
                    ++n3;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

