/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web.graphs;

import java.io.BufferedOutputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.torproject.metrics.web.graphs.RObject;
import org.torproject.metrics.web.graphs.RObjectGenerator;

public class GraphImageServlet
extends HttpServlet {
    private static final long serialVersionUID = -7356818641689744288L;
    private RObjectGenerator objectGenerator;

    @Override
    public void init() {
        this.objectGenerator = (RObjectGenerator)this.getServletContext().getAttribute("RObjectGenerator");
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        RObject graph;
        String requestedGraph = request.getRequestURI();
        String fileType = null;
        if (requestedGraph.endsWith(".png") || requestedGraph.endsWith(".pdf")) {
            fileType = requestedGraph.substring(requestedGraph.length() - 3);
            requestedGraph = requestedGraph.substring(0, requestedGraph.length() - 4);
        }
        if (requestedGraph.contains("/")) {
            requestedGraph = requestedGraph.substring(requestedGraph.lastIndexOf("/") + 1);
        }
        if ((graph = this.objectGenerator.generateGraph(requestedGraph, fileType, request.getParameterMap(), true)) == null || graph.getBytes() == null || fileType == null) {
            response.sendError(500);
            return;
        }
        response.setContentType("image/" + fileType);
        response.setHeader("Content-Length", String.valueOf(graph.getBytes().length));
        response.setHeader("Content-Disposition", "inline; filename=\"" + graph.getFileName() + "\"");
        BufferedOutputStream output = new BufferedOutputStream(response.getOutputStream(), 1024);
        output.write(graph.getBytes(), 0, graph.getBytes().length);
        output.flush();
        output.close();
    }
}

