/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.torproject.metrics.web.AnyServlet;
import org.torproject.metrics.web.ContentProvider;
import org.torproject.metrics.web.News;
import org.torproject.metrics.web.graphs.Countries;

public class NewsServlet
extends AnyServlet {
    private static final long serialVersionUID = -7696996243187241242L;
    protected List<News> sortedNews;
    protected SortedMap<String, String> countries;

    @Override
    public void init() throws ServletException {
        super.init();
        ArrayList<News> sortedNews = new ArrayList<News>();
        for (News news : ContentProvider.getInstance().getNewsList()) {
            if (news.getStart() == null) continue;
            sortedNews.add(news);
        }
        Collections.sort(sortedNews, new Comparator<News>(){

            @Override
            public int compare(News o1, News o2) {
                return o1.getStart().compareTo(o2.getStart()) * -1;
            }
        });
        this.sortedNews = sortedNews;
        TreeMap<String, String> countries = new TreeMap<String, String>();
        for (String[] country : Countries.getInstance().getCountryList()) {
            countries.put(country[0], country[1]);
        }
        this.countries = countries;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LinkedHashMap<String, String[]> cutOffDates = new LinkedHashMap<String, String[]>();
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
        cal.set(7, 1);
        cutOffDates.put(String.format("%tF", cal), new String[]{"This week", "week"});
        cal.set(5, 1);
        cutOffDates.put(String.format("%tF", cal), new String[]{"This month", "month"});
        cal.set(2, cal.get(2) / 3 * 3);
        cutOffDates.put(String.format("%tF", cal), new String[]{"This quarter", "quarter"});
        cal.set(2, 0);
        String yearStart = String.format("%tF", cal);
        cutOffDates.put(yearStart, new String[]{"This year", "year"});
        do {
            cal.add(1, -1);
            yearStart = String.format("%tF", cal);
            String year = String.format("%tY", cal);
            cutOffDates.put(yearStart, new String[]{year, year});
        } while (!this.sortedNews.isEmpty() && yearStart.compareTo(this.sortedNews.get(this.sortedNews.size() - 1).getStart()) > 0);
        LinkedHashMap newsByCategory = new LinkedHashMap();
        for (String[] category : cutOffDates.values()) {
            newsByCategory.put(category, new ArrayList());
        }
        block12: for (News news : this.sortedNews) {
            StringBuilder sb = new StringBuilder();
            sb.append("<h3 class=\"media-heading\">").append(news.getStart());
            if (news.getEnd() != null) {
                sb.append(" to ").append(news.getEnd());
            }
            if (news.getPlaces() != null) {
                boolean appendUnknownCountry = false;
                for (String string : news.getPlaces()) {
                    if (this.countries.containsKey(string)) {
                        sb.append(" <span class=\"label label-warning\">").append((String)this.countries.get(string)).append("</span>");
                        continue;
                    }
                    appendUnknownCountry = true;
                }
                if (appendUnknownCountry) {
                    sb.append(" <span class=\"label label-warning\">Unknown country</span>");
                }
            }
            if (news.getProtocols() != null) {
                void var12_17;
                String[] appendUnknownCountry = news.getProtocols();
                int n = appendUnknownCountry.length;
                boolean bl = false;
                while (var12_17 < n) {
                    String protocol;
                    switch (protocol = appendUnknownCountry[var12_17]) {
                        case "relay": {
                            sb.append(" <span class=\"label label-success\">Relays</span>");
                            break;
                        }
                        case "bridge": {
                            sb.append(" <span class=\"label label-primary\">Bridges</span>");
                            break;
                        }
                        case "<OR>": {
                            sb.append(" <span class=\"label label-info\">&lt;OR&gt;</span>");
                            break;
                        }
                        default: {
                            sb.append(" <span class=\"label label-info\">").append(protocol).append("</span>");
                        }
                    }
                    ++var12_17;
                }
            }
            if (news.isUnknown()) {
                sb.append(" <span class=\"label label-default\">Unknown</span>");
            }
            sb.append("</h3><p>").append(news.getDescription()).append("</p>");
            if (news.getLinks() != null && news.getLinks().length > 0) {
                int written = 0;
                sb.append("<p class=\"links\">");
                for (String link : news.getLinks()) {
                    if (written++ > 0) {
                        sb.append(" ");
                    }
                    if (link.startsWith("https://metrics.torproject.org/")) {
                        sb.append(link);
                        continue;
                    }
                    sb.append(link.replaceFirst(">", " target=\"_blank\">"));
                }
                sb.append("</p>");
            }
            String[] formattedNews = new String[]{sb.toString()};
            for (Map.Entry entry : cutOffDates.entrySet()) {
                if (news.getStart().compareTo((String)entry.getKey()) < 0) continue;
                ((List)newsByCategory.get(entry.getValue())).add(formattedNews);
                continue block12;
            }
        }
        for (String[] category : cutOffDates.values()) {
            if (!((List)newsByCategory.get(category)).isEmpty()) continue;
            newsByCategory.remove(category);
        }
        request.setAttribute("categories", this.categories);
        request.setAttribute("news", newsByCategory);
        request.getRequestDispatcher("WEB-INF/news.jsp").forward(request, response);
    }
}

