/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.torproject.metrics.web.graphs.Countries;

public class News {
    private String start;
    private String end;
    private List<String> places;
    private String[] protocols;
    private String description;
    private String[] links;
    private boolean unknown;
    static SortedMap<String, String> countries = new TreeMap<String, String>();

    String getStart() {
        return this.start;
    }

    String getEnd() {
        return this.end;
    }

    List<String> getPlaces() {
        return this.places;
    }

    String[] getProtocols() {
        return this.protocols;
    }

    String getDescription() {
        return this.description;
    }

    String[] getLinks() {
        return this.links;
    }

    boolean isUnknown() {
        return this.unknown;
    }

    String formatAsTableRow() {
        StringBuilder sb = new StringBuilder();
        sb.append("<tr><td><span class=\"dates\">");
        if (null == this.start) {
            sb.append("N/A");
        } else if (null == this.end || this.start.equals(this.end)) {
            sb.append(this.start);
        } else {
            sb.append(this.start).append(" to ").append(this.end);
        }
        sb.append("</span></td><td>");
        if (null != this.places) {
            boolean appendUnknownCountry = false;
            for (String place : this.getPlaces()) {
                if (countries.containsKey(place)) {
                    sb.append(" <span class=\"label label-warning\">").append((String)countries.get(place)).append("</span>");
                    continue;
                }
                appendUnknownCountry = true;
            }
            if (appendUnknownCountry) {
                sb.append(" <span class=\"label label-warning\">Unknown country</span>");
            }
        }
        if (null != this.protocols) {
            String[] stringArray = this.protocols;
            int n = stringArray.length;
            block11: for (int i = 0; i < n; ++i) {
                String protocol;
                switch (protocol = stringArray[i]) {
                    case "relay": {
                        sb.append(" <span class=\"label label-success\">Relays</span>");
                        continue block11;
                    }
                    case "bridge": {
                        sb.append(" <span class=\"label label-primary\">Bridges</span>");
                        continue block11;
                    }
                    case "<OR>": {
                        sb.append(" <span class=\"label label-info\">&lt;OR&gt;</span>");
                        continue block11;
                    }
                    default: {
                        sb.append(" <span class=\"label label-info\">").append(protocol).append("</span>");
                    }
                }
            }
        }
        if (this.unknown) {
            sb.append(" <span class=\"label label-default\">Unknown</span>");
        }
        sb.append("</td><td>");
        if (null != this.description) {
            sb.append(this.description).append("<br/>");
        }
        if (null != this.links) {
            for (String link : this.links) {
                int tagEnd = link.indexOf(62);
                if (tagEnd < 0 || tagEnd + 2 > link.length()) continue;
                sb.append(link, 0, tagEnd);
                sb.append(" class=\"link\"");
                if (!link.startsWith("<a href=\"https://metrics.torproject.org/")) {
                    sb.append(" target=\"_blank\"");
                }
                sb.append('>').append(link.substring(tagEnd + 1, tagEnd + 2).toUpperCase()).append(link.substring(tagEnd + 2));
            }
        }
        sb.append("</td></tr>");
        return sb.toString();
    }

    static {
        for (String[] country : Countries.getInstance().getCountryList()) {
            countries.put(country[0], country[1]);
        }
    }
}

