/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.torproject.metrics.web.Category;
import org.torproject.metrics.web.MetricServlet;

public class LinkServlet
extends MetricServlet {
    @Override
    public void init() throws ServletException {
        super.init();
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String requestUri = request.getRequestURI();
        if (requestUri == null || !requestUri.endsWith(".html")) {
            response.sendError(400);
            return;
        }
        String requestedId = requestUri.substring(requestUri.contains("/") ? requestUri.lastIndexOf("/") + 1 : 0, requestUri.length() - 5);
        if (!this.idsByType.containsKey("Link") || !((Set)this.idsByType.get("Link")).contains(requestedId)) {
            response.sendError(400);
            return;
        }
        request.setAttribute("categories", this.categories);
        request.setAttribute("id", requestedId);
        request.setAttribute("title", this.titles.get(requestedId));
        if (this.categoriesById.containsKey(requestedId)) {
            Category category = (Category)this.categoriesById.get(requestedId);
            request.setAttribute("categoryHeader", category.getHeader());
            request.setAttribute("categoryDescription", category.getDescription());
            ArrayList<String[]> categoryTabs = new ArrayList<String[]>();
            for (String metricId : category.getMetrics()) {
                categoryTabs.add(new String[]{(String)this.titles.get(metricId), metricId});
            }
            request.setAttribute("categoryTabs", categoryTabs);
        }
        request.setAttribute("description", this.descriptions.get(requestedId));
        request.setAttribute("data", this.data.get(requestedId));
        request.getRequestDispatcher("WEB-INF/link.jsp").forward(request, response);
    }
}

