/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.torproject.metrics.web.Category;
import org.torproject.metrics.web.Metric;
import org.torproject.metrics.web.News;

public class ContentProvider {
    private static ContentProvider instance = new ContentProvider();
    private List<Metric> metricsList;
    private List<Category> categoriesList;
    private List<News> newsList;

    public static ContentProvider getInstance() {
        return instance;
    }

    private ContentProvider() {
        Gson gson = new GsonBuilder().create();
        this.metricsList = Arrays.asList((Object[])gson.fromJson((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("WEB-INF/json/metrics.json")), Metric[].class));
        this.categoriesList = Arrays.asList((Object[])gson.fromJson((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("WEB-INF/json/categories.json")), Category[].class));
        this.newsList = Arrays.asList((Object[])gson.fromJson((Reader)new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("WEB-INF/json/news.json")), News[].class));
    }

    public List<Metric> getMetricsList() {
        return new ArrayList<Metric>(this.metricsList);
    }

    public List<Category> getCategoriesList() {
        return new ArrayList<Category>(this.categoriesList);
    }

    public List<News> getNewsList() {
        return new ArrayList<News>(this.newsList);
    }
}

