/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.hidserv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Simulate {
    private static File simCellsCsvFile = new File("out/csv/sim-cells.csv");
    private static File simOnionsCsvFile = new File("out/csv/sim-onions.csv");
    private static Random rnd = new Random();

    public static void main(String[] args) throws Exception {
        System.out.print("Simulating extrapolation of rendezvous cells");
        Simulate.simulateManyCells();
        System.out.print("\nSimulating extrapolation of .onions");
        Simulate.simulateManyOnions();
        System.out.println("\nTerminating.");
    }

    private static void simulateManyCells() throws Exception {
        simCellsCsvFile.getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(simCellsCsvFile));
        bw.write("run,frac,wmean,wmedian,wiqm\n");
        int numberOfExtrapolations = 1000;
        for (int i = 0; i < 1000; ++i) {
            bw.write(Simulate.simulateCells(i));
            System.out.print(".");
        }
        bw.close();
    }

    private static void simulateManyOnions() throws Exception {
        simOnionsCsvFile.getParentFile().mkdirs();
        BufferedWriter bw = new BufferedWriter(new FileWriter(simOnionsCsvFile));
        bw.write("run,frac,wmean,wmedian,wiqm\n");
        int numberOfExtrapolations = 1000;
        for (int i = 0; i < 1000; ++i) {
            bw.write(Simulate.simulateOnions(i));
            System.out.print(".");
        }
        bw.close();
    }

    private static String simulateCells(int run) {
        double[] fractions;
        long cells;
        int numberRendPoints = 3000;
        double[] consensusWeights = new double[3000];
        double totalConsensusWeight = 0.0;
        for (int i = 0; i < 3000; ++i) {
            double consensusWeight;
            consensusWeights[i] = consensusWeight = -Math.log(1.0 - rnd.nextDouble());
            totalConsensusWeight += consensusWeight;
        }
        double[] probRendPoint = new double[3000];
        for (int i = 0; i < 3000; ++i) {
            probRendPoint[i] = consensusWeights[i] / totalConsensusWeight;
        }
        double cellsLambda = 1.0E-4;
        long[] observedCells = new long[3000];
        block2: for (long cellsLeft = 10000000000L; cellsLeft > 0L; cellsLeft -= cells) {
            cells = Math.min(cellsLeft, (long)(-Math.log(1.0 - rnd.nextDouble()) / 1.0E-4));
            double selectRendPoint = rnd.nextDouble();
            for (int i = 0; i < probRendPoint.length; ++i) {
                if (!((selectRendPoint -= probRendPoint[i]) <= 0.0)) continue;
                int n = i;
                observedCells[n] = observedCells[n] + cells;
                continue block2;
            }
        }
        long binSize = 1024L;
        double b = 6826.666666666667;
        long[] reportedCells = new long[3000];
        long[] removedNoiseCells = new long[3000];
        for (int i = 0; i < 3000; ++i) {
            long subtractedHalfOfBinSize;
            long reported;
            long observed = observedCells[i];
            long afterBinning = (observed + 1024L - 1L) / 1024L * 1024L;
            double randomDouble = rnd.nextDouble();
            double laplaceNoise = -6826.666666666667 * (randomDouble > 0.5 ? 1.0 : -1.0) * Math.log(1.0 - 2.0 * Math.abs(randomDouble - 0.5));
            reportedCells[i] = reported = afterBinning + (long)laplaceNoise;
            long roundedToNearestRightSideOfTheBin = (reported + 512L) / 1024L * 1024L;
            removedNoiseCells[i] = subtractedHalfOfBinSize = roundedToNearestRightSideOfTheBin - 512L;
        }
        StringBuilder sb = new StringBuilder();
        for (double fraction : fractions = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99}) {
            ArrayList<double[]> singleRelayExtrapolations;
            double totalReportingProbability;
            TreeSet<Integer> nonReportingRelays = new TreeSet<Integer>();
            for (int j = 0; j < 3000; ++j) {
                nonReportingRelays.add(j);
            }
            ArrayList shuffledRelays = new ArrayList(nonReportingRelays);
            Collections.shuffle(shuffledRelays);
            TreeSet reportingRelays = new TreeSet();
            for (int j = 0; j < (int)(3000.0 * fraction); ++j) {
                reportingRelays.add(shuffledRelays.get(j));
                nonReportingRelays.remove(shuffledRelays.get(j));
            }
            do {
                singleRelayExtrapolations = new ArrayList<double[]>();
                totalReportingProbability = 0.0;
                Iterator subtractedHalfOfBinSize = reportingRelays.iterator();
                while (subtractedHalfOfBinSize.hasNext()) {
                    int reportingRelay = (Integer)subtractedHalfOfBinSize.next();
                    double probability = probRendPoint[reportingRelay];
                    if (probability > 0.0) {
                        singleRelayExtrapolations.add(new double[]{(double)removedNoiseCells[reportingRelay] / probability, removedNoiseCells[reportingRelay], probability});
                    }
                    totalReportingProbability += probability;
                }
                if (totalReportingProbability < fraction - 0.001) {
                    int addRelay = (Integer)new ArrayList(nonReportingRelays).get(rnd.nextInt(nonReportingRelays.size()));
                    nonReportingRelays.remove(addRelay);
                    reportingRelays.add(addRelay);
                    continue;
                }
                if (!(totalReportingProbability > fraction + 0.001)) continue;
                int removeRelay = (Integer)new ArrayList(reportingRelays).get(rnd.nextInt(reportingRelays.size()));
                reportingRelays.remove(removeRelay);
                nonReportingRelays.add(removeRelay);
            } while (totalReportingProbability < fraction - 0.001 || totalReportingProbability > fraction + 0.001);
            Collections.sort(singleRelayExtrapolations, new Comparator<double[]>(){

                @Override
                public int compare(double[] o1, double[] o2) {
                    return o1[0] < o2[0] ? -1 : (o1[0] > o2[0] ? 1 : 0);
                }
            });
            double totalProbability = 0.0;
            double totalValues = 0.0;
            double totalInterquartileProbability = 0.0;
            double totalInterquartileValues = 0.0;
            Double weightedMedian = null;
            for (double[] extrapolation : singleRelayExtrapolations) {
                totalValues += extrapolation[1];
                totalProbability += extrapolation[2];
                if (weightedMedian == null && totalProbability > totalReportingProbability * 0.5) {
                    weightedMedian = extrapolation[0];
                }
                if (!(totalProbability > totalReportingProbability * 0.25) || !(totalProbability < totalReportingProbability * 0.75)) continue;
                totalInterquartileValues += extrapolation[1];
                totalInterquartileProbability += extrapolation[2];
            }
            sb.append(String.format("%d,%.2f,%.0f,%.0f,%.0f%n", run, fraction, totalValues / totalProbability, weightedMedian, totalInterquartileValues / totalInterquartileProbability));
        }
        return sb.toString();
    }

    private static String simulateOnions(int run) {
        double[] fractions;
        int numberHsDirs = 3000;
        TreeSet<Double> hsDirFingerprints = new TreeSet<Double>();
        for (int i = 0; i < 3000; ++i) {
            hsDirFingerprints.add(rnd.nextDouble());
        }
        TreeSet ring = new TreeSet(Collections.reverseOrder());
        Iterator iterator = hsDirFingerprints.iterator();
        while (iterator.hasNext()) {
            double fingerprint = (Double)iterator.next();
            ring.add(fingerprint);
            ring.add(fingerprint - 1.0);
        }
        TreeMap<Double, Double> hsDirFractions = new TreeMap<Double, Double>();
        Iterator fingerprint = hsDirFingerprints.iterator();
        while (fingerprint.hasNext()) {
            double fingerprint2;
            double start = fingerprint2 = ((Double)fingerprint.next()).doubleValue();
            int positionsToGo = 3;
            Iterator iterator2 = ring.tailSet(fingerprint2).iterator();
            while (iterator2.hasNext()) {
                double prev;
                start = prev = ((Double)iterator2.next()).doubleValue();
                if (positionsToGo-- > 0) continue;
                break;
            }
            hsDirFractions.put(fingerprint2, fingerprint2 - start);
        }
        int numberOnions = 40000;
        int replicas = 4;
        int storeOnDirs = 3;
        TreeMap storedDescs = new TreeMap();
        Iterator iterator3 = hsDirFingerprints.iterator();
        while (iterator3.hasNext()) {
            double fingerprint3 = (Double)iterator3.next();
            storedDescs.put(fingerprint3, new TreeSet());
        }
        for (int i = 0; i < 40000; ++i) {
            block6: for (int j = 0; j < 4; ++j) {
                double fingerprint4;
                int leftToStore = 3;
                Iterator iterator4 = hsDirFingerprints.tailSet(rnd.nextDouble()).iterator();
                while (iterator4.hasNext()) {
                    fingerprint4 = (Double)iterator4.next();
                    ((SortedSet)storedDescs.get(fingerprint4)).add(i);
                    if (--leftToStore > 0) continue;
                    break;
                }
                if (leftToStore <= 0) continue;
                iterator4 = hsDirFingerprints.iterator();
                while (iterator4.hasNext()) {
                    fingerprint4 = (Double)iterator4.next();
                    ((SortedSet)storedDescs.get(fingerprint4)).add(i);
                    if (--leftToStore > 0) continue;
                    continue block6;
                }
            }
        }
        long binSize = 8L;
        double b = 26.666666666666668;
        TreeMap<Double, Long> reportedOnions = new TreeMap<Double, Long>();
        TreeMap<Double, Long> removedNoiseOnions = new TreeMap<Double, Long>();
        for (Map.Entry e : storedDescs.entrySet()) {
            double fingerprint5 = (Double)e.getKey();
            long observed = ((SortedSet)e.getValue()).size();
            long afterBinning = (observed + 8L - 1L) / 8L * 8L;
            double randomDouble = rnd.nextDouble();
            double laplaceNoise = -26.666666666666668 * (randomDouble > 0.5 ? 1.0 : -1.0) * Math.log(1.0 - 2.0 * Math.abs(randomDouble - 0.5));
            long reported = afterBinning + (long)laplaceNoise;
            reportedOnions.put(fingerprint5, reported);
            long roundedToNearestRightSideOfTheBin = (reported + 4L) / 8L * 8L;
            long subtractedHalfOfBinSize = roundedToNearestRightSideOfTheBin - 4L;
            removedNoiseOnions.put(fingerprint5, subtractedHalfOfBinSize);
        }
        StringBuilder sb = new StringBuilder();
        for (double fraction : fractions = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 0.99}) {
            ArrayList<double[]> singleRelayExtrapolations;
            double totalReportingProbability;
            TreeSet nonReportingRelays = new TreeSet(hsDirFractions.keySet());
            ArrayList shuffledRelays = new ArrayList(nonReportingRelays);
            Collections.shuffle(shuffledRelays);
            TreeSet reportingRelays = new TreeSet();
            for (int j = 0; j < (int)((double)hsDirFractions.size() * fraction); ++j) {
                reportingRelays.add(shuffledRelays.get(j));
                nonReportingRelays.remove(shuffledRelays.get(j));
            }
            do {
                singleRelayExtrapolations = new ArrayList<double[]>();
                totalReportingProbability = 0.0;
                Iterator iterator5 = reportingRelays.iterator();
                while (iterator5.hasNext()) {
                    double reportingRelay = (Double)iterator5.next();
                    double probability = (Double)hsDirFractions.get(reportingRelay) / 3.0;
                    if (probability > 0.0) {
                        singleRelayExtrapolations.add(new double[]{(double)((Long)removedNoiseOnions.get(reportingRelay)).longValue() / probability, ((Long)removedNoiseOnions.get(reportingRelay)).longValue(), probability});
                    }
                    totalReportingProbability += probability;
                }
                if (totalReportingProbability < fraction - 0.001) {
                    double addRelay = (Double)new ArrayList(nonReportingRelays).get(rnd.nextInt(nonReportingRelays.size()));
                    nonReportingRelays.remove(addRelay);
                    reportingRelays.add(addRelay);
                    continue;
                }
                if (!(totalReportingProbability > fraction + 0.001)) continue;
                double removeRelay = (Double)new ArrayList(reportingRelays).get(rnd.nextInt(reportingRelays.size()));
                reportingRelays.remove(removeRelay);
                nonReportingRelays.add(removeRelay);
            } while (totalReportingProbability < fraction - 0.001 || totalReportingProbability > fraction + 0.001);
            Collections.sort(singleRelayExtrapolations, new Comparator<double[]>(){

                @Override
                public int compare(double[] first, double[] second) {
                    return Double.compare(first[0], second[0]);
                }
            });
            double totalProbability = 0.0;
            double totalValues = 0.0;
            double totalInterquartileProbability = 0.0;
            double totalInterquartileValues = 0.0;
            Double weightedMedian = null;
            for (double[] extrapolation : singleRelayExtrapolations) {
                totalValues += extrapolation[1];
                totalProbability += extrapolation[2];
                if (weightedMedian == null && totalProbability > totalReportingProbability * 0.5) {
                    weightedMedian = extrapolation[0];
                }
                if (!(totalProbability > totalReportingProbability * 0.25) || !(totalProbability < totalReportingProbability * 0.75)) continue;
                totalInterquartileValues += extrapolation[1];
                totalInterquartileProbability += extrapolation[2];
            }
            sb.append(String.format("%d,%.2f,%.0f,%.0f,%.0f%n", run, fraction, totalValues / totalProbability, weightedMedian, totalInterquartileValues / totalInterquartileProbability));
        }
        return sb.toString();
    }
}

